	subroutine cancel_io
C
C	This routine is used to cancel the local I/O.
C
C	The status return from the SYS$CANCEL's are not checked
C	since this routine is called from the error routine.
C
	implicit none
	include 'bbs_inc.for'
	integer status
	integer sys$cancel
C
C	Cancel the local I/O (if any).
C
	status = sys$cancel(%val(lchan_in))
	status = sys$cancel(%val(lchan_out))
	call check_status('cancel_local',status)
	return
	end

	subroutine wake_up
C
C	Subroutine to wake up hibernate state.
C
	implicit none
	integer*4 status, sys$wake, check_status

	status = sys$wake(,)	! Wake us up.
	call check_status('wake_up',status)
	return
	end

	subroutine init_timer(timer_pointer)
C
C	The subroutine simply calls LIB$INIT_TIMER.
C
	implicit none

	integer status, lib$init_timer, timer_pointer

	status = lib$init_timer(timer_pointer)
	call check_status('init_timer',status)
	return
	end

	subroutine elapsed_time(timer_pointer)
C
C	This routine is called at the end of file transmission to output
C	the elapsed time.  The LIB$INIT_TIMER must have been called previous
C	to calling this routine.
C
	implicit none
	integer*4 timer_pointer

	external write_elapsed

	call lib$show_timer(timer_pointer,,write_elapsed,)
	return
	end

	subroutine write_elapsed (time)
C
C	This routine is used to write the elapsed time.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	CHARACTER*(*) TIME
	INTEGER TIME_SIZE, INDEX

	TIME_SIZE = LEN(TIME)			! Get the time string size.
	TIME_SIZE = INDEX (TIME, '  BUFIO:')
	CALL WRITE_USER('***'//TIME(1:TIME_SIZE)//'***'//crlf(:cl))
	RETURN
	END

	INTEGER FUNCTION CHECK_STATUS(FACILITY_NAME,STATUS_CODE)
C
C	Subroutine to check status from a System Service.
C
C	Inputs:
C		FACILITY_NAME - Subroutine name.
C		STATUS_CODE - Status code.
C
C	Outputs:
C		Returns the status code passed in.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'
C
C	Setup the error message.
C
	CHARACTER*(*) FACILITY_NAME, ERROR_MESSAGE
	PARAMETER (ERROR_MESSAGE = ss//
	1 '*** VAXNET Terminated with ERROR ***'//BELL//ss)
	CHARACTER*80 MESS_TXT
	INTEGER*4 STATUS_CODE

	CHECK_STATUS = STATUS_CODE	! Pass back the status code.

	IF (STATUS_CODE .EQ. SS$_NORMAL) RETURN
C
C	If the error is exceeded quota (probably buffered I/O quota),
C	cancel the outstanding I/O so the write of the error message
C	will complete successfully.
C
	IF (STATUS_CODE .EQ. SS$_EXQUOTA) THEN
		CALL CANCEL_IO()	! Cancel the outstanding I/O.
	ENDIF
C
C	Report error message to the terminal.
C
C	Set flags for GETMSG for:
C		- Include text of message.
C		- Include message identifier.
C		- Include severity indicator.
C		- Do not include facility name.
C
	FLAGS = "7			! Set up the flags.
	CALL SYS$GETMSG(%VAL(STATUS_CODE),MSGLEN,MESS_TXT,%VAL(FLAGS),)
C
	write(6,*)crlf(:cl)//'%'//facility_name//'-'//mess_txt(2:msglen)
	1   //bell//crlf(:cl)
C
C	If the modem hangs up, show it was hungup, and insure a file
C	transfer (if any) gets aborted.
C
	IF (STATUS_CODE .EQ. SS$_HANGUP) THEN
		CONTROLC_TYPED = .TRUE.	! Set flag to abort transmission.
	ENDIF
	CALL HANGUP_MODEM()		! Make sure modem is hungup.
	CALL SYS$EXIT(%VAL(STATUS_CODE)) ! Exit with the status code.
	END

	LOGICAL FUNCTION GET_VAXFILE(FILE)
C
C	This function is used to get the file name of the file
C	on the VAX and then open it for either read or write.
C
C	Inputs:
C		FILE - string descriptor with the file name (if any).
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'
	INCLUDE '($RMSDEF)/NOLIST'


	CHARACTER*(*) FILE, MODULE_NAME

	character cc*4
	PARAMETER (MODULE_NAME = 'GET_VAXFILE')

	GET_VAXFILE = .FALSE.		! Initialize to bad return.
C
C	If we were passed a file name, use it.
C
	VAX_FILE = FILE		! Copy the file name
	VSIZE = LEN(FILE)	!    and the file size.
C
C	Sending a file to the remote.
C
C	Vaxnet> SEND vax_file remote_file
C
200	IF (FLOW .EQ. TO_VAX) GO TO 500		! Send a file to the VAX.
C
C
C	Open the file for read.
C
400	OPEN (UNIT=FILE_UNIT, TYPE='OLD', READONLY, SHARED,
	1			FILE=VAX_FILE(1:VSIZE), ERR=9900)
	GET_VAXFILE = .TRUE.			! Return success.
	RETURN
C
C	Getting a file from the REMOTE.
C
C	Vaxnet> GET remote_file vax_file
C
C
C	Open the file for write.
C
500	continue
	if (file_type.eq.binary) then
	    cc='none'
	else
	    cc='list'
	endif

	OPEN (UNIT=FILE_UNIT, TYPE='NEW', NAME=VAX_FILE(1:VSIZE),
	1		RECORDSIZE=OUT_SIZE, CARRIAGECONTROL=cc,
	1		BUFFERCOUNT=2, ERR=9900)
	GET_VAXFILE = .TRUE.			! Return success.
	RETURN

9900	continue
c	CALL RMS_ERROR (MODULE_NAME)		! Report the RMS error.
	RETURN
	END

	SUBROUTINE UPDATE_TOTALS (NBYTES)
C
C	This routine is called after a record is successfully transmitted
C	to update the various counters.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR'
	include 'kermit_inc.for'

	RETRY_COUNT = 0				! Reinitialize retry counter.
	BYTE_COUNT = BYTE_COUNT + NBYTES	! Accumulate the byte count
	RECORD_COUNT = RECORD_COUNT + 1		!	and the record count.
	TOTAL_BYTES = TOTAL_BYTES + NBYTES	! Update the total byte count.
	TOTAL_RECORDS = TOTAL_RECORDS + 1	!	and the record count.
	RETURN

	ENTRY CLEAR_COUNTS
C
C	Entry to initialize counts.
C
	BYTE_COUNT = 0				! Clear byte count.
	RECORD_COUNT = 0			! Clear record count.
	TOTAL_BYTES = 0				! Clear total bytes.
	TOTAL_RECORDS = 0			! Clear total records.
	ERROR_COUNT = 0				! Clear error count.
	ERROR_RECORD = 0			! Clear error record #.
	PARITY_ERRORS = 0			! Initialize
	OVERRUN_ERRORS = 0			!      the
	TIMEOUTS = 0				!        various
	FRAMING_ERRORS = 0			!          counters.
	RETRY_COUNT = 0				!           
	FILE_COUNT = 0				! Number of file transfered.
	BLOCK_COUNT = 0				! Number of blocks transfered.
	BLOCK_RECEIVED = 0			! Received block number.
	BLOCK_XMITTED = 0			! Transmitted block number.
	PACKET_COUNT = 0			! Number of data packets.
	TOTAL_PACKETS = 0			! Total data packet count.
	RETURN

	ENTRY COUNT_FILES
C
C	This routine is called after each file transmission to reset
C	some counters and to update the files copied count.
C
	BYTE_COUNT = 0				! Clear the byte count,
	RECORD_COUNT = 0			!	the record count,
	ERROR_COUNT = 0				!	the error count and,
	ERROR_RECORD = 0			!	the error record number,
	BLOCK_COUNT = 0				!	the data block count,
	PACKET_COUNT = 0			! 	the data packet count.
	FILE_COUNT = FILE_COUNT + 1		! Count number of files copied.
	RETRY_COUNT = 0				! Reinitialize retry counter.
	RETURN

	ENTRY REPORT_TOTALS
C
C	Entry to report the final statistics.
C
	IF (PROTOCOL .EQ. XMODEM) THEN
	    CALL SYS$FAO ('!/XMODEM Status Report:!/'//
	1	'Total blocks:!7UL, total records:!7UL, total bytes:!8UL!/'//
	1	'Parity errors:!6UL,      overruns:!7UL,    timeouts:!8UL!/',
	1		SIZE, SCRATCH,
	1	%VAL(BLOCK_COUNT), %VAL(RECORD_COUNT), %VAL(BYTE_COUNT),
	1	%VAL(PARITY_ERRORS), %VAL(FRAMING_ERRORS),%VAL(OVERRUN_ERRORS))
	ELSEIF (PROTOCOL .EQ. KERMIT) THEN
	    CALL SYS$FAO ('!/KERMIT Status Report:!/'//
	1	'Total packets:!7UL, total records:!7UL, total bytes:!8UL!/'//
	1	'Parity errors:!7UL,      overruns:!7UL,    timeouts:!8UL!/',
	1		SIZE, SCRATCH,
	1	%VAL(TOTAL_PACKETS), %VAL(TOTAL_RECORDS), %VAL(TOTAL_BYTES),
	1	%VAL(PARITY_ERRORS), %VAL(FRAMING_ERRORS),%VAL(OVERRUN_ERRORS))
	ENDIF
	CALL WRITE_USER (SCRATCH(1:SIZE))
	END

	LOGICAL FUNCTION REPORT_ERROR(DISPLAY)
C
C	This routine is used to report a transmission error.  If the retry
C	limit is exceeded, the function returns failure.
C
C	Inputs:
C		DISPLAY - Controls whether the error should be displayed.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	LOGICAL DISPLAY
	CHARACTER*(*) RETRY_MSG
	PARAMETER (RETRY_MSG = ss//
	1 '*** Retry limit exceeded, aborting file transmission ***'
	1 //BELL//ss)

	REPORT_ERROR = .TRUE.			! Presume limit not exceeded.
	ERROR_COUNT = ERROR_COUNT + 1		! Bump the error count.
	ERROR_RECORD = RECORD_COUNT + 1		! Save the error record number.
	RETRY_COUNT = RETRY_COUNT + 1		! Bump the retry count.

	IF (RETRY_COUNT .GE. RETRY_LIMIT) THEN
		REPORT_ERROR = .FALSE.		! Show retry limit exceeded.
C		CALL WRITE_USER(RETRY_MSG)	! Tell the user what happened.
	ENDIF
	RETURN
	END

	SUBROUTINE REPORT_SUCCESS
	implicit integer*4 (a-z)
	include 'bbs_inc.for/nolist'
C
C	Routine to display a successful transmission.
C
	CALL CHECK_DISPLAY()
	CALL SYS$FAO ('*** File "!AS" successfully transferred. ***!/',
	1   SIZE, SCRATCH, VAX_FILE(1:VSIZE))
	CALL WRITE_USER (SCRATCH(1:SIZE))
	RETURN

	ENTRY REPORT_ABORT
C
C	Routine to display a aborted transmission.
C
	CALL CHECK_DISPLAY()
	CALL WRITE_USER('*** Transmission of file "'//VAX_FILE(1:VSIZE)//
	1		'" aborted. ***'//crlf(:cl))
	RETURN
	END

	SUBROUTINE CHECK_DISPLAY
C
C	This routine simply writes single spacing to the local terminal
C	if record information was displayed on the screen.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	IF (RECORD_COUNT .GE. DISPLAY_RECORD) THEN
	    CALL WRITE_TTY (crlf(:cl))
	    ENDIF
	RETURN
	END

	subroutine setup_local(interactive)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - SETUP_LOCAL
c
c	This routine is used to setup the local terminal characteristics.
c
c	Inputs:
c		INTERACTIVE - logical .TRUE. for interactive mode.
c				else .FALSE. for normal mode.
c
c	Dale Miller - UALR
c
c	Rev. 4.8  03-Feb-1987
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include '($ttdef)/nolist'
	include '($tt2def)/nolist'

	logical interactive
	character*(*) module_name
	parameter (module_name = 'setup_local')
	integer sys$qiow
	integer check_status,status

c	Get the local terminal characteristics and set the terminal
c	to full duplex to allow simultanious reads and writes.

	status = sys$qiow(%val(lefn_in),%val(lchan_in),
	1   %val(io$_sensemode),liosb,,,local_char,%val(12),,,,)
	if (.not. check_status(module_name,status)) return

c	For interactive mode, we must enable full duplex (if not enabled)
c	and put the terminal in binary passall mode.  The terminal must
c	be in passall mode to prevent control characters (CTRL/C, CTRL/S,
c	CTRL/Q, CTRL/X, and CTRL/Y) from being processed by the terminal
c	driver when a read is not active.

	if (interactive) then
	    local_char(3) = local_char(3) .or. tt2$m_pasthru
	    local_char(2) = local_char(2) .and. (.not. tt$m_halfdup)
	    local_char(2) = local_char(2) .or. tt$m_eightbit
	    local_char(2) = local_char(2) .and. (.not. tt$m_ttsync)
	else
	    local_char(3) = local_char(3) .and. (.not. tt2$m_pasthru)
	    local_char(2) = local_char(2) .and. (.not. tt$m_eightbit)
	    local_char(2) = local_char(2) .or. tt$m_ttsync
	    if((ur.editor.and.7) .eq. 7) then
		local_char(2) = local_char(2) .or. (tt$_vt100 * 2**8)
		local_char(3) = local_char(3) .or. tt2$m_ansicrt
		local_char(3) = local_char(3) .or. tt2$m_deccrt
	    else if ((ur.editor.and.3) .eq. 3) then
		local_char(2) = local_char(2) .or. (tt$_vt52 * 2**8)
	    end if
	endif

c	The CTRL/S state must be cleared before going into passall mode,
c	otherwise the read never completes because the CTRL/Q used to clear
c	the suspended state get put in the input buffer.  This results in
c	VAXNET getting hung in a hibernate even though reads are active.

	local_char(3) = local_char(3) .or. tt2$m_xon
	status = sys$qiow(%val(lefn_in),%val(lchan_in),
	1   %val(io$_setmode),liosb,,,local_char,%val(12),,,,)
	call check_status(module_name,status)
	return
	end

	subroutine clear_typeahead
c
c	Clears the typeahead buffer on the local channel.
c	Also sets up the local typeahead buffer.
c
	implicit integer*4 (a-z)
	include 'bbs_inc.for/nolist'

	status = sys$qiow(%val(lefn_in),%val(lchan_in),
	1	%val(io$_readlblk + io$m_purge),
	2	liosb,,,rbuffer,%val(0),,,,)
	call check_status('clear_typeahead',status)
	tnext=1
	return
	end

	SUBROUTINE WAITABIT(SECONDS)
C
C	This subroutine just waits a little then returns.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	CHARACTER*(*) SECONDS
	INTEGER*4 DELTA(2)

	STATUS = SYS$BINTIM('0 00:00:'//SECONDS,DELTA)
	IF (.NOT. CHECK_STATUS('WAITABIT(BINTIM)',STATUS)) RETURN
	STATUS = SYS$SETIMR(%VAL(TIMER_EFN),DELTA,,)
	IF (.NOT. CHECK_STATUS('WAITABIT(SETIMR)',STATUS)) RETURN
	STATUS = SYS$WAITFR(%VAL(TIMER_EFN))
	CALL CHECK_STATUS('WAITABIT(WAITFR)',STATUS)

C	STATUS = SYS$SCHDWK(,,DELTA,,)	! Schedule wakeup.
C	IF (.NOT. CHECK_STATUS('WAITABIT(SCHDWK)',STATUS)) RETURN
C	STATUS = SYS$HIBER()		! Go into hibernation.
	RETURN
	END

	LOGICAL FUNCTION CVT_DTB(STR,NUM)
C
C	This routine is used to convert an ASCII string of numbers to
C	an integer.
C
C	Inputs:
C		STR - string descriptor.
C		NUM - integer to return number to.
C
C	Outputs:
C		.TRUE./.FALSE. = success/failure.
C
	CHARACTER*(*) STR
	INTEGER*4 NUM

	CVT_DTB = LIB$CVT_DTB(%VAL(LEN(STR)),%REF(STR),NUM)
	RETURN
	END

	INTEGER FUNCTION GET_EFN(EVENT_FLAG)
C
C	Get an event flag.
C
	IMPLICIT NONE
	INTEGER*4 EVENT_FLAG, CHECK_STATUS, LIB$GET_EF, STATUS

	STATUS = LIB$GET_EF(EVENT_FLAG)	! Local input event flag.
	CALL CHECK_STATUS('LIB$GET_EF',STATUS)
	RETURN
	END

	integer function read_byte (seconds)
c
c	This routine is used to read a single byte.
c	If any characters are in the local typeahead, they are used first.
c
c	Inputs:
c		SECONDS = The timeout in seconds.
c
	implicit integer*4 (a-z)
	include 'bbs_inc.for/nolist'

	integer seconds
	logical*1 buff(1)

	if(tnext.gt.1) then
	    read_byte = tbuffer(1)
	    cbuffer=cbuffer(2:tnext)
	    tnext=tnext-1
	    return
	else
	    call raw_read (buff, 1, seconds, noterm)
	    read_byte = buff(1) .and. bitmask
	    return
	endif
	end

	SUBROUTINE SEND_BYTE (BUFFER)
C
C	This routine is used to write a single byte.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	LOGICAL*1 BUFFER(1), BUFF(1)

	BUFF(1) = BUFFER(1) .AND. BITMASK
	CALL RAW_WRITE (BUFF(1),1)
	RETURN
	END

	INTEGER FUNCTION RAW_READ (BUFFER, BYTES, SECONDS, termin)
C
C	This routine is used to read raw data (no interpretation).
C
C	Inputs:
C		BUFFER = The buffer to read into.
C		BYTES = The number of bytes to read.
C		SECONDS = The timeout in seconds.
c		TERMIN  = The read terminator table
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'RAW_READ')

	LOGICAL*1 BUFFER(1)
	integer*4 termin(2)
	INTEGER BYTES, SECONDS, STATUS

	STATUS = SYS$QIOW (%VAL(LEFN_IN),%VAL(LCHAN_IN),
	1		%VAL(IO$_TTYREADALL + IO$M_NOECHO + IO$M_TIMED),
	1		LIOSB,,,BUFFER,%VAL(BYTES),
	1		%VAL(SECONDS),termin,,)

	RAW_READ = STATUS		! Copy the directive status.
	IF (.NOT. CHECK_STATUS (MODULE_NAME, STATUS)) RETURN
	RAW_READ = LIOSB(1)		! Pass back I/O status.
	RBYTE_COUNT = LIOSB(2)		! Save the byte count.
C
C	Check for various errors:
C
	IF     (LIOSB(1) .EQ. SS$_TIMEOUT) THEN		! Timeout error ?
		TIMEOUTS = TIMEOUTS + 1			! Yes, count it.
		GO TO 200				! And continue ...
	ELSEIF (LIOSB(1) .EQ. SS$_PARITY) THEN		! Parity error ?
		PARITY_ERRORS = PARITY_ERRORS + 1	! Yes, count it,
		GO TO 200				! And continue ...
	ELSEIF (LIOSB(1) .EQ. SS$_DATAOVERUN) THEN	! Data overrun ?
		OVERRUN_ERRORS = OVERRUN_ERRORS + 1	! Yes, count it.
		GO TO 200				! And continue ...
	ELSEIF (LIOSB(1) .NE. SS$_ABORT) THEN		! CTRL/C to abort.
		CALL CHECK_STATUS (MODULE_NAME, RAW_READ)
	ENDIF
	RETURN
C
C	Here for timeout and hardware errors.
C
200	BUFFER(1) = 0				! Force bad transmission
	RBYTE_COUNT = 0				!  by clearing buffer & BC.
	RETURN
	END

	SUBROUTINE RAW_WRITE (BUFFER, BYTES)
C
C	This routine is used to write raw data (no interpretation).
C
C	Inputs:
C		BUFFER - The buffer to write.
C		BYTES - The number of bytes to write.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'RAW_WRITE')

	LOGICAL*1 BUFFER(1)
	INTEGER BYTES, STATUS

c	CALL WRITE_DEBUG (MODULE_NAME, BUFFER, BYTES)
	STATUS = SYS$QIOW (%VAL(LEFN_OUT),%VAL(LCHAN_OUT),
	1		%VAL(IO$_WRITELBLK + IO$M_NOFORMAT),
	1		XIOSB,,,BUFFER,%VAL(BYTES),,,,)
	CALL CHECK_STATUS (MODULE_NAME, STATUS)
	RETURN
	END

	SUBROUTINE XMODEM_TOTALS (BYTES)
C
C	This routine is called after a record is successfully transmitted
C	to update the various counters.  Since the routine is called while
C	building a transmit buffer from multiple input records, the record
C	display has a special entry which is called after tranmitting the
C	current block.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	INTEGER BYTES

	BYTE_COUNT = BYTE_COUNT + BYTES		! Accumulate the byte count
	RECORD_COUNT = RECORD_COUNT + 1		!	and the record count.
	RETURN
	END

	SUBROUTINE WRITE_USER(MSG)
C
C	Write a buffer to the user and the log file if open.
C
C	Inputs:
C		MSG - string descriptor with message.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	CHARACTER*(*) MSG
	INTEGER SIZE, STATUS

	SIZE = LEN(MSG)
	GO TO 100

	ENTRY WRITE_BUFF (MSG)
C
C	Entry to write to the log file and the terminal.
C
	SIZE = LEN(MSG)
	GO TO 100

	ENTRY WRITE_TTY (MSG)
C
C	Entry to write to the terminal only.
C
	SIZE = LEN(MSG)
100	STATUS = SYS$QIOW(%VAL(LEFN_OUT),%VAL(LCHAN_OUT),
	1    %VAL(IO$_WRITELBLK + IO$M_NOFORMAT),
	1    LIOSB,,,%REF(MSG),%VAL(SIZE),,,,)
	IF (.NOT. STATUS) THEN
	    CALL LIB$SIGNAL(%VAL(STATUS))
	    CALL SYS$EXIT(%VAL(STATUS))
	    ENDIF
	RETURN
	END

	SUBROUTINE RMS_ERROR (MODULE)
C
C	This routine is called to report an RMS error.
C
C	CALL ERRSNS(num,rmssts,rmsstv,iunit,)
C
C	Where:	num = fortran error code,
C		rmssts = RMS completion status code.
C		rmsstv = RMS status code.
C		iunit = logical unit number.
C
	IMPLICIT NONE

	INTEGER*4 FERR, RMSSTS, RMSSTV, LUN, CHECK_STATUS, ERROR
	CHARACTER*(*) MODULE

	CALL ERRSNS (FERR,RMSSTS,RMSSTV,LUN,)	! Get the last error code.
	ERROR = RMSSTS				! Copy the RMS error code.
	IF (ERROR .EQ. 0) ERROR = FERR		! Use the FORTRAN error code.
	CALL CHECK_STATUS (MODULE, ERROR)	! Go report the error message.
	RETURN
	END

	SUBROUTINE WRITE_REMOTE (BUFFER, NBYTES)
C
C	This subroutine is used to write a buffer to the remote.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	LOGICAL*1 BUFFER(1)

	BYTES = NBYTES + 1		! Adjust the byte count.
	BUFFER(BYTES) = CR		! Append Terminator.
	GO TO 100			! And continue ...
C
C	The next entry is used to write the buffer without appending
C	a carriage return to the end of the message.
C
	ENTRY WRITE_BYTE (BUFFER, NBYTES)
	BYTES = NBYTES			! Copy the byte count.

100	STATUS = SYS$QIOW(%VAL(LEFN_OUT),%VAL(LCHAN_OUT),
	1		%VAL(IO$_WRITELBLK + IO$M_NOFORMAT),
	1		XIOSB,,,BUFFER,%VAL(BYTES),,,,)
	CALL CHECK_STATUS('WRITE_REMOTE',STATUS)
	RETURN
	END

	SUBROUTINE HANGUP_MODEM
C
C	This routine is called to hangup the modem.
C
	implicit integer*4 (a-z)
	INCLUDE 'BBS_INC.FOR/NOLIST'

	LOCAL_STATUS = SYS$QIOW(%VAL(LEFN_IN),%VAL(LCHAN_IN),
	1   %VAL(IO$_SETMODE + IO$M_HANGUP),LIOSB,,,,,,,,)
	RETURN
	END

	subroutine fake_vaxnet
c	This code was surgically removed from VAXNET, and appears here
c	in a somewhat mangled, but usuable state.
	implicit integer*4 (a-z)
	include 'bbs_inc.for/nolist'
	bitmask=sevenbit_mask
c	set up event flags
	call get_efn(lefn_in)		! Local input event flag
	call get_efn(lefn_out)		! Local output event flag
C
C	Translate SYS$COMMAND, and assign a channel for QIO's.
C
	I = 11				! Size of SYS$COMMAND
	LOCAL_DEVICE = 'SYS$COMMAND'
10	STATUS = SYS$TRNLOG(LOCAL_DEVICE(1:I),I,LOCAL_DEVICE,,,)
	IF (STATUS .NE. SS$_NOTRAN) GO TO 10
C
C	Note in the following that I contains the true length, and remember
C	that TRNLOG puts a stupid 4-byte header on the translations of
C	SYS$INPUT/OUTPUT specifically.  This header only exists if the
C	first byte starts with an escape character.
C
	IF (LOCAL_DEVICE(1:1) .EQ. CHAR(esc)) THEN
		S = 5			! Point past header.
	ELSE
		S = 1			! Use entire string.
	ENDIF
	STATUS = SYS$ASSIGN(LOCAL_DEVICE(S:I),LCHAN_IN,,)
	IF (.NOT. STATUS) THEN
		CALL LIB$SIGNAL(%VAL(STATUS))
		CALL SYS$EXIT(%VAL(STATUS))
	ENDIF
	STATUS = SYS$ASSIGN(LOCAL_DEVICE(S:I),LCHAN_OUT,,)

	return
	END

	subroutine ctrl_o_check(*,*)
c	this routine will stick anything other than ^c, ^q, ^s, and ^o
c	into the local typeahead buffer.
c	and take alternate returns for ^o or ^c
c
	implicit none
	include 'bbs_inc.for/nolist'
	logical*1 temp1(1)

	timeouts=0
	call raw_read(temp1,1,0,noterm)
	temp1(1) = temp1(1) .and. bitmask
	do while(temp1(1).ne.0)
	    if(temp1(1).eq.03) return 1	!Control-c return statement
	    if(temp1(1).eq.15) return 2	!Control-o return statement
	    if(temp1(1).eq.21.or.temp1(1).eq.24) tnext=1   !^x/^u
	    if(temp1(1).eq.19) then
		do while(temp1(1).ne.3.and.temp1(1).ne.17
	1	    .and.temp1(1).ne.15)
		    call raw_read(temp1,1,60,noterm)
		    temp1(1) = temp1(1) .and. bitmask
		    if(timeouts.gt.4) call finish_timeout
		    if(tnext.lt.1024) then
			tbuffer(tnext)=temp1(1)
			tnext=tnext+1
		    else
			write(6,1001)bell
		    endif
		    end do
		if(temp1(1).eq.03) return 1
		if(temp1(1).eq.15) return 2
		if(temp1(1).eq.17) return
		end if
	    if(tnext.lt.1024) then
		tbuffer(tnext)=temp1(1)
		tnext=tnext+1
		temp1(1)=0
	    else
		write(6,1001)bell
		temp1(1)=0
	    endif
	    timeouts=0
	    call raw_read(temp1,1,0,noterm)
	    temp1(1) = temp1(1) .and. bitmask
	    end do
	return
 1001	format(a)
	end

	subroutine kill_mess (irec,status)
	implicit integer*4 (a-z)
	include 'bbs_inc.for/nolist'
	include 'sys$library:foriosdef/nolist'
c
	character cdummy*1,zmail_to*30,zmail_from*30
	character snum*6,qmail_to*30,yesno*3,string*30
	character zfirst_name*20,zlast_name*20
	byte dummyb
	logical*1 reprint,found,nostop

	record /userlog_structure/ zur

	record /mail_header_structure/ mh

 1001	format(a)

	status=0
10000	read(2,rec=irec,iostat=ios,err=90600) mh
	unlock(unit=2)
	istat = str$upcase(mh.mail_to,mh.mail_to)
	if(mail_name.ne.mh.mail_to.and.mail_name.ne.mh.mail_from
	1   .and.(.not.sysop2)) then
	    write(6,1001)crlf(:cl)//'That is not your message.'
	    return
	    end if

	write(6,1001)crlf(:cl)//'Are you sure? [Yes] '
	dummy=3
	call get_upcase_string(yesno,dummy)
	if(dummy.gt.0.and.yesno(1:1).eq.'N') then
	    return
	    end if
	read(2,rec=irec,iostat=ios,err=90600) mh
	mh.mail_deleted=.true.
	write(2,rec=irec,iostat=ios,err=90600) mh
	if(mh.mail_person.and..not.mh.mail_read) then
	    istat=str$upcase(qmail_to,mh.mail_to)
	    spc=index(qmail_to,' ')
	    zfirst_name=qmail_to(1:spc-1)	
	    do ii=spc+1,30
		if(zmail_to(ii:ii).ne.' ') go to 10200
		end do

10200	    zlast_name=qmail_to(ii:30)
	    zur.user_key=zlast_name//zfirst_name
	    read(1,key=zur.user_key,iostat=ios,err=10400)zur
	    zur.num_unread=zur.num_unread-1
	    if (zur.num_unread.lt.0) zur.num_unread=0
	    rewrite(1,err=90500)zur
	    end if

10400	write(6,1001)crlf(:cl)
	istat=str$trim(mh.mail_from,mh.mail_from,dummy1)
	istat=str$trim(mh.mail_to,mh.mail_to,dummy2)
	if(dummy1.lt.1.or.dummy1.gt.30) dummy1=30
	if(dummy2.lt.1.or.dummy2.gt.30) dummy2=30
	write(6,1001)crlf(:cl)//'Message from '//mh.mail_from(1:dummy1)//
	1    ' to '//mh.mail_to(1:dummy2)//' deleted.'//bell
	return

90500	status=1	!error on userlog
	return

90600	status=2	!error on message files
	return
	end

	subroutine finish_timeout
*	this routine is called in case of a timeout.
	implicit integer*4 (a-z)
	include 'bbs_inc.for'
	write(6,1001)crlf(:cl)//'Your terminal has been idle too long.'
	write(6,1001)crlf(:cl)//'UBBS is signing off now.'
	read(1,key=ur.user_key,iostat=ios,err=90500)ur
	ur.seconds_today = current_units
	rewrite(1,iostat=ios,err=90500)ur
90500	continue		!graceful non-handling of errors
	close(unit=1)
	close(unit=2)
	close(unit=3)
	interactive=.false.		!reset before exiting
	call setup_local(interactive)
	write(6,1001)crlf(:cl)
	close(unit=6)
	call exit
 1001	format(a)
	end

	integer function uopen(fab,rab,lun)
	implicit none

	include '($rabdef)'
	include '($fabdef)'

	record /rabdef/ rab
	record /fabdef/ fab
	integer sys$open,sys$connect

	integer lun,status
	
c	modify the rab to simplify things
	rab.rab$l_rop = ibset(rab.rab$l_rop, rab$v_wat)

c	actually open the file
	status=sys$open(fab)
	if(status) status=sys$connect(rab)
c	return the status
	uopen=status
	return
	end

	integer function getsize(fab,rab,lun)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - GETSIZE
c	This is a user open procedure to determine file size and file
c	revision date.
c	Dale Miller - UALR
c
c	Rev. 6.1  08-Jun-1988
c	Rev. 7.1  19-Sep-1988
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c	This user open finds out the file size.

	implicit none

	include '($rabdef)'
	include '($fabdef)'
	include '($xabdef)'
	include '($xabdatdef)'

	structure /xxx/
	    union
		map
		    record /xabdef/ xab
		end map
		map
		    record /xabdatdef/ dat
		end map
	    end union
	end structure

	record /xxx/ xabdat
	record /rabdef/ rab
	record /fabdef/ fab
	integer sys$open,sys$connect
	
	integer lun,status,fsize,rev_date(2),back_date(2)
	common/filesize/fsize, rev_date, back_date
	
c	Initialize FAB block and set up link to XAB.
	fab.fab$b_bid = fab$c_bid
	fab.fab$b_bln = fab$c_bln
	fab.fab$l_xab = %loc(xabdat.xab.xab$b_cod)

c	Set up the XAB block to be a XABDAT block.
	xabdat.xab.xab$b_cod = xab$c_dat
	xabdat.xab.xab$b_bln = xab$c_datlen
	xabdat.xab.xab$l_nxt = 0

c	Actually open the file
	status=sys$open(fab)
	if(status) status=sys$connect(rab)
c	Return the status
	getsize=status
c	Store the size
	fsize=fab.fab$l_alq
c	Store the revision date
	rev_date(1) = xabdat.xab.xab$q_rdt(1)
	rev_date(2) = xabdat.xab.xab$q_rdt(2)
c	Store the backup date
	back_date(1) = xabdat.dat.xab$q_bdt(1)
	back_date(2) = xabdat.dat.xab$q_bdt(2)
	return
	end

	INTEGER FUNCTION FIND_FILE (FILE,SIZE)
C
C	This function is used to lookup a file spec containing wildcards.
C
C	Inputs:
C		FILE - The file spec to lookup.
C		SIZE - The file spec size.
C
C	Outputs:
C		Any error from LIB$FIND_FILE.
C
	implicit integer*4 (a-z)
	INCLUDE 'bbs_inc.for'
	INCLUDE '($RMSDEF)/NOLIST'

	CHARACTER*(*) FILE, MODULE_NAME
	CHARACTER*128 FILE_NAME

	PARAMETER (MODULE_NAME = 'FIND_FILE')
	LOGICAL WILD_CARDS
	INTEGER FIND_CONTEXT, FILE_SIZE, SIZE, DFLAG, SON

	FILE_NAME = FILE(1:SIZE)	! Copy the file specification.
	FILE_SIZE = SIZE		! Copy the file size.
	FIND_CONTEXT = 0		! Initialize the file context.
C
C	Set flag to determine if device and/or directory is specified.
C
	GO TO 100			! Go find the specified file(s).

	ENTRY FIND_NEXT (FILE, SIZE)
C
C	Find the first/next file name.
C
	FIND_NEXT = RMS$_NMF		! Initialize to "No more files"

100	STATUS = LIB$FIND_FILE (FILE_NAME(1:FILE_SIZE), FILE, FIND_CONTEXT)
	FIND_NEXT = STATUS		! Pass back the status.

	SIZE = INDEX (FILE, ' ') - 1	! End of expanded file name.
C
C	Return the file name size minus the spaces it's padded with.
C
	SIZE = INDEX (FILE, ' ') - 1	! Return the file name size.
	IF (.NOT. STATUS) THEN
	    IF (STATUS .NE. RMS$_NMF) THEN
		    IF (STATUS .EQ. RMS$_PRV) THEN
			GO TO 100	! Next file on privilege violation.
		    ENDIF
	    ELSE
		VAX_WILD = .FALSE.	! Wildcards are no longer active.
	    ENDIF
	ENDIF
	RETURN
	END

	subroutine type_file(filename)
	implicit none
	include 'bbs_inc.for'
	character*(*) filename
	character*512 record
	integer length

	open(unit=4,file=filename,status='old',readonly,
	1   shared,err=0020)
	read(4,1002,iostat=ios)length,record
	do while (.not.ios)
	    call ctrl_o_check(*10,*10)
	    write(6,1001)crlf(:cl)//record(1:length)
	    read(4,1002,iostat=ios)length,record
	    end do
 0010	close(unit=4)
 0020	return
 1001	format(a)
 1002	format(q,a)
	end

	subroutine make_readable(instring,length,outstring)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - MAKE_READABLE
c	This routine takes an input string and translates control characters
c	to a displayable representation.
c	Dale Miller - UALR
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	character*(*) instring,outstring
	integer*4 length,i,j,temp
	character*3 text(33)
	integer*4 ltxt(33)
	data text/'NUL','SOH','STX','ETX','EOT','ENQ','ACK','BEL',
	1	  'BS ','HT ','LF ','VT ','FF ','CR ','SO ','SI ',
	2	  'DLE','DC1','DC2','DC3','DC4','NAK','SYN','ETB',
	3	  'CAN','EM ','SUB','ESC','FS ','GS ','RS ','US ','SP '/

	data ltxt/8*3,8*2,9*3,2,2*3,5*2/

	j=0
	do i=1,length
	    temp=ichar(instring(i:i))+1
	    if(temp.le.33) then
		outstring=outstring(1:j)//'<'//text(temp)(1:ltxt(temp))//'>'
		j=j+2+ltxt(temp)
	    else if(temp.eq.128) then
		outstring=outstring(1:j)//'<DEL>'
		j=j+5
	    else
		outstring=outstring(1:j)//instring(i:i)
		j=j+1
	    end if
	    end do
	length=j
	return
	end

	integer function bbs_put_output(msg_str)
c
c	This routine mimics lib$put_output for the bbs to allow it to use
c	its own carriage control and interrupt routines
c
	implicit none
	include 'bbs_inc.for'
	character*(*) msg_str

	bbs_put_output = ss$_normal

	if (controlc_typed) return
	call ctrl_o_check(*10,*10)
	write(6,1001)crlf(:cl)//msg_str
	return

 0010	controlc_typed = .true.
	return

 1001	format(a)
	end

	integer function bbs_get_input(get_str,prompt_str,out_len)
c
c	This routine mimics lib$get_input for the bbs to allow it to use
c	its own carriage control, typeahead buffer, and interrupt routines
c
	implicit none
	include 'bbs_inc.for'
	character*(*) get_str,prompt_str
	integer*2 out_len

	bbs_get_input = ss$_normal

	if (controlc_typed) go to 10

	call ctrl_o_check(*10,*10)
	write(6,1001)crlf(:cl)//prompt_str
	out_len=50
	call get_uplow_string(get_str,out_len)
	return

 0010	controlc_typed = .true.
	get_str=' '
	out_len=0
	return

 1001	format(a)
 1002	format(q,a)
	end

	subroutine out(msg_str,*)
c
c	This routine provides a convienient way to output a line and
c	check the status on return.
c
	implicit none
	include 'bbs_inc.for'
	character*(*) msg_str

	call ctrl_o_check(*10,*10)
	write(6,1001)crlf(:cl)//msg_str
	return

 0010	return 1

 1001	format(a)
	end

	subroutine add_elapsed_time(*)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c
c	This routine is called at each entry to the main or mail menu.  It 
c	will add the time so far to the user's time and check it against
c	the total allowed.  The LIB$INIT_TIMER must have been called previous
c	to calling this routine.
c
c	Rev. 3.6  25-Jun-1986
c	Rev. 4.1  07-Jul-1986
c	Rev. 4.4  15-Aug-1986
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	implicit none
	include 'bbs_inc.for/nolist'
	character cdate*9,ctime*8
	real*8 systime,qdummy,mill10
	integer*4 zone,daynum,oldzone,istat
	integer*4 syst(2),hours
	integer lib$day_of_week,lib$stat_timer
	equivalence(systime,syst)
	data mill10/'ffffffffff676980'x/	!Quadword -10,000,000
	
 1001	format(a)
 1002	format(i2)

c	See if the date has changed.
	call date(cdate)
	if(cdate.ne.ur.current_day) then
	    read(1,key=ur.user_key,iostat=ios,err=90500)ur
	    ur.current_day=cdate
	    ur.seconds_today=0
	    rewrite(1,iostat=ios,err=90500)ur
	    initial_units=0
	    current_units=0
	    call init_timer(user_timer)
	    write(6,1001)crlf(:cl)//crlf(:cl)//'Your timer has been reset.'//
	1	crlf(:cl)//bell
	    end if
c
c	Find out how badly to hit him.
	zone=lib$day_of_week(,daynum)
	call time(ctime)
	read(ctime,1002)hours
	zone=1
	if(hours.gt.18)zone=2
	if(hours.lt.08.or.daynum.ge.6)zone=4
	if(zone.ne.oldzone) then
	    read(1,key=ur.user_key,err=90500)ur
	    ur.seconds_today = current_units
	    rewrite(1,err=90500)ur
	    call init_timer(user_timer)
	    initial_units=ur.seconds_today
	    oldzone=zone
	    endif

c	Return his time used as a quadword.
	istat=lib$stat_timer(1,qdummy,user_timer)

c	Divide the system time by -10,000,000 to get seconds
	call ediv(qdummy,mill10,systime)

	current_units=syst(1)/zone+initial_units
	if(current_units.gt.allowable_units) return 1
	if(current_units.gt.ur.seconds_today+60) then
	    read(1,key=ur.user_key,iostat=ios,err=90500)ur
	    ur.seconds_today = current_units
	    rewrite(1,iostat=ios,err=90500)ur
	    endif
	return

90500	continue
	return 1
	end

	subroutine arklug_files_section
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine takes care of the ARKLUG files section
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 3.6  25-Jun-1986
c	Rev. 6.1  08-Jun-1988
c	Rev. 7.1  19-Sep-1988
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include 'sys$library:foriosdef/nolist'
	include '($rmsdef)'
	character cdummy*1,darea*3
	character filename*50,filnam*80,disk*4,line*200,ftyp*7
	character binasc*4,zfilnam*20,term*5,cdate*9
	character space*30/'                    '/
	logical*1 reprint,dummyl
	integer i,istat,per,spc,length,flen
	integer file_character/65/	! The value of 'A' in decimal
	integer dummy,dummy1
	integer get_xmodem,send_xmodem
	integer fsize,rev_date(2),back_date(2)
	integer sflags/4/
	logical get_vaxfile,kermit_receive
	integer lib$spawn,lib$delete_file,str$trim,sys$setddir
	integer lbr$output_help,str$upcase,sys$trnlog,lib$set_logical
	real*8  noprivs/'000000000000000'x/
	external getsize,bbs_put_output,bbs_get_input
	record /userlog_structure/ zur

	common/filesize/fsize,rev_date,back_date

 1001	format(a)
 1003	format(q,a)
 1004	format('$!',a3,'=',a18,i3,1x,a)
 1019	format(a1,'file_',i6.6,'.dat')
 1024   format(i5.5)

c	Start the whole thing off
 4000	continue
	call date(cdate)
	write(term,1024)user_number	! set up terminal name for Kermit
	write(6,1001)crlf(:cl)//
	1   '(D)ownload, (U)pload, (H)elp or (E)xit? [exit] '
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	if(cdummy.eq.'D') go to 4100
	if(cdummy.eq.'U') go to 4700
	if(cdummy.eq.'H') then
	    controlc_typed=.false.
	    istat=lbr$output_help(bbs_put_output,,
	1	'bbs_help file_transfer','ubbs_data:helplib',,bbs_get_input)
	    go to 4000
	    end if
	write(6,1001)crlf(:cl)//'Invalid selection.  Please try again.'
	go to 4000

 4100	continue		!Download
	if (.not.approved_file_down) then
	    write(6,1001)crlf(:cl)//bell//
	1	'You are not yet approved for the files section.'
	    write(6,1001)crlf(:cl)//'Sorry.'
	    return
	    end if
	area='download'
	write(6,1001)crlf(:cl)//
	1   'You are now entering DCL. You may move freely thru the DECUS'
	write(6,1001)crlf(:cl)//
	1   'directory with DCL commands.  Kermit and Xmodem are available'
	write(6,1001)crlf(:cl)//'for downloading.'
	write(6,1001)crlf(:cl)//
	1   'Note: You have only read permissions on all files.'//crlf(:cl)
	istat= sys$trnlog('SYS$DISK',,line,,,)
	istat=lib$set_logical('SYS$DISK','DUA10:')
	istat=sys$setddir('[decus]',dummy,filnam)
	call setup_local(.false.)
	istat=lib$spawn(,,,sflags,,,,,,,)
	call setup_local(.true.)
	istat=sys$setddir(filnam(1:dummy),,)
	istat=str$trim(line,line,dummy)
	istat=lib$set_logical('SYS$DISK',line(1:dummy))
	return
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 4700	continue		!Upload
	area='upload'
	if (.not.approved_file_up) then
	    write(6,1001)crlf(:cl)//bell//
	1	'You are not yet approved for the files section.'
	    write(6,1001)crlf(:cl)//'Sorry.'
	    return
	    end if
	if(reprint.or.(.not.ur.xpert)) then
	    reprint=.false.
	    call out(crlf(:cl)//'The following upload areas'//
	1	' are available:',*4701)
	    call out('VAX - VAX/VMS',*4701)
	    call out('PDP - PDP 11 series',*4701)
	    call out('RNB - Rainbow',*4701)
	    call out('MIS - Miscellaneous files',*4701)
 4701	    write(6,1001)crlf(:cl)//'Enter area of interest? [exit]'
	else
	    write(6,1001)crlf(:cl)//'Area? '
	end if
	dummy=3	    	    
	call get_uplow_string(darea,dummy)
	istat = str$upcase(darea,darea)
	if(dummy.eq.0.or.darea.eq.'EXI') go to 4900
	if(darea.eq.'?') then
	    reprint=.true.
	    go to 4700
	    end if
	if( (darea.ne.'VAX') .and. (darea.ne.'PDP') .and.
	1   (darea.ne.'RNB') .and. (darea.ne.'MIS')) then
	    write(6,1001)crlf(:cl)//
	1	'That is not a valid area.  Please try again'
	    reprint=.true.
	    go to 4700
	    end if
	write(6,1001)crlf(:cl)//'(A)scii, (B)inary, (H)elp, (E)xit? [exit]'
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if (cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	if (cdummy.eq.'A') then
	    file_type = ascii
	    ftyp='Ascii '
	    binasc='.asc'
	else if (cdummy.eq.'B') then
	    file_type=binary
	    ftyp='Binary'
	    binasc='.bin'
	else if (cdummy.eq.'H') then
	    controlc_typed=.false.
	    istat=lbr$output_help(bbs_put_output,,
	1	'bbs_help file','ubbs_data:helplib',,bbs_get_input)
	    go to 4700
	else
	    write(6,1001)crlf(:cl)//'Invalid selection. Please try again'
	    go to 4700
	end if

	if(file_type.eq.binary) then
	    write(6,1001)crlf(:cl)//'Binary transfers must be by xmodem'
	    write(6,1001)crlf(:cl)//'or Kermit protocol.'
	    write(6,1001)crlf(:cl)//'(K)ermit or (X)modem protocol? [exit] '
	    dummy=1
	    call get_upcase_string(cdummy,dummy)
	    if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	    if(cdummy.eq.'K') protocol=kermit
	    if(cdummy.eq.'X') protocol=xmodem
	    if(protocol.eq.unknown) go to 4720
	else
 4720	    write(6,1001)crlf(:cl)//'(A)scii, (K)ermit or'//
	1	' (X)modem protocol? [exit] '
	    dummy=1
	    call get_upcase_string(cdummy,dummy)
	    if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	    if(cdummy.eq.'A') protocol=asciid
	    if(cdummy.eq.'K') protocol=kermit
	    if(cdummy.eq.'X') protocol=xmodem
	    if(protocol.eq.unknown) go to 4720
	end if	
c	get the file name
	write(6,1001)crlf(:cl)//
	1   'File names may consist of a-z, 0-9, underscore,'
	write(6,1001)crlf(:cl)//
	1   'and at most 1 period.  Names may be 1-18 characters.'
	write(6,1001)crlf(:cl)//'File name? [exit]'
	flen=18
	call get_filnam_string(filename,flen)
	if(flen.eq.0) go to 4900
c
c	compute a dummy file name
c
	write(zfilnam,1019)char(file_character),user_number
	filnam='ubbs_files:[upl]'//zfilnam
	file_character=file_character+1
c
c	if he has made it this far, we are ready to upload.
c
	if(protocol.eq.xmodem) then
	    write(6,1001)crlf(:cl)//
	1	'Beginning xmodem upload -- Ctrl-d to abort.'
	    call init_timer(file_timer)
	    call clear_counts()
	    timeout_count=10
	    retry_limit=5
	    flow=to_vax
	    bitmask=eightbit_mask
	    dummyl=get_vaxfile(filnam)
	    dummyl=get_xmodem()
	    bitmask=sevenbit_mask
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	    if(dummyl) then
		write(6,1001)crlf(:cl)//'Successful upload!'
		go to 4800
	    else
		write(6,1001)crlf(:cl)//'Upload failed'
 4730		istat = lib$delete_file(filnam//';*')
	    end if
	elseif (protocol.eq.kermit) then
	    flow=to_vax
	    call clear_counts()
	    call default_parameters()
	    timeout_count=10
	    retry_limit=5
	    write(6,1001)crlf(:cl)//
	1	'Beginning Kermit upload.'
	    call waitabit('2')
	    call init_timer(file_timer)
	    dummyl=get_vaxfile(filnam)
	    dummyl = kermit_receive(ldesc, rbuffer, xbuffer)
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	    if(dummyl) then
		write(6,1001)crlf(:cl)//'Successful transfer'
		go to 4800
	    else
		write(6,1001)crlf(:cl)//'Transfer failed.'//bell
		istat=lib$delete_file(filnam//';*')
	    end if
	else			!ascii upload
	    flow=to_vax
	    dummyl=get_vaxfile(filnam)
	    call out('Ascii files must not contain any non-printable',*4739)
	    call out('characters, and must not have any lines over',*4739)
	    call out('200 characters in length.',*4739)
	    call out('Each line must be terminated by a carriage',*4739)
	    call out('return.  The BBS will add a line feed for each',*4739)
	    call out('line you send.',*4739)
	    call out('Control-z to end, Control-c to abort.',*4739)
 4739	    write(6,1001)crlf(:cl)//crlf(:cl)//bell//
	1	'Start your file send now.'
	    write(6,1001)crlf(:cl)
 4740	    length=-200
	    call get_uplow_string(line,length)
	    if(length.lt.0) go to 4750
	    call send_cr()
	    call send_lf()
	    if(length.eq.0) then
		write(file_unit,1001)' '
	    else
		write(file_unit,1001)line(1:length)
	    end if
	    go to 4740

 4750	    if(length.eq.-1) then
		close(unit=file_unit)
		write(6,1001)crlf(:cl)//'Successful upload!'
		go to 4800
	    else
		close(unit=file_unit,disp='delete')
		write(6,1001)crlf(:cl)//bell//'Upload aborted'
	    end if
	end if
	go to 4900

 4800	continue	! get file description
	write(6,1001)crlf(:cl)//'Please give a 1-line description of the'
	write(6,1001)crlf(:cl)//'file for the download directory.'
	write(6,1001)crlf(:cl)//'?'
	dummy=40
	call get_uplow_string(line,dummy)
	if(dummy.eq.0.or.line.eq.' ') go to 4800

c	find out how big the file is.  This useropen will put the file
c	size into fsize.
	open(unit=4,file=filnam,status='old',readonly,
	1   useropen=getsize)
	close(unit=4)

c	Format a message and send to the operator.
	open(unit=4,file='mail.tmp',status='new',
	1    carriagecontrol='list')
	istat=str$trim(filnam,filnam,dummy)
	write(4,1001)'File name='//filename
	write(4,1001)'From:'//mail_name//' Stored as:'//zfilnam
	write(4,1001)'$rename '//filnam(1:dummy)//
	1   ' ubbs_files:['//darea//binasc//']'//filename(1:flen)
	write(4,1004)darea,filename(1:18),fsize,ftyp//cdate//
	1   ' '//line(1:dummy)
 	close(unit=4)
	istat = lib$spawn('mail/subject="upload" mail.tmp sysop')
	go to 4900	!finished
 
 4900	continue
	return
	end

	subroutine listcat(darea)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will give the directory of files for a download area
c	Dale Miller - UALR
c
c
c	Rev. 4.0  27-Jun-1986
c	Rev. 4.5  24-Sep-1986
c	Rev. 6.0  06-Jun-1988
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for'
	character*(*) darea
	character cdate*11,filtyp*6,startoff*18
	integer length,dummy
	real*8 long_ago
	logical short

	integer istat,keyln
	integer compquad
	integer sys$asctim,sys$bintim,str$upcase,str$trim
	external uopen

	record/file_description/ fd

	short=.true.
	write(6,1001)crlf(:cl)//'Do you want a short or a long listing?'//
	1   ' [Short]'
	dummy=5
	call get_upcase_string(startoff,dummy)
	if(startoff(1:1).eq.'L') short=.false.

	write(6,1001)crlf(:cl)//'Enter earliest date of files you'//
	1   ' wish to see.'//crlf(:cl)//
	2   'The date must be dd-mmm-yyyy (e.g. 19-APR-1986)'//
	3   crlf(:cl)//'Or enter <cr> for a all dates.'//
	4   crlf(:cl)//'?'
	dummy=11
	call get_uplow_string(cdate,dummy)
	if(dummy.eq.0) cdate='01-JUL-1985'
	istat=str$upcase(cdate,cdate)
	istat = sys$bintim(cdate(:11)//' 00:00:00.00',long_ago)
	write(6,1001)crlf(:cl)//
	1   'Enter the starting file name or <cr> for beginning :'
	dummy=18
	startoff=char(0)
	call get_filnam_string(startoff,dummy)
	if(startoff.eq.' ') startoff='.'
	cdate(5:5)=char(ichar(cdate(5:5))+32)
	cdate(6:6)=char(ichar(cdate(6:6))+32)
	write(6,1001)crlf(:cl)//'    Files since: '//cdate(:11)
	call ctrl_o_check(*10,*10)

c	Open the indexed file for reading.
	open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5   readonly,		key=(1:18:character),
	6   useropen=uopen)

	fd.file_name='$Header'
	read(4,key=fd.file_name,err=100)fd
	istat = sys$asctim(,cdate,fd.upload_date,)

	cdate(5:5)=char(ichar(cdate(5:5))+32)
	cdate(6:6)=char(ichar(cdate(6:6))+32)
	write(6,1001)crlf(:cl)//'Last file added: '//cdate(:11)
	call ctrl_o_check(*10,*10)

 0100	fd.file_name=startoff
	read(4,keygt=fd.file_name,iostat=ios)fd
	do while (ios.eq.0)
	    call ctrl_o_check(*10,*10)
	    if(fd.file_type.eq.'A') then
		filtyp='Ascii '
	    else if(fd.file_type.eq.'B') then
		filtyp='Binary'
	    else
		go to 110
	    end if
	    istat=compquad(fd.upload_date,long_ago)
	    if(istat.ne.-1 .and. (.not.short)) then
		write(6,1001)crlf(:cl)//
	1	    '************************************************'//
	2	    '***********************'//crlf(:cl)
		istat = sys$asctim(,cdate,fd.upload_date,)
		cdate(5:5)=char(ichar(cdate(5:5))+32)
		cdate(6:6)=char(ichar(cdate(6:6))+32)
		istat=str$trim(fd.keywords,fd.keywords,keyln)

	    	write(6,1002)crlf(:cl),fd.file_name,cdate(:11),
	1	    (fd.file_size+1)/2,filtyp,fd.times_down,
	2	    crlf(:cl)//crlf(:cl),
	3	    fd.keywords(:keyln),fd.upload_name//crlf(:cl)

		istat=index(fd.upload_text,char(cr))
		do while(istat.ne.0)
		    write(6,1001)crlf(:cl)//fd.upload_text(:istat-1)
		    call ctrl_o_check(*10,*10)
		    fd.upload_text=fd.upload_text(istat+1:)
		    istat=index(fd.upload_text,char(cr))
		    end do
	        end if
	    if(istat.ne.-1 .and. short) then
		istat = sys$asctim(,cdate,fd.upload_date,)
		cdate(5:5)=char(ichar(cdate(5:5))+32)
		cdate(6:6)=char(ichar(cdate(6:6))+32)
		istat=str$trim(fd.keywords,fd.keywords,keyln)

	    	write(6,1003)crlf(:cl),fd.file_name,cdate(:11),
	1	    (fd.file_size+1)/2,filtyp,fd.keywords(:keyln)

	        end if
 0110	    read(4,keygt=fd.file_name,iostat=ios)fd
	    end do
 0010	close(unit=4)
	return
 1001	format(a)
 1002	format(a,a18,5x,a11,1x,i5,'K bytes',2x,a6,4x,'Accesses:',i5,a,5x,
	1   'Keywords: ',a,' By:',a)
 1003	format(a,a18,1x,a11,i4,'K ',a6,1x,a)
	end

	subroutine enter_message(length,*,size)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine handles the entering of messages.
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.8  05-Feb-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include 'sys$library:foriosdef/nolist'

	character cdummy*1,string*80,term*5
	logical flag
	integer*4 i,length,dummy,istat,number,size,current
	integer array_edit
c	system routines
	integer str$trim

 1001	format(a)
 1011	format(i<dummy>)
 1013	format(a,i2,'>')
 1015	format(a,i2,1x,a)
 1024	format(i5.5)

	write(term,1024)mod(user_number,100000)
	current=0
	if(size.eq.0) write(6,1001)crlf(:cl)//crlf(:cl)//
	1   'Your message may be 1 to 20 80-character lines.'
	if((ur.editor.and.1).eq.1) then
	    length=0
	    call setup_local(.false.)
	    call array_edit(message,length,80,20)
	    call setup_local(.true.)
	    if(length.gt.20) then
		write(6,1001)crlf(:cl)//'Truncated to 20 lines'
		length=20
		end if
	    if(length.eq.0) then
		write(6,1001)crlf(:cl)//'Message aborted.'//bell
		return 1
		end if
	    go to 3060
	    end if

	write(6,1001)crlf(:cl)//'End your entry with a blank line.'
	i=1
 3040	do length=i,20
	    dummy=80
	    if((size.ne.0).and.(size-current.lt.79)) dummy=size-current-1
	    write(6,1013)crlf(:cl),length
	    call get_uplow_string(message(length),dummy)
	    if(dummy.eq.0) go to 3050
	    current=current+dummy+1
	    if((size.ne.0).and.(current.ge.size)) go to 3050
	    end do
	length=21
 3050	length=length-1			!message length
	if(length.eq.0) then
	    write(6,1001)crlf(:cl)//'Message aborted.'//bell
	    return 1
	    end if
c	send menu goes here
 3060	write(6,1001)crlf(:cl)//crlf(:cl)//'(S)end, (C)ontinue,'//
	1   ' (A)bort, (L)ine-edit, (F)ull-edit or (E)dit? [S] '
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if(dummy.eq.0) return
	if(cdummy.eq.'A') then			! Abort message send
	    write(6,1001)crlf(:cl)//'Entry aborted.'//bell	
	    return 1
	    endif
	if(cdummy.eq.'C') then			! Continue entering
	    i=length+1
	    go to 3040
	    endif
	if(cdummy.eq.'E'.or.cdummy.eq.'F'.or.cdummy.eq.'L') then ! Edit message
	  if((((ur.editor.and.1).eq.1).and.cdummy.ne.'L')
	1    .or. cdummy.eq.'E') then
	    call setup_local(.false.)
	    istat=array_edit(message,length,80,20)
	    call setup_local(.true.)
	    if(length.gt.20) then
		write(6,1001)crlf(:cl)//'Truncated to 20 lines'
		length=20
		end if
	    if(length.eq.0) then
		write(6,1001)crlf(:cl)//'Message aborted.'//bell
		return 1
		end if
	    go to 3060
	  else
 3069	    write(6,1001)crlf(:cl)//'Your entry now reads:'
	    do i=1,length
		istat=str$trim(message(i),message(i),dummy)
		write(6,1015)crlf(:cl),i,message(i)(1:dummy)
		end do
	    write(6,1001)crlf(:cl)
 3070	    write(6,1001)crlf(:cl)//
	1	'Which line do you wish to change? [exit] '
	    dummy=2
	    flag=.false.
	    call get_number(string,dummy,flag)
	    if(dummy.eq.0) go to 3060
	    read(string,1011)number
	    if(number.eq.0) go to 3060
	    if(number.gt.length) then
		write(6,1001)crlf(:cl)//'Invalid line number'
		go to 3070
		end if
	    write(6,1001)crlf(:cl)//'Line editor activated'
	    write(6,1013)crlf(:cl),number
	    dummy=80
	    call get_edit_string(message(number),dummy)
	    go to 3070
	  end if
	    end if
	if(cdummy.eq.'S') then			! Save message
	    return
	    end if

c	Otherwise, error.
	write(6,1001)crlf(:cl)//bell//'Invalid response..try again.'//bell
	go to 3060 

	end

	subroutine get_edit_string (string,len)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will perform MS-BASIC type line editing on a string.
c	Dale Miller - UALR
c
c
c	Rev. 4.8  05-Feb-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	character string*(*),temp3*200
	logical*1 back_up(3)/bs,' ',bs/
	logical*1 del_stg(3)/'\',' ','\'/
	logical*1 to_send(1)
	integer tempi,j,i
	integer max,len,current,istat
	integer str$trim
	integer read_byte

 1001	format(a)
c	Find out current length
	istat=str$trim(string,string,current)
	max=len
	len=0
	timeouts=0
	temp3=' '

c	Initial mode -- no controls entered
 0010	continue
	tempi=read_byte(60)
	if(timeouts.gt.4) call finish_timeout
	if(tempi.eq.cr. or. tempi.eq.69 .or.
	1   tempi.eq.101) then
	    go to 50				!carriage return or 'E'
	else if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rubout
	    if(len.eq.0) go to 10			!nothing to delete
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then		!Control-r
	    call out(temp3(1:len),*10)
	else if(tempi.eq.nak .or. tempi.eq.can) then	! Ctrl-u or ctrl-x
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	else if(tempi.eq.32) then		! Space - take next char
	    if(len.ge.current) go to 10
	    len=len+1
	    temp3(len:len)=string(len:len)
	    to_send(1)=ichar(string(len:len))
	    call send_byte(to_send)
	else if(tempi.eq.68 .or. tempi.eq.100) then	! 'D' - delete next char
	    if(len.ge.current) go to 10
	    del_stg(2)=ichar(string(len+1:len+1))
	    call raw_write(del_stg,3)
	    string(len+1:)=string(len+2:)
	    current=current-1
	else if(tempi.eq.63 .or. tempi.eq.105) then	! 'I' - Insert mode
	    go to 0100				! too involved for inline
	else if(tempi.eq.88 .or. tempi.eq.120) then	! 'X' - extend
c	     Actually, EOL plus I.
	    if(current.gt.len) then
		temp3(len+1:current)=string(len+1:current)
		write(6,1001)temp3(len+1:current)
		len=current
		end if
	    go to 0100
	else if(tempi.eq.72 .or. tempi.eq.104) then	! 'H' - Hack
	    current=len
	    temp3(len+1:)=' '
	    string(len+1:)=' '
	    go to 0100
	end if

	go to 10

 0050	continue
	if(current.gt.len) then
	    temp3(len+1:current)=string(len+1:current)
	    write(6,1001)temp3(len+1:current)
	    len=current
	    end if
	string=temp3
	return

 0100	continue	! Insert mode.  Only allowed control is BS.
	tempi=read_byte(60)
	if(timeouts.gt.4) call finish_timeout
	if(tempi.eq.cr) go to 50		!carriage return
	if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rubout
	    if(len.eq.0) go to 10			!nothing to delete
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then		!Control-r
	    call out(temp3(1:len),*10)
	else if(tempi.le.us) then		! Other control
	    go to 10
	else					! Valid input character
	    if(len.ge.max) go to 10
	    len=len+1
	    temp3(len:len)=char(tempi)
	    to_send(1)=tempi
	    call send_byte(to_send)
	    string(len:)=char(tempi)//string(len:)
	    current=current+1
	end if

	go to 100

	end

	integer function array_edit(passed_data,passed_length,row,col)
C+++
C MODULE NAME:	array_edit	FILE NAME: array_edit.for
C MODULE OVERVIEW:
C	This subroutine invokes the EDT editor on an array of
C	character data. 
C	Given an array of data (up to max_col lines long), this
C	routine will send it to EDT and, upon termination of
C	EDT, return the data in a standard FORTRAN character
C	array.  Users may use all features of EDT except journal
C	files.
C
C FORMAL PARAMETERS:
C	passed_data : the address of a fixed string descriptor for
C			a FORTRAN character data array. READ/WRITE
C	passed_length : the current number of lines filled in the
C			array. READ/WRITE
C	row : the width of the array, in bytes (ie, the line length) READ
C	col : the length of the array, up to max_col (defined as 100)
C		 lines long READ
C
C CALLS:
C	EDT$EDIT : to edit the data.
C
C IMPLICIT INPUTS:
C	none
C
C IMPLICIT OUTPUTS:
C	none
C
C SIDE EFFECTS:
C	any side effects possible with EDT (including "write")
C
C COMPLETION CODES:
C	SS$_NORMAL -- for normal return
C	SS$_BADPARAM -- for illegal parameters
C	SS$_INSFMEM -- unable to allocate sufficient virtual memory
C
C AUTHOR: jms 		CREATION DATE: May 21, 1985
C MAINTENANCE RECORD: (edit increment number, description, date, initials)
C	V1.00-00	jms	Original version
C
C---
c	Rev. 5.2  17-Oct-1987
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


	implicit none

C	arguments

	character*(*) passed_data(*)		! the passed data block
	integer passed_length			! how many lines are filled
	integer row				! number of rows in input
	integer col				! number of columns in input

C	include files

C	integer*4 max_col			! maximum number of columns
	parameter max_col = 100			! SEE ALSO ARRAY_EDIT
	integer*4 length			! length of data
	integer*4 data(2,max_col)		! DSD for up to 100 records
	common /array_edit_common/ length,data	! common block definition
	include '($SSDEF)'

C	local variables

	integer		com_data(2,max_col)	! pointers to string data
	integer		null_string(2)		! a null string, for length
	integer		cur_len			! length of a string
	integer		index			! do loop index variable
	integer		index2			! do loop index variable
	character*1 	null_character		! the null character
	character*32    ctrl_chrs
	integer 	afileio_bpv(2)		! BPV data type for EDT$EDIT
	integer		afileio			! subroutine to handle I/O
	external 	afileio

C	RTL functions

	integer		str$left		! extract substring of a string
	integer		str$copy_dx		! copy by descriptor src->dst
	integer		lib$sget1_dd		! get 1 dynamic string
	integer		str$find_first_in_set	! find 1st char in set of chars
	integer		edt$edit		! callable EDT editor 
	integer		str$trim		! remove trailing spaces

	ctrl_chrs  =  char(00)//char(01)//char(02)//char(03)//char(04)//
	1   char(05)//char(06)//char(07)//char(08)//char(09)//char(10)//
	2   char(11)//char(12)//char(13)//char(14)//char(15)//char(16)//
	3   char(17)//char(18)//char(19)//char(20)//char(21)//char(22)//
	4   char(23)//char(24)//char(25)//char(26)//char(27)//char(28)//
	5   char(29)//char(30)//char(31)

	array_edit = SS$_NORMAL			! set default return status
	length=passed_length			! fill in common block
	afileio_bpv(1) = %loc(afileio)		! and create the descriptor
	afileio_bpv(2) = 1			! for the BPV.

C	parameter bounds checking. 
	if (col.gt.max_col .or. col.lt.0 .or. row.lt.0 .or. 
	1	passed_length.lt.0) then
		array_edit = SS$_BADPARAM
		return
	endif

C+++
C Witness a major kludge -- getting FORTRAN fixed string descriptors
C to convert to VMS dynamic string descriptors.  For each row in the
C array, get a dynamic string of length row.  Copy the FORTRAN entry
C at row I into the dynamic string descriptor, and then shorten
C the dynamic string to the correct length.
C---
	do index=1,col
		if (lib$sget1_dd(row,data(1,index)) .ne. SS$_NORMAL) then
			array_edit = SS$_INSFMEM
			return
		endif
		call str$trim(data(1,index),
	1	    passed_data(index)(1:row),cur_len)
	end do

C+++
C Now, call the editor.
C---
	call edt$edit ( 'an input file',! input file
	1		'You have entered', ! output file
	2		'ubbs_data:wordwrap.edt',	! command file
	3		,		! journal file
	4		"44,		! bits 1B5,1B2
	5		afileio_bpv,	! fileio routine
	6		,		! workio routine
	7		,)		! xlate routine


C+++
C copy the data back into the FORTRAN array, and
C update the length. Since str$copy_dx signals all
C errors (except STR$_TRU, which we don't care about
C anyway), no need to check status. Return from whence we came.
C---
	do index=1,col
	    call str$copy_dx( passed_data(index) , data(1,index) )
	    end do
	do index=1,min(length,col)
	    index2=str$find_first_in_set(passed_data(index),ctrl_chrs)
	    do while(index2.ne.0)
		if(index2.eq.1) then
		    passed_data(index)=passed_data(index)(2:)
		else
		    passed_data(index)=passed_data(index)(1:index2-1)//
	1		passed_data(index)(index2+1:)
		end if
		index2=str$find_first_in_set(passed_data(index),ctrl_chrs)
		end do
	    end do
	passed_length=length
	return

	end

	integer function afileio(code, stream, record, rhb)

C+++
C MODULE NAME:	afileio		FILE NAME:	array_edit.for
C MODULE OVERVIEW:
C	This subroutine is passed to the EDT$EDIT subroutine
C	to simulate disk i/o. In this way, arrays of data
C	can be edited with the EDT editor.
C
C FORMAL PARAMETERS:
C	code : the action desired (defined by EDTSHR.EXE)
C	stream : the file for which "code" action is desired
C	record : the record to read/write OR the filename to open
C	rhb : the record header block (not VMS) OR the related filename to open
C
C IMPLICIT INPUTS:
C	from common block /ARRAY_EDIT_COMMON/
C		length : the length of the data (read/write)
C		data : the original data (not updated until EDT exits)
C
C IMPLICIT OUTPUTS:
C	none
C
C SIDE EFFECTS:
C	none
C
C COMPLETION CODES:
C	SS$_NORMAL : all normal errors
C	RMS$_EOF : for end of file on read
C	all other errors are signaled.
C
C AUTHOR: jms		CREATION DATE:	May 21, 1985
C MAINTENANCE RECORD:
C	V1.00-0		Original Version	JMS
C
C---

	implicit none

C passed arguments

	integer*4 code				! code passed in from EDT
	integer*4 stream			! stream to act upon
	integer*4 record(2)			! DSD for record
	integer*4 rhb(2)			! DSD for record header block

C common block definitions

C	integer*4 max_col			! maximum number of columns
	parameter max_col = 100			! SEE ALSO ARRAY_EDIT
	integer*4 length			! length of data
	integer*4 data(2,max_col)		! DSD for up to 100 records
	common /array_edit_common/ length,data	! common block definition
	include 'bbs_inc.for'
C included libraries and constant files

c	include '($ssdef)'
	include '($rmsdef)'

C RTL routines
	
	integer		edt$fileio

C local variables

	integer		in_ptr			!input file pointer
	integer		out_ptr			!output file pointer


C set status initially to be normal

	afileio = SS$_NORMAL

C+++
C Determine what to do based on what file is being requested.
C For most files (all except input and output), we pass the I/O
C request on to the system EDT$FILEIO routine.  For input and
C output files, handle the I/O to/from an array. This is particularily
C easy since the input file is opened and read once, and the output
C file is opened and written once.
C---

	if (stream .eq. edt$k_input_file) then
C+++
C Handle case of input file. Check request. Normal requests
C are to open_input and get.  edt$k_close is also a legal
C request, which is ignored.  All othe requests are illegal,
C but we ignore them without returning error conditions.
C---
		if (code .eq. edt$k_get) then
C+++
C Read data until length lines have been reached.
C When done, return RMS$_EOF and do not copy.
C---
			if (in_ptr .gt. length) then
				afileio = RMS$_EOF
			else
				call str$copy_dx ( record, data(1,in_ptr) )
				in_ptr=in_ptr+1
				rhb(1)='020E0000'X	! fix numbers
			endif

		else if (code .eq. edt$k_open_input) then
C+++
C Reset input pointer to 1 when opening input file
C---
			in_ptr=1

		else if (code .eq. edt$k_open_output_seq) then

			continue				! error

		else if (code .eq. edt$k_open_output_noseq) then

			continue				! error

		else if (code .eq. edt$k_open_in_out) then

			continue				! error

		else if (code .eq. edt$k_put) then

			continue				! error

		else if (code .eq. edt$k_close_del) then

			continue				! no action

		else if (code .eq. edt$k_close) then

			continue				! no action

		endif

	else if (stream .eq. edt$k_output_file) then
C+++
C Handle case of output file. Legal actions are open_output_noseq,
C put, and close.  Close is used to reset the length to the
C length of the file. Open resets pointers, and put is used to
C write the data out. All other possible codes are checked for,
C but none are handled.
C---
		if (code .eq. edt$k_put) then

			if (out_ptr .le. max_col) then
				call str$copy_dx ( data(1,out_ptr), record )
				out_ptr = out_ptr+1
			endif

		else if (code .eq. edt$k_open_output_noseq) then

			length=0
			out_ptr=1

		else if (code .eq. edt$k_close) then

			length=out_ptr-1

		else if (code .eq. edt$k_get) then

			continue			! error

		else if (code .eq. edt$k_open_input) then

			continue			! error

		else if (code .eq. edt$k_open_output_seq) then

			continue			! error

		else if (code .eq. edt$k_open_in_out) then

			continue			! error

		else if (code .eq. edt$k_put) then

			continue			! error

		else if (code .eq. edt$k_close_del) then

			continue			! no action

		endif

	else if (stream .eq. edt$k_write_file) then

c		Allow if operator, otherwise ignore.
		if(sysop2) afileio = edt$fileio(code,stream,record,rhb)

	else if (stream .eq. edt$k_command_file) then

		afileio = edt$fileio(code,stream,record,rhb)

	else if (stream .eq. edt$k_include_file) then

		if(sysop2) then
			afileio = edt$fileio(code,stream,record,rhb)
		else if (code .eq. edt$k_get) then
			afileio = RMS$_EOF
			end if

	else if (stream .eq. edt$k_journal_file) then

		afileio = edt$fileio(code,stream,record,rhb)

	endif

	return

	end

	integer function netmail(
	1   node,			! Node to send to
	2   from_name,			! FROM name
	3   to_name,			! TO name @ node
	4   to_show,			! What to show in TO field
	5   subject,			! Subject
	6   text)			! Text array
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	NETMAIL.FOR
c	This program will send a message to a user using the VAX/VMS
c	"handle" via DECnet.  Based on a BASIC program from "VAX Professional"
c
c	Dale Miller - UALR
c
c	Rev. 1.0  26-Jan-1987
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


	implicit none 
 
	character*(*)  node
	character*(*) from_name
	character*(*) to_name
	character*(*) to_show
	character*(*) subject
	character*80 text(20)
	character*80 work

	integer istat,len,mlen,i
	integer str$trim,str$upcase

	logical errchk

 1001	format(a)


c	Open the link to the mail task, and handle errors

	istat=str$upcase(work,node)
	istat=str$trim(work,work(1:6),len)

	open(unit=11,				! Open channel to MAIL server
	1   file=work(1:len)//'::"27="',
	2   access='sequential',
	3   form='formatted',
	4   carriagecontrol='none',
	5   status='new')

c	Send the FROM information

	istat=str$trim(from_name,from_name,len)
	write(11,1001,err=9999) from_name(1:len)
c	Send each message which states who should receive the text on the
c	other side. ALWAYS CHECK what status the MAIL server gives back.

	istat=str$upcase(work,to_name)
	istat=str$trim(work,work(1:32),len)
	write(11,1001,err=9999)work(1:len)

	if (errchk(0)) go to 9999		! Check if MAIL server accepted
c	Terminate the list of receivers with a one byte null record

	write(11,1001,err=9999) char(0)
c	Send the text that shows up in the TO: field of mail

	istat=str$trim(work,to_show,len)
	write(11,1001,err=9999) work(1:len)
c	Write the subject line to the DECnet link.

	istat=str$trim(work,subject,len)
	write(11,1001,err=9999) work(1:len)	! Put the text
c	Read in each line of text and send it across line by line.
c	This can be optimized to send one long chunk.

	mlen=20
	do while (text(mlen).eq.' ')
	    mlen=mlen-1
	    end do
	do i=1,mlen
	    istat=str$trim(work,text(i),len)
	    write(11,1001,err=9999) work(1:len)	! Put the text
	    end do 

c	Write end of text message.

	write(11,1001,err=9999) char(0)		! Put null byte
c	Loop through and receive the status code for all users
c	the mail was sent to.

	if(errchk(0)) go to 9999		! Go check error, print msgs
c	Finished, go close up shop

	close(unit=11)
	netmail=0
	return

 9999	Continue				! Error return
	close(unit=11)
	netmail=1
	return
	end
 
	logical function errchk(x)
c	Check to see if the message just sent was received ok; or, check
c	what the incoming message from the MAIL server says.
c	This routine will dump error text to the terminal
	implicit none
	character*255 mess
	integer len
	integer x,dummy

 1002	format(q,a)
	read(11,1002,err=2000)len,mess
	dummy=ichar(mess(1:1))
	if((dummy.and.1).eq.1) then		! Success?
	    errchk=.false.
	    return
	    end if

c	Come here if an error was received


 0020	continue
	read(11,1002,err=2000)len,mess(1:len)	! Get text/terminator indication

	if(len.ne.1) then			! If len <> 1, must be text
	    print*,mess(1:len)			! so print it
	    go to 0020				! and loop for possibly more
	    end if
	if(ichar(mess(1:1)).ne.0) go to 20	! 0 byte means all done
	errchk=.true.
	return

 2000	print*,'%Network communications error'
	errchk=.true.
	end

	subroutine get_password (password,len)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will read a password and echo asterisks in its place.
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.9  10-Feb-1987
c	Rev. 5.3  02-Dec-1987
c	Rev. 5.4  21-Dec-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	logical*1 asterisk(1)/'*'/
	logical*1 back_up(3)/bs,' ',bs/
	character password*(*)
	integer len,tempi,j,read_byte

	len=0
	timeouts=0
	password=' '

 0010	tempi=read_byte(60)
	if(timeouts.gt.4) call finish_timeout
	if(tempi.eq.cr) then				!carriage return
	    do j=len+1,10
		call send_byte(asterisk)
		end do
	    call send_byte(cr)
	    return
	else if(tempi.eq.bs.or.tempi.eq.rub) then	!Backspace or rubout
	    if(len.eq.0) go to 10			!nothing to delete
	    password(len:len)=' '
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.nak.or.tempi.eq.can) then	!^U or ^X
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	    password=' '
	else if(len.ge.10) then
	    go to 10
	else if(tempi.le.us) then			!other control character
	    go to 10
	else if(tempi.ge.97.and.tempi.le.122) then
	    tempi=tempi-32
	    len=len+1
	    password(len:len)=char(tempi)
	    call send_byte(asterisk)
	else
	    len=len+1
	    password(len:len)=char(tempi)
	    call send_byte(asterisk)
	end if

	go to 10

	end

	subroutine get_upcase_string (string,len)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will allow input of an upper-case-only string.
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.9  10-Feb-1987
c	Rev. 5.3  02-Dec-1987
c	Rev. 5.4  21-Dec-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	character string*(*)
	logical*1 back_up(3)/bs,' ',bs/
	logical*1 to_send(1)
	logical*1 spc
	integer tempi,len,max,j
	integer read_byte

	spc=.false.
	if(len.lt.0) then
	    len=-len
	    spc=.true.
	    end if
	max=len
	len=0
	timeouts=0
	string=' '

 0010	tempi=read_byte(60)
	if(timeouts.gt.4) then
	    call finish_timeout
	else if(tempi.eq.cr) then			!carriage return
	    call send_byte(cr)
	    return
	else if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rub
	    if(len.eq.0) go to 10			!nothing to delete
	    string(len:len)=' '
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then			!Control-r  (Repaint line)
	    call out(string(1:len),*10)
	else if(tempi.eq.nak.or.tempi.eq.can) then	!^U or ^X
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	    string=' '
	else if(len.ge.max) then
	    continue
	else if(tempi.le.us) then			!other control character
	    continue
	else if(tempi.eq.32.and..not.spc) then
	    continue

c	force to only alphabetic plus ' and -
	else if ((tempi.ge.33.and.tempi.le.38) .or.
	1   (tempi.ge.40.and.tempi.le.44) .or.
	2   (tempi.ge.46.and.tempi.le.64) .or.
	3   (tempi.ge.91.and.tempi.le.96) .or.
	4   (tempi.ge.123.and.tempi.le.126)) then
	    continue

c	good character
	else
	    len=len+1
	    if(tempi.ge.97.and.tempi.le.122) tempi=tempi-32
	    string(len:len)=char(tempi)
	    to_send(1)=tempi
	    call send_byte(to_send)
	end if

	go to 10

	end

	subroutine get_uplow_string (string,len)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will allow input of all but control characters.
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.9  10-Feb-1987
c	Rev. 5.3  02-Dec-1987
c	Rev. 5.4  21-Dec-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	character string*(*)
	logical*1 back_up(3)/bs,' ',bs/
	logical*1 to_send(1),ctlz
	integer read_byte,tempi,j,len,max

	ctlz=.false.		!assume no control-z allowed
	if(len.lt.0) then
	    len=-len
	    ctlz=.true.
	    end if
	max=len
	len=0
	timeouts=0
	string=' '

 0010	tempi=read_byte(60)
	if(timeouts.gt.4) then
	    call finish_timeout
	else if(tempi.eq.cr) then			!carriage return
	    call send_byte(cr)
	    return
	else if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rub
	    if(len.eq.0) go to 10			!nothing to delete
	    string(len:len)=' '				!Clear out old one
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then			!Control-r  (Repaint line)
	    call out(string(1:len),*10)
	else if(tempi.eq.nak.or.tempi.eq.can) then	!^U or ^X
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	    string=' '
	else if((tempi.eq.sub).and.(len.eq.0).and.ctlz) then !control-z (eof)
	    len=-1
	    string=' '
	    return
	else if((tempi.eq.etx).and.(len.eq.0).and.ctlz) then !control-c (abort)
	    len=-2
	    string=' '
	    return
	else if(len.ge.max) then
	    continue
	else if(tempi.le.us) then			!other control character
	    continue

c	good character
	else
	    len=len+1
	    string(len:len)=char(tempi)
	    to_send(1)=tempi
	    call send_byte(to_send)
	end if

	go to 10

	end

	subroutine get_number (string,len,flag)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will read a numeric string or an asterisk.
c	If flag = .true. an asterisk is allowed.
c
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.9  10-Feb-1987
c	Rev. 4.11 27-Nov-1987
c	Rev. 5.4  21-Dec-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	logical*1 asterisk(1)/'*'/
	logical*1 back_up(3)/bs,' ',bs/
	character string*(*)
	logical flag
	logical*1 to_send(1)
	integer read_byte,tempi,j,len,max

	max=len				
	len=0
	timeouts=0
	string=' '

 0010	tempi=read_byte(60)
	if(timeouts.gt.4) then
	    call finish_timeout
	else if(tempi.eq.cr) then			!carriage return
	    call send_byte(cr)
	    return
	else if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rub
	    if(len.eq.0) go to 10			!nothing to delete
	    string(len:len)=' '
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then			!Control-r  (Repaint line)
	    call out(string(1:len),*10)
	else if(tempi.eq.nak.or.tempi.eq.can) then	!^U or ^X
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	    string=' '
	else if(len.ge.max) then
	    continue
	else if(tempi.eq.42.and.(len.ne.0.or.(.not.flag))) then	!Asterisk
	     continue
	else if(tempi.gt.42.and.tempi.lt.48) then	!Non-numeric
	    continue
	else if(tempi.lt.42.or.tempi.gt.57) then	!Non-numeric
	    continue
	else if(string(1:1).eq.'*') then		!Asterisk was entered
	    continue
c	good character
	else
	    len=len+1
	    string(len:len)=char(tempi)
	    to_send(1)=tempi
	    call send_byte(to_send)
	end if

	go to 10

	end

	subroutine get_filnam_string (string,len)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will allow input of a VAX filename.
c
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.9  10-Feb-1987
c	Rev. 4.12 11-Jun-1987
c	Rev. 5.4  21-Dec-1987
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	character string*(*)
	logical*1 back_up(3)/bs,' ',bs/
	logical*1 to_send(1)
	logical*1 period
	integer read_byte,tempi,j,len,max

	period=.false.
	max=len
	len=0
	timeouts=0
	string=' '

 0010	tempi=read_byte(60)
	if(timeouts.gt.4) then
	    call finish_timeout
	else if(tempi.eq.cr) then			!carriage return
	    call send_byte(cr)
	    if(period) then
		return
	    else
		if(len.eq.max) len=len-1
		len=len+1
		string(len:len)='.'
		return
	    end if
	else if(tempi.eq.bs .or. tempi.eq.rub) then	!backspace or rub
	    if(len.eq.0) go to 10			!nothing to delete
	    string(len:len)=' '
	    len=len-1
	    call raw_write(back_up,3)
	else if(tempi.eq.dc2) then			!Control-r  (Repaint line)
	    call out(string(1:len),*10)
	else if(tempi.eq.nak.or.tempi.eq.can) then	!^U or ^X
	    do j=1,len
		call raw_write(back_up,3)
		end do
	    len=0
	    string=' '
	else if(len.ge.max) then
	    continue
	else if(tempi.le.us) then			!other control character
	    continue

c	force to only alphabetic plus _,$,- and .

	else if(tempi.eq.46.and.period) then
	    continue
	else if ((tempi.le.35) .or.
	1   (tempi.eq.36.and.len.eq.0) .or.		! Disallow leading $
	2   (tempi.ge.37.and.tempi.le.44) .or.
	3   (tempi.eq.47) .or.
	4   (tempi.ge.58.and.tempi.le.64) .or.
	5   (tempi.ge.91.and.tempi.le.94) .or.
	6   (tempi.eq.96) .or.
	7   (tempi.ge.123.and.tempi.le.126)) then
	    continue

c	good character
	else
	    len=len+1
	    if(tempi.ge.97.and.tempi.le.122) tempi=tempi-32
	    string(len:len)=char(tempi)
	    to_send(1)=tempi
	    call send_byte(to_send)
	    if(tempi.eq.46) period=.true.
	end if

	go to 10

	end

	subroutine searchcat(darea)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will search the directory of files for a download area
c	for a specific keyword.
c	Dale Miller - UALR
c
c
c	Rev. 4.10 11-Feb-1987
c	Rev. 6.0  06-Jun-1988
c	Rev. 7.2  02-Jan-1989
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for'
	character*(*) darea
	character cdate*11,filtyp*6,startoff*18
	character keyword*40,lookup*40
	integer length,dummy,kl
	real*8 long_ago
	logical short

	integer istat,keyln
	integer compquad
	integer sys$asctim,sys$bintim,str$upcase,str$trim
	external uopen

	record/file_description/ fd

	write(6,1001)crlf(:cl)//'Keyword to search for? [exit]'
	kl=40
	call get_uplow_string(keyword,kl)
	if(kl.eq.0) return
	istat=str$upcase(keyword,keyword)

	short=.true.
	write(6,1001)crlf(:cl)//'Do you want a short or a long listing?'//
	1   ' [Short]'
	dummy=5
	call get_upcase_string(startoff,dummy)
	if(startoff(1:1).eq.'L') short=.false.
	write(6,1001)crlf(:cl)//'Enter earliest date of files you'//
	1   ' wish to see.'//crlf(:cl)//
	2   'The date must be dd-mmm-yyyy (e.g. 19-APR-1986)'//
	3   crlf(:cl)//'Or enter <cr> for a all dates.'//
	4   crlf(:cl)//'?'
	dummy=11
	call get_uplow_string(cdate,dummy)
	if(dummy.eq.0) cdate='01-JUL-1985'
	istat=str$upcase(cdate,cdate)
	istat = sys$bintim(cdate(:11)//' 00:00:00.00',long_ago)
	istat = sys$asctim(,cdate,long_ago,)

	write(6,1001)crlf(:cl)//
	1   'Enter the starting file name or <cr> for beginning :'
	dummy=18
	startoff=char(0)
	call get_filnam_string(startoff,dummy)
	if(startoff.eq.' ') startoff='.'
	cdate(5:5)=char(ichar(cdate(5:5))+32)
	cdate(6:6)=char(ichar(cdate(6:6))+32)
	write(6,1001)crlf(:cl)//'    Files since: '//cdate(:11)
	call ctrl_o_check(*10,*10)

c	Open the indexed file for reading.
	open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5   readonly,		key=(1:18:character),
	6   useropen=uopen)

	fd.file_name='$Header'
	read(4,key=fd.file_name,err=100)fd
	istat = sys$asctim(,cdate,fd.upload_date,)

	cdate(5:5)=char(ichar(cdate(5:5))+32)
	cdate(6:6)=char(ichar(cdate(6:6))+32)
	write(6,1001)crlf(:cl)//'Last file added: '//cdate(:11)
	call ctrl_o_check(*10,*10)

 0100	fd.file_name=startoff
	read(4,keygt=fd.file_name,iostat=ios)fd
	do while (ios.eq.0)

	    call ctrl_o_check(*10,*10)

	    istat=str$upcase(lookup,fd.keywords)
	    if(index(fd.file_name//' '//lookup,keyword(1:kl)).eq.0) go to 110

	    if(fd.file_type.eq.'A') then
		filtyp='Ascii '
	    else if(fd.file_type.eq.'B') then
		filtyp='Binary'
	    else
		go to 110
	    end if
	    istat=compquad(fd.upload_date,long_ago)
	    if(istat.ne.-1 .and. (.not.short)) then
		write(6,1001)crlf(:cl)//
	1	    '************************************************'//
	2	    '***********************'//crlf(:cl)
		istat = sys$asctim(,cdate,fd.upload_date,)
		cdate(5:5)=char(ichar(cdate(5:5))+32)
		cdate(6:6)=char(ichar(cdate(6:6))+32)
		istat=str$trim(fd.keywords,fd.keywords,keyln)

	    	write(6,1002)crlf(:cl),fd.file_name,cdate(:11),
	1	    (fd.file_size+1)/2,filtyp,fd.times_down,
	2	    crlf(:cl)//crlf(:cl),
	3	    fd.keywords(:keyln),fd.upload_name//crlf(:cl)

		istat=index(fd.upload_text,char(cr))
		do while(istat.ne.0)
		    write(6,1001)crlf(:cl)//fd.upload_text(:istat-1)
		    call ctrl_o_check(*10,*10)
		    fd.upload_text=fd.upload_text(istat+1:)
		    istat=index(fd.upload_text,char(cr))
		    end do
	        end if
	    if(istat.ne.-1 .and. short) then
		istat = sys$asctim(,cdate,fd.upload_date,)
		cdate(5:5)=char(ichar(cdate(5:5))+32)
		cdate(6:6)=char(ichar(cdate(6:6))+32)
		istat=str$trim(fd.keywords,fd.keywords,keyln)

	    	write(6,1003)crlf(:cl),fd.file_name,cdate(:11),
	1	    (fd.file_size+1)/2,filtyp,fd.keywords(:keyln)

	        end if
 0110	    read(4,keygt=fd.file_name,iostat=ios)fd
	    end do
 0010	close(unit=4)
	return
 1001	format(a)
 1002	format(a,a18,5x,a11,1x,i5,'K bytes',2x,a6,4x,'Accesses:',i5,a,5x,
	1   'Keywords: ',a,' By:',a)
 1003	format(a,a18,1x,a11,i4,'K ',a6,1x,a)
	end

	subroutine send_code

c	These routines are used to send a control character to the remote.

	implicit none
	include 'bbs_inc.for/nolist'
	logical*1 last_code(2)

c	Entry to send line feed

	entry send_lf
	last_code(1) = lf
	go to 100

c	Entry to send carriage return

	entry send_cr
	last_code(1) = cr
	go to 100

c	Entry to send SOH (Start of Header).	CTRL/A

	entry send_soh
	last_code(1) = soh
	go to 100

c	Entry to send STX (Start of Text).	CTRL/B

	entry send_stx
	last_code(1) = stx
	go to 100

c	Entry to send ETX (End of Text).	CTRL/C

	entry send_etx
	last_code(1) = etx
	go to 100

c	Entry to send ACK (Acknowlegment).

	entry send_ack
	last_code(1) = ack
	go to 100

c	Entry to send NAK (Negative Acknowlement).

	entry send_nak
	last_code(1) = nak
	go to 100

c	Entry to send SYN (Synchronize).

	entry send_syn
	last_code(1) = syn
	go to 100

c	Entry to send ENQ (Enquire).

	entry send_enq
	last_code(1) = enq
	go to 100

c	Entry to send EOF (End of File).

	entry send_eof
	last_code(1) = sub
	go to 100

c	Entry to send EOT (End of Transmission).

	entry send_eot
	last_code(1) = eot
	go to 100

c	Entry to send CAN (Cancel).

	entry send_can
	last_code(1) = can
	go to 100

c	Entry to send 'C' (CRC sync character).

	entry send_c
	last_code(1) = '43'X
	go to 100
C
C	This entry is used to resend the last code in the event that
C	the previous transmission was lost or garbled and the remote
C	sent us an ENQ to find out what the last response was.
C
	entry resend_code
100	call raw_write (last_code(1), 1)
	return
	end

	logical function get_xmodem
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - GET_XMODEM.FOR
c	This routine is used transfer a file from the remote system to
c	the VAX using the XMODEM protocol.
c	Dale Miller - UALR
c
c	Rev. 4.13 04-Jul-1987
c	Rev. 5.6  03-Mar-1988
c	Rev. 6.2  21-Jul-1988
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'

	character*(*) module_name

	integer data_size,data_index,checksum_index
	parameter (module_name = 'get_xmodem')
C	parameter (data_size = 128)		! Number of data bytes.
	parameter (data_index = 4)		! Index to 1st data byte.
	parameter (checksum_index = 132)	! Index to checksum byte.
	logical report_error, received_eof,crc
	integer i, index, size, read_byte
	integer block_expected, previous_block, block_comp, checksum, rec_size
	integer xmodem_checksum
	integer high,low
	byte highbyte,lowbyte
	common /crcval/high,low
	equivalence (high,highbyte)
	equivalence (low,lowbyte)

	get_xmodem = .false.			! Initialize to bad return.
	data_size = 128				! Initialize to standard Xmodem

	block_expected = 1			! Initialize the block number.
	previous_block = block_expected		! Initialize the previous block.
	received_eof = .false.			! Initialize the EOF flag.
	rec_size = 0				! Initialize the record size.
	error_count = 0

c	Synchronize with remote XMODEM and determine if the transfer is
c	to be CRC or checksum.  Try CRC for 3 times before giving up and
c	using checksum.

	crc = .true.			!Assume CRC until proven otherwise
 0010	call send_c
	rbuffer(1) = read_byte (10)		! Read the first byte.
	if (liosb(1) .ne. ss$_normal) then
	    error_count = error_count + 1
	    if (error_count.gt.4) then
		error_count = 0
		go to 99
		end if
	    go to 10
	    end if
	if (rbuffer(1) .eq. eot) then
	    go to 700				! End of transmission.
	else if (rbuffer(1) .eq. soh) then
	    data_size = 128
	    go to 101				! Standard Xmodem
	else if (rbuffer(1) .eq. stx) then
	    data_size = 1024
	    go to 101				! Ymodem variant
	else
	    go to 10
	end if

c	CRC failed, try for checksum

 0099	continue
	crc = .false.
	call send_nak()			! Send NAK to synchronize.

c	Loop, waiting for the first byte from the remote.
c
c	We expect an SOH, STX, or EOT byte at this point.


 0100	continue
	rbuffer(1) = read_byte (10)		! Read the first byte.
	if (liosb(1) .ne. ss$_normal) go to 600 ! Report error/NAK.
	
	if (rbuffer(1) .eq. soh) then
	    data_size = 128
	else if (rbuffer(1) .eq. stx) then
	    data_size=1024
	else if (rbuffer(1) .eq. eot) then
	    go to 700				! End of transmission.
	else
	    go to 100				! Unrecognized lead-in
	end if

c	We received the SOH or STX byte, read the rest of the block.
c
c	Format:  <SOH/STX><block #><comp block #>
c		 < 128/1024 data bytes ><checksum/CRC>

 0101	continue
	if (crc) then
	    call raw_read(rbuffer(2),data_size+(data_index),
	1	timeout_count,noterm)
	else
	    call raw_read(rbuffer(2),data_size+(data_index-1),
	1	timeout_count,noterm)
	end if

	block_received = rbuffer(2) .and. bitmask ! Copy the block number.
	block_comp = rbuffer(3)	.and. bitmask	! Copy complemented block #.
	if (block_received .ne. block_expected) go to 550
	if ( (block_received + block_comp) .ne. bitmask) go to 600
	if (crc) then
	    call clrcrc
c	    These must be added to clear the buffer if a longer block
c	    has been used before.
	    rbuffer(data_size+data_index+data_index-1)=0
	    rbuffer(data_size+data_index+data_index-2)=0
	    call updcrc(rbuffer(data_index), data_size+data_index)
	    if(highbyte.ne.0.or.lowbyte.ne.0) go to 600
	else
	    checksum = xmodem_checksum (rbuffer(data_index), data_size)
	    if (checksum.ne.(rbuffer(checksum_index).and.bitmask)) go to 600
	end if
	block_count = block_count + 1		! Adjust the block count.

c	Copy the receive buffer and break at CR/LF if text mode.

	if(file_type .eq. binary) go to 300

	do 200 i = data_index,data_size+(data_index-1)
	rec_size = rec_size + 1			! Update the record size.
	lbuffer(rec_size) = rbuffer(i)		! Copy the receive buffer.
	if (lbuffer(rec_size) .eq. SUB) then
	    rec_size = rec_size - 1		! Don't write the CTRL/Z.
	    received_eof = .true.		! Show EOF was received.
	    write (file_unit,401,err=999) (lbuffer(index),index=1,rec_size)
	    go to 700				! And go write the buffer.
	endif
	if (rec_size .gt. 1) then
	    if ( (lbuffer(rec_size-1) .eq. cr) .and.
	1		(lbuffer(rec_size) .eq. lf) ) then
		rec_size = rec_size - 2		! Adjust for the CR/LF.
		write (file_unit,401,err=999) (lbuffer(index),index=1,rec_size)
 0401	format(<rec_size>a1)
		call xmodem_totals (rec_size)	! Update the file totals.
                retry_count=0
		rec_size = 0
	    endif
	endif
200	continue

c	Check for too many bytes in the output buffer.

	if (rec_size .gt. out_size) then
	    call check_display()
	    call send_can()			! Cancel the transmission.
	    call write_user ('*** The output record is too large, '//
	1	'are you sure this is an ASCII file ? ***'//crlf(:cl))
	    go to 9999			! And report the abortion.
	endif
	go to 500

 0300	continue
c
c	Write the buffer to the output file.
c
	lbufferc = rbufferc(data_index:data_size+data_index-1)
	rec_size = data_size			! Update the record size.

	do while (rec_size .gt. 0)
	    write (file_unit,400,err=999) lbufferc(1:128)
 0400	    format (a128)
	    call xmodem_totals (128)	! Update the totals.
            retry_count=0
	    lbufferc = lbufferc(129:)
	    rec_size = rec_size - 128		! Initialize the record size.
	end do

500	previous_block = block_expected		! Copy the current block #.
	block_expected = mod (block_expected+1,256) .and. bitmask
	call send_ack()				! Send an ACKnowlegment.
	go to 100				! Go read the next block.

c	We come here when the block number don't match.

550	if (block_received .eq. previous_block) then
	    call send_ack()			! ACK previous block number.
	    go to 100				! Go read the next block.
	else
	    call check_display()
	    call sys$fao ('*** Phase error -- received block is !UL ***!/',
	1		size, scratch, %val(block_received) )
	    call write_user (scratch(1:size))
	    call sys$fao ('***      While the expected block is !UL. ***!/',
	1		size, scratch, %val(block_expected) )
	    call write_user (scratch(1:size))
	    call send_can()			! Cancel the transmission.
	    go to 9999
	endif
c
c	We come here to send a NAK for a tranmission error.
c
600	continue
c	call clear_typeahead		! Wait until remote is idle.
	if (report_error(.true.)) then	! Report the transmission error.
	    call send_nak()		! Tell remote to resend last record.
	    go to 100			! And try again.
	else
	    call send_can()		! Limit exceeded, abort transmission.
	    go to 9999			! Report the abortion ...
	endif
c
c	We come here to process end of file.
c
700	close (unit=file_unit)		! Close the input file
	call send_ack()			! Tell remote XMODEM we got EOT.
	call report_success()		! Report the transmission success.
	get_xmodem = .true.		! Return success.
	return
c
c	We come here if an error occurs writing the output file.
c
999	call rms_error (module_name)	! Report the RMS error message.
	call send_can()			! Cancel the transmission & exit.
c
c	We come here to report failure.
c
9999	close (unit=file_unit)		! Close the input file.
	call report_abort()		! Report the aborted transmission.
	return
	end

	logical function send_xmodem
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - SEND_XMODEM.FOR
c	This routine is used transfer a file to the remote system from
c	the VAX using the XMODEM protocol.
c
c	Dale Miller - UALR
c
c	Rev. 4.13 04-Jul-1987
c	Rev. 5.6  03-Mar-1988
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'

	character*(*) module_name
	parameter (module_name = 'Send_Xmodem')
	integer data_index,data_size,block_size
	parameter (data_index = 4)		! Index to 1st data byte.
	logical report_error, at_eof, crc
	integer bytes, xmit_size, checksum, dindex, i
	integer xmodem_checksum, read_byte
	integer high,low
	byte highbyte,lowbyte
	common /crcval/high,low
	equivalence (high,highbyte)
	equivalence (low,lowbyte)

	send_xmodem = .false.			! Initialize to bad return.
	at_eof = .false.			! Show not at end of file.
	block_xmitted = 1			! Initialize the block #.
	xmit_size = data_index - 1		! Initialize the XMIT size.
	if (protocol .eq. ymodem) then
	    data_size = 1024			! Number of data bytes.
	else
	    data_size = 128			! Standard Xmodem
	end if
	block_size = data_size + 3		! Size of block - checksum.
c
c	Wait until the remote XMODEM sends us a NAK or 'C'.
c
	call clear_typeahead()			! Clear any garbage.
0010	rbuffer(1) = read_byte (timeout_count)	! Read the first byte.
	if(rbuffer(1).eq.nak) then
	    crc=.false.
	else if(rbuffer(1).eq.'C') then
	    crc=.true.
	else if (report_error(.true.)) then	! Report transmission error.
	    go to 10				! And try again.
	else
	    call send_can()			! Limit exceeded, abort.
	    go to 9999				! Report the abortion ...
	endif

 0099	error_count=0				! Don't penalize him for startup

c
c	Read a record from the input file.
c
100	dindex = 1				! Index into input record.
	read (file_unit,110,end=9900,err=9990) bytes,(lbuffer(i),i=1,bytes)
110	format (q,<bytes+1>a1)
	call xmodem_totals (bytes)		! Update the file totals.
        retry_count=0
c
c	If we're in text mode, append a CR/LF sequence.
c
	if (file_type .eq. ascii) then
	    lbuffer(bytes+1) = cr		! Append a carraige return
	    lbuffer(bytes+2) = lf		!	and a line feed.
	    bytes = bytes + 2			! Adjust the byte count.
	endif
	if (bytes .eq. 0) go to 100		! Blank binary record.

c	Prepare the buffer to transmit.
c
c	Format:  <SOH/STX><block #><comp block #>< 128/1024 data bytes >
c		 <checksum/CRC>

200	do 300 i = dindex,bytes
	xmit_size = xmit_size + 1		! Adjust the XMIT buffer size.
	xbuffer(xmit_size) = lbuffer(i) .and. bitmask ! Copy the next byte.
	if (xmit_size .eq. block_size) go to 400 ! Go transmit this block.
300	continue
	go to 100				! Go read the next record.

c	Calculate the checksum or CRC and transmit this block.

 0400	dindex = i + 1				! Save index into record.
	if(protocol .eq. ymodem) then
	    xbuffer(1) = stx			! Indicate long block
	else
	    xbuffer(1) = soh			! Start with the SOH byte.
	end if
	xbuffer(2) = block_xmitted		! Fill in the block number.
	xbuffer(3) = (255 - block_xmitted) .and. bitmask ! Comp. block number.

	if (crc) then
	    call clrcrc
	    xmit_size=xmit_size+2
	    xbuffer(xmit_size-1) = 0
	    xbuffer(xmit_size)   = 0
	    call updcrc (xbuffer(4), xmit_size-3)
	    xbuffer(xmit_size-1) = highbyte
	    xbuffer(xmit_size)   = lowbyte
	else
	    checksum = xmodem_checksum (xbuffer(data_index), data_size)
	    xmit_size = xmit_size + 1		! Point to checksum byte.
	    xbuffer(xmit_size) = checksum	! Fill in the checksum.
	endif

	block_xmitted = mod (block_xmitted+1,256) .and. bitmask
	block_count = block_count + 1		! Adjust the block count.

c	Write the buffer to the remote.

600	call raw_write (xbuffer, xmit_size)	! Write this block of data.

c	Now, we must wait for an ACKnowlegment.

	rbuffer(1) = read_byte (timeout_count)	! Read response from remote.
	if (liosb(1) .ne. ss$_normal) go to 700 ! Report transmission error.
	if (rbuffer(1) .eq. can) go to 9999	! Transmission is cancelled.
	if (rbuffer(1) .eq. ack) go to 800	! Block successfully sent.
c
c	Report the transmission error.
c
700	if (report_error(.true.)) then		! Report transmission error.
	    go to 600				! And try again.
	else
	    call send_can()			! Limit exceeded, abort.
	    go to 9999				! Report the abortion ...
	endif
c
c	Now we're ready to finish the previous record or read the next.
c
800	if (xbuffer(1) .eq. eot) go to 9910	! Our EOT has been ACKed.
        retry_count=0
900	if (at_eof) then
	    xmit_size = 1			! Set size of XMIT buffer.
	    xbuffer(xmit_size) = eot		! Get ready to send EOT.
	    go to 600				! Send end of transmission.
	endif
	xmit_size = data_index - 1		! Reinitialize the XMIT size.
	if (dindex .le. bytes) then
	    go to 200				! Finish the previous record.
	else
	    go to 100				! Read the next record.
	endif
c
c	We come here for end of file on input file.
c
9900	at_eof = .true.				! Show we're at end of file.
	if ( (file_type .eq. binary) .and.
	1	(xmit_size .eq. data_index-1) ) GO TO 900 ! Send EOT only.
c
c	This is the last block, so we pad it with EOF bytes.
c
	do 9901 i = 1,block_size
	xmit_size = xmit_size + 1		! Bump the XMIT buffer size.
	xbuffer(xmit_size) = sub		! Fill buffer with EOF's.
	if (xmit_size .eq. block_size) go to 400 ! Go transmit this block.
9901	continue
c
c	Transmission complete.
c
9910    close (unit=file_unit)			! Close the input file.
	call report_success()			! Report transmission success.
	send_xmodem = .true.			! Show success.
	return
c
c	We come here if an error occurs writing the output file.
c
9990	call rms_error (module_name)		! Report the RMS error message.
	call send_can()				! Cancel the transmission.
c
c	Here to report failure.
c
9999	close (unit=file_unit)			! Close the output file.
	if (at_eof) then
	    call check_display()
	    call write_user('*** Remote not responding on completion. ***'//
	1	crlf(:cl))
	endif
	call report_abort()			! Report aborted transmission.
	return
	end

	integer function xmodem_checksum (buffer, bytes)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - XMODEM_CHECKSUM.FOR
c	This routine is used to calculate the checksum with the XMODEM
c	protocol.
c	read.
c	Dale Miller - UALR
c
c	Rev. 4.13 04-Jul-1987
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'

	logical*1 buffer(1)
	integer bytes,i

	xmodem_checksum = 0			! Initialize the checksum.
	if (bytes .gt. 0) then
	    do i=1,bytes
		xmodem_checksum = (xmodem_checksum + buffer(i)) .and. bitmask
		end do
	    endif
	return
	end

	subroutine updcrc(bbyte,n)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - UPDCRC.FOR
c	updates the Cyclic Redundancy Code
c	uses x^16 + x^12 + x^5 + 1 as recommended by CCITT
c	and as used by CRCSUBS version 1.20 for 8080 microprocessor
c	and incorporated into the MODEM7 protocol of the CP/M user's group
c	result to send is low byte of high and low in that order.
c	see Computer Networks, Andrew S. Tanenbaum, Prentiss-Hall, 1981
c
c	J. James Belonis II - University of Washington, Seattle
c
c	Rev. 4.13 04-Jul-1987
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	byte bbyte(*)
	integer n,i,j
c  must declare integer to allow shifting
	integer byte,newbyte
	integer bit,bitl,bith

        integer high,low
	byte highbyte,lowbyte
        common /crcval/high,low
	equivalence (high,highbyte)
	equivalence (low,lowbyte)

	do i=1,n
	    byte=bbyte(i)

	    do j=1,8
c  get high bits of bytes so we don't lose them when shift
c  positive is left shift
		bit =ishft( iand(128,byte), -7)
		bitl=ishft( iand(128,low),  -7)
		bith=ishft( iand(128,high), -7)
		newbyte=ishft(byte,1)	! Get ready for next iteration
		byte=newbyte		! Introduced dummy variable newbyte
					!  to avoid "access violation"
		low =ishft(low ,1)+bit	! Shift those bits in
		high=ishft(high,1)+bitl

		if(bith.eq.1) then
		    high=ieor(16,high)
		    low=ieor(33,low)
		    endif
		enddo
	    enddo
        return
        end

	subroutine clrcrc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines - CLRCRC.FOR
c	Clears the Cyclic Redundancy Code for use by UPDCRC
c	J. James Belonis II - University of Washington, Seattle
c
c	Rev. 4.13 04-Jul-1987
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	integer high,low
	byte highbyte,lowbyte
	common /crcval/high,low
	equivalence (high,highbyte)
	equivalence (low,lowbyte)

	high=0
	low=0
	return
	end

	SUBROUTINE SET_TERMINATOR(PTR,TBL,TBYTE)
C
C	This routine is used to set the terminator character for reads
C	in the terminator table.  This table which has 256 bits for
C	this entire character set, must have a bit set for each character
C	used to terminate a read (i.e., <CR>).  Currently, I presume
C	only one character is used to terminate the read (table is cleared).
C
C	Inputs:
C		PTR - address of table pointer.
C		TBL - address of terminator table.
C		TBYTE - byte to set into table.
C
	IMPLICIT INTEGER*4 (A-Z)

	INTEGER*4 PTR(2), TBL(8)
	LOGICAL*1 TBYTE(1)

	DO 100 I=1,8
	TBL(I) = 0			! Clear the entire table.
100	CONTINUE
	I = ((TBYTE(1)/32) + 1)		! Offset into table.
	BIT = (TBYTE(1) - ((I-1)*32)) 	! Bit to set in longword.
	PTR(1) = I*4			! Terminator table size.
	PTR(2) = %LOC(TBL)		! Fill in the table address.
	CALL LIB$INSV(1,BIT,1,TBL(I))	! Set the terminator bit.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_RECEIVE (FBUFF, RDATA, SDATA)
C
C	This function is used to receive file(s) from a remote KERMIT.
C
C	Inputs:
C		FBUFF	The file output buffer.			(By Descriptor)
C		RDATA	The receive data buffer.		(By Reference)
C		SDATA	The send data buffer.			(By Reference)
C
C	Outputs:
C		True/False = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	CHARACTER*(*) FBUFF
	BYTE RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KERMIT_RECEIVE')

	INTEGER RECEIVE_INIT, RECEIVE_FILE, RECEIVE_DATA
C
C	In server mode, we must start the transmission by sending an
C	initialize "I" packet to the remote.  In non-server mode, we
C	simply wait for the send-init packet from the remote.
C
	STATE = 'R'				! State = "Receive-Init"
	RETRY_COUNT = 0				! Initialize retry count.
	PAKNUM = 0				! Initialize packet number.
	CALL CLEAR_TYPEAHEAD			! Clear typeahead buffer.

C
C	Dispatch on the receive state.
C
	DO WHILE (.TRUE.)
	    IF (STATE .EQ. 'A') THEN		! "Abort" state.
c		IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Limit exceeded?
c		    CALL REPORT_RETRYS()	! Yes, tell the user.
c		ENDIF
		CALL REPORT_ABORT()		! Tell user about it.
		KERMIT_RECEIVE= .FALSE.		! Set failure status.
		RETURN
	    ELSEIF (STATE .EQ. 'C') THEN	! Complete state.
		KERMIT_RECEIVE = .TRUE.		! Set success status.
		RETURN
	    ELSEIF (STATE .EQ. 'D') THEN	! Receive-Data.
		STATE = RECEIVE_DATA (FBUFF, RDATA, SDATA)
	    ELSEIF (STATE .EQ. 'F') THEN	! Receive-File.
		STATE = RECEIVE_FILE (RDATA, SDATA)
	    ELSEIF (STATE .EQ. 'R') THEN	! Receive-Init.
		STATE = RECEIVE_INIT (RDATA, SDATA)
	    ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, STATE)
		KERMIT_RECEIVE = .FALSE.	! Set failure status.
		RETURN
	    ENDIF
	ENDDO
	END

	INTEGER FUNCTION RECEIVE_DATA (FBUFF, RDATA, SDATA)
C
C	This function is used to receive the file data.
C
C	Inputs:
C		FBUFF	The output file buffer.
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	CHARACTER*(*) FBUFF
	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM
	INTEGER RECEIVE_PACKET

	LOGICAL	KERMIT_UNPACK
	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'RECEIVE_DATA')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    CLOSE (UNIT=FILE_UNIT)		! Close the VAX file.
	    RECEIVE_DATA = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		RECEIVE_DATA = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'D') THEN		! Get Data packet ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		PACKET_COUNT = PACKET_COUNT + 1	! Adjust the packet count.
		TOTAL_PACKETS = TOTAL_PACKETS+1	! Update the total packets.
		IF (.NOT. KERMIT_UNPACK (FBUFF, RDATA, R_LEN)) THEN
		    CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'A')
		    CLOSE (UNIT=FILE_UNIT)	! Close the VAX file.
		    RECEIVE_DATA = 'A'		! Set "Abort" state.
		    RETURN
		ENDIF
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'Y') ! Send ACK.
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		RECEIVE_DATA = STATE		! Stay in this state.
		RETURN
	    ELSEIF (R_NUM .EQ. PREPAK) THEN	! Previous packet ?
		CALL KSEND_PACKET (SDATA, 0, PREPAK, 'Y') ! Re-ACK it.
		RETRY_COUNT = 0			! Init the retry count.
		RECEIVE_DATA = STATE		! Stay in this state.
		RETURN
	    ELSE
		RECEIVE_DATA = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		RECEIVE_DATA = 'A'		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'F') THEN		! File-Header packet ?
	    IF (R_NUM .EQ. PREPAK) THEN		! Previous packet ?
C
C	The ACK for the file header was missed, resend the ACK.
C
		CALL KSEND_PACKET (SDATA, 0, PREPAK, 'Y') ! Re-ACK it.
		RETRY_COUNT = 0			! Init the retry count.
		RECEIVE_DATA = STATE		! Stay in this state.
		RETURN
	    ELSE
		RECEIVE_DATA = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. 'Z') THEN		! End-of-file packet ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Previous packet ?
		IF (RBYTES .GT. 0) THEN		! Something to write ?
		    CALL KERMIT_WRITE (FBUFF(1:RBYTES))
		ENDIF
		CLOSE (UNIT=FILE_UNIT)		! Close the VAX file.
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'Y') ! ACK EOF.
		CALL REPORT_SUCCESS()		! Report transmit success.
		CALL COUNT_FILES()		! Count files transferred.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		RECEIVE_DATA = 'F'		! "Receive-File" state.
		RETURN
	    ELSE
		CLOSE (UNIT=FILE_UNIT)		! Close the VAX file.
		RECEIVE_DATA = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		CALL REPORT_ERROR (.TRUE.)	! Show user the error.
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'N') ! Send a NAK.
		RECEIVE_DATA = STATE		! Return current state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		RECEIVE_DATA = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION RECEIVE_FILE (RDATA, SDATA)
C
C	This function is used to receive the file name.
C
C	Inputs:
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM
	INTEGER RECEIVE_PACKET

c	LOGICAL KERMIT_OPENR
	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'RECEIVE_FILE')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    RECEIVE_FILE = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		RECEIVE_FILE = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'B') THEN		! Break packet ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'Y') ! Send ACK.
		RECEIVE_FILE = 'C'		! Return "Complete" state.
		RETURN
	    ELSE
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'F') THEN		! File-Header packet ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
c		IF (.NOT. KERMIT_OPENR (RDATA, R_LEN)) THEN
c		    CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'A')
c		    RECEIVE_FILE = 'A'		! Return "Abort" state.
c		    RETURN
c		ENDIF
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'Y') ! Send ACK.
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		RBYTES = 0			! The record byte count.
		RECEIVE_FILE = 'D'		! Return Data state.
		RETURN
	    ELSE
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. 'S') THEN		! Send-init packet.
	    IF (R_NUM .EQ. PREPAK) THEN		! Previous packet ?
C
C	The ACK for the file header was missed, resend our parameters.
C
		CALL KSEND_PARAMETERS (SDATA)	! Yes, resend our params.
		CALL KSEND_PACKET (SDATA, ISIZE, PREPAK, 'Y') ! Re-ACK it.
		RETRY_COUNT = 0			! Init the retry count.
		RECEIVE_FILE = STATE		! Stay in this state.
		RETURN
	    ELSE
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. 'Z') THEN		! End-of-file packet ?
	    IF (R_NUM .EQ. PREPAK) THEN		! Previous packet ?
		CALL KSEND_PACKET (SDATA, 0, PREPAK, 'Y') ! Resend ACK.
		RETRY_COUNT = 0			! Init the retry count.
		RECEIVE_FILE = STATE		! Stay in this state.
		RETURN
	    ELSE
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		CALL REPORT_ERROR (.TRUE.)	! Show user the error.
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'N') ! Send a NAK.
		RECEIVE_FILE = STATE		! Return current state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		RECEIVE_FILE = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION RECEIVE_INIT (RDATA, SDATA)
C
C	This function is used to receive the initial packet.
C
C	Inputs:
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	R_STATE, R_LEN, R_NUM
	BYTE    RDATA(MAXDATASIZ), SDATA(MAXDATASIZ)
	INTEGER RECEIVE_PACKET

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'RECEIVE_INIT')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    RECEIVE_INIT = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		RECEIVE_INIT = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		RECEIVE_INIT = 'A'		! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'S') THEN		! Send-init packet.
	   	CALL RECEIVE_PARAMETERS (RDATA, R_LEN) ! Set receive params.
		CALL KSEND_PARAMETERS (SDATA)	! Set our init params.
		CALL KSEND_PACKET (SDATA, ISIZE, PAKNUM, 'Y')
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		RECEIVE_INIT = 'F'		! Set File-Receive state.
		RETURN
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'N') ! Send a NAK.
		RECEIVE_INIT = STATE		! Return current state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		RECEIVE_INIT = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	LOGICAL FUNCTION KERMIT_SEND (FBUFF, RDATA, SDATA)
C
C	This function is used to send file(s) to a remote KERMIT.
C
C	Inputs:
C		FBUFF	Buffer for file writes.			(By Descriptor)
C		RDATA	The receive data buffer.		(By Reference)
C		SDATA	The send data buffer.			(By Reference)
C
C	Outputs:
C		True/False = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	include 'bbs_inc.for'

	CHARACTER*(*) FBUFF
	BYTE RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KERMIT_SEND')

	BYTE S_LEN				! The send data length.
	INTEGER KSEND_INIT, KSEND_FILE, KSEND_DATA, KSEND_EOF, KSEND_BREAK

	STATE = 'S'				! Start state = Send-Init.
	RETRY_COUNT = 0				! Initialize retry count.
	PAKNUM = 0				! Initialize packet number.
	END_OF_FILE = .FALSE.			! Show not at end of file.
	call clear_typeahead			! Clear typeahead buffer.
C
C	Loop on the send state.
C
	DO WHILE (.TRUE.)
	    IF (STATE .EQ. 'A') THEN		! "Abort" state.
c		IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Limit exceeded?
c		    CALL REPORT_RETRYS()	! Yes, tell the user.
c		ENDIF
		CALL REPORT_ABORT()		! Tell user about it.
		CLOSE (UNIT=FILE_UNIT)		! Close the VAX file.
		KERMIT_SEND = .FALSE.		! Set failure status.
		RETURN
	    ELSEIF (STATE .EQ. 'B') THEN	! Send-Break state.
		STATE = KSEND_BREAK (RDATA, SDATA)
	    ELSEIF (STATE .EQ. 'C') THEN	! Complete state.
		KERMIT_SEND = .TRUE.		! Set success status.
		RETURN
	    ELSEIF (STATE .EQ. 'D') THEN	! Send-Data state.
		STATE = KSEND_DATA (FBUFF, RDATA, SDATA, S_LEN)
	    ELSEIF (STATE .EQ. 'F') THEN	! Send-File state.
		STATE = KSEND_FILE (FBUFF, RDATA, SDATA, S_LEN)
	    ELSEIF (STATE .EQ. 'S') THEN	! Send-Init state.
		STATE = KSEND_INIT (RDATA, SDATA)
	    ELSEIF (STATE .EQ. 'Z') THEN	! Send-End-Of-File.
		STATE = KSEND_EOF (RDATA, SDATA)
	    ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, STATE)
		KERMIT_SEND = .FALSE.		! Set failure status.
		RETURN
	    ENDIF
	ENDDO
	END

	INTEGER FUNCTION KSEND_BREAK (RDATA, SDATA)
C
C	This function is used to send a break (EOT).
C
C	Inputs:
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM
	INTEGER RECEIVE_PACKET

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KSEND_BREAK')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    KSEND_BREAK = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Send the break (EOT) packet to the remote.
C
	CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'B')
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		KSEND_BREAK = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		KSEND_BREAK = 'A'		! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'N') THEN		! NAK packet received.
		KSEND_BREAK = STATE		! Stay in this state.
		RETURN
	ELSEIF (R_STATE .EQ. 'Y') THEN		! Get expected ACK ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		KSEND_BREAK = 'C'		! Set "Complete" state.
		RETURN
	    ELSE
		KSEND_BREAK = STATE		! Stay in this state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		KSEND_BREAK = STATE		! Stay in this state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		KSEND_BREAK = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION KSEND_DATA (FBUFF, RDATA, SDATA, S_LEN)
C
C	This function is used to send the file data.
C
C	Inputs:
C		FBUFF	The input file buffer.
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C		S_LEN	The send data length.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	CHARACTER*(*) FBUFF
	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM, S_LEN
	LOGICAL	KERMIT_PACK
	INTEGER RECEIVE_PACKET

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KSEND_DATA')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    KSEND_DATA = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Send a data packet to the remote.
C
	CALL KSEND_PACKET (SDATA, S_LEN, PAKNUM, 'D')
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		KSEND_DATA = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		KSEND_DATA = 'A'		! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'N') THEN		! NAK packet received.
		KSEND_DATA = STATE		! Stay in this state.
		RETURN
	ELSEIF (R_STATE .EQ. 'Y') THEN		! Get expected ACK ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		PACKET_COUNT = PACKET_COUNT + 1	! Count the data packets.
		TOTAL_PACKETS = TOTAL_PACKETS+1	! Update the total packets.
		CALL KERMIT_REPORT()		! Update screen display.
C
C		Fill the next data packet to send.
C
		IF (KERMIT_PACK (FBUFF, SDATA, S_LEN)) THEN
		    KSEND_DATA = STATE		! Stay in "Data" state.
		ELSE
		    KSEND_DATA = 'Z'		! Set "End-of-file" state.
		ENDIF
		RETURN
	    ELSE
		KSEND_DATA = STATE		! Stay in this state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		KSEND_DATA = STATE		! Stay in this state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		KSEND_DATA = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION KSEND_EOF (RDATA, SDATA)
C
C	This function is used to send the end of file.
C
C	Inputs:
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM
c	LOGICAL NEXT_REMFILE
	INTEGER RECEIVE_PACKET

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KSEND_EOF')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    KSEND_EOF = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Send an end of file packet to the remote.
C
	CALL KSEND_PACKET (SDATA, 0, PAKNUM, 'Z')
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		KSEND_EOF = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		KSEND_EOF = 'A'			! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'N') THEN		! NAK packet received.
		KSEND_EOF = STATE		! Stay in this state.
		RETURN
	ELSEIF (R_STATE .EQ. 'Y') THEN		! Get expected ACK ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		CALL REPORT_SUCCESS()		! Report success message.
c		IF (NEXT_REMFILE()) THEN	! Check for another file.
c		    CALL COUNT_FILES()		! Count files transferred.
c		    KSEND_EOF = 'F'		! Set "File-Header" state.
c		    END_OF_FILE = .FALSE.	! Reset end of file flag.
c		ELSE				! No more files to send.
		    KSEND_EOF = 'B'		! Switch to "Break" state.
c		ENDIF
		RETURN
	    ELSE
		KSEND_EOF = STATE		! Stay in this state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		KSEND_EOF = STATE		! Stay on this state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		KSEND_EOF = 'A'			! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION KSEND_FILE (FBUFF, RDATA, SDATA, S_LEN)
C
C	This function is used to send the file name.  Upon switching to
C	the Data State, the send data buffer is filled with the first
C	packet data from the input file.
C
C	Inputs:
C		FBUFF	The input file buffer.
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C		S_LEN	The send data length.
C
C	Outputs:
C		Return value is the next state.
C
C	If Data State:
C		SDATA	The first data packet.
C		S_LEN	The data packet length.
C
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	CHARACTER*(*) FBUFF
	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM, S_LEN
	LOGICAL	KERMIT_PACK
	INTEGER	RECEIVE_PACKET
	INTEGER RSIZE,ISTAT,STR$TRIM

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KSEND_FILE')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    KSEND_FILE = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Send the file header packet to the remote.
C
	istat = str$trim (remote_file,remote_file,rsize)
	CALL KSEND_PACKET (%REF(REMOTE_FILE), RSIZE, PAKNUM, 'F')
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		KSEND_FILE = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		KSEND_FILE = 'A'		! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'N') THEN		! NAK packet received.
		KSEND_FILE = STATE		! Stay in this state.
		RETURN
	ELSEIF (R_STATE .EQ. 'Y') THEN		! Get expected ACK ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
C
C		Fill the send packet with the first packet data.
C
		RBYTES = 0			! The record byte count.
		IF (KERMIT_PACK (FBUFF, SDATA, S_LEN)) THEN
		    KSEND_FILE = 'D'		! Set "Data" state.
		ELSE
		    KSEND_FILE = 'Z'		! Set "End-of-file" state.
		ENDIF
		RETURN
	    ELSE
		KSEND_FILE = STATE		! Stay in this state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		KSEND_FILE = STATE		! Stay in this state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		KSEND_FILE = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION KSEND_INIT (RDATA, SDATA)
C
C	This function is used to send the initial parameters.
C
C	Inputs:
C		RDATA	The receive data buffer.
C		SDATA	The send data buffer.
C
C	Outputs:
C		Return value is the next state.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	RDATA (MAXDATASIZ), SDATA (MAXDATASIZ)
	BYTE	R_STATE, R_LEN, R_NUM
	INTEGER RECEIVE_PACKET

	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KSEND_INIT')

	RETRY_COUNT = RETRY_COUNT + 1		! Adjust the retry count.
	IF (RETRY_COUNT .GT. RETRY_LIMIT) THEN	! Retry limit exceeded ?
	    KSEND_INIT = 'A'			! Set "Abort" state.
	    RETURN
	ENDIF
C
C	Send our init parameters to the remote.
C
	CALL KSEND_PARAMETERS (SDATA)		! Set our init params.
	CALL KSEND_PACKET (SDATA, ISIZE, PAKNUM, 'S')
C
C	Read and decode the incoming packet.
C
	R_STATE = RECEIVE_PACKET (RDATA, R_LEN, R_NUM)
	IF     (R_STATE .EQ. 'A') THEN		! "Abort" packet?
		KSEND_INIT = R_STATE		! Return "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'E') THEN		! Error received packet.
		CALL KERMIT_ERROR (RDATA, R_LEN)! Display the error text.
		KSEND_INIT = 'A'		! Set the "Abort" state.
		RETURN
	ELSEIF (R_STATE .EQ. 'N') THEN		! NAK packet received.
		KSEND_INIT = STATE		! Stay in this state.
		RETURN
	ELSEIF (R_STATE .EQ. 'Y') THEN		! Get expected ACK ?
	    IF (R_NUM .EQ. PAKNUM) THEN		! Get expected packet ?
	   	CALL RECEIVE_PARAMETERS (RDATA, R_LEN) ! Set receive params.
		RETRY_COUNT = 0			! Init the retry count.
		PREPAK = PAKNUM			! Save previous packet.
		PAKNUM = MOD (PAKNUM+1, 64)	! Adjust packet number.
		KSEND_INIT = 'F'		! Set File-Receive state.
		RETURN
	    ELSE
		KSEND_INIT = STATE		! Stay in this state.
		RETURN
	    ENDIF
	ELSEIF (R_STATE .EQ. .FALSE.) THEN	! Didn't get a packet.
		KSEND_INIT = STATE		! Stay in this state.
		RETURN
	ELSE
		CALL UNEXPECTED_STATE (MODULE_NAME, R_STATE)
		KSEND_INIT = 'A'		! Return "Abort" state.
		RETURN
	ENDIF
	END

	INTEGER FUNCTION KERMIT_CHECKSUM (P_DATA, P_SIZE)
C
C	This function is used to calculate the KERMIT checksum.
C
C	Inputs:
C		P_DATA	The data buffer.
C		P_SIZE	The data size.
C
C	Outputs:
C		Returns the calculated checksum.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'

	BYTE P_DATA (MAXPACKSIZ)
	INTEGER P_SIZE, CHECKSUM, I

	CHECKSUM = 0			! Initialize the checksum.
	DO I = 1, P_SIZE
	    CHECKSUM = CHECKSUM + P_DATA(I) ! Accumulate the checksum.
	ENDDO
	CHECKSUM = ( (ISHFT (CHECKSUM .AND. "300, -6) + CHECKSUM) .AND. "077)
	KERMIT_CHECKSUM = CHECKSUM	! Return the checksum.
	RETURN
	END

	SUBROUTINE KERMIT_ERROR (P_DATA, P_LEN)
C
C	This function is used to report an error message received from the
C	remote in an error packet.
C
C	Inputs:
C		P_DATA	Packet data with error text.
C		P_LEN	The packet data length.
C
C	Outputs:
C		None.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_LEN

	INTEGER SIZE
	CALL WRITE_USER (SS//
	1  '*** Aborting with this error from the remote KERMIT: ***'//SS)
	SIZE = P_LEN				! Convert to longword value.
c	CALL WRITE_BUFFER (P_DATA, SIZE)	! Write the error text.
c	CALL WRITE_USER (SS)			! Single space the output.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_OPENR (P_DATA, P_LEN)
C
C	This function is used to open the VAX file when receiving a file.
C
C	Inputs:
C		P_DATA	Packet data with file name.
C		P_LEN	The packet data length.
C
C	Outputs:
C		Return .TRUE./.FALSE. = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	include 'bbs_inc.for'

	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_LEN

	INTEGER I
	CHARACTER*(*) MODULE_NAME
	PARAMETER (MODULE_NAME = 'KERMIT_OPENR')
C
C	Open the VAX file for output.
C
	IF (FILE_TYPE.EQ.BINARY) THEN
	    OPEN (UNIT=FILE_UNIT, TYPE='NEW', NAME=VAX_FILE(1:VSIZE),
	1		RECORDSIZE=OUT_SIZE, CARRIAGECONTROL='NONE',
	1		BUFFERCOUNT=2, ERR=9900)
	ELSE
	    OPEN (UNIT=FILE_UNIT, TYPE='NEW', NAME=VAX_FILE(1:VSIZE),
	1		RECORDSIZE=OUT_SIZE, CARRIAGECONTROL='LIST',
	1		BUFFERCOUNT=2, ERR=9900)
	ENDIF
	KERMIT_OPENR = .TRUE.			! Show file is open.
	RETURN

9900	CALL RMS_ERROR (MODULE_NAME)		! Report the RMS error.
	KERMIT_OPENR = .FALSE.			! Show file open failed.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_PACK (FBUFF, P_DATA, P_LEN)
C
C	This function is used to pack the data a VAX file into a data
C	packet for transmission to the remote KERMIT.
C
C	Inputs:
C		FBUFF	The input file buffer.			(By Descriptor)
C		P_DATA	The data packet buffer.			(By Reference)
C		P_LEN	The packet data length.			(By Reference)
C		RBYTES	The current record count.		(Global)
C
C	Outputs:
C		Returns .TRUE./.FALSE. = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	LOGICAL	KERMIT_READ
	CHARACTER*(*) FBUFF
	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_LEN

	BYTE	C				! The next file character.
	BYTE	C7				! 7-bit version of above.
	INTEGER F,				! Index into file buffer.
	1	I				! Index into packet data.

	IF (END_OF_FILE) THEN			! If at end of file,
	    KERMIT_PACK = .FALSE.		!   then return failure.
	    RETURN
	ENDIF
C
C	Pack the file data into the data packet.
C
	I = 1					! Initialize packet index.
	P_LEN = 0				! Initialize packet length.
	DO WHILE (I .LT. PACKET_LENGTH)		! Do until packet limit.
	    IF (RBYTES .EQ. 0) THEN		! More bytes is the buffer?
		F = 1				! Initialize file buffer index.
		IF (.NOT. KERMIT_READ (FBUFF, RBYTES)) THEN
		    IF (P_LEN .NE. 0) THEN	! Have a partial packet ?
			KERMIT_PACK = .TRUE.	! Yes, send this packet.
			RETURN
		    ELSE
			KERMIT_PACK = .FALSE.	! Else, show file is done.
			RETURN
		    ENDIF
		ENDIF
	    ENDIF
	    C = ICHAR (FBUFF(F:F))		! Copy the next character.
	    C7 = C .AND. "177			! 7-bit version of above.
	    IF ( (C7 .LT. SP) .OR. (C7 .EQ. RUB)
	1			.OR. (C7 .EQ. QCTLC) ) THEN
		IF (I+1 .GE. PACKET_LENGTH) THEN ! Too close to packet end?
		    KERMIT_PACK = .TRUE.	! Yes, show packet ready.
		    RETURN
		ENDIF
		P_DATA(I) = QCTLC		! Must quote this character.
		I = I + 1			! Adjust the packet index.
		IF (C7 .EQ. QCTLC) THEN		! If quote character,
		    P_DATA(I) = C		!   copy the quote char.
		ELSE
		    P_DATA(I) = (C .XOR. 64)	! Uncontolify the character.
		ENDIF
		I = I + 1			! Point to next position.
		P_LEN = P_LEN + 2		! Adjust the packet length.
	    ELSE
		P_DATA(I) = C			! Copy normal character.
		I = I + 1			! Point to next position.
		P_LEN = P_LEN + 1		! Adjust the packet length.
	    ENDIF
	    F = F + 1				! Adjust file buffer index.
	    RBYTES = RBYTES - 1			! Adjust the record bytes.
	ENDDO
	KERMIT_PACK = .TRUE.			! Yes, show packet ready.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_READ (FDATA, BYTES)
C
C	This function used to read a record from the VAX file.
C
C	Inputs:
C		FDATA	The file read buffer.
C		BYTES	Variable for bytes read.
C
C	Outputs:
C		BYTES	The number of bytes read.
C
C		Returns .TRUE./.FALSE. = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	INTEGER BYTES
	CHARACTER*(*) FDATA, MODULE_NAME
	PARAMETER (MODULE_NAME = 'KERMIT_READ')
C
C	Read a record from the VAX file.
C
	BYTES = 0				! Initialize byte count.
	DO WHILE (BYTES .EQ. 0)
	    READ (FILE_UNIT, 100, END=9910, ERR=9900) BYTES, FDATA
100	    FORMAT (Q, A)
	    CALL KERMIT_TOTALS (BYTES)		! Update the file totals.
	    IF (FILE_TYPE.NE.BINARY) THEN		! If ASCII file type,
		BYTES = BYTES + 1		! Count carriage return.
		FDATA(BYTES:BYTES) = CHAR(CR)	! Append carriage return.
		BYTES = BYTES + 1		! Count the line feed.
		FDATA(BYTES:BYTES) = CHAR(LF)	! Append the line feed.
	    ENDIF
	ENDDO
	KERMIT_READ = .TRUE.			! Show read successful.
	RETURN
C
C	We come here when an error occurs reading the input file.
C
9900	CALL RMS_ERROR (MODULE_NAME)		! Report the RMS error.
C
C	We come here for end of file on input file.
C
9910	CLOSE (UNIT=FILE_UNIT)			! Close the input file.
	END_OF_FILE = .TRUE.			! Show EOF or error.
	KERMIT_READ = .FALSE.			! Show the read failed.
	RETURN
	END

	SUBROUTINE KERMIT_TOTALS (BYTES)
C
C	This routine is called after a record is successfully transmitted
C	to update the various counters.  Since the routine is called while
C	building a transmit packet from multiple input records, the record
C	display has a special entry which is called after transmitting the
C	current block.
C
C	Inputs:
C		BYTES	The number of record bytes.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'BBS_INC.FOR'

	INTEGER BYTES

	BYTE_COUNT = BYTE_COUNT + BYTES		! Accumulate the byte count
	RECORD_COUNT = RECORD_COUNT + 1		!	and the record count.
	TOTAL_BYTES = TOTAL_BYTES + BYTES	! Update the total byte count.
	TOTAL_RECORDS = TOTAL_RECORDS + 1	!	and the record count.
	RETURN

	ENTRY KERMIT_REPORT
	RETRY_COUNT = 0				! Reinitialize retry counter.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_UNPACK (FBUFF, P_DATA, P_LEN)
C
C	This function is used to unpack a data packet and write the data
C	to the the VAX file.
C
C	Inputs:
C		FBUFF	The output file buffer.			(By Descriptor)
C		P_DATA	The data packet buffer.			(By Reference)
C		P_LEN	The packet data length.			(By Reference)
C		RBYTES	The current record count.		(Global)
C
C	Outputs:
C		Returns .TRUE./.FALSE. = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	LOGICAL	KERMIT_WRITE
	CHARACTER*(*) FBUFF
	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_LEN

	LOGICAL QUOTE_SEEN			! Control quote seen flag.
	INTEGER F,				! Index into file buffer.
	1	I				! Index into packet data.
C
C	Copy and decode the data packet.
C
	F = RBYTES				! Copy record byte count.
	QUOTE_SEEN = .FALSE.			! Init the quote seen flag.
	DO I = 1, P_LEN
	  IF (QUOTE_SEEN) THEN
	    IF ((P_DATA(I) .AND. "177) .NE. QCTLC) THEN ! Quote of quote?
	      FBUFF(F:F) = CHAR(P_DATA(I) .XOR. 64) ! No convert control.
	    ELSE
	      FBUFF(F:F) = CHAR(P_DATA(I))	! Copy the quote char.
	    ENDIF
	    QUOTE_SEEN = .FALSE.		! Re-init quote flag.
C
C	Check for carriage-return/line-feed sequence for record end.
C
	    IF ( (FILE_TYPE.NE.BINARY) .AND. (F .GT. 1) ) THEN
	      IF ( (FBUFF(F-1:F-1) .EQ. CHAR(CR)) .AND.
	1		FBUFF(F:F) .EQ. CHAR(LF) ) THEN
		KERMIT_UNPACK = KERMIT_WRITE (FBUFF(1:F-2))
		F = 0				! Reset buffer index.
		IF (.NOT. KERMIT_UNPACK) RETURN	! Return failure status.
	      ENDIF
	    ELSEIF (F .EQ. 128) THEN
	      KERMIT_UNPACK = KERMIT_WRITE (FBUFF(1:F))
	      F = 0				! Reset buffer index.
	      IF (.NOT. KERMIT_UNPACK) RETURN	! Return failure status.
	    ENDIF
	  ELSE
	    F = F + 1				! Point to next position.
	    FBUFF(F:F) = CHAR(P_DATA(I))	! Copy the data character.
	    IF (P_DATA(I) .EQ. QCTLC) THEN	! If quote character,
	      QUOTE_SEEN = .TRUE.		!   show quote was seen.
	    ELSEIF ( (FILE_TYPE.EQ.BINARY) .AND. (F .EQ. 128) ) THEN
	      KERMIT_UNPACK = KERMIT_WRITE (FBUFF(1:F))
	      F = 0				! Reset buffer index.
	      IF (.NOT. KERMIT_UNPACK) RETURN	! Return failure status.
	    ENDIF
	  ENDIF
	ENDDO
	RBYTES = F				! Copy the buffer index.
	KERMIT_UNPACK = .TRUE.			! Show data unpacked OK.
	RETURN
	END

	LOGICAL FUNCTION KERMIT_WRITE (FDATA)
C
C	This function used to KERMIT packet data to the VAX file.
C
C	Inputs:
C		FDATA	The file data to write.
C
C	Outputs:
C		Returns .TRUE./.FALSE. = Success/Failure.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	CHARACTER*(*) FDATA, MODULE_NAME
	PARAMETER (MODULE_NAME = 'KERMIT_WRITE')
C
C	Write the data to the output file.
C
	WRITE (FILE_UNIT, 100, ERR=9900) FDATA
100	FORMAT (A)
	CALL KERMIT_TOTALS (LEN(FDATA))		! Update file totals.
	CALL KERMIT_REPORT()			! Update the screen.
	KERMIT_WRITE = .TRUE.			! Show write successful.
	RETURN

9900	CALL RMS_ERROR (MODULE_NAME)		! Report the RMS error.
	KERMIT_WRITE = .FALSE.			! Show the write failed.
	RETURN
	END

	INTEGER FUNCTION RECEIVE_PACKET (P_DATA, P_LEN, P_NUM)
C
C	This function is used to receive a packet.
C
C	Inputs:
C		P_DATA	Buffer for received data.
C		P_LEN	The data length.
C		P_NUM	The packet number.
C
C	Outputs:
C		The value returned is the packet type.
C
C		The above inputs are filled on success.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_NUM, P_LEN

	INTEGER CHECKSUM, I, PCHK, PACK_SIZE, STATUS
	INTEGER KERMIT_CHECKSUM, READ_BYTE, RAW_READ
C
C	Packet Format:
C
C	+------+-----------+-----------+------+--------------+-------+
C	| MARK | char(LEN) | char(SEQ) | TYPE | ... DATA ... | CHECK |
C	+------+-----------+-----------+------+--------------+-------+
C	       |<---- Packet Length / Check Calculation ---->|

C
C	Wait for the start of a packet character.
C
	PACKET(PMARK) = 0			! Initialize mark field.
	DO WHILE (PACKET(PMARK) .NE. MARKC)	! Loop until MARK detected.
	    IF (CONTROLC_TYPED) THEN		! CTRL/C typed to abort?
		RECEIVE_PACKET = 'A'		! Return an "Abort" code.
		RETURN
	    ENDIF
	    PACKET(PMARK) = READ_BYTE (TIMOUT)	! Read start of packet.
	ENDDO
C
C	Read the packet size.
C
	PACKET(PLEN) = READ_BYTE (TIMOUT)	! Read the packet size.
	IF (PACKET(PLEN) .NE. 0) THEN
	    PACK_SIZE = PACKET(PLEN) - 32	! Copy the packet size.
	    PACK_SIZE = PACK_SIZE .AND. "177	! Make sure not too big.
	    IF (PACK_SIZE .GT. PACKBUFSIZ) THEN
		PACK_SIZE = PACKBUFSIZ		! Set maximum packet size.
	    ENDIF
	ELSE
	    RECEIVE_PACKET = .FALSE.		! Timeout or error.
	    RETURN
	ENDIF
C
C	Read the rest of the packet (+1 for end of line character).
C
	STATUS = 0				! Initialize status code.
	DO WHILE (.NOT. STATUS)
	    IF (CONTROLC_TYPED) THEN		! CTRL/C typed to abort?
		RECEIVE_PACKET = 'A'		! Return an "Abort" code.
		RETURN
	    ENDIF
	    STATUS = RAW_READ (PACKET(PSEQ), PACK_SIZE+1, TIMOUT, TPTR)
	    IF (.NOT. STATUS) THEN
		RECEIVE_PACKET = .FALSE.	! Return failure status.
		RETURN
	    ENDIF
	ENDDO
C
C	Decode the packet and validate the checksum.
C
	CHECKSUM = KERMIT_CHECKSUM (PACKET(PLEN), PACK_SIZE)
	PCHK = (PACKET(PLEN) - 32) + TO_CHECK	! Set offset to checksum.
C
C	If the checksum matches return the received packet type, otherwise
C	return failure.
C
	IF ( CHECKSUM .EQ. (PACKET(PCHK)-32) ) THEN ! If checksum matches,
	    P_LEN = PACKET(PLEN) - 32 - POVER	! Copy the packet length.
	    P_NUM = PACKET(PSEQ) - 32		! Copy the packet number.
	    DO I = 1, P_LEN
		P_DATA(I) = PACKET(PDATA+(I-1))	! Copy the packet data.
	    ENDDO
	    RECEIVE_PACKET = PACKET(PTYPE)	! Return the packet type.
	ELSE
	    RECEIVE_PACKET = .FALSE.		! Return failure status.
	ENDIF
	RETURN
	END

	INTEGER FUNCTION KSEND_PACKET (P_DATA, P_LEN, P_NUM, P_TYPE)
C
C	This function is used to send a packet.
C
C	Inputs:
C		P_DATA	Data buffer to send.
C		P_LEN	The data length.
C		P_NUM	The packet number.
C		P_TYPE	The packet type.
C
C	Outputs:
C		None.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'

	BYTE	P_DATA (MAXDATASIZ)
	BYTE	P_LEN, P_NUM, P_TYPE

	INTEGER I, PBYTES, PSIZE, PCHK
	INTEGER KERMIT_CHECKSUM
C
C	+------+-----------+-----------+------+--------------+-------+
C	| MARK | char(LEN) | char(SEQ) | TYPE | ... DATA ... | CHECK |
C	+------+-----------+-----------+------+--------------+-------+
C	       |<---- Packet Length / Check Calculation ---->|

C
C	Send out required pad characters (if any).
C
	DO I = 1, PAD
	    CALL SEND_BYTE (PADC)		! Write the pad character.
	ENDDO
C
C	Construct the packet to send.
C
	PACKET(PMARK) = MARKC			! Copy the MARK character.
	PACKET(PLEN) = P_LEN + POVER + 32	! Set the packet size.
	PACKET(PSEQ) = P_NUM + 32		! Set the packet number.
	PACKET(PTYPE) = P_TYPE			! Set the packet type.
	DO I = 1, P_LEN
	    PACKET(PDATA+(I-1)) = P_DATA(I)	! Copy packet data.
	ENDDO
	PSIZE = P_LEN + POVER			! Set the packet size.
	PCHK = PSIZE + TO_CHECK			! Set offset to checksum.
	PACKET(PCHK) = KERMIT_CHECKSUM (PACKET(PLEN), PSIZE) + 32
	PACKET(PCHK+1) = EOLC			! Set end of line character.
	PBYTES = P_LEN + TOVER			! Set total packet size.
	CALL RAW_WRITE (PACKET, PBYTES)		! Write the packet.	
	RETURN
	END

	INTEGER FUNCTION DEFAULT_PARAMETERS
C
C	This function setup the default init parameters.  These defaults
C	are used if the remote doesn't specify the parameter in its'
C	send-init packet (all parameters are optional).
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'
C
C	Setup the default init parameters.
C
	SPSIZ  = DEFMAXL		! Set maximum packet length.
	TIMOUT = DEFTIME		! Set timeout limit to use.
	PAD    = DEFNPAD		! Set number of pad characters.
	PADC   = DEFPADC		! Set pad character to use.
	EOLC   = DEFEOLC		! Set end of line character.
	QCTLC  = DEFQCTL		! Set control quote character.
	QBINC  = DEFQBIN		! Set eight bit quote character.
	CHKTYP = DEFCHKT		! Set the packet check type.
	REPTC  = DEFREPT		! Set the repeat character.
	CAPAS  = DEFCAPAS		! Set extended capabilities.
C
C	Initialize other flags:
C
	MARKC = SOH			! Set the mark (start) character.
	IMAGE = .FALSE.			! Presume not image mode.
	QBIN = .FALSE.			! Set no eight bit quoting.
	REPEAT = .FALSE.		! Set no repeat char processing.
	TURN = .FALSE.			! Presume no turnaround char.
	FILNAMCNV = .FALSE.		! Presume no filename convert.
C
C	Set the KERMIT end of line character in the read terminator table.
C
	CALL SET_TERMINATOR (TPTR, TTBL, EOLC)	! Set EOL terminator.
	RETURN
	END

	INTEGER FUNCTION RECEIVE_PARAMETERS (RDATA, RLEN)
C
C	This function is used to set the receive init parameters.
C
C	Inputs:
C		RDATA	Buffer with the receive init parameters.
C		RLEN	The number of parameters received.
C
C	Outputs:
C		None.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	RDATA (ISIZE), RLEN
C
C	Copy the received init parameters (all params are optional).
C
	IF (RLEN .GE. IMAXL) THEN
	    SPSIZ  = RDATA (IMAXL) - 32	! Set maximum packet length.
	ENDIF
	IF (RLEN .GE. ITIME) THEN
	    TIMOUT = RDATA (ITIME) - 32	! Set timeout limit to use.
	    IF (TIMOUT .EQ. 0) THEN
		TIMOUT = TIMEOUT_COUNT	! Use our timeout count.
	    ENDIF
	ENDIF
	IF (RLEN .GE. INPAD) THEN
	    PAD    = RDATA (INPAD) - 32	! Set number of pad characters.
	ENDIF
	IF (RLEN .GE. IPAD) THEN
	    PADC = RDATA (IPAD) .XOR. 64 ! Set pad character to use.
	ENDIF
	IF (RLEN .GE. IEOLC) THEN
	    EOLC   = RDATA (IEOLC) - 32	! Set end of line character.
	ENDIF
	IF (RLEN .GE. IQCTL) THEN
	    QCTLC  = RDATA (IQCTL)	! Set control quote character.
	    IF (QCTLC .EQ. 0) THEN
		QCTLC = DEFQCTL		! Set the default quote char.
	    ENDIF
	ENDIF
	IF (RLEN .GE. IQBIN) THEN
	    QBINC  = RDATA (IQBIN)	! Set eight bit quote character.
	ENDIF
	IF (RLEN .GE. ICHKT) THEN
	    CHKTYP = RDATA (ICHKT)	! Set the packet check type.
	ENDIF
	IF (RLEN .GE. IREPT) THEN
	    REPTC  = RDATA (IREPT)	! Set the repeat character.
	ENDIF
	IF (RLEN .GE. ICAPAS) THEN
	    CAPAS = RDATA (ICAPAS) - 32	! Set extended capabilities.
	ENDIF
C
C	Change the read terminator table if the end of line character
C	has been changed by the remote.
C
	IF (EOLC .NE. DEFEOLC) THEN	! If NE, different EOL char.
	    CALL SET_TERMINATOR (TPTR, TTBL, EOLC) ! Set new terminator.
	ENDIF
	RETURN
	END

	INTEGER FUNCTION KSEND_PARAMETERS (SDATA)
C
C	This function is used to set our init parameters.
C
C	Inputs:
C		SDATA	Buffer for our init parameters.
C
C	Outputs:
C		None.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'
	INCLUDE 'bbs_inc.for'

	BYTE	SDATA (ISIZE)
C
C	Setup our init parameters.
C
	SDATA (IMAXL) = PACKET_LENGTH + 32	! Set maximum packet length.
	SDATA (ITIME) = TIMEOUT_COUNT + 32	! Set timeout limit to use.
	SDATA (INPAD) = MYNPAD + 32		! Set number of pad characters.
	SDATA (IPAD)  = MYPADC .XOR. 64		! Set pad character to use.
	SDATA (IEOLC) = MYEOLC + 32		! Set end of line character.
	SDATA (IQCTL) = MYQCTL			! Set control quote character.
	SDATA (IQBIN) = MYQBIN			! Set eight bit quote character.
	SDATA (ICHKT) = MYCHKT			! Set the packet check type.
	SDATA (IREPT) = MYREPT			! Set the repeat character.
	SDATA (ICAPAS) = MYCAPAS + 32		! Set extended capabilities.
	RETURN
	END

	SUBROUTINE UNEXPECTED_STATE (MODULE, BSTATE)
C
C	This routine is called whenever an unexpected state is found
C	to report the current state to the user.
C
C	Inputs:
C		MODULE	The module name.			(By Descriptor)
C		BSTATE	The bad state detected.			(By Reference)
C
C	Outputs:
C		None.
C
	IMPLICIT NONE
	INCLUDE 'kermit_inc.for'

	CHARACTER*(*) MODULE
	BYTE BSTATE

	CHARACTER*(*) SS
	PARAMETER (SS = CHAR(13)//CHAR(10))	! Single space.

	CALL WRITE_USER (SS//
	1	'*** Unexpected state in module "'//MODULE//'", state = '//
	2	CHAR(BSTATE)//' ***'//SS)
	RETURN
	END

	subroutine read_mail(mess,irec,status,nostop,next_mess)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will read a message, display it on the screen,
c	and then give the user a menu of options.
c
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 4.5  29-Aug-1986
c	Rev. 4.7  29-Nov-1986
c	Rev. 5.5  19-Jan-1988
c	Rev. 5.6  04-Mar-1988
c	Rev. 6.1  08-Jun-1988
c	Rev. 7.0  29-Aug-1988
c	Rev. 7.3  20-Jan-1989
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include 'sys$library:foriosdef/nolist'

	external     bbs_get_input,bbs_put_output

	character    line*80,pm*14/' ** private **'/,xxx*4
	character    cdummy*1,zmail_to*30,zmail_from*30
	character    snum*6,qmail_to*30,yesno*3,string*30,lms*9
	character    zfirst_name*20,zlast_name*20,defcmd*1
	logical*1    flag,reprint,found,nostop,busy
	byte         dummyb
        integer      status,err,next_mess,irec,mess,zz,istat
	integer      dummy1,dummy2,dummy3,ii,x,dummy,kstatus,spc
        integer      hold_messnum,qq,jj
	integer      str$upcase,str$trim,sys$asctim,lbr$output_help
	integer      lib$wait

	record /userlog_structure/ zur

	record /mail_header_structure/ mh

 1001	format(a)
 1011	format(i<dummy>)
 1013	format(a,i2,'>')
 1015	format(a,i2,1x,a)
 1019	format(a,'Section #',i1,' - ',a)
	status=0
	err=0

c	Step 1.  Get in the general area of the message
	found=.false.
	next_mess=0
	
	do while(.not.found)
	    irec=irec+20
	    if(irec.gt.last_header) found=.true.
	    read(2,rec=irec,iostat=ios,err=90600)mh
	    unlock(unit=2)
	    if(mh.mail_messnum.ge.mess) found=.true.
	    end do
	irec=irec-20

c	We are now within 20 reads of the message

	found=.false.
	do while(.not.found)
	    if(irec.gt.last_header) found=.true.
	    read(2,rec=irec,iostat=ios,err=90600) mh
	    unlock(unit=2)
	    if(mh.mail_messnum.ge.mess) then
		found=.true.
	    else
		irec=irec+1
	    end if
	    end do
	if(mh.mail_messnum.gt.mess) then
	    next_mess=mh.mail_messnum
	    irec=irec-1
	    go to 20000
	    end if
	if(mh.mail_deleted.and.(.not.sysop)) go to 20000
	zz=mh.mail_section
	dummyb=2**zz
	istat=str$upcase(zmail_to,mh.mail_to)
	istat=str$upcase(zmail_from,mh.mail_from)

	if((zmail_to.ne.mail_name).and.
	1   ((dummyb.and.ur.auth_sections).eq.0)) go to 20000

	if(mh.mail_messnum.eq.mess.and.mh.mail_private) then
	    if((mail_name.ne.zmail_to).and.
	1	(mail_name.ne.zmail_from).and.(.not.sysop)) then
		go to 20000
		end if
	    end if
	if(mh.mail_messnum.eq.mess) then
	    status=-1					! We read it
	    istat=str$trim(mh.mail_from,mh.mail_from,dummy1)
	    istat=str$trim(mh.mail_to,mh.mail_to,dummy2)
	    istat=str$trim(mh.mail_subject,mh.mail_subject,dummy3)
	    if(dummy1.lt.1.or.dummy1.gt.30) dummy1=30
	    if(dummy2.lt.1.or.dummy2.gt.30) dummy2=30
	    if(dummy3.lt.1.or.dummy3.gt.30) dummy3=30
	    xxx = '    '
	    write(6,1019)crlf(:cl)//ffeed(:fl),mh.mail_section,
	1	secnam(mh.mail_section+1)
	    call ctrl_o_check(*21000,*10580)
	    call comint(mh.mail_messnum,lms)
	    write(6,1001)crlf(:cl)//'Message number:'//lms//' on '//
	1	mh.mail_date//' at '//mh.mail_time
	    call ctrl_o_check(*21000,*10580)
	    if(mh.mail_read) xxx = ' (X)'
	    if(mh.mail_private) then
		write(6,1001)crlf(:cl)//
	1	    '   From: '//mh.mail_from(1:dummy1)//pm
	    else
		write(6,1001)crlf(:cl)//'   From: '//mh.mail_from(1:dummy1)
	    end if
	    call ctrl_o_check(*21000,*10580)
	    write(6,1001)crlf(:cl)//'     To: '//Mh.mail_to(1:dummy2)//xxx
	    call ctrl_o_check(*21000,*10580)
	    if(mh.mail_reply_to.eq.0) then
		write(6,1001)crlf(:cl)//'Subject: '//mh.mail_subject(1:dummy3)
	    else
		call comint(mh.mail_reply_to,lms)
		write(6,1001)crlf(:cl)//'Subject: #'//lms//'-'//
	1	    mh.mail_subject(1:dummy3)
	    end if
	    if((sysop2).and..not.mh.mail_person) then
		istat=sys$asctim(,string,mh.mail_expire,)
		write(6,1001)' -- Expires on: '//string(1:11)
		end if
	    call ctrl_o_check(*21000,*10580)
	    if(mh.mail_deleted) write(6,1001)crlf(:cl)//'**** deleted ****'
	    write(6,1001)crlf(:cl)
	    do ii=mh.mail_first,mh.mail_last
		read(3,rec=ii,iostat=ios)line
		unlock(unit=3)
		call ctrl_o_check(*21000,*10580)
		istat=str$trim(line,line,x)
		write(6,1001)crlf(:cl)//line(1:x)
		end do
	    write(6,1001)crlf(:cl)
	    end if
	if((mh.mail_messnum.eq.mess).and.(.not.mh.mail_read).and.
	1    (zmail_to.eq.mail_name)) then
	    read(2,rec=irec,iostat=ios,err=90600) mh
	    mh.mail_read=.true.
	    write(2,rec=irec,err=90600,iostat=ios) mh
	    read(1,key=ur.user_key,iostat=ios,err=90500)ur
	    ur.num_unread=ur.num_unread-1
	    if(ur.num_unread.lt.0) ur.num_unread=0
	    if(mess.gt.ur.last_message.and.area.ne.'marked')
	1	ur.last_message=mess
	    rewrite(1,err=90500)ur
	    end if
	if (area.eq.'marked') go to 10580
	if(mess.gt.ur.last_message) then
10540	    read(1,key=ur.user_key,iostat=ios,err=90500)ur
	    if(area.ne.'marked')ur.last_message=mess
	    rewrite(1,err=90500,iostat=ios)ur
	    end if
10580	continue
	if(nostop.and.(zmail_to.ne.mail_name)) return
10590	continue
	if(zmail_to.eq.mail_name) then
	    defcmd='K'
	else
	    defcmd='C'
	endif

10591	continue
	if(reprint) then
	    reprint=.false.
	    write(6,1001)crlf(:cl)//'(C)ontinue     (E)nd'
	    write(6,1001)crlf(:cl)//'(H)elp         (K)ill'
	    write(6,1001)crlf(:cl)//'(N)ostop       (R)eply'
	    write(6,1001)crlf(:cl)//crlf(:cl)//'Command? ['//defcmd//']'
	else
	    write(6,1001)crlf(:cl)//
	1	'Command (C,E,H,K,N,R,?)? ['//defcmd//'] '
	end if
	dummy=1
	call get_uplow_string(cdummy,dummy)
	istat=str$upcase(cdummy,cdummy)
	if(dummy.eq.0) cdummy=defcmd
	if(cdummy.eq.'C') go to 20000
	if(cdummy.eq.'E') go to 21000
	if(cdummy.eq.'H') go to 22000
	if(cdummy.eq.'K') go to 22500
	if(cdummy.eq.'N') go to 23000
	if(cdummy.eq.'P'.and.sysop2) go to 22700	! Make message private
	if(cdummy.eq.'R') go to 24000
	if(cdummy.eq.'U'.and.sysop2) go to 22600		! undelete message
	if(cdummy.eq.'?') then
	    reprint=.true.
	    go to 10591
	    end if

	write(6,1001)crlf(:cl)//'That was not a valid command'
	go to 10591

20000	continue		!Continue
	return

21000	continue		!Exit
	status=3
	return

22000	continue		!Help
	controlc_typed=.false.
	istat=lbr$output_help(bbs_put_output,,
	1   'bbs_help retrieve','ubbs_data:helplib',,bbs_get_input)
	go to 10591


22500	continue		!Kill message
	call kill_mess (irec,kstatus)
	if(kstatus.eq.1) go to 90500
	if(kstatus.eq.2) go to 90600
	DEFCMD='C'
	go to 10591

22600	continue		!Unkill message
	read(2,rec=irec,iostat=ios,err=90600) mh

	mh.mail_deleted=.false.
	write(2,rec=irec,iostat=ios,err=90600) mh
	write(6,1001)crlf(:cl)//'Message restored'
	go to 10591

22700	continue		!Make message private
	read(2,rec=irec,iostat=ios,err=90600) mh
	mh.mail_private= .not. mh.mail_private
	write(2,rec=irec,err=90600,iostat=ios) mh
	if(mh.mail_private) then
	    write(6,1001)crlf(:cl)//'Message is now private'
	else
	    write(6,1001)crlf(:cl)//'Message is now public'
	end if
	go to 10591

23000	continue		!Nostop
	nostop=.true.
	return

24000	continue		!Reply
	if (.not.approved_mail_send) go to 10591
	mh.mail_person=.true.
	mh.mail_private=.false.
	zmail_to=mh.mail_from
	istat=str$upcase(qmail_to,zmail_to)
	spc=index(qmail_to,' ')
	zfirst_name=qmail_to(1:spc-1)
	do ii=spc+1,30
	    if(zmail_to(ii:ii).ne.' ') go to 3010
	    end do
c	no last name found.
	write(6,1001)crlf(:cl)//'There seems to be some problem here'//
	1    crlf(:cl)//'This person does not exist!'
	go to 10591
3010	zlast_name=qmail_to(ii:30)
	zur.user_key=zlast_name//zfirst_name
	dummy=0
	hold_messnum=mh.mail_messnum
	mh.mail_private=.false.
	write(6,1001)crlf(:cl)//'Is this a private message? [no]'
	dummy=3
	call get_upcase_string(yesno,dummy)
	if(yesno(1:1).eq.'Y') mh.mail_private=.true.
	ii=20
	call enter_message(ii,*3040,0)
	mh.mail_read=.false.
	mh.mail_deleted=.false.
	mh.mail_to=zmail_to
	mh.mail_from=mail_name
	call modify_mail_info(mh,*3040)

 3020	read(2,rec=1,iostat=ios,err=90500)last_header, last_data,
	1   first_mnum,last_mnum,busy
	if(busy) then
	    unlock(unit=2)
	    dummy=lib$wait(1.0)
	    go to 3020
	    end if
	last_header=last_header+1
	last_mnum=last_mnum+1
	write(2,rec=1)last_header,last_data+ii,first_mnum,last_mnum
	call date(mh.mail_date)
	call time(mh.mail_time)
	mh.mail_reply_to=mh.mail_messnum
	mh.mail_messnum=last_mnum
	mh.mail_first=last_data+1
	mh.mail_last=last_data+ii
	do qq=1,10
	    mh.mail_replys(qq)=0
	    end do

c	write the header
	write(2,rec=last_header,err=90600,iostat=ios) mh

c	and the message
	do jj=1,ii
	    write(3,rec=last_data+jj)message(jj)
	    end do

c	now, set up for read thread
	read(2,rec=irec,iostat=ios,err=90600) mh
	qq=1
	do while(mh.mail_replys(qq).ne.0.and.qq.lt.11)
	    qq=qq+1
	    end do
	if(qq.le.10.and.mh.mail_replys(qq).eq.0) mh.mail_replys(qq)=last_mnum
	write(2,rec=irec,iostat=ios,err=90600) mh

c	tell him about it
	call comint(last_mnum,lms)
	write(6,1001)crlf(:cl)//' Message number'//lms//
	1   ' sent.'//bell//bell

c	tell reciever he has mail
	if(.not.mh.mail_person) go to 10591

	read(1,key=zur.user_key,iostat=ios,err=10591)zur
	zur.num_unread = zur.num_unread+1
	rewrite(1,err=90500,iostat=ios)zur

	go to 10591			!Ask him for another command

c	Come here if he aborted reply to fix up header again.
3040	read(2,rec=irec,iostat=ios,err=90600) mh
	go to 10591

90500	status=1	!error on userlog
	return

90600	status=2	!error on message files
	return

	end


	subroutine modify_mail_info (mh,*)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine will allow a user to change the parameters on a message
c	before sending it.
c
c	Dale Miller - UALR
c
c
c	Rev. 5.6  04-Mar-1988
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include '($foriosdef)'

	character    cdummy*1,zmail_subject*30,zmail_to*30,qmail_to*30,yesno*3
	character    zlast_name*20,zfirst_name*20,pdummy*3,dummy_20*20
	character    string*20
	logical      dummyl
	real*8       right_now,rdummy,day_31
	integer      dummy,ii,namln,istat,spc,kk,sect,compquad
	integer      str$upcase,sys$gettim,sys$asctim,sys$bintim,str$trim

	record /userlog_structure/     zur
	record /mail_header_structure/ mh

 1001	format(a)
 1011	format(i1)
 1020	format(a,i1,' - ',a)

	istat = sys$bintim('18-DEC-1858 00:00:00',day_31)
 0010	write(6,1001)crlf(:cl)//
	1   'Options: (S)end, (M)odify, (A)bort [send]?'
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if(dummy.eq.0.or.cdummy.eq.'S') then
	    return
	else if(cdummy.eq.'A') then
	    write(6,1001)crlf(:cl)//'Message send aborted'
	    return 1
	else if(cdummy.ne.'M') then
	    write(6,1001)crlf(:cl)//bell//
	1	'Unrecognized option -- please try again'
	    go to 0010
c	He has elected to change this message.  Step through the possibilities
	end if

	write(6,1001)crlf(:cl)//crlf(:cl)//'Message is to: ['//
	1  mh.mail_to//']'
	namln=30
	call get_uplow_string(zmail_to,namln)
	istat=str$upcase(qmail_to,zmail_to)
	if(namln.eq.0.or.zmail_to.eq.mh.mail_to) then
	    go to 0200				! No change, that's easy.
	    end if
	mh.mail_to = zmail_to
	mh.mail_person = .true.			! Assume an individual
	spc=index(qmail_to,' ')
	zfirst_name=qmail_to(1:spc-1)	
	do ii=spc+1,30
	    if(zmail_to(ii:ii).ne.' ') go to 0110
	    end do
c	No last name found.  This must be a public message
	mh.mail_person=.false.
	go to 0200	!no need to check further

 0110	zlast_name=qmail_to(ii:30)
	zur.user_key=zlast_name//zfirst_name
	read(1,key=zur.user_key,iostat=ios)zur
	unlock(unit=1)
	if(ios.ne.0) mh.mail_person=.false.		!Error on read

 0200	write(6,1001)crlf(:cl)//'      Subject: ['//mh.mail_subject//']'
	dummy=20
	call get_uplow_string(zmail_subject,dummy)
	if(dummy.eq.0.or.zmail_subject.eq.mh.mail_subject) then
	    continue
	else
	    mh.mail_subject = zmail_subject
	end if
	if(.not.mh.mail_person) then
 3031	    continue
	    right_now = mh.mail_expire
	    istat=sys$asctim(,dummy_20,right_now,)
	    mh.mail_private=.false.
	    write(6,1001)crlf(:cl)//
	1	'What is the expiration date for this message? ['//
	2	dummy_20(:11)//']'
	    dummy=11
	    call get_uplow_string(string,dummy)
	    istat=str$upcase(string,string)
	    if(dummy.eq.0) then
		mh.mail_expire=right_now
	    else
		istat=sys$bintim(string(:11)//' 00:00:00',mh.mail_expire)
	    end if
	    dummy=compquad(mh.mail_expire,right_now)
	    if(dummy.eq.-1) then
		write(6,1001)crlf(:cl)//
	1	    'That is not a valid date.  Dates must be of the'//
	2	    crlf(:cl)//'form dd-mmm-yyyy (e.g. 01-Jan-1986)'
		go to 3031
	    end if
	    call addquad(right_now,day_31,rdummy)
	    dummy=compquad(rdummy,mh.mail_expire)
	    if(dummy.eq.-1) then
		write(6,1001)crlf(:cl)//
	1	    'Your expiration date may be no more than 1 month in'//
	2	    crlf(:cl)//'the future.  Please try again'
		go to 3031
	    end if
	    istat=sys$asctim(,string,mh.mail_expire,)
	else
	    if(mh.mail_private) then
		pdummy='Yes'
	    else
		pdummy='No'
	    end if
	    write(6,1001)crlf(:cl)//'Is this a private message?'//
	1	' ['//pdummy//']'
	    dummy=3
	    call get_upcase_string(yesno,dummy)
	    if(yesno(1:1).eq.'Y') mh.mail_private=.true.
	    if(yesno(1:1).eq.'N') mh.mail_private=.false.
	end if

 3080	sect=mh.mail_section
	istat = str$trim(secnam(sect+1),secnam(sect+1),dummy)
	write(6,1001)crlf(:cl)//'Section number? (enter 9 for list)'//
	1   '['//char(sect+48)//' - '//secnam(sect+1)(:dummy)//']'
	dummy=1
	dummyl=.false.
	call get_number(string,dummy,dummyl)
	if(string.eq.'9') then
	    do kk=0,7
		call ctrl_o_check(*3080,*3080)
		write(6,1020)crlf(:cl),kk,secnam(kk+1)
		end do
	    go to 3080
	else if (dummy.eq.0) then
	    go to 0010
	    end if
	read(string,1011)sect
	if(sect.gt.7) then
	    write(6,1001)crlf(:cl)//'Invalid section number'
	    go to 3080
	    end if
	mh.mail_section=sect
	go to 0010

 0300	continue
	return
	end

	subroutine ubbs_files_section
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c	UBBS subroutines
c	This routine handles all of the UBBS file transfer.
c	Dale Miller - UALR
c
c
c	Rev. 3.5  19-Jun-1986
c	Rev. 3.6  24-Jun-1986
c	Rev. 4.0  27-Jun-1986
c	Rev. 4.1  07-Jul-1986
c	Rev. 4.2  20-Jul-1986
c       Rev. 4.6  09-Nov-1986
c	Rev. 4.7  29-Nov-1986
c	Rev. 4.10 11-Feb-1987
c	Rev. 4.13 04-Jul-1987
c	Rev. 4.14 12-Sep-1987
c	Rev. 5.5  05-Jan-1988
c	Rev. 5.6  03-Mar-1988
c	Rev. 6.0  06-Jun-1988
c	Rev. 6.1  08-Jun-1988
c	Rev. 6.3  23-Aug-1988
c	Rev. 7.0  29-Aug-1988
c	Rev. 7.1  19-Sep-1988
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	implicit none
	include 'bbs_inc.for/nolist'
	include 'sys$library:foriosdef/nolist'
	include '($rmsdef)'
	character cdummy*1,darea*3
	character filename*50,filnam*80,disk*4,line*200,ftyp*7
	character binasc*4,zfilnam*20,term*5,cdate*9,types*1,cdate2*11
	character space*30/'                    '/
	logical*1 reprint,dummyl
	integer i,istat,per,spc,length,flen
	integer dummy,dummy1,dummy2
	integer get_xmodem,send_xmodem,find_file,find_next
	integer kermit_send,kermit_receive
	integer fsize,rev_date(2),back_date(2)
	logical get_vaxfile
	integer lib$delete_file,str$trim,lib$find_file
	integer lbr$output_help,str$upcase,sys$gettim
	external getsize,bbs_put_output,bbs_get_input,uopen

	record /userlog_structure/ zur
	record/file_description/ fd

	common/filesize/fsize,rev_date,back_date

 1001	format(a)
 1003	format(q,a)
 1004	format('$!',a3,'=',a18,i3,1x,a)
 1019	format(a1,'file_',i6.6,'.dat')
 1024   format(i5.5)

	ldesc.dsc$w_maxstrlen = buffer_size
	ldesc.dsc$a_pointer   = %loc(lbuffer)
	rdesc.dsc$w_maxstrlen = buffer_size
	rdesc.dsc$a_pointer   = %loc(rbuffer)
	xdesc.dsc$w_maxstrlen = buffer_size
	xdesc.dsc$a_pointer   = %loc(xbuffer)


c	Start the whole thing off
 4000	continue
	call date(cdate)
	write(6,1001)crlf(:cl)//
	1   '(D)ownload, (U)pload, (H)elp or (E)xit? [exit] '
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	if(cdummy.eq.'D') go to 4100
	if(cdummy.eq.'U') go to 4700
	if(cdummy.eq.'H') then
	    controlc_typed=.false.
	    istat=lbr$output_help(bbs_put_output,,
	1	'bbs_help file_transfer','ubbs_data:helplib',,bbs_get_input)
	    go to 4000
	    end if
	write(6,1001)crlf(:cl)//'Invalid selection.  Please try again.'
	go to 4000

 4100	continue		!Download
	area='download'
	if (.not.approved_file_down) then
	    write(6,1001)crlf(:cl)//bell//
	1	'You are not yet approved for the download section.'
	    write(6,1001)crlf(:cl)//'Sorry.'
	    return
	    end if
	flow=to_remote
	if(reprint.or.(.not.ur.xpert)) then
	    reprint=.false.
	    call type_file('ubbs_files:[000000]download.areas')
 4101	    write(6,1001)crlf(:cl)//crlf(:cl)//
	1	'Enter area of interest? [exit]'
	else
	    write(6,1001)crlf(:cl)//'Area? '
	end if
	dummy=3	    	    
	call get_uplow_string(darea,dummy)
	istat = str$upcase(darea,darea)
	if(dummy.eq.0.or.darea.eq.'EXI') go to 4900
	if(darea.eq.'?') then
	    reprint=.true.
	    go to 4100
	    end if
	dummy=0
	if (lib$find_file('ubbs_files:['//darea//']allow.down',
	1   filename,dummy).ne.rms$_normal) then
	    write(6,1001)crlf(:cl)//
	1	'That is not a valid area.  Please try again'
	    reprint=.true.
	    go to 4100
	    end if
c	Offer to print the SYSOP bulletin, if it exists
	filnam = 'ubbs_files:['//darea//'.asc]sysop.bulletin'
	open(unit=4,file=filnam,status='old',readonly,
	1   useropen=getsize,iostat=istat)

	if(istat.eq.0)then
	    call sys$asctim(,cdate2,rev_date,)
	    cdate2(5:5) = char(ichar(cdate2(5:5))+32)
	    cdate2(6:6) = char(ichar(cdate2(6:6))+32)
	    write(6,1001)crlf(:cl)//crlf(:cl)//
	1	'View FILE SYSOP bulletin - Rev. '//
	2	cdate2//'? [no]'
	    dummy=1
	    call get_upcase_string(cdummy,dummy)
	    if(cdummy.eq.'Y') then
		call type_file(filnam)
		end if
	else
	    write(6,1001)crlf(:cl)//crlf(:cl)//
	1	'No FILE SYSOP bulletin today - please press <return>'
	    dummy=1
	    call get_upcase_string(cdummy,dummy)
	    end if

 4150	continue
c!	Process users group areas separately
c!	if(darea.eq.'CUG') goto 4160
	write(6,1001)crlf(:cl)//crlf(:cl)//
	1'Enter name of file to download, ? for list, ?? to search,'
	write(6,1001)crlf(:cl)//'or <cr> to exit. '
	dummy=30
	call get_uplow_string(filename,dummy)
	istat=str$upcase(filename,filename)
	if(dummy.eq.0) go to 4900
	if(filename.eq.'?') then
	    call listcat(darea)
	    go to 4150	    
	    end if
	if(filename.eq.'??') then
	    call searchcat(darea)
	    go to 4150	    
	    end if
	if(filename.eq.'ABC.XYZ') go to 5000
	per=index(filename,'.')
	if(per.eq.0) then
	    spc=index(filename,' ')
	    filename(spc:spc)='.'
	    end if
	file_type=ascii			!make assumption
	filnam='ubbs_files:['//darea//'.asc]'//filename
	dummyl=get_vaxfile(filnam)
	if(dummyl) go to 4170
	file_type=binary		!wrong assumption, try again
	filnam='ubbs_files:['//darea//'.bin]'//filename
	dummyl=get_vaxfile(filnam)
	if(dummyl) go to 4170
c	See if it is archived
	open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5			key=(1:18:character),
	6   useropen=uopen)

	fd.file_name=filename
	istat=str$trim(fd.file_name,fd.file_name,dummy)
	if(fd.file_name(dummy:dummy).eq.'.') fd.file_name(dummy:dummy)=' '
	read(4,key=fd.file_name,iostat=ios)fd
	close(unit=4)
	if(fd.archived.and.(ios.eq.0)) then
	    write(6,1001)crlf(:cl)//'That file is currently stored off-line.'
	    write(6,1001)crlf(:cl)//'Files are restored each weeknight at'//
	1	' midnight.'
	    write(6,1001)crlf(:cl)//crlf(:cl)//
	1	'Do you wish to request a restore? [No]'
	    dummy=1
	    call get_upcase_string(cdummy,dummy)

	    if(cdummy.eq.'Y') then
		open(unit=4,file='ubbs_data:to_restore.dat',
	1	    shared,access='append',carriagecontrol='list',
	2	    status='unknown')
		if(fd.file_type.eq.'A'.or.fd.file_type.eq.'U') then
		    write(4,1001)'['//darea//'.ASC]'//filename
		else
		    write(4,1001)'['//darea//'.BIN]'//filename
		end if
		close(unit=4)
		end if

	    go to 4150
	    end if
	write(6,1001)crlf(:cl)//bell//
	1   'That is not a valid filename.  Try again.'
	go to 4150

 4170	if(file_type.eq.binary) then
	    protocol=asciid
	    write(6,1001)crlf(:cl)//'Binary files must be transferred via'
	    write(6,1001)crlf(:cl)//'Xmodem, Ymodem or Kermit'
	    protocol=unknown
	    do while(protocol.eq.unknown)
		write(6,1001)crlf(:cl)//
	1	    '(K)ermit (X)modem or (Y)modem transfer [exit]'
		dummy=1
		call get_upcase_string(cdummy,dummy)
		if(dummy.eq.0.or.cdummy.eq.'E') go to 4150
		if(cdummy.eq.'K') protocol=kermit
		if(cdummy.eq.'X') protocol=xmodem
		if(cdummy.eq.'Y') protocol=ymodem
		end do
	else
	    protocol=unknown
	    do while(protocol.eq.unknown)
		write(6,1001)crlf(:cl)//
	1	    '(A)scii, (K)ermit (X)modem or (Y)modem transfer? [exit]'
		dummy=1
		call get_upcase_string(cdummy,dummy)
		if(dummy.eq.0.or.cdummy.eq.'E') go to 4150
		if(cdummy.eq.'A') protocol=asciid
		if(cdummy.eq.'K') protocol=kermit
		if(cdummy.eq.'X') protocol=xmodem
		if(cdummy.eq.'Y') protocol=ymodem
		end do
	    end if

c
c	File is open, protocol is selected.  Do it to it.
c
c! 4177	continue
	if (protocol.eq.xmodem .or. protocol.eq.ymodem) then
	    call clear_counts()
	    timeout_count=10
	    retry_limit=5
	    bitmask=eightbit_mask
	    write(6,1001)crlf(:cl)//
	1	'Beginning Xmodem/Ymodem download -- Ctrl-x to abort.'
	    call init_timer(file_timer)
	    dummyl=send_xmodem()
	    bitmask=sevenbit_mask
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	else if(protocol.eq.kermit) then
	    call clear_counts()
	    call default_parameters()
	    timeout_count=10
	    retry_limit=5
	    write(6,1001)crlf(:cl)//
	1	'Beginning Kermit download.'
	    call waitabit('2')
	    remote_file = filename
	    call init_timer(file_timer)
	    dummyl = kermit_send(ldesc, rbuffer, xbuffer)
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	else		!ascii dump
	    write(6,1001)crlf(:cl)//'Control-c to abort download'
	    write(6,1001)crlf(:cl)//'Open your capture buffer now.'
	    call waitabit('10')
	    call init_timer(file_timer)
	    dummyl = .false.
	    read(file_unit,1003,iostat=ios)length,line
	    do while(ios.eq.0)
		call out(line(1:length),*4200)
		read(file_unit,1003,iostat=ios)length,line
		end do
	    dummyl = .true.
 4200	    close (unit=file_unit)
	    call waitabit('10')
	    call elapsed_time(file_timer)
	end if

	if(dummyl) then
	    write(6,1001)crlf(:cl)//'Successful transfer'
	    ur.down_files=ur.down_files+1
	    read(1,key=ur.user_key)zur
	    rewrite(1,err=4150)ur

c	Update the directory entry for this file.

	    open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5			key=(1:18:character),
	6   useropen=uopen)

	    fd.file_name=filename
	    istat=str$trim(fd.file_name,fd.file_name,dummy)
	    if(fd.file_name(dummy:dummy).eq.'.') fd.file_name(dummy:dummy)=' '

	    read(4,key=fd.file_name,iostat=ios)fd

	    fd.times_down=fd.times_down+1
	    call sys$gettim(fd.download_date)

	    rewrite(4,iostat=ios)fd
	
	    close(unit=4)
	else
	    write(6,1001)crlf(:cl)//'Transfer failed.'//bell
	end if
	go to 4150


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

 4700	continue		!Upload
	area='upload'
	if (.not.approved_file_up) then
	    write(6,1001)crlf(:cl)//bell//
	1	'You are not yet approved for the upload section.'
	    write(6,1001)crlf(:cl)//'Sorry.'
	    return
	    end if
	if(reprint.or.(.not.ur.xpert)) then
	    reprint=.false.
	    call type_file('ubbs_files:[000000]upload.areas')
 4701	    write(6,1001)crlf(:cl)//'Enter area of interest? [exit]'
	else
	    write(6,1001)crlf(:cl)//'Area? '
	end if
	dummy=3	    	    
	call get_uplow_string(darea,dummy)
	istat = str$upcase(darea,darea)
	if(dummy.eq.0.or.darea.eq.'EXI') go to 4900
	if(darea.eq.'?') then
	    reprint=.true.
	    go to 4700
	    end if

	dummy=0
	if (lib$find_file('ubbs_files:['//darea//']allow.up',
	1   filename,dummy).ne.rms$_normal) then
	    write(6,1001)crlf(:cl)//
	1	'That is not a valid area.  Please try again'
	    reprint=.true.
	    go to 4700
	    end if
	write(6,1001)crlf(:cl)//'(A)scii, (B)inary, (H)elp, (E)xit? [exit]'
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if (cdummy.eq.'E'.or.dummy.eq.0) go to 4900
	if (cdummy.eq.'A') then
	    file_type = ascii
	    ftyp='Ascii '
	    fd.file_type='U'
	    binasc='.asc'
	else if (cdummy.eq.'B') then
	    file_type=binary
	    fd.file_type='V'
	    ftyp='Binary'
	    binasc='.bin'
	else if (cdummy.eq.'H') then
	    controlc_typed=.false.
	    istat=lbr$output_help(bbs_put_output,,
	1	'bbs_help file','ubbs_data:helplib',,bbs_get_input)
	    go to 4700
	else
	    write(6,1001)crlf(:cl)//'Invalid selection. Please try again'
	    go to 4700
	end if

	if(file_type.eq.binary) then
	    protocol=unknown
	    do while(protocol.eq.unknown)
		write(6,1001)crlf(:cl)//'Binary transfers must be by Xmodem,'
		write(6,1001)crlf(:cl)//'Ymodem or Kermit protocol.'
		write(6,1001)crlf(:cl)//
	1	    '(K)ermit or (X)modem/Ymodem protocol? [exit] '
		dummy=1
		call get_upcase_string(cdummy,dummy)
		if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
		if(cdummy.eq.'K') protocol=kermit
		if(cdummy.eq.'X') protocol=xmodem
		end do
	else
	    protocol=unknown
	    do while(protocol.eq.unknown)
		write(6,1001)crlf(:cl)//'(A)scii, (K)ermit or'//
	1	    ' (X)modem/Ymodem protocol? [exit] '
		dummy=1
		call get_upcase_string(cdummy,dummy)
		if(cdummy.eq.'E'.or.dummy.eq.0) go to 4900
		if(cdummy.eq.'A') protocol=asciid
		if(cdummy.eq.'K') protocol=kermit
		if(cdummy.eq.'X') protocol=xmodem
		end do
	end if	
c	get the file name
	write(6,1001)crlf(:cl)//
	1   'File names may consist of a-z, 0-9, underscore, dash, $,'
	write(6,1001)crlf(:cl)//
	1   'and at most 1 period.  Names may be 1-18 characters.'
 4721	write(6,1001)crlf(:cl)//'File name? [exit]'
	flen=18
	call get_filnam_string(filename,flen)
	if(filename.eq.'.') go to 4900

	fd.file_name=filename
	if(fd.file_name(flen:flen).eq.'.') fd.file_name(flen:flen)=' '
	filnam='ubbs_files:['//darea//binasc//']'//filename

	open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5			key=(1:18:character),
	6   useropen=uopen)

c	Only let recognized SYSOPs change sysop.bulletin.

	if(fd.file_name.eq.'SYSOP.BULLETIN') then
	    fd.file_name = '$Header'
	    read(4,key=fd.file_name)fd
	    if( mail_name.ne.fd.upload_name.and.
	1	mail_name.ne.fd.upload_text(1:30).and.
	2	mail_name.ne.fd.upload_text(31:60)) then
		write(6,1001)crlf(:cl)//'That name is reserved - please'//
	1	    ' choose another'//crlf(:cl)
		go to 4721
		end if
	    fd.file_name = 'SYSOP.BULLETIN'
	    read(4,key=fd.file_name,err=4725)fd
	    delete(4,err=4725)
	    istat = lib$delete_file(filnam//';*')
	    go to 4725
	    end if

	read(4,key=fd.file_name,err=4725)fd
	unlock(unit=4)

c	If it's his, give him the option to change it.
	if(fd.upload_name.eq.mail_name) then
	    write(6,1001)crlf(:cl)//
	1	'You have already uploaded a file with that name.'
	    write(6,1001)crlf(:cl)//
	1	'Do you wish to overwrite it? [N]'
	    dummy=1
	    call get_upcase_string(cdummy,dummy)
	    if(cdummy.ne.'Y') go to 4721
	    read(4,key=fd.file_name,err=4725)fd
	    delete(unit=4)
	    istat = lib$delete_file(filnam//';*')
	    go to 4725
	    end if
	close(unit=4)

c	It's not his, make him choose another name.
	write(6,1001)crlf(:cl)//
	1   'That file already exists.  Please choose another name.'
	write(6,1001)crlf(:cl)//
	1   'If this is to be a replacement for '//filename(:flen)//','
	write(6,1001)crlf(:cl)//
	1   'please notify the operator via (P)rivate message.'
	go to 4721

 4725	continue
	close(unit=4)
c
c	if he has made it this far, we are ready to upload.
c
	if(protocol.eq.xmodem) then
	    write(6,1001)crlf(:cl)//
	1	'Beginning Xmodem/Ymodem upload -- Ctrl-d to abort.'
	    call init_timer(file_timer)
	    call clear_counts()
	    timeout_count=10
	    retry_limit=5
	    flow=to_vax
	    bitmask=eightbit_mask
	    dummyl=get_vaxfile(filnam)
	    dummyl=get_xmodem()
	    bitmask=sevenbit_mask
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	    if(dummyl) then
		write(6,1001)crlf(:cl)//'Successful upload!'
		go to 4800
	    else
		write(6,1001)crlf(:cl)//'Upload failed'
 4730		istat = lib$delete_file(filnam//';*')
	    end if
	elseif (protocol.eq.kermit) then
	    flow=to_vax
	    call clear_counts()
	    call default_parameters()
	    timeout_count=10
	    retry_limit=5
	    write(6,1001)crlf(:cl)//
	1	'Beginning Kermit upload.'
	    call waitabit('2')
	    call init_timer(file_timer)
	    dummyl=get_vaxfile(filnam)
	    dummyl = kermit_receive(ldesc, rbuffer, xbuffer)
	    call waitabit('10')
	    call elapsed_time(file_timer)	!Display elapsed time
	    call report_totals()		!Report final stats
	    if(dummyl) then
		write(6,1001)crlf(:cl)//'Successful transfer'
		go to 4800
	    else
		write(6,1001)crlf(:cl)//'Transfer failed.'//bell
		istat=lib$delete_file(filnam//';*')
	    end if
	else			!ascii upload
	    flow=to_vax
	    dummyl=get_vaxfile(filnam)
	    call out('Ascii files must not contain any non-printable',*4739)
	    call out('characters, and must not have any lines over',*4739)
	    call out('200 characters in length.',*4739)
	    call out('Each line must be terminated by a carriage',*4739)
	    call out('return.  The BBS will add a line feed for each',*4739)
	    call out('line you send.',*4739)
	    call out('Control-z to end, Control-c to abort.',*4739)
 4739	    write(6,1001)crlf(:cl)//crlf(:cl)//bell//
	1	'Start your file send now.'
	    write(6,1001)crlf(:cl)
 4740	    length=-200
	    call get_uplow_string(line,length)
	    if(length.lt.0) go to 4750
	    call send_cr()
	    call send_lf()
	    if(length.eq.0) then
		write(file_unit,1001)' '
	    else
		write(file_unit,1001)line(1:length)
	    end if
	    go to 4740

 4750	    if(length.eq.-1) then
		close(unit=file_unit)
		write(6,1001)crlf(:cl)//'Successful upload!'
		go to 4800
	    else
		close(unit=file_unit,disp='delete')
		write(6,1001)crlf(:cl)//bell//'Upload aborted'
	    end if
	end if
	go to 4900

 4800	continue	! get file description
	write(6,1001)crlf(:cl)//'Please enter the description for this file'
	write(6,1001)crlf(:cl)//'to be placed in the download directory.'
	write(6,1001)crlf(:cl)//
	1   'The description may be up to 20 lines. (max of 400 characters)'
	call enter_message(length,*4801,400)
	dummy1=1
	fd.upload_text=' '
	do i=1,length
	    istat=str$trim(message(i),message(i),dummy2)
	    fd.upload_text(dummy1:dummy1+dummy2)=message(i)(:dummy2)//char(cr)
	    dummy1=dummy1+dummy2+1
	    end do

	write(6,1001)crlf(:cl)//
	1   'Please enter keywords descriptive of this file for searches'//
	1   crlf(:cl)//'(up to 79 characters)?'
	dummy=79
	call get_uplow_string(fd.keywords,dummy)
	if(dummy.ne.0.and.fd.keywords.ne.' ') go to 4809

 4801	write(6,1001)crlf(:cl)//'Do you wish to abort this upload? [No]'
	dummy=1
	call get_upcase_string(cdummy,dummy)
	if(cdummy.ne.'Y') go to 4800
	istat = lib$delete_file(filnam//';*')
	go to 4900

c	find out how big the file is.  This useropen will put the file
c	size into fsize.
 4809	open(unit=4,file=filnam,status='old',readonly,
	1   useropen=getsize,err=4810)
	close(unit=4)

 4810	fd.file_size=fsize

	open(unit=4,		shared,
	1   file='ubbs_files:['//darea//']files.idx',
	2   status='old',	organization='indexed',
	3   access='keyed',	form='unformatted',
	4   recl=192,		recordtype='variable',
	5			key=(1:18:character),
	6   useropen=uopen)

	call sys$gettim(fd.upload_date)
	call sys$gettim(fd.download_date)
	fd.times_down=0
	fd.upload_name=mail_name

	write(4)fd
	close(unit=4)

c	Update his userlog record
	read(1,key=ur.user_key)ur
	ur.up_files=ur.up_files+1
	rewrite(1,err=4900)ur
 
 4900	continue
	return
 5000	continue
	types='X'
	call update_index(darea,types)
	go to 4000
	end
