C
C	Include file for KERMIT.
C
	PARAMETER POVER      =	3	! Packet overhead count:
					!    LEN, SEQ, & TYPE.
	PARAMETER TOVER      =	6	! Total packet overhead:
					! MARK, LEN, SEQ, TYPE, CHECK, EOL.
	PARAMETER MAXDATASIZ =	91	! Maximum data size field.
	PARAMETER MAXPACKSIZ =	94	! Maximum packet size (-MARK & CHECK)
	PARAMETER PACKBUFSIZ =	98	! The packet buffer size:
					! MARK, CHECK1, [CHECK2,] & EOL.
	PARAMETER TO_CHECK   =	2	! This size + PLEN = check field.
	PARAMETER PACKET_LENGTH = 80
C
C	Define my init characteristics.
C
	PARAMETER DEFMAXL    =	80	! Maximum packet length.
	PARAMETER DEFTIME    =	10	! Timeout value to use.
	PARAMETER DEFNPAD    =	0	! Number of padding characters.
	PARAMETER DEFPADC    =	0	! Padding character to send.
	PARAMETER DEFEOLC    =	13	! End-Of-Line character.
	PARAMETER DEFQCTL    =	'#'	! Control quote character.
	PARAMETER DEFQBIN    =  'N'	! No eight bit quoting.
	PARAMETER DEFCHKT    =  '1'	! Check type (1=checksum).
	PARAMETER DEFREPT    =	' '	! No repeat char processing.
	PARAMETER DEFCAPAS   =	0	! No extended capabilities.
C
C	Define my init characteristics.
C
	PARAMETER MYMAXL     =	80	! Maximum packet length.
	PARAMETER MYTIME     =	10	! Timeout value to use.
	PARAMETER MYNPAD     =	0	! Number of padding characters.
	PARAMETER MYPADC     =	0	! Padding character to send.
	PARAMETER MYEOLC     =	13	! End-Of-Line character.
	PARAMETER MYQCTL     =	'#'	! Control quote character.
	PARAMETER MYQBIN     =  'N'	! No eight bit quoting.
	PARAMETER MYCHKT     =  '1'	! Check type (1=checksum).
	PARAMETER MYREPT     =	' '	! No repeat char processing.
	PARAMETER MYCAPAS    =	0	! No extended capabilities.
C
C	Define the packet offsets:
C
C	I'd like to define a structure here, but since the packets can
C	vary in size I'm unable to use a structure declaration.
C
	PARAMETER PMARK	= 1		! Start of packet character.
	PARAMETER PLEN	= 2		! The packet length field.
	PARAMETER PSEQ	= 3		! The packet sequence field.
	PARAMETER PTYPE	= 4		! The packet type field.
	PARAMETER PDATA	= 5		! The packet data field.
C
C	Define init packet offsets:
C
	PARAMETER IMAXL	= 1		! Maximum packet length.
	PARAMETER ITIME	= 2		! Timeout limit to use.
	PARAMETER INPAD	= 3		! Number of pad characters.
	PARAMETER IPAD	= 4		! Pad character to use.
	PARAMETER IEOLC	= 5		! End of line character.
	PARAMETER IQCTL	= 6		! Control quote character.
C
C	The next init packet fields are optional.
C
	PARAMETER IQBIN	= 7		! 8-bit quote character.
	PARAMETER ICHKT	= 8		! Check type to use.
	PARAMETER IREPT	= 9		! Repeat character to use.
	PARAMETER ICAPAS = 10		! Capabilities mask.

	PARAMETER ISIZE = ICAPAS	! Set the init packet size.
C
C	Define Variables:
C
	INTEGER		cpsiz,		! The current packet size.
	1		rbytes,		! The record byte count.
	2		rpsiz,		! Maximum receive packet size.
	3		spsiz,		! Maximum send packet size.
	4		pad,		! How much padding to send.
	5		paknum,		! The packet number.
	6		prepak,		! The previous packet number.
	7		maxtry,		! The maximum retry count.
	8		numtry,		! Times this packet retried.
	9		oldtry,		! Times previous packet retried.
	1		timout,		! Timeout for foreign host on sends.
	2		packet_count,
	3		total_packets,
	4		total_bytes,
	5		total_records

	LOGICAL		image,		! 8-bit mode for file data.
	1		filnamcnv,	! Do file name case conversions.
	2		qbin,		! Do 8-bit character quoting.
	3		repeat,		! Do repeat character compression.
	4		turn,		! Look for turnaround char (XON).
	5		end_of_file

	BYTE		state,		! Present state of the automaton.
	1		cchksum,	! Our (computed) checksum.
	2		padc,		! Padding character to send.
	3		eolc,		! End-Of-Line character to send.
	4		qctlc,		! Control quote character.
	5		qbinc,		! Binary quote character.
	5		markc,		! Character to use for MARK.
	6		bquote,		! The binary quote character.
	7		chktyp,		! The check type to use.
	8		reptc,		! Character to use for repeats.
	9		capas		! The capabilities bit mask.

	BYTE	packet(PACKBUFSIZ)	! Allocate packet for send/receive.

	COMMON /KERCOM/	cpsiz, rpsiz, spsiz, pad, timout, paknum, prepak,
	1		maxtry, numtry, oldtry, image, turn, filnamcnv,
	2		state, cchksum, padc, eolc, qctlc, markc, packet,
	3		qbin, qbinc, chktyp, repeat, reptc, capas, rbytes,
	4		packet_count,total_packets,end_of_file,
	5		total_bytes,total_records

C
C	End of KERMIT include file.
C
