[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module topic_menu;

[global] procedure topic_menu;

{Allow user to select options pertaining to list of topics for
 this category.}

var i : integer;

begin
  topic_option := 'D';

  repeat   
    adjust := false;
    smg$erase_display(error_display);
    smg$unpaste_virtual_display(error_display,pasteboard);

    case topic_option of
      'A',key_insert : if bb_manager then add_topic;
      'B',key_prev : begin
                       if (topic_start = topic_root) then
                         begin
                           smg$begin_pasteboard_update(pasteboard);
                           smg$put_chars(main_display,' Beginning of topics ',
                                         18,30,,smg$m_reverse);
                           if bb_manager then
                             smg$set_physical_cursor(pasteboard,23,59)
                           else
                             smg$set_physical_cursor(pasteboard,23,47);
                           smg$end_pasteboard_update(pasteboard);
                         end
                       else
                         begin
                           i := 0;
                           while ((topic_start^.previous<>nil) and 
                                  (i<display_height)) do
                             begin
                               topic_start := topic_start^.previous;
                               i := i+1;
                             end;
                           write_topic_directory;
                         end;
                     end;
      'E',key_remove : if bb_manager then delete_topic;
      'D',key_find : write_topic_directory;
      'F',key_next,key_cr : begin
                              {If at bottom of list, reset to top of list.}
                              if (topic_list^.next = nil) then
                                topic_list := topic_root;
                              topic_start := topic_list;
                              write_topic_directory;
                            end;
      'S',key_select : begin
                         m_menu := false;
                         messages;
                       end;
      'H',key_help : begin
                       t_menu := false;
                       put_help('Help','BB$TOPIC.HLP',pause:=true);
                     end;
      otherwise
    end;

    {If topic added or deleted, adjust the list.}
    if ((topic_option in ['A',key_insert,'E',key_remove]) and adjust) then
      begin
        write_menu('','Adjusting topic list.  Please wait...');
        create_topic_dir_list;
        message_state;
      end;

    {After adding, deleting or selecting topics or using HELP, repaint
     topic menu screen.}
    if (((topic_option in ['A',key_insert,'E',key_remove]) and adjust) or
        (topic_option in ['S',key_select,'H',key_help])) then
      write_topic_directory;  {repaint screen after add or delete of topic}

    if (t_menu = false) then
      begin
        if bb_manager then
          write_menu('Topic Menu:',
                     ' Dir Frwd Back | Select Help Quit | Add Erase ')
        else
          write_menu('Topic Menu:',
                     ' Dir Frwd Back | Select Help Quit ');
        t_menu := true;
      end;
    topic_option := getchar;
  until topic_option in ['Q',key_exit];

  goto50;
end;

end.
