[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module message_menu;

[global] 
procedure message_menu;

{Write the message menu.  This procedure is repeated until the user decides
 to leave the current topic.}

var message : boolean;  {True if there are messages.}
    row, column : integer;

begin
  repeat
    adjust := false;  {Flag for repainting message menu.}
    message := true;  {Flag for if topic has any messages in it.}

    {Print message menu box.}
    if (dir_root^.next = nil) then
      begin  {Menu printed for empty topic}
        message := false;
        if (m_menu = false) then
          begin
            m_menu := true;
            write_menu('Message Menu:',' Add | Topics Help Quit ');
          end;
      end
    else
      if (m_menu = false) then
        begin    {Menu for topic with messages.}
          m_menu := true;
          write_menu('Message Menu:',
   	   ' Dir Frwd Back|Read Nxt Prev|Add Erase Snd Write|Topics Help Quit');
        end;

    {Print appropriate messages if user tries to add or delete from a
     topic that has been "protected".}
    message_option := getchar;
    smg$unpaste_virtual_display(error_display,pasteboard);
    if (message_option in ['A',key_insert,'E',key_remove]) and (protected)
     then 
	begin
          smg$erase_display(main_display);
          case message_option of
            'A',key_insert : begin	
                               smg$put_chars(main_display,
'This is a PROTECTED board.  Messages may only be added by USERSERVICES.',10,1,,
smg$m_reverse);
                             end;
            'E',key_remove : begin	
                               smg$put_chars(main_display,
'This is a PROTECTED board.  Messages may only be erased by USERSERVICES.',10,1,,
smg$m_reverse);
                             end;
              otherwise
  	    end;{case}
            if not(message) then
              smg$set_physical_cursor(pasteboard,23,39)
            else
              smg$set_physical_cursor(pasteboard,23,79);
  	  end
        else
          case message_option of
            'A',key_insert :  add_menu;
            'B',key_prev : begin
                             if message then
                               if dir_display then
                                 previous_message_directory_page
                               else
                                 previous_message_page;
                           end;
            'D',key_find : begin
                             if message then
                               begin
                                 if (dir_start^.next <> nil) then
                                   begin
                                     if (dir_start <> dir_root) then
                                       dir_start := dir_start^.next;
                                   end
                                 else
                                   dir_start := dir_root^.next;          
                                 dir_list := dir_start;
                                 dir_curr := dir_start;
        	                 write_message_directory;
                               end;
                           end;
            'E',key_remove : if message then delete_message;
            'F',key_next,key_cr : begin
			            if message then 
                                      if dir_display then
                                        begin
                                          if (dir_list^.next = nil) then
                                            if (dir_list = dir_root) then
                                              begin
                                                 smg$put_chars(main_display, 
                                                   ' No messages exist.',10,31,,
                                                     smg$m_reverse);
                                                 smg$set_physical_cursor(pasteboard,23,39);
                                              end
                                            else
                                              begin
                                                smg$put_chars(main_display,
	                                          ' End of messages. Back for more messages.   ',18,18,,smg$m_reverse);
                                                smg$set_physical_cursor(pasteboard,23,79);
                                              end
                                          else 
                                            begin
                                              dir_start := dir_list;
                                              dir_curr := dir_start^.next;
                                              write_message_directory;
                                            end;
                                        end       
                                      else
                                        begin
                                          if (data_curr^.next = nil) then
                                            next_message
                                          else
                                            write_message_data;
                                        end;
                                  end;
            'N' : if message then next_message;
            'P' : if message then previous_message;
            'R' : if message then 
                    begin
                      m_menu := false;
                      find_message;
                        if found then
                          begin
                            dir_list := dir_curr;
                            dir_start := dir_curr;
                            create_message_data_list;
                            data_curr := data_root;
                            write_message_data;
                          end;
                    end;
            'S' : if message then reply_menu;
            'W' : if message then extract;
            'H',key_help : begin
                             m_menu := false;
                             if message then
                               put_help('Help','BB$MESSAGE1.HLP',pause:=true)
                             else
                               put_help('Help','BB$MESSAGE2.HLP',pause:=true);
                           end;
            'Q' : begin
                    update_topic_info;
                    goto50;
                  end
            otherwise
          end;

    {If messages were added or deleted, list will have to be reformed.}
    if (((message_option in ['A',key_insert,'E',key_remove]) or
        ((message_option = 'S') and (destination_option = 'L'))) and
        (adjust)) then
      begin
        write_menu('','Adjusting message list.  Please wait...');
        create_message_dir_list;

        {Repaint message list screen}
        if (dir_start^.next <> nil) then
          begin
            if (dir_start <> dir_root) then
              dir_start := dir_start^.next;
            dir_list := dir_start;
            dir_curr := dir_start;
          end;
	write_message_directory;
      end;
  until message_option in ['T',key_exit];
end;

end.
