[INHERIT('smgdefs','BB.PEN')]
module log_message;

[global] 
procedure log_message;

{This procedure writes a record into the userfile for each message that
 is read.  If a message is previously read nothing is done.}

var
  new_user_record : newuserrec;
  temp_record : bbrec;

begin
  with topic_list^.message_counters do
    begin
      findk(newuserfile,0,dir_curr^.last_date_accessed+current_topic,eql,
            error:=continue);

      if ufb(newuserfile) then
        begin
          new_user_record.message_id := dir_curr^.last_date_accessed+current_topic;
          write(newuserfile,new_user_record,error:=continue);

          {Update message counters.}
          if (status(newuserfile) = 0) then
            begin
              dir_curr^.class := 1;
              topic_list^.message_counters.read_message := 
                            topic_list^.message_counters.read_message + 1;
              if (topic_list^.last_date_accessed <= 
                  dir_curr^.last_date_accessed) then
                topic_list^.message_counters.new_message := 
                             topic_list^.message_counters.new_message - 1
              else
                topic_list^.message_counters.skipped_message := 
                              topic_list^.message_counters.skipped_message - 1;
            end
          else
            begin
	      write_error('Unable to update User''s infomation file');
              smg$set_physical_cursor(pasteboard,23,79);
            end;
        end;
    end;  {with}

end;

end.
