[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module delete_message;

[global] 
procedure delete_message;

{Delete messages from the current topic by message number.  A bulletin
 board manager may delete any message.  A regular user may only delete
 messages previously added by that user.}

var
  new_user_record : newuserrec;
  temp_record : bbrec;
  owner, first_record : boolean;

begin
  m_menu := false;
  adjust := false;

  repeat
    find_message(base := 0);
    if found then
      begin
        $setprv(1,prv$m_sysprv);
        open(bbwrtfile,file_location+chosen_file,history:=old,
             access_method:=keyed,organization:=indexed,sharing:=readwrite,
             error:=continue);
        i:=1;
        owner:=false;

        {Check to make sure this user has authority to delete the message.}
        repeat
          owner := dir_curr^.poster = cluster_usernames[i];
          i := i+1;
        until owner or bb_manager or (i > num_nodes+1);

        if not owner then owner := dir_curr^.poster = user_id;
        if owner or bb_manager then
          begin
            write_menu('','Deleting message from bulletin board...');
            dir_curr^.number := -dir_curr^.number;
            actual_message_count := actual_message_count - 1;

            first_record := true;
            repeat
              findk(bbwrtfile,1,dir_curr^.topic+dir_curr^.date,eql,
                    error:=continue);
              owner := not ufb(bbwrtfile);

              if owner then 
                begin
                  delete(bbwrtfile);
                
                  {Delete record from user file it there is one.}
		  if (status(bbwrtfile) = 0) then
		    begin
                      new_user_record.message_id :=
                                  dir_curr^.last_date_accessed+current_topic;

                      if (first_record) then
                        with topic_list^.message_counters do
                          begin
                            adjust := true;  {Flags to adjust message list when delete finishes.}
                            first_record := false;
                            findk(newuserfile,0,new_user_record.message_id,
                                   eql,error:=continue);

                            if (not ufb(newuserfile)) then
                              begin
                                read_message := read_message - 1;
                                {delete record of message from the user's file}
                                delete(newuserfile);
                              end
                            else 
                               if (dir_curr^.last_date_accessed <= 
                                     bbwrtfile^.date_posted) then
                                 new_message := new_message - 1
                               else
                                 skipped_message := skipped_message - 1;

                            total_message := read_message + new_message + 
                                             skipped_message;
                          end;{with}
                    end;
                end;           
            until not owner;
          end
        else
          begin
            write_error('You do not own that message.');
            smg$set_physical_cursor(pasteboard,23,79);
          end;

      close(bbwrtfile,error:=continue);
      $setprv(0,prv$m_sysprv);
    end;
  until out_of_bounds or (actual_message_count < 1);

  if (actual_message_count < 1) then
    begin
      dir_root^.next := nil;
      dir_start := dir_root;
      dir_curr := dir_root;
    end;

end;
end.
