[inherit('sys$library:starlet','lib$spawn','smgdefs','smg$repaint_line',
'BB.PEN')]
module add_file;

[global] 
procedure add_file;

{Put an existing file into local database file or onto the
 internet with VAX/VMS mail utility.}

var
  filename : string;

begin
  repeat

    {Query user for file name.  Then see if file name is valid.  A
     carriage return to this query sends user back to previous menu.}
    write_menu('','File Name <CR> | <CR> for previous menu: ');
    readstr(filename);

    smg$unpaste_virtual_display(error_display,pasteboard);
    if ((length(filename) > 0) and (filename <> key_exit)) then
      begin
        open(ifile,filename,history:=readonly,error:=continue);
        if (status(ifile) = 0) then
          begin
            get_message_info;   {Create header for message.}
            case destination_option of
               'I','P' : put_internet(mail_file:=filename);
               'L' : put_local;
            end;
            close(ifile,error:=continue);
          end
        else
          write_error('Unable to open input file.');
      end;
  until (length(filename) = 0) or (filename = key_exit) or 
        (message_option = 'S');
end;

end.
