/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __MSG_JAM_H
#define __MSG_JAM_H

#include <stdio.h>

#include "files.h"
#include "jam.h"

#define MSG_FLAG_PRIVATE        0x0001
#define MSG_FLAG_SENT           0x0002
#define MSG_FLAG_RECEIVED       0x0004
#define MSG_FLAG_DELETED        0x0008

#define BUF_SIZE 4096

#define LINE_TYPE_NORMAL  0
#define LINE_TYPE_QUOTE   1
#define LINE_TYPE_TAG     2
#define LINE_TYPE_TEAR    3
#define LINE_TYPE_ORIGIN  4
#define LINE_TYPE_KLUDGE  5
#define LINE_TYPE_SPECIAL 6

typedef struct LINE_REC
{
    struct LINE_REC *next;
    struct LINE_REC *prev;

    unsigned long ptr;
    unsigned char len;
    char line_type;
}
LINE_REC;

extern LINE_REC *msg_first_linerec;
extern LINE_REC *msg_linerec;
extern unsigned long msg_current_line;

extern FILE_BUF *msg_Fjhr, *msg_Fjdx, *msg_Fjdt;

extern char msg_from[36];
extern char msg_to[36];
extern char msg_subj[81];
extern unsigned long msg_date;
extern unsigned msg_flags;

extern unsigned long msg_msgnum;
extern unsigned long msg_replyto,msg_reply1st,msg_replynext;

extern char msg_msgid_kludge[81];
extern char msg_reply_kludge[81];
extern char msg_orig_net[100];
extern char msg_dest_net[100];
extern char msg_charset_kludge[81];
extern char msg_intl_kludge[81];
extern char msg_origin_line[200];

extern unsigned short msg_zone,msg_net,msg_node,msg_point;

extern unsigned msg_firstmsg,msg_messages;

extern unsigned long msg_txtpos,msg_txtlen;
extern unsigned long msg_txtlines;

extern unsigned char *msg_dat_buf;
extern unsigned long msg_dat_start,msg_dat_end;

int msg_init(void);
void msg_deinit(void);

int msg_open_area(char *fname, char create);
void msg_close_area(void);

int msg_read_message(unsigned long num);
int msg_enter_msg(char *txtfile);
int msg_update_message(unsigned long num);

int msg_init_msgtext(void);
void msg_deinit_msgtext(void);
char *msg_read_textline(unsigned long line);

unsigned msg_read_msgtext(unsigned long txtpos, char **buffer, unsigned bufsize);

#endif
