/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __MENUTYPE_H
#define __MENUTYPE_H

#define MENU_SHOW_TEXT                  0x0001
#define MENU_ASK_STRING                 0x0002
#define MENU_GOTO_MENU                  0x0003
#define MENU_LOGOFF                     0x0004
#define MENU_SHOW_ANSI                  0x0005

#define MENU_FAREA_CHANGE               0x0006
#define MENU_FAREA_LIST                 0x0007
#define MENU_FAREA_FILESEARCH           0x0008
#define MENU_FAREA_KEYSEARCH            0x0009
#define MENU_FAREA_DOWNLOAD             0x000A

#define MENU_MAREA_CHANGE               0x000B
#define MENU_MSG_READ                   0x000C
#define MENU_MSG_NEXT                   0x000D
#define MENU_MSG_PREV                   0x000E
#define MENU_LIST_MSGS                  0x000F
#define MENU_MSG_ENTER                  0x0010
#define MENU_MSG_REPLY                  0x0011
#define MENU_MSG_GOTO                   0x0012
#define MENU_MSG_DOWN                   0x0013
#define MENU_MSG_RESTORE                0x0014

#define MENU_FAREA_DELETE               0x0015
#define MENU_FAREA_UPLOAD               0x0016

#define MENU_MAREA_SHOWSTAT             0x0017

#define MENU_SHOW_JOBS                  0x0018
#define MENU_KILL_JOB                   0x0019

#define MENU_MAREA_PTR_DAYS             0x001a
#define MENU_MAREA_NEXT_NEW             0x001b

#define MENU_FAREA_NEWFILES             0x001c

#define MENU_SETUP_EDIT                 0x001d

#define MENU_EXECUTE                    0x001e

#define MENU_MSG_KILL                   0x001f
#define MENU_YELL                       0x0020
#define MENU_RUNPS                      0x0021
#define MENU_RUNUPTIME                  0x0022
#define MENU_MSG_REPLY_ANOTHER          0x0023
#define MENU_WHO                        0x0024
#define MENU_NODEMSG                    0x0025
#define MENU_MAREA_PTRS                 0x0026
#define MENU_USERLIST                   0x0027
#define MENU_LASTCALLERS                0x0028
#define MENU_LASTNODEMSGS               0x0029
#define MENU_FAREA_RENAME               0x002a
#define MENU_SHELL                      0x002b
#define MENU_SCORELIST                  0x002c
#define MENU_BBSUSAGE                   0x002d

#define MENU_CHANGE_USER                0x002e
#define MENU_KILL_USER                  0x002f

extern char answer[256]; /* Answer macro */

int run_menutype(unsigned menutype, char *data);

void take_param(char *field); /* Move first parameter from cmd line to field */
void take_data_param(char *field, char *parms); /* Move first parameter from parms to field */
void remove_param(); /* Remove first parameter from cmd line */
void remove_data_param(char **data); /* Remove first parameter from parms */

#endif
