/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* menutype.c - Run menutypes */

/* Todo: Rewrite this whole file. :) */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef __linux__
#  include <signal.h>
#  include <sys/wait.h>
#  include <sys/time.h>
#endif

#include "os.h"
#include "threads.h"
#include "ask_str.h"
#include "files.h"
#include "showfile.h"
#include "toplist.h"
#include "nodes.h"
#include "bbs_func.h"
#include "output.h"
#include "fsearch.h"
#include "fareas.h"
#include "mareas.h"
#include "filelist.h"
#include "download.h"
#include "messages.h"
#include "lastcall.h"
#include "grabmsgs.h"
#include "menutype.h"
#include "keyb.h"
#include "userbase.h"
#include "chat.h"
#include "logfile.h"
#include "modem.h"
#include "setup.h"
#include "timeslic.h"
#include "config.h"
#include "language.h"

char answer[256];

void create_dorinfo(void)
{
    FILE *F;
    char tmp[50],buf[20],name[36],*last = NULL,*strp;

    strcpy(name,sysop_name);
    strp = strchr(name,' ');
    if (strp != NULL)
    {
        *strp++ = '\0';
        last = strp;
    }
    strp = strrchr(name,' ');
    if (strp != NULL) last = strp+1;

    sprintf(buf, "%sdorinfo%d.def", common_path, nodenum);
    F = fopen(buf,"w+b");
    if (F == NULL) return;
    chmod(buf, 0660);

    fprintf(F,"%s\r\n",strupr(strcpy(tmp,bbs_name)));
    fprintf(F,"%s\r\n",strupr(name));
    fprintf(F,"%s\r\n",strupr(last));
#ifdef __DOS__
    fprintf(F,"COM%d\r\n", hCom);
#else
    fprintf(F,"COM%d\r\n", hCom == 0 ? 0 : comport);
#endif
    fprintf(F,"%lu BAUD,N,8,1\r\n", bpsrate);
    if (user.Emulation == USER_EMULATION_ASCII)
        fprintf(F,"0\r\n");
    else
        fprintf(F,"1\r\n");

    strcpy(name,usrsub.name);
    strp = strchr(name,' ');
    if (strp != NULL)
    {
        *strp++ = '\0';
        last = strp;
    }
    strp = strrchr(name,' ');
    if (strp != NULL) last = strp+1;

    fprintf(F,"%s\r\n",name);
    fprintf(F,"%s\r\n",last);
    fprintf(F,"%s\r\n",usrsub.city);
    fprintf(F,"1\r\n");
    fprintf(F,"30\r\n"); /* Security level */
    fprintf(F,"%d\r\n",time_left);

    fclose(F);
}

#ifdef __linux__
void idiot_mode(char *name)
{
    char *arg[6];
    char buf[80];
    FILE *F;
    struct stat statbuf;
    int tries;

    write_log("Started idiot_mode() with application %s",name);
    output("\r\nStarting %s .. this will take a couple of seconds..",name);

    /* Check if dosemu is still in background */
    if (dosemu_pid != -1 && waitpid(dosemu_pid,NULL,WNOHANG) != 0)
    {
        /* Nope, it wasn't. */
        dosemu_pid = -1;
    }

    if (dosemu_pid == -1)
    {
        /* Start DOS emulator */
        dosemu_pid = fork();
        if (dosemu_pid == -1)
        {
            output("\r\nCouldn't fork()! Out of memory??");
            write_log("idiot_mode() : Couldn't fork()! Out of memory??");
            return;
        }

        if (dosemu_pid == 0)
        {
            /* Start DOS emulator */
            arg[0] = "dos";
            arg[1] = "-F";
            sprintf(buf, "/etc/dosemu%d.conf", nodenum);
            arg[2] = buf;
            arg[3] = "-o";
            arg[4] = "/tmp/debug";
            arg[5] = NULL;
            execvp(arg[0],&arg[0]);
        }
    }
    else
    {
        kill(dosemu_pid, SIGCONT);
    }

    sprintf(buf,"%sack.%d",common_path,nodenum);
    remove(buf);

    /* Create starting semafore to dosemu */
    sprintf(buf,"%swaiting.%d",common_path,nodenum);
    F = fopen(buf, "w+b"); fwrite(name,1,1,F); fclose(F);
    chmod(buf, 0660);

    /* Wait for ack-file from dosemu.. */
    tries = 0;
    sprintf(buf,"%sack.%d",common_path,nodenum);
    while (stat(buf,&statbuf) != 0 && tries < 10)
    {
        outchr('.');
        tries++;
        sleep(1);
    }
    output("ok!\r\n");

    sprintf(buf,"%sack.%d",common_path,nodenum); remove(buf);

    if (tries == 30)
    {
        /* Didn't got ack-file in 30 seconds, something must've happened to
         dosemu.. */
        output("What?? DOS-emulator must have crashed, why doesn't it work???\r\n");
    }
    else
    {
        /* Update node file */
        noderec.doing = DOING_DOOR;
        strcpy(noderec.data,name);
        update_nodefile(0);

        /* Wait until door quits */
        for (;;)
        {
            sleep(1);

            /* Check if dosemu is still in there.. */
            if (waitpid(dosemu_pid,NULL,WNOHANG) != 0)
            {
                output("\r\n\n@X07Great, DOS-emulator crashed..\r\n");
                dosemu_pid = -1;
                break;
            }

            /* Check if door was quit. */
            sprintf(buf,"%swaiting.%d",common_path,nodenum);
            if (stat(buf,&statbuf) != 0) break;
        }
        inactivity = 0; told_inactivity = 0; last_tim = last_min = time(NULL);
    }

    sprintf(buf,"%swaiting.%d",common_path,nodenum); remove(buf);

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    if (dosemu_pid != -1) kill(dosemu_pid, SIGSTOP);
}
#endif

void take_data_param(char *field, char *parms)
{
    char *strp = parms;
    int hipsu = 0;

    while (*strp == ' ') strp++;
    if (*strp == ';')
    {
        *field = '\0';
        return;
    }
    if (*strp == ',')
    {
        /* , = cr */
        *field++ = '\n';
        strp++;
    }
    else
    {
        while (*strp != '\0' && (hipsu || (*strp != ';' && *strp != ' ' && *strp != ',')))
        {
            if (*strp == '\"')
            {
                if (hipsu)
                {
                    *field++ = *strp++;
                    break;
                }
                hipsu = 1;
            }
            *field++ = *strp++;
        }
    }
    *field = '\0';
    while (*strp == ' ') strp++;

    memmove(parms, strp, strlen(strp)+1);
}

void take_param(char *field)
{
    take_data_param(field, parms);
}

int run_menutype(unsigned menutype, char *data)
{
    unsigned long lnum;
    char *strp, tmp[256];
    int slen;

    /* data must be between " characters */
    if (data[0] != '"')
    {
        data[0] = '\0';
    }
    else
    {
        slen = strlen(data)-1;
        if (data[slen] != '"') slen = 0;
        data[slen] = '\0';
        if (slen != 0) data++;
    }

    switch (menutype)
    {
        case MENU_SHOW_TEXT:
            output("%s", data);
            break;
        case MENU_ASK_STRING:
            answer[0] = 0;
            strp = strchr(data, ' ');
            if (strp != NULL) *strp++ = '\0';
            if (!ask_string(strp == NULL ? "" : strp, answer, (int) atol(data), 0, NULL)) return 1;
            break;
        case MENU_GOTO_MENU:
            strcpy(menuname,data);
            return 2;
        case MENU_LOGOFF:
            if (data[0] == '\0') take_param(data);
            if (yes_no(lang[LANG_LOGOFF], 0, &data))
            {
                /* Hang up */
                return 1;
            }
            break;
        case MENU_SHOW_ANSI:
            show_file(data);
            break;
        case MENU_YELL:
            if (data[0] == '\0')
            {
                strcpy(data, parms);
                parms[0] = '\0';
            }
            yell_sysop(data);
            break;
        case MENU_USERLIST:
            if (data[0] == '\0') take_param(data);
            userlist(data);
            break;
        case MENU_LASTCALLERS:
            last_callers();
            break;
        case MENU_BBSUSAGE:
            if (data[0] == '\0') take_param(data);
            bbs_time_usage(data);
            break;
        case MENU_LASTNODEMSGS:
            display_old_nodemsgs();
            break;
        case MENU_SHOW_JOBS:
            show_jobs();
            break;
        case MENU_KILL_JOB:
            if (data[0] == '\0') take_param(data);
            kill_job(data);
            break;
        case MENU_FAREA_CHANGE:
            if (data[0] == '\0') take_param(data);
            if (select_farea(data) == 0)
                output(lang[LANG_DIR_NOT_FOUND]);
            break;
        case MENU_FAREA_LIST:
            if (data[0] == '\0') take_param(data);
            list_files(data);
            break;
        case MENU_FAREA_FILESEARCH:
            if (data[0] == '\0') take_param(data);
            file_search(data);
            break;
        case MENU_FAREA_KEYSEARCH:
            if (data[0] == '\0') take_param(data);
            keyword_search(data);
            break;
        case MENU_FAREA_NEWFILES:
            if (data[0] == '\0') take_param(data);
            newfiles_search(data);
            break;
        case MENU_FAREA_DOWNLOAD:
            if (data[0] == '\0') take_param(data);
            download_files(data);
            break;
        case MENU_FAREA_DELETE:
            if (data[0] == '\0') take_param(data);
            delete_file(data);
            break;
        case MENU_FAREA_RENAME:
            if (data[0] == '\0') take_param(data);
            rename_file(data);
            break;
        case MENU_FAREA_UPLOAD:
            upload_files(1);
            break;
        case MENU_MAREA_CHANGE:
            /* Select new message area */
            if (data[0] == '\0') take_param(data);
            select_marea(data);
            break;
        case MENU_MSG_READ:
            draw_msg(current_msg);
            break;
        case MENU_MSG_NEXT:
            next_message(2);
            break;
        case MENU_MSG_PREV:
            prev_message(2);
            break;
        case MENU_LIST_MSGS:
            if (data[0] == '\0') take_param(data);
            list_msgs(data);
            break;
        case MENU_MSG_ENTER:
            /* Enter new message */
            if (data[0] == '\0') take_param(data);
            enter_message(0,0,data);
            break;
        case MENU_MSG_REPLY:
            enter_message(1,0,NULL);
            break;
        case MENU_MSG_REPLY_ANOTHER:
            enter_message(1,1,NULL);
            break;
        case MENU_MSG_GOTO:
            /* Jump to message # */
            if (data[0] == '\0') take_param(data);
            conv_macros(data,tmp);
            if (sscanf(tmp,"%lu",&lnum) == 1)
                goto_message(lnum);
            else
                output(lang[LANG_MSG_NOT_FOUND]);
            break;
        case MENU_MSG_DOWN:
            /* Download message packet */
            if (data[0] == '\0') take_param(data);
            grab_messages(data);
            break;
        case MENU_MSG_RESTORE:
            if (data[0] == '\0') take_param(data);
            if (stricmp(data,"CALL") == 0)
            {
                if (restore_pointers(ptrs_this_call) == 1)
                    output("\r\nLastread pointers restored to start of call\r\n");
            }
            if (stricmp(data,"CLEAR") == 0)
            {
                clear_pointers();
                output("\r\nLastread pointers cleared\r\n");
            }
            break;
        case MENU_MSG_KILL:
            kill_message();
            break;
        case MENU_MAREA_PTR_DAYS:
            /* Select new message area */
            if (data[0] == '\0') take_param(data);
            pointer_days(data);
            break;
        case MENU_MAREA_SHOWSTAT:
            show_mareas_status();
            break;
        case MENU_MAREA_NEXT_NEW:
            next_new_message(1);
            break;
        case MENU_SETUP_EDIT:
            if (data[0] == '\0') take_param(data);
            edit_setup(data);
            break;
        case MENU_EXECUTE:
            create_dorinfo();
#ifdef __linux__
            idiot_mode(data);
#elif defined (__OS2__)
            noderec.doing = DOING_DOOR; noderec.data[0] = '\0';
            update_nodefile(0);

            conv_macros(data,tmp);
            flush_transmit();
            block_thread = 1;
            write_log("Running door '%s'", tmp);
            system(tmp);
            block_thread = 0;

            noderec.doing = DOING_NOTHING;
            update_nodefile(0);
#else
            system(data);
#endif
            sprintf(tmp, "%sdorinfo%d.def", common_path, nodenum);
            remove(tmp);
            break;
        case MENU_RUNPS:
            output("\r\n");
#ifdef __linux__
            if (data[0] != '\0')
                sprintf(tmp,"ps %s > %s", data, devname);
            else
            {
                sprintf(tmp,"ps %s > %s", parms, devname);
                parms[0] = '\0';
            }
            tty_old();
            system(tmp);
            tty_raw();
            /*show_file(tmp+9);
            remove(tmp+9);*/
#elif defined (__OS2__)
            sprintf(tmp,"go > \\tmp\\bbs%d\\show.tmp",nodenum);
            system(tmp);
            show_file(tmp+5);
            remove(tmp+5);
#endif
            break;
        case MENU_RUNUPTIME:
            output("\r\n");
#ifdef __linux__
            if (data[0] != '\0')
                sprintf(tmp,"uptime %s > %s", data, devname);
            else
            {
                sprintf(tmp,"uptime %s > %s", parms, devname);
                parms[0] = '\0';
            }
            tty_old();
            system(tmp);
            tty_raw();
#elif defined (__OS2__)
            sprintf(tmp,"go -ut > \\tmp\\bbs%d\\show.tmp",nodenum);
            system(tmp);
            show_file(tmp+9);
            remove(tmp+9);
#endif
            break;
        case MENU_WHO:
            display_who();
            break;
        case MENU_NODEMSG:
            /* Send node message */
            if (data[0] == '\0')
            {
                strcpy(data, parms);
                parms[0] = '\0';
            }
            send_nodemsg(data);
            break;
        case MENU_MAREA_PTRS:
            update_pointers(current_msg-1);
            break;
        case MENU_SHELL:
            if (in_group("sysop"))
            {
#ifdef __linux__
                KbdDeInit();
                dup2(hCom, STDIN_FILENO);
                dup2(hCom, STDOUT_FILENO);
                dup2(hCom, STDERR_FILENO);

                tty_old();
                system("/bin/zsh");
                tty_raw();

                KbdInit();
#endif
            }
            break;
        case MENU_SCORELIST:
            create_user_score_list();
            break;
        case MENU_CHANGE_USER:
            if (in_group("sysop"))
            {
                if (!write_user())
                {
                    write_log("Can't write to userbase.");
                    output("\r\nCan't write to userbase.\r\n");
                    break;
                }

                if (data[0] == '\0') take_param(data);

                /* Get user name */
                tmp[0] = '\0';
                if (!ask_string("\r\n@X07Read user: ", tmp, 35, 0, &data) || tmp[0] == '\0') break;

                /* Read user */
                lnum = scan_user(tmp);
                if (lnum != 0)
                {
                    if (read_user(lnum, 1))
                        output("\r\n@X07OK. You're now %s", tmp);
                    else
                        output("\r\n@X07Failed.");
                }
                else
                {
                    output("\r\n@X07No such user as '%s'", tmp);
                }
            }
            break;
        case MENU_KILL_USER:
            if (in_group("sysop"))
            {
                user.Attrib1 ^= USER_ATTRIB_DELETED;
                if (user.Attrib1 & USER_ATTRIB_DELETED)
                    output(lang[LANG_USER_DELETED]);
                else
                    output(lang[LANG_USER_UNDELETED]);
            }
            break;
        default:
            printf("\nUnknown menutype %u\n",menutype);
            break;
    }

    while (parms[0] == ';') memmove(parms, parms+1, strlen(parms));
    return 0;
}
