#ifndef __LASTCALL_H
#define __LASTCALL_H

#include <time.h>

#define DONE_DOWNLOAD     0x0001
#define DONE_UPLOAD       0x0002
#define DONE_READ         0x0004
#define DONE_WRITE        0x0008
#define DONE_YELL         0x0010
#define DONE_MSGPKT       0x0020
#define DONE_NEW_USER     0x0040
#define DONE_CARRIER_LOST 0x0080

typedef struct
{
    unsigned short node;
    char name[36];
    char alias[36];
    char city[26];
    unsigned long bpsrate;
    time_t login;
    time_t logoff;
    unsigned short done_flags;
}
LASTCALL_REC;

typedef struct
{
    int nodenum;
    time_t login;
    time_t logoff;
}
BBSUSAGE_REC;

extern LASTCALL_REC current_lastrec;
extern LASTCALL_REC lastrec;

void last_callers(void);                /* List last callers */
void write_lastcaller(void);            /* Write record to last callers list */

void bbs_time_usage(char *data);        /* Show BBS time usage */

#endif
