/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* keyb.c - Keyboard handling for DOS and OS/2 */

#ifdef __OS2__
#  define INCL_KBD
#  include <os2.h>
#elif defined (__DOS__)
#  include <dos.h>
#endif

#include <stdlib.h>
#include <string.h>

#include "os.h"
#include "chat.h"
#include "config.h"
#include "output.h"
#include "modem.h"
#include "userbase.h"
#include "timeslic.h"

#ifndef __NT__

static char KbdScanCode = 0;

int kbhit(void)
{
#ifdef __OS2__
    KBDKEYINFO key;

    key.fbStatus = 0;
    KbdPeek(&key,0);
    return (key.fbStatus & KBDTRF_FINAL_CHAR_IN) != 0;
#else
    union REGS regs;
    memset(&regs, 0, sizeof regs);
    regs.loreg.ah = 0x01;
    intr(0x16,&regs,&regs);
    return (regs.hireg.cflag & 0x40) == 0;
#endif
}

#if !defined (__linux__) && !defined (__OS2__) && !defined (__NT__)
static void _getkey(unsigned char *chScan, unsigned char *chChar)
{
    union REGS regs;
    regs.h.ah = 0x00;
#ifdef __386__
    int386(0x16, &regs, &regs);
#else
    int86(0x16, &regs, &regs);
#endif
    *chScan = regs.h.ah;
    *chChar = regs.h.al;
}
#endif

int getch(void)
{
#ifdef __OS2__
    KBDKEYINFO ki;
    char ch;

    if (KbdScanCode != 0)
    {
        ch = KbdScanCode;
        KbdScanCode = 0;
        return ch;
    }

    ki.chChar = 0;
    ki.chScan = 0;
    KbdCharIn(&ki, IO_WAIT, 0);

    if (ki.chChar == 0xe0)
    {
        if (ki.chScan)
        {
            ki.chChar = 0;		/* force scan return */
        }
        else
        {						/* get next block */
            ki.chChar = 0;
            KbdCharIn(&ki, IO_WAIT, 0);
            if (!ki.chScan)
            {					/* still no scan? */
                ki.chScan = ki.chChar;	/* move new char over */
                ki.chChar = 0;	/* force its return */
            }
            else
            {
                ki.chChar = 0;	/* force new scan */
            }
        }
    }
    if (ki.chScan == 0xe0)
    {
        if (!ki.chChar)
        {
            ki.chScan = 0;
            KbdCharIn(&ki, IO_WAIT, 0);
            if (!ki.chScan)
            {					/* still no scan? */
                ki.chScan = ki.chChar;	/* move new char over */
                ki.chChar = 0;	/* force its return */
            }
            else
            {
                ki.chChar = 0;	/* force new scan */
            }
        }
        else
        {
            ki.chScan = 0;		/* handle 0xe00d case */
        }
    }
    if (ki.chChar)
    {
        ki.chScan = 0;
    }
#else
    unsigned char chChar, chScan;
    char ch;

    if (KbdScanCode != 0)
    {
        ch = KbdScanCode;
        KbdScanCode = 0;
        return ch;
    }
    while (!kbhit()) give_timeslice();

    _getkey(&chScan, &chChar);
    if (chChar == 0xe0)
    {
        if (chScan)
        {
            chChar = 0; 		/* force scan return */
        }
        else
        {						/* get next block */
            chChar = 0;

            _getkey(&chScan, &chChar);
            if (!chScan)
            {					/* still no scan? */
                chScan = chChar;  /* move new char over */
                chChar = 0; 	/* force its return */
            }
            else
            {
                chChar = 0; 	/* force new scan */
            }
        }
    }
    if (chScan == 0xe0)
    {
        if (!chChar)
        {
            chScan = 0;

            _getkey(&chScan, &chChar);
            if (!chScan)
            {					/* still no scan? */
                chScan = chChar;  /* move new char over */
                chChar = 0; 	/* force its return */
            }
            else
            {
                chChar = 0; 	/* force new scan */
            }
        }
        else
        {
            chScan = 0; 		/* handle 0xe00d case */
        }
    }
    if (chChar)
    {
        chScan = 0;
    }
#endif

#ifdef __OS2__
#  define chScan ki.chScan
#  define chChar ki.chChar
#endif
    if (chChar == 0)
    {
        if (chScan == 38)
        {
            /* Alt-L = Line chat */
            line_chat();
            KbdScanCode = 255;
            return 0;
        }
        if (chScan == 46)
        {
            /* Alt-C = Split screen chat */
            if (user.Emulation == USER_EMULATION_ASCII)
                line_chat();
            else
                split_screen_chat();
            KbdScanCode = 255;
            return 0;
        }
        if (chScan == 35)
        {
            /* Alt-H = Hang up */
            carrier = 0;
            KbdScanCode = 254;
            return 0;
        }

        if (chScan == 36)
        {
            /* Alt-J = shell */
#ifdef __OS2__
            block_thread = 1;
#endif
            system(shell);
#ifdef __OS2__
            block_thread = 0;
#endif
            KbdScanCode = 255;
            return 0;
        }

        if (chScan == 120)
        {
            /* Alt-1 = Less time */
            if (time_left < 5) time_left = 0; else time_left -= 5;
            user.TodayMinutes += 5;
            KbdScanCode = 254;
            return 0;
        }
        if (chScan == 121)
        {
            /* Alt-2 = More time */
            time_left += 5;
            if (user.TodayMinutes > 5) user.TodayMinutes -= 5;
            KbdScanCode = 254;
            return 0;
        }
    }

    inactivity = 0; told_inactivity = 0;
    KbdScanCode = chScan;
    return local_in[(unsigned char) chChar];
}

#endif
