/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* grabmsgs.c - Grab messages */

/* Todo: Hippo and OMEN formats */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#ifdef BIG_ENDIAN
/* Why does Linux define this even with intel CPU? Oh well.. */
#  undef BIG_ENDIAN
#  include "bluewave.h"
#  define BIG_ENDIAN
#else
#  include "bluewave.h"
#endif

#include "qwk.h"

#include "os.h"
#include "memory.h"
#include "userbase.h"
#include "download.h"
#include "filelist.h"
#include "ask_str.h"
#include "timeslic.h"
#include "crc32.h"
#include "threads.h"
#include "files.h"
#include "nodes.h"
#include "keyb.h"
#include "modem.h"
#include "output.h"
#include "mareas.h"
#include "fareas.h"
#include "logfile.h"
#include "messages.h"
#include "msg_jam.h"
#include "config.h"
#include "lastcall.h"
#include "bbs_func.h"
#include "setup.h"
#include "language.h"

enum { FORMAT_BW, FORMAT_QWK, FORMAT_OMEN, FORMAT_HIPPO };

#define READBUF_SIZE 16384

static int Fmix, Ffti, Fdat;  /* Blue Wave files */
static MIX_REC mix;             /* Blue Wave .MIX file record */

static char *readbuf;           /* Message text read buffer */

static int back;
static unsigned long old_area;

static unsigned long total_msgs,total_personal;

/* QWK stuff */
static int Fndx;
static NDX_REC ndx;
static unsigned long area_msgs,area_personal;

static char *week_day[7] =
{
    "su","mo","tu","we","th","fr","sa"
};

long basicreal2long(long invalue)
{
    long temp;
    int negative,expon;

    if (invalue & 0x00800000)
        negative = 1;
    else
        negative = 0;

    expon = (int) ((invalue >> 24) & 0xff);
    temp = (invalue & 0x007fffff) | 0x00800000;
    expon -= 152;
    if (expon == 0) return 0;

    if (expon < 0)
        temp >>= abs(expon);
    else
        temp <<= expon;

    if (negative)
        return -temp;
    else
        return temp;
}

long long2basicreal(long invalue)
{
    int negative;
    long expon;

    if (invalue == 0) return 0;

    if (invalue < 0)
    {
        negative = 1;
        invalue = labs(invalue);
    } else
        negative = 0;
    expon = 152;
    if (invalue < 0x007fffff)
    {
        while ((invalue & 0x00800000) == 0)
        {
            invalue <<= 1;
            expon--;
        }
    }
    else
    {
        while (invalue & 0xff000000)
        {
            invalue >>= 1;
            expon++;
        }
    }
    invalue &= 0x007fffff;
    if (negative)
        invalue |= 0x00800000;
    return invalue + (expon << 24);
}

int init_grabpacket(int format)
{
    unsigned long rec;
    char str[256];
    int Finfo;
    INF_HEADER info;
    INF_AREA_INFO ainfo;

    switch (format)
    {
        case FORMAT_BW:
            /* Create .inf file */
            sprintf(str, "%s"SSLASH"%s.inf", hold_farea.path, msg_packet_id);
            Finfo = FileCreate(str, CREATE_MODE);
            if (Finfo == -1)
            {
                write_log("Could not create file '%s'", str);
                output("\r\nCould not create file .inf file\r\n");
                return 0;
            }
            FileMode(Finfo, O_BINARY);

            /* Info file header */
            memset(&info, 0, sizeof(info));
            info.ver = PACKET_LEVEL;
            strcpy((char *) info.loginname, usrsub.name);
            strcpy((char *) info.aliasname, usrsub.alias);
            info.zone = 2; info.net = 227; info.node = 33; info.point = 0;
            strcpy((char *) info.sysop, sysop_name);
            strcpy((char *) info.systemname, bbs_name);
            info.maxfreqs = 0;
            info.can_forward = 1;
            info.inf_header_len = sizeof(INF_HEADER);
            info.inf_areainfo_len = sizeof(INF_AREA_INFO);
            info.mix_structlen = sizeof(MIX_REC);
            info.fti_structlen = sizeof(FTI_REC);
            info.uses_upl_file = 1;
            info.from_to_len = 35;
            info.subject_len = 71;
            strcpy((char *) info.packet_id, msg_packet_id);
            info.file_list_type = INF_FLIST_NONE;
            if (in_group("sysop")) info.netmail_flags = 0xffff;

            /* Write INF_HEADER */
            if (FileWrite(Finfo, &info, sizeof(info)) == 0)
            {
                write_log("Error writing to file '%s.inf'", msg_packet_id);
                output("\r\nError writing to .inf file\r\n");
                FileClose(Finfo);
                return 0;
            }

            /* Write area info records */
            for (rec=1; rec<=msg_areas; rec++)
            {
                read_marea_record(rec);
                if ((marea.flags & MAREA_FLAG_READ_RIGHTS) == 0) continue;

                if (marea.description[0] != '\0')
                    sprintf(str,"%s, %s",marea.name,marea.description);
                else
                    strcpy(str,marea.name);

                /* Create INF_AREA_INFO */
                memset(&ainfo, 0, sizeof(ainfo));
                sprintf((char *) ainfo.areanum,"%lu",marea.number);
                strncpy((char *) ainfo.echotag,marea.bw_tag,sizeof(ainfo.echotag)-1);
                strncpy((char *) ainfo.title,str,sizeof(ainfo.title)-1);
                if (marea.flags & MAREA_FLAG_SELECTED) ainfo.area_flags |= INF_SCANNING;
                if (marea.flags & MAREA_FLAG_NETMAIL) ainfo.area_flags |= INF_NETMAIL | INF_ECHO;
                if (marea.flags & MAREA_FLAG_ECHO) ainfo.area_flags |= INF_ECHO;
                if (marea.flags & MAREA_FLAG_WRITE_RIGHTS) ainfo.area_flags |= INF_POST;
                if ((marea.flags & MAREA_FLAG_PRIVATE_MSGS) == 0) ainfo.area_flags |= INF_NO_PRIVATE;
                if ((marea.flags & MAREA_FLAG_PUBLIC_MSGS) == 0) ainfo.area_flags |= INF_NO_PUBLIC;
                if (marea.flags & MAREA_FLAG_NO_TAGS) ainfo.area_flags |= INF_NO_TAGLINE;
                ainfo.network_type = INF_NET_FIDONET;

                /* Write INF_AREA_INFO */
                if (FileWrite(Finfo, &ainfo, sizeof(ainfo)) == 0)
                {
                    write_log("Error writing to file '%s.inf'", msg_packet_id);
                    output("\r\nError writing to .inf file\r\n");
                    FileClose(Finfo);
                    return 0;
                }
            }
            FileClose(Finfo);

            /* Create .mix file */
            sprintf(str, "%s"SSLASH"%s.mix", hold_farea.path, msg_packet_id);
            Fmix = FileCreate(str, CREATE_MODE);
            if (Fmix == -1)
            {
                write_log("Could not create file '%s'", str);
                output("\r\nCould not create .mix file\r\n");
                return 0;
            }
            FileMode(Fmix, O_BINARY);

            /* Create .fti file */
            sprintf(str, "%s"SSLASH"%s.fti", hold_farea.path, msg_packet_id);
            Ffti = FileCreate(str, CREATE_MODE);
            if (Ffti == -1)
            {
                write_log("Could not create file '%s'", str);
                output("\r\nCould not create .fti file\r\n");
                FileClose(Fmix);
                return 0;
            }
            FileMode(Ffti, O_BINARY);

            /* Create .dat file */
            sprintf(str, "%s"SSLASH"%s.dat", hold_farea.path, msg_packet_id);
            Fdat = FileCreate(str, CREATE_MODE);
            if (Fdat == -1)
            {
                write_log("Could not create file '%s.dat'", msg_packet_id);
                output("\r\nCould not create file '%s.dat'\r\n", msg_packet_id);
                FileClose(Ffti);
                FileClose(Fmix);
                return 0;
            }
            FileMode(Fdat, O_BINARY);

            mix.areanum[0] = '\0';

            write_log("Grabbing messages to Blue Wave packet");
            output(lang[LANG_GRABBING_MSGS], "Blue Wave");
            break;
        case FORMAT_QWK:
            output(lang[LANG_GRABBING_MSGS], "QWK");
            sprintf(str, "%s"SSLASH"messages.dat", hold_farea.path);
            Fdat = FileCreate(str, CREATE_MODE);
            if (Fdat == -1)
            {
                write_log("Could not create file '%s'", str);
                output("\r\nCould not create messages.dat\r\n");
                return 0;
            }
            FileMode(Fdat, O_BINARY);

            memset(str,0,128);
            strncpy(str, "Message packet produced by "SOFTWARE_NAME"/"OP_SYSTEM" "BBS_VERSION, 128);
            if (FileWrite(Fdat, str, 128) != 128)
            {
                write_log("Error writing to file '%s"SSLASH"messages.dat'", hold_farea.path);
                output("\r\nError writing to messages.dat\r\n");
                FileClose(Fdat);
                return 0;
            }
            break;
    }

    back = 0;
    old_area = 0;
    total_msgs = 0;
    total_personal = 0;
    return 1;
}

int grab_message(int format)
{
    char str[256],*txt;
    unsigned long txtpos,totalsize,blocks,oldFpos;
    unsigned bytes_got,slen,num;
    unsigned short point;
    struct tm *tim;

    FTI_REC fti;
    QWK_REC qwk;

    switch (format)
    {
        case FORMAT_BW:
            if (mix.areanum[0] == '\0')
            {
                /* First area, create .mix record */
                memset(&mix,0,sizeof(mix));
                sprintf((char *) mix.areanum,"%u",current_marea);
                mix.msghptr = FileSeek(Ffti, 0, SEEK_CUR);
                old_area = marea.number;
                output(lang[LANG_GRABAREA_PRINT]);
            }

            if (old_area != marea.number)
            {
                /* Not same message area as it was in last message, so write
                   last .mix record */
                if (FileWrite(Fmix, &mix, sizeof(mix)) == 0)
                {
                    output(lang[LANG_OUT_OF_DISKSPACE]);
                    return 0;
                }

                if (old_area != 0)
                {
                    total_msgs += mix.totmsgs;
                    total_personal += mix.numpers;

                    memset(str,8,back); str[back] = '\0';
                    outtext(str);
                    output(lang[LANG_GRABAREA_MSGS],mix.totmsgs);
                    if (mix.numpers > 0) output(lang[LANG_GRABAREA_PERSONAL], mix.numpers);
                }

                /* Create .mix record */
                memset(&mix,0,sizeof(mix));
                sprintf((char *) mix.areanum,"%lu",marea.number);
                mix.msghptr = FileSeek(Ffti, 0, SEEK_CUR);

                output(lang[LANG_GRABAREA_PRINT]);
                back = 0;
                old_area = marea.number;
            }

            /* Update .mix record */
            mix.totmsgs++;
            if (mix.totmsgs % 20 == 0)
            {
                if (!carr_det()) return 2;
                if (kbhit_nowait() && getch() == 3)
                {
                    /* Abort */
                    output(lang[LANG_GRAB_ABORTED]);
                    return 2;
                }
                if (mdm_kbhit() && mdm_getch() == 3)
                {
                    /* Abort */
                    output(lang[LANG_GRAB_ABORTED]);
                    return 2;
                }
                memset(str,8,back); str[back] = '\0';
                output("%s%u",str,mix.totmsgs);
                sprintf(str,"%u",mix.totmsgs);
                back = strlen(str);
            }
            if (stricmp(msg_to,usrsub.name) == 0) mix.numpers++;

            /* Create .fti record */
            memset(&fti,0,sizeof(fti));
            strcpy((char *) fti.from,msg_from);
            strcpy((char *) fti.to,msg_to);
            strcpy((char *) fti.subject,msg_subj);
            fti.msgnum = (unsigned short) msg_msgnum;
            fti.replyto = (unsigned short) msg_replyto;
            fti.replyat = (unsigned short) msg_reply1st;
            fti.msgptr = FileSeek(Fdat, 0, SEEK_CUR);
            fti.msglength = 0;
            if (msg_flags & MSG_FLAG_PRIVATE) fti.flags |= FTI_MSGPRIVATE;

            tim = localtime((time_t *) &msg_date);
            sprintf((char *) fti.date,"%02d %s %02u %02d:%02d:%02d",
                    tim->tm_mday,month[tim->tm_mon],tim->tm_year%100,
                    tim->tm_hour,tim->tm_min,tim->tm_sec);

            /* "verify" character ' ' */
            str[0] = 32; num = 1;

            /* MSGID kludge */
            if (msg_msgid_kludge[0] != '\0')
            {
                sprintf(str+num,"\x01MSGID: %s\r",msg_msgid_kludge);
                num += strlen(str+num);
            }

            /* CHARSET kludge */
            if (msg_charset_kludge[0] != '\0')
            {
                sprintf(str+num,"\x01""CHARSET: %s\r",msg_charset_kludge);
                num += strlen(str+num);
            }

            if (marea.flags & MAREA_FLAG_NETMAIL)
            {
                /* INTL (and FMPT) kludge to netmails */
                if (msg_dest_net[0] == '\0') strcpy(msg_dest_net,"????");
                sprintf(str+num,"\x01""INTL %s %s\r",msg_dest_net,msg_orig_net);
                num += strlen(str+num);
                str2addr(msg_orig_net,&fti.orig_zone,&fti.orig_net,&fti.orig_node,&point);
                if (point != 0)
                {
                    sprintf(str+num,"\x01""FMPT %u\r",point);
                    num += strlen(str+num);
                }
            }

            if (FileWrite(Fdat, str, num) != num)
            {
                output(lang[LANG_OUT_OF_DISKSPACE]);
                return 0;
            }

            fti.msglength = num;

            /* Write message text to .dat file */
            txtpos = 0;
            do
            {
                bytes_got = msg_read_msgtext(txtpos,&readbuf,READBUF_SIZE);
                if (bytes_got > 0)
                {
                    /* Write to .dat file */
                    if (FileWrite(Fdat, readbuf, bytes_got) != bytes_got)
                    {
                        output(lang[LANG_OUT_OF_DISKSPACE]);
                        return 0;
                    }
                    txtpos += bytes_got;
                }
            } while (bytes_got == READBUF_SIZE);
            fti.msglength += txtpos;

            /* Write .fti record */
            if (FileWrite(Ffti, &fti, sizeof(fti)) != sizeof(fti))
            {
                output(lang[LANG_OUT_OF_DISKSPACE]);
                return 0;
            }
            break;

        case FORMAT_QWK:
            if (old_area != marea.number)
            {
                /* Not same message area as it was in last message */
                if (old_area != 0)
                {
                    total_msgs += area_msgs;
                    total_personal += area_personal;

                    memset(str,8,back); str[back] = '\0';
                    outtext(str);
                    output(lang[LANG_GRABAREA_MSGS],area_msgs);
                    if (area_personal > 0) output(lang[LANG_GRABAREA_PERSONAL], area_personal);
                    FileClose(Fndx);
                }
                sprintf(str,"%s"SSLASH"%03u.ndx", hold_farea.path, current_marea);
                Fndx = FileCreate(str, CREATE_MODE);
                if (Fndx == -1)
                {
                    write_log("Can't create file '%s'", str);
                    output("\r\nCan't create .ndx file!\r\n");
                    return 0;
                }
                FileMode(Fndx, O_BINARY);

                area_msgs = 0;
                area_personal = 0;

                output(lang[LANG_GRABAREA_PRINT]);
                back = 0;
                old_area = marea.number;
            }

            if (area_msgs % 10 == 0)
            {
                if (!carr_det()) return 2;
                if (kbhit_nowait() && getch() == 3)
                {
                    /* Abort */
                    output(lang[LANG_GRAB_ABORTED]);
                    return 2;
                }
                if (mdm_kbhit() && mdm_getch() == 3)
                {
                    /* Abort */
                    output(lang[LANG_GRAB_ABORTED]);
                    return 2;
                }
                memset(str,8,back); str[back] = '\0';
                output("%s%u", str, area_msgs);
                sprintf(str,"%lu", area_msgs);
                back = strlen(str);
            }
            if (stricmp(msg_to, usrsub.name) == 0) area_personal++;

            memset(&ndx, 0, sizeof(ndx));
            ndx.conf = (unsigned char) current_marea;
            ndx.pos = long2basicreal(FileSeek(Fdat, 0, SEEK_CUR)/128+1);
            if (FileWrite(Fndx, &ndx, sizeof(ndx)) != sizeof(ndx))
            {
                output(lang[LANG_OUT_OF_DISKSPACE]);
                write_log("(1) Out of disk space");
                return 0;
            }

            memset(&qwk, 32, sizeof(qwk));
            /* Flags */
            if (msg_flags & MSG_FLAG_PRIVATE) qwk.flag = '*';
            /* Msg number */
            sprintf(str,"%lu", msg_msgnum); memcpy(qwk.num, str, strlen(str));
            /* Date/time */
            tim = localtime((time_t *) &msg_date);
            sprintf(str,"%02d-%02d-%02d", tim->tm_mon, tim->tm_mday, tim->tm_year%100); memcpy(qwk.date, str, strlen(str));
            sprintf(str,"%02d:%02d", tim->tm_hour, tim->tm_min); memcpy(qwk.time, str, strlen(str));
            /* To */
            strupr(strcpy(str, msg_to));
            slen = strlen(str); if (slen > 25) slen = 25;
            memcpy(qwk.mto, str, strlen(str));
            /* From */
            strupr(strcpy(str, msg_from));
            slen = strlen(str); if (slen > 25) slen = 25;
            memcpy(qwk.mfrom, str, strlen(str));
            /* Subject */
            strupr(strcpy(str, msg_subj));
            slen = strlen(str); if (slen > 25) slen = 25;
            memcpy(qwk.subj, str, strlen(str));
            /* Reply to */
            sprintf(str,"%lu", msg_replyto); memcpy(qwk.reply, str, strlen(str));
            /* Message text blocks */
            qwk.blocks[0] = '1';
            /* Active */
            qwk.active = 225;
            /* Conference */
            qwk.conf = (unsigned char) marea.number;
            /* Logical msg number */
            qwk.lognum = (unsigned short) area_msgs;

            oldFpos = FileSeek(Fdat, 0, SEEK_CUR);
            /* Write QWK header to file */
            if (FileWrite(Fdat, &qwk, sizeof(qwk)) != sizeof(qwk))
            {
                output(lang[LANG_OUT_OF_DISKSPACE]);
                write_log("(2) Out of disk space");
                return 0;
            }

            /* Write message text to file */
            if (msg_init_msgtext() == 0)
            {
                area_msgs++;
                break;
            }

            str[0] = 227;
            totalsize = 0;
            for (num=1; num<=msg_txtlines; num++)
            {
                txt = msg_read_textline(num); slen = strlen(txt);
                if (slen > 0 && FileWrite(Fdat, txt, slen) != slen)
                {
                    output(lang[LANG_OUT_OF_DISKSPACE]);
                    return 0;
                }
                if (FileWrite(Fdat, &str[0], 1) != 1)
                {
                    output(lang[LANG_OUT_OF_DISKSPACE]);
                    write_log("(3) Out of disk space");
                    return 0;
                }
                totalsize += slen+1;
            }
            msg_deinit_msgtext();

            /* Pad text always to 128 chars */
            blocks = 1 + (totalsize/128);
            if (totalsize & 127)
            {
                blocks++;
                memset(str, 32, 128);
                if (FileWrite(Fdat, str, (int) (128 - (totalsize & 127))) == 0)
                {
                    output(lang[LANG_OUT_OF_DISKSPACE]);
                    write_log("(4) Out of disk space");
                    return 0;
                }
            }

            /* Update qwk.blocks.. */
            sprintf(str, "%lu", blocks); memcpy(qwk.blocks, str, strlen(str));
            FileSeek(Fdat, oldFpos, SEEK_SET);
            if (FileWrite(Fdat, &qwk, sizeof(qwk)) != sizeof(qwk))
            {
                output(lang[LANG_OUT_OF_DISKSPACE]);
                write_log("(5) Out of disk space");
                return 0;
            }
            FileSeek(Fdat, 0, SEEK_END);

            area_msgs++;
    }
    return 1;
}

void close_grabpacket(int format)
{
    char str[256];
    unsigned rec;
    time_t _tim;
    struct tm *tim;

    switch (format)
    {
        case FORMAT_BW:
            if (old_area > 0)
            {
                total_msgs += mix.totmsgs;
                total_personal += mix.numpers;

                memset(str, 8, back); str[back] = '\0';
                outtext(str);
                output(lang[LANG_GRABAREA_MSGS], mix.totmsgs);
                if (mix.numpers > 0) output(lang[LANG_GRABAREA_PERSONAL], mix.numpers);

                /* Write .mix record */
                if (FileWrite(Fmix, &mix, sizeof(mix)) == 0)
                    output(lang[LANG_OUT_OF_DISKSPACE]);
            }

            FileClose(Fmix);
            FileClose(Ffti);
            FileClose(Fdat);
            break;
        case FORMAT_QWK:
            if (old_area > 0)
            {
                total_msgs += area_msgs;
                total_personal += area_personal;

                memset(str, 8, back); str[back] = '\0';
                outtext(str);
                output(lang[LANG_GRABAREA_MSGS], area_msgs);
                if (area_personal > 0) output(lang[LANG_GRABAREA_PERSONAL], area_personal);
            }

            /* Close messages.dat and *.ndx files */
            FileClose(Fdat);
            FileClose(Fndx);

            /* Create control.dat file */
            _tim = time(NULL);
            tim = localtime(&_tim);

            sprintf(str, "%s"SSLASH"control.dat", hold_farea.path);
            Fdat = FileCreate(str, CREATE_MODE);
            if (Fdat == -1)
            {
                write_log("Could not create file '%s'", str);
                output("Could not create control.dat! QWK packets won't work without it!\r\n");
                return;
            }
            FileMode(Fdat, O_BINARY);
            FileWrite(Fdat, str, sprintf(str, "%s\r\n", bbs_name));
            FileWrite(Fdat, str, sprintf(str, "%s\r\n", bbs_location));
            FileWrite(Fdat, str, sprintf(str, "%s\r\n", bbs_phone));
            FileWrite(Fdat, str, sprintf(str, "%s, sysop\r\n", first_sysop_name));
            FileWrite(Fdat, str, sprintf(str, "0,%s\r\n", msg_packet_id));
            FileWrite(Fdat, str, sprintf(str, "%02d-%02d-%d,%02d:%02d:%02d\r\n",
                    tim->tm_mon, tim->tm_mday, tim->tm_year,
                    tim->tm_hour, tim->tm_min, tim->tm_sec));
            strcat(strupr(strcpy(str,usrsub.name)),"\r\n");
            FileWrite(Fdat, str, strlen(str));
            FileWrite(Fdat, str, sprintf(str, "\r\n"));
            FileWrite(Fdat, str, sprintf(str, "0\r\n"));
            FileWrite(Fdat, str, sprintf(str, "%lu\r\n", total_msgs));
            FileWrite(Fdat, str, sprintf(str, "%u\r\n", msg_areas-1));
            for (rec=1; rec<=msg_areas; rec++)
            {
                read_marea_record(rec);
                if ((marea.flags & MAREA_FLAG_READ_RIGHTS) == 0) continue;

                FileWrite(Fdat, str, sprintf(str, "%lu\r\n", marea.number));
                if (marea.description[0] != '\0')
                    sprintf(str,"%s, %s\r\n", marea.name, marea.description);
                else
                    strcat(strcpy(str,marea.name), "\r\n");
                FileWrite(Fdat, str, strlen(str));
            }
            FileClose(Fdat);
            break;
    }
}

static char pktname[256];
static int thread_finished;
static int ThreadID;

static int gp_format;
static PACKER_REC *packer;

void grab_packet_thread(void *ptrs)
{
    char pub,pvt,str[MAX_PATH_LEN],path[256],*strp;
    unsigned long msgarea,mnum;
    int format,cancelled;

    DIR *dirp;
    struct dirent *direntp;

    time_t _tim;
    struct tm *tim;

    format = gp_format;

    if (ptrs == NULL)
    {
        /* Redirect input */
        /*remove("input.tmp");
        freopen("input.tmp","r",stdin);*/
    }

    cancelled = 0;
    for (msgarea=1; msgarea<=msg_areas; msgarea++)
    {
        if (read_marea_record(msgarea) == 0) continue;
        memcpy(&msg_area, &marea, sizeof(msg_area));
        if ((marea.flags & MAREA_FLAG_READ_RIGHTS) == 0) continue;

        if (marea.flags & MAREA_FLAG_SELECTED)
        {
            /* Selected message area found */
            pub = (marea.flags & MAREA_FLAG_PUBLIC_MSGS) > 0;
            pvt = (marea.flags & MAREA_FLAG_PRIVATE_MSGS) > 0;

            /* Check if this area has unread messages */
            if (msgarea_stat(marea.path,TYPE_JAM) == 0) continue;
            if (marea_stat.unread_msgs == 0) continue;
            if (!carr_det()) break;

            /* Open message base */
            if (open_msgarea(marea.path,TYPE_JAM) == 0) continue;

            for (mnum=marea.lr_ptr+1; mnum<=msg_messages; mnum++)
            {
                if (msg_read_message(mnum) == 0) continue;

                if ((pub && !pvt) || /* Public message area */
                    (pvt && pub && ((msg_flags & MSG_FLAG_PRIVATE) == 0)) || /* Public message */
                    (stricmp(msg_to,usrsub.name) == 0) || /* User is receiver */
                    (stricmp(msg_from,usrsub.name) == 0)) /* User is sender */
                {
                    switch (grab_message(format))
                    {
                        case 0:
                            /* Out of disk space! */
                            update_pointers(mnum);
                            goto __out;
                        case 2:
                            /* No carrier! */
                            restore_pointers((unsigned long *) ptrs);
                            cancelled = 1;
                            goto __out;
                    }
                    /* If it was personal, set on "received" flag */
                    if (stricmp(msg_to,usrsub.name))
                    {
                        msg_flags |= MSG_FLAG_RECEIVED;
                        msg_update_message(mnum);
                    }
                }
            }

            update_pointers(mnum-1);
        }
    }
__out:

    close_grabpacket(format);

    _tim = time(NULL);
    tim = localtime(&_tim);

    if (carr_det() && !cancelled)
    {
        num1 = total_msgs; num2 = total_personal;
        output(lang[LANG_PACKING_MSGS]);

        switch (format)
        {
            case FORMAT_BW:
                sprintf(str, " %s.%s%d %s.inf %s.mix %s.fti %s.dat",
                        msg_packet_id, week_day[tim->tm_wday], user.TodayMsgPkts,
                        msg_packet_id, msg_packet_id, msg_packet_id, msg_packet_id);
                break;
            case FORMAT_QWK:
                sprintf(str, " %s.qwk messages.dat control.dat *.ndx", msg_packet_id);
                break;
        }

        sprintf(path, packer->pack, str);

        printf("Command line: %s\n", path);
        write_log("Packing messages with command line: %s", path);

        getcwd(str, sizeof(str));
        change_dir(hold_farea.path);
#ifdef __linux__
        tty_old();
#endif
        if (system(path) != 0)
        {
#ifdef __linux__
            tty_raw();
#endif
            output(lang[LANG_PACKING_ERROR]);
            restore_pointers((unsigned long *) ptrs);
            cancelled = 1;
        }
#ifdef __linux__
        else
            tty_raw();
#endif
        change_dir(str);
    }
    fflush(stdout);

    /* Redirect input and output back */

    if (ptrs == NULL)
    {
        /*freopen(DEV_IN,"r",stdin); setbuf(stdin,NULL);
        freopen(DEV_OUT,"w",stdout); setbuf(stdout,NULL);*/
    }

    remove("output.tmp");
    switch (format)
    {
        case FORMAT_BW:
            sprintf(str, "%s"SSLASH"%s.inf", hold_farea.path, msg_packet_id); remove(str);
            sprintf(str, "%s"SSLASH"%s.mix", hold_farea.path, msg_packet_id); remove(str);
            sprintf(str, "%s"SSLASH"%s.fti", hold_farea.path, msg_packet_id); remove(str);
            sprintf(str, "%s"SSLASH"%s.dat", hold_farea.path, msg_packet_id); remove(str);
            sprintf(str,"%s"SSLASH"%s.%s%d", hold_farea.path, msg_packet_id,
                    week_day[tim->tm_wday], user.TodayMsgPkts);
            break;
        case FORMAT_QWK:
            sprintf(str, "%s"SSLASH"control.dat", hold_farea.path); remove(str);
            sprintf(str, "%s"SSLASH"messages.dat", hold_farea.path); remove(str);

            /* Remove *.ndx files */
            dirp = opendir(hold_farea.path);
            if (dirp == NULL)
            {
                /* Error opening directory.. */
                write_log("Couldn't open directory '%s'", hold_farea.path);
            }
            else
            {
                for (;;)
                {
                    direntp = readdir(dirp);
                    if (direntp == NULL) break;

                    strp = strrchr(direntp->d_name,'.');
                    if (strp != NULL && strcmp(strp+1,"ndx") == 0)
                    {
                        /* .ndx file found! kill! kill! kill! */
                        sprintf(str, "%s"SSLASH"%s", hold_farea.path, direntp->d_name);
                        remove(str);
                    }
                }
                closedir(dirp);
            }

            sprintf(str,"%s"SSLASH"%s.qwk", hold_farea.path, msg_packet_id);
            break;
    }

    pktname[0] = '\0';
    if (carr_det() && !cancelled && (thread_finished == 0 || thread_finished == 2))
    {
        /* Flag message packet */
        strcpy(pktname,str);

        if (thread_finished == 2)
        {
            add_flag(NULL,str,"Your message packet",0);
            output("\r\nMessage packet is ready.\r\n");
        }
        else
        {
            thread_finished = 1;
        }
    }

    end_thread(ThreadID);
}

void grab_packet(int format)
{
    FILE *Ftxt;
    unsigned long *ptrs;
    char str[256],*strp,val;

    /* Get user packer */
    val = 0;
    while (val < 2)
    {
        val++;
        packer = firstpacker;
        while (packer != NULL)
        {
            if (toupper(user.Packer) == toupper(packer->key))
            {
                break;
            }
            packer = packer->next;
        }
        if (packer == NULL && val == 1) edit_setup("packer");
    }
    if (packer == NULL) return;

    if (init_grabpacket(format) == 0) return;

    gp_format = format;

    ptrs = (unsigned long *) _malloc(msg_areas*sizeof(unsigned long));
    if (ptrs == NULL)
    {
        output("\r\nNot enough memory to save lastread pointers!\r\n");
        return;
    }

    save_pointers(ptrs,0);
    output(lang[LANG_BEGIN_GRABBING]);

    /* Redirect output */
    sprintf(str, "%s"SSLASH"output.tmp", hold_farea.path);
    /*freopen(str, "w", stdout); setbuf(stdout,NULL);*/
    Ftxt = fopen(str, "rb");

    current_lastrec.done_flags |= DONE_MSGPKT;
    thread_finished = 0;
#if 0
    if (begin_thread(&grab_packet_thread, "Grabbing messages", NO_MESSAGES, 16384, &ThreadID) == 0)
    {
#endif
        fclose(Ftxt);
        /*freopen(DEV_OUT,"w",stdout);
        remove("output.tmp");*/

        //output("Sorry, couldn't create grab thread!\r\n");
        grab_packet_thread(ptrs);
        if (thread_finished == 1 && pktname[0] != '\0')
        {
            /* Download message packet */
            add_flag(NULL, pktname, "Your message packet", 0);

            strp = strrchr(pktname,SLASH);
            if (strp == NULL) strp = pktname; else strp++;

            /* Download packet */
            sprintf(str,"/tmp/%s",strp);
            if (!download_files(str))
            {
                /* Download failed, restore pointers */
                output(lang[LANG_RESTORING_PTRS]);
                restore_pointers(ptrs);
            }
            user.MsgsRead += total_msgs;
            if (user.TodayMsgPkts >= 9) user.TodayMsgPkts = 0; else user.TodayMsgPkts++;

            remove(pktname);
            delete_file(str);
        }
#if 0
    }
    /* This thread doesn't work quite yet..... */
    else
    {
        do
        {
            if (!carr_det())
            {
                /* No carrier */
                thread_finished = 3;

                /* Send some break-characters */
                sprintf(str, "%s"SSLASH"input.tmp", hold_farea.path);
                F = fopen(str, "a+b");
                fprintf(F,"\x03\x03\x03\x03\x03\x03\x03");
                fclose(F);

                remove_thread(ThreadID);
                remove(str);
                break;
            }

            if (kbhit_nowait() || mdm_kbhit())
            {
                /* Read keyboard */
                ch = mdm_kbhit() ? mdm_getch() : getch();
                switch (ch)
                {
                    case 0:
                        getch();
                        break;
                    case 3:
                        /* Ctrl-C */
                        thread_finished = 3;

                        /* Send some break-characters */
                        sprintf(str, "%s"SSLASH"input.tmp", hold_farea.path);
                        F = fopen(str, "a+b");
                        fprintf(F,"\x03\x03\x03\x03\x03\x03\x03");
                        fclose(F);

                        remove_thread(ThreadID);
                        remove(str);
                        break;
                    case 'B':
                    case 'b':
                        thread_finished = 2;
                        break;
                }
            }

            if (Ftxt != NULL)
            {
                do
                {
                    readed = fread(str,1,sizeof(str)-1,Ftxt);
                    if (readed > 0)
                    {
                        /* Write packer output to screen */
                        str[readed] = '\0';
                        outtext(str);
                    }
                } while (readed == sizeof(str));
            }
            give_timeslice();
        } while (!thread_finished);

        if (thread_finished == 1)
        {
            /* Flush Ftxt */
            do
            {
                readed = fread(str,1,sizeof(str)-1,Ftxt);
                if (readed > 0)
                {
                    /* Write packer output to screen */
                    str[readed] = '\0';
                    outtext(str);
                }
            } while (readed > 0);

            add_flag(NULL,pktname,"Your message packet",0);

            strp = strrchr(pktname,SLASH);
            if (strp == NULL) strp = pktname;

            /* Download packet */
            sprintf(str,"/tmp/%s",strp);
            if (!download_files(str))
            {
                /* Download failed, restore pointers */
                output("\r\nRestoring lastread pointers..\r\n");
                restore_pointers(ptrs);
            }
            user.MsgsRead += total_msgs;
            if (user.TodayMsgPkts >= 9) user.TodayMsgPkts = 0; else user.TodayMsgPkts++;

            remove(pktname);
            delete_file(str);
        }
        else if (thread_finished == 2)
        {
            output("\r\nMessage packet will appear in hold directory as soon as it is packed.");
        }
        else if (thread_finished == 3)
        {
            output("\r\nAborted, restoring lastread pointers..\r\n");
            restore_pointers(ptrs);
        }
        fclose(Ftxt);
        remove("output.tmp");
    }
#endif

    _free(ptrs);

    /* Make sure pointers are saved */
    if (write_user() == 0)
    {
        write_log("grab_packet() : Error writing user files!");
        output("\r\nError writing user files!\r\n");
    }
}

int grab_messages(char *data)
{
    unsigned long old_area;

    if (restrict_usage & NO_MESSAGES)
    {
        output("\r\nThread #%d restricts usage of message commands!\r\n",restrictive_thread(NO_MESSAGES));
        return 0;
    }

    old_area = current_marea;

    /* Update node file */
    noderec.doing = DOING_GRABBING;
    update_nodefile(0);

    if (stricmp(data,"BW") == 0) grab_packet(FORMAT_BW);
    else if (stricmp(data,"QWK") == 0) grab_packet(FORMAT_QWK);
    /*else if (stricmp(data,"OMEN") == 0) grab_packet(FORMAT_OMEN);
    else if (stricmp(data,"HIPPO") == 0) grab_packet(FORMAT_HIPPO);*/
    else
    {
        output("\r\nUnknown grab format '%s'\r\n",data);
        return 0;
    }
    read_marea_record(old_area);
    memcpy(&msg_area, &marea, sizeof(msg_area));
    open_msgarea(marea.path, TYPE_JAM);

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    return 1;
}
