/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __FILELIST_H
#define __FILELIST_H

typedef struct
{
    char *name;
    char date[9];
    unsigned long size;
    unsigned short downs;
}
FILELIST_REC;

typedef struct FLAG_REC
{
    struct FLAG_REC *next;

    unsigned farea;
    char *link;
    char *fname;
#ifdef __WATCOMC__
    char origname[];
#else
    char origname[0];
#endif
}
FLAG_REC;

extern FILELIST_REC frec;
extern int npos,positions[100];
extern char pos_fnames[100][81];

extern FLAG_REC *first_flag;
extern FLAG_REC *last_flag;
extern FLAG_REC *flagrec;

int list_files(char *parms);    /* List files in current area */

int file_flagged(char *fname);  /* Is file flagged? */
FLAG_REC *flagged_record(char *link);

int add_flag(char *fname, char *linkname, char *desc, unsigned farea); /* Add file to flagged files */
int flag_file(char *fname, int Fbbs); /* Flag file in current file area */
void deinit_flags(void);

int check_more(int *lines, int Fbbs, int forced); /* More (Yes/No/Flag)-prompt */

int delete_file(char *fname);   /* Delete file */
int rename_file(char *parms);   /* Rename file */

int add_dl_counter(char *fname);/* Increase file download counter */

int compare_filenames(char *fname, char *wildcard);

int disp_desc(char **desc, char *maxp, int *lines, int Fdes);
int print_file(char *fname, char *data, int *lines, int Fdes, char **desc_out);

int get_filemail(void);

#endif
