/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* bbs_func.c - read configuration and process menu files */

/* Todo : rewrite execute_menu() */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifdef __linux__
#  include <signal.h>
#endif

#include "os.h"
#include "memory.h"
#include "files.h"
#include "ask_str.h"
#include "userbase.h"
#include "modem.h"
#include "nodes.h"
#include "fsearch.h"
#include "new_user.h"
#include "threads.h"
#include "crc32.h"
#include "fareas.h"
#include "logfile.h"
#include "mareas.h"
#include "messages.h"
#include "showfile.h"
#include "menutype.h"
#include "lastcall.h"
#include "output.h"
#include "timeslic.h"
#include "config.h"
#include "keyb.h"
#include "filelist.h"
#include "language.h"

char tmp1_str[256];
char tmp2_str[256];

unsigned long num1, num2, num3, num4, num5;

unsigned long bpsrate;
unsigned nodenum;
int comport;

char menuname[256];
char parms[256];

int run_auto;
int quit;
int logging;

int dosemu_pid = -1; /* DOS-emu process ID */

int execute_menu(char *fname, char included); /* Run menu */

/* Accepts only Y (ret=1) or N (ret=0) as answer */
int yes_no(char *text, int def, char **data)
{
    char ch, tmp[256];

    if (data != NULL && *data != NULL && **data != '\0' && **data != ';')
    {
        /* Take answer from parameters */
        take_data_param(tmp, *data);
        if (*data == '\0' && *data != parms) *data = parms;
        if (tmp[0] == '\n')
        {
            /* ',' in command line, return default.. */
            return def;
        }
        else if (toupper(tmp[0]) == 'Y') return 1; /* Y pressed */
        else if (toupper(tmp[0]) == 'N') return 0; /* N pressed */
    }

    output(text);
    for (;;)
    {
        /* Wait for key.. */
        for (;;)
        {
            if (!carr_det()) return 0;

            if (kbhit())
            {
                ch = (char) toupper(getch());
                break;
            }
            if (mdm_kbhit())
            {
                ch = (char) toupper(mdm_getch());
                break;
            }
            give_timeslice();
        }

        if (ch == 13) return def; /* Enter pressed */
        if (ch == 'Y') return 1; /* Y pressed */
        if (ch == 'N') return 0; /* N pressed */
    }
}

int up_func(int chr)
{
    switch (chr)
    {
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        default:
            return toupper(chr);
    }
}

int lo_func(int chr)
{
    switch (chr)
    {
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        case '':
            return '';
        default:
            return tolower(chr);
    }
}

void close_stuff(void)
{
    char str[100];

    noderec.doing = DOING_DOWN;
    update_nodefile(0);

    /* Send logoff node text */
    sprintf(str, "\x01@X0FPoistuminen: %s (%d).", usrsub.name, nodenum);
    send_nodetext(str, 0);

    /* Close userbase */
    close_userbase();
    close_filebase();
    close_nodefile();
    deinit_fareas();
    deinit_mareas();
    close_node_messages();
    deinit_flags();
    close_language();

    if (ptrs_this_call != NULL) _free(ptrs_this_call);
}

int read_everything(void)
{
    char tmp[256];

    /* Read user groups */
    load_charset(user.CharSet);
    read_groups();
    if (in_group("sysop")) time_left = 3600;

    /* Read file areas */
    if (init_fareas(0) == 0)
    {
        write_log("Could not read file areas");
        output("\r\nFATAL: Could not read file areas!\r\n");
        close_stuff();
        return 1;
    }

    /* Read message areas */
    if (init_mareas() == 0)
    {
        write_log("Could not read message areas");
        output("\r\nFATAL: Could not read message areas!\r\n");
        close_stuff();
        return 1;
    }
    read_lastread();

    sprintf(tmp, "%s"SSLASH"%s", data_path, filebase_name);
    if (!open_filebase(tmp))
    {
        write_log("Could not open filebase indexes");
        printf("\nWARNING: Could not open filebase indexes.\n");
    }
    return 0;
}

/* Ask user name, returns 0 = no carrier, 1 = ok, 2 = read from concord base,
   3 = new user */
int ask_user_name(char *username, char *name, char *password)
{
    int get_ptrs;
    char lastname[36], *strp, *strp2, last;

    get_ptrs = 0;
    lastname[0] = '\0'; password[0] = '\0';

    for (;;)
    {
        if (!carr_det()) return 0;

        if (lastname[0] != '\0')
            write_log("Name wrote: %s", lastname);

        if (username[0] == '\0')
        {
            usrsub.name[0] = '\0';
            if (!ask_string(lang[LANG_ASK_REAL_NAME], usrsub.name, sizeof(usrsub.name)-1, 0, NULL)) return 0;
        }
        else
        {
            strcpy(usrsub.name, username);
            username[0] = '\0';
        }
        strcpy(lastname,usrsub.name);

        /* Remove spaces from end */
        strp = usrsub.name;
        while (*strp != '\0') strp++;
        strp--;
        while (strp > usrsub.name && *strp == ' ') strp--;
        *(++strp) = '\0';

        /* Remove spaces from start */
        strp = usrsub.name;
        while (*strp == ' ') strp++;

        /* Don't accept one word names */
        if (strchr(strp, ' ') == NULL) continue;

        /* Don't accept too short names */
        if (strlen(strp) <= 6) continue;

        /* Don't accept names starting with ... */
        if (strnicmp(strp, "AT ", 3) == 0) continue;
        if (strnicmp(strp, "ATD", 3) == 0) continue;
        if (strnicmp(strp, "ATZ", 3) == 0) continue;
        if (strnicmp(strp, "I AM ", 5) == 0) continue;
        if (strnicmp(strp, "NEW ", 4) == 0) continue;
        if (strnicmp(strp, "UUSI ", 5) == 0) continue;

        /* Capitalise name */
        strp2 = name;
        last = ' ';
        while (*strp != '\0')
        {
            if (last == ' ')
            {
                if (*strp == ' ')
                {
                    strp++;
                    continue;
                }
                *strp2 = (char) up_func(*strp);
            }
            else
            {
                *strp2 = (char) lo_func(*strp);
            }
            last = *(strp++);
            strp2++;
        }
        *strp2 = '\0';

        user_num = scan_user(name);
        if (user_num == 0)
        {
            /* Check if user put password after its name.. */
            strp = strrchr(name, ';');
            if (strp != NULL)
            {
                /* ';' found, password is after it */
                strp2 = strp;
                while (*(strp2-1) == ' ') strp2--; *strp2 = '\0';
                *strp++ = '\0';
                user_num = scan_user(name);
                if (user_num != 0)
                {
                    while (*strp == ' ') strp++;
                    strcpy(password, strp);
                }
            }
            else
            {
                /* Check if it was separated with space.. */
                strp = strrchr(name, ' ');
                if (strp != NULL)
                {
                    *strp++ = '\0';
                    user_num = scan_user(name);
                    if (user_num == 0)
                        *(strp-1) = ' '; /* I guess it wasn't */
                    else
                    {
                        while (*strp == ' ') strp++;
                        strcpy(password, strp);
                    }
                }
            }
        }

        if (user_num == 0 && concord_base[0] != '\0')
        {
            /* User not found, check if it's in Concord's userbase */
            output(lang[LANG_GET_CONCORD_BASE]);
            user_num = scan_concord_user(name);
            if (user_num != 0)
            {
                /* Found, need to read lastread pointers. */
                output(lang[LANG_CONCORD_FOUND]);
                return 2;
            }
        }

        if (user_num != 0)
        {
            /* User was found from userbase */
            return 1;
        }

        /* Still not found, new user? */
        if (concord_base[0] != '\0')
            output(lang[LANG_CONCORD_NOT_FOUND]);

        if (yes_no(lang[LANG_NEW_USER], 0, NULL) == 1) return 3;
    }
}

/* Returns 0 = no carrier, 1 = ok, 2 = failed */
int ask_password(char *password)
{
    int tries;

    tries = 0;
    while (password[0] == '\0' || stricmp(password, usrsub.password) != 0)
    {
        if (tries > 0 && password[0] != '\0')
        {
            write_log("Wrong password: '%s'", password);
            if (tries == 5) return 2;
            output(lang[LANG_WRONG_PASSWORD]);
        }

        password[0] = '\0';
        if (!ask_string(lang[LANG_ENTER_PASSWORD], password, 20, '.', NULL)) return 0;

        tries++;
    }

    return 1;
}

int goto_bbs(char *username)
{
    char get_ptrs, str[256], name[36], password[21];
    int ret, newuser;

    int detx, dety, detemu;
    char detemuname[20];

    parms[0] = '\0';
    logging = 1;

    sprintf(name,"%snodemsg.%d",common_path,nodenum);
    remove(name);

    /* Read language file */
    if (read_language(firstlang->fname) == 0)
    {
        write_log("Could not read english language file");
        output("\r\nFATAL: Could not read english language file!\r\n");
        sleep(3);
        return 1;
    }
    memcpy(&user_lang, firstlang, sizeof(user_lang));

    /* Open node file */
    if (open_nodefile() == 0)
    {
        write_log("Could not open/create node file");
        output("\r\nFATAL: Could not open/create node file!\r\n");
        sleep(3); modem_setdtr(0);
        close_language();
        return 1;
    }

    /* Update node file */
    noderec.doing = DOING_LOGGING_IN;
    noderec.login = time(NULL);
    update_nodefile(0);

    /* Open userbase */
    if (open_userbase("userbase") == 0)
    {
        write_log("Could not create userbase files");
        printf("FATAL: Could not create userbase files!\n");
        close_nodefile(); close_language();
        return 1;
    }

    memset(&user,0,sizeof(user));
    memset(&usrsub, 0, sizeof(usrsub));

    detx = dety = 0; detemu = USER_EMULATION_ASCII;
    if (hCom == 0)
    {
        /* Local */
        user.Emulation = USER_EMULATION_ANSI_X364;
        user.ScreenLen = 25;
        user.ScreenWidth = 80;
    }
    else
    {
        /*
         esc[c - if it responds esc[?<n>;<n>c, ANSI X3.64 is detected
         escZ - same as above, but just in case..
         esc[255C, esc[255B - move cursor to lower right corner and ..
         esc[6n - request cursor position, if it responds with esc[yy;xxR,
                  screen length is detected and ANSI emulation is set
         esc[5n - Another ANSI X3.64 check .. should respond with esc[0n
        */
        user.ScreenLen = 24;
        user.ScreenWidth = 80;
        user.Emulation = USER_EMULATION_ASCII;
        mdm_strout("\x1b[s\x1b[255C\x1b[255B\x1b[6n\x1b[u\x1b[c\x1bZ\x1b[5n\r                              \r");

        while (wait_modem())
        {
            if (mdm_getch() == 0)
            {
                if (reqx >= 70) { detx = user.ScreenWidth = reqx; }
                if (reqy >= 10) { dety = user.ScreenLen = reqy; }
                mdm_getch();
            }
        }
        detemu = user.Emulation;
    }

    if (wherey > user.ScreenLen) wherex = user.ScreenLen;
    if (wherex > user.ScreenWidth) wherex = user.ScreenWidth;

    if (user.Emulation == USER_EMULATION_ASCII)
        strcpy(current_emulation, "ASCII");
    else if (user.Emulation == USER_EMULATION_ANSI)
        strcpy(current_emulation, "Dummy-ANSI");
    else if (user.Emulation == USER_EMULATION_ANSI_X364)
        strcpy(current_emulation, "ANSI X3.64");
    strcpy(detemuname, current_emulation);

    /* Display logo */
    show_file("logo.ans");

    dosemu_pid = -1;
    if (bpsrate < 2400 && bpsrate > 0 && nodenum != 3)
    {
        /* Kick slow users out */
        output(lang[LANG_TOO_LOW_BBS]);
        sleep(3); modem_setdtr(0);
        write_log("Forced logoff because of too slow modem.");
        close_language(); close_nodefile(); close_userbase();
        return 0;
    }

    /* Ask user name */
    get_ptrs = 0; newuser = 0;
    switch (ask_user_name(username, name, password))
    {
        case 0:
            close_userbase(); close_nodefile(); close_language();
            return 0;
        case 2:
            get_ptrs = 1;
            break;
        case 3:
            newuser = 1;
            break;
    }

    memset(&current_lastrec, 0, sizeof(current_lastrec));

    /* Update node file */
    noderec.doing = DOING_LOGGING_IN;
    update_nodefile(0);

    sprintf(str,"\x01@X0FSisntulo: %s (%d)", name, nodenum);
    send_nodetext(str,0);

    /* New user */
    if (newuser)
    {
        write_log("New user: %s", name);
        current_lastrec.done_flags |= DONE_NEW_USER;
        strcpy(usrsub.name, name);

        if (read_everything() != 0) return 1;

        user_num = ask_newu_questions();
        if (user_num == 0)
        {
            /* New user questions failed (no carrier etc.) */
            close_stuff();
            return 0;
        }
    }
    else
    {
        if (read_user(user_num, 0) == 0)
        {
            write_log("Error reading userbase");
            output("\r\nFATAL: Error reading userbase!\r\n");
            close_stuff();
            return 1;
        }

        if (user.Attrib1 & USER_ATTRIB_DELETED)
        {
            /* Deleted, cya. */
            write_log("Deleted user tried to log in.");
            output(lang[LANG_DELETED_USER_LOGIN]);
            close_stuff();
            return 0;
        }

        if (in_group("trashcan"))
        {
            /* In trashcan, cya. */
            write_log("Trashcan user tried to log in.");
            output(lang[LANG_TRASHCAN_USER_LOGIN]);
            close_stuff();
            return 0;
        }

        write_log("User logged in: %s",name);

        /* Ask password */
        switch (ask_password(password))
        {
            case 2:
                /* Password failure */
                if (yes_no(lang[LANG_ALL_PASSWORDS_WRONG], 1, NULL) == 1)
                {
                    if (init_mareas() == 0)
                    {
                        write_log("Could not read message areas");
                        output("\r\nFATAL: Could not read message areas!\r\n");
                        close_stuff();
                        return 1;
                    }
                    if (init_fareas(0) == 0)
                    {
                        write_log("Could not read file areas");
                        output("\r\nFATAL: Could not read file areas!\r\n");
                        close_stuff();
                        return 1;
                    }

                    read_marea_record(1); memcpy(&msg_area,&marea,sizeof(msg_area));
                    open_msgarea(marea.path,TYPE_JAM);
                    sprintf(str, "\"%s\" \"Password failure\"", sysop_name);
                    enter_message(0, 0, str);
                    write_log("All passwords wrong, hanging up");
                    close_stuff();
                    return 0;
                }
            case 0:
                /* No carrier */
                close_nodefile(); close_userbase(); close_language();
                return 0;
        }

        if (read_everything() != 0) return 1;

        if (detx != 0 && detx != user.ScreenWidth)
        {
            sprintf(str, lang[LANG_CHANGE_WIDTH], detx, detx);
            if (yes_no(str, 1, NULL)) user.ScreenWidth = detx;
        }
        if (dety != 0 && dety != user.ScreenLen)
        {
            sprintf(str, lang[LANG_CHANGE_LENGTH], dety, dety);
            if (yes_no(str, 1, NULL)) user.ScreenLen = dety;
        }
        if (detemu != user.Emulation && detemu != USER_EMULATION_ASCII)
        {
            sprintf(str, lang[LANG_CHANGE_EMULATION], detemuname, detemuname);
            if (yes_no(str, 1, NULL)) user.Emulation = detemu;
        }
    }
    current_lastrec.node = (unsigned short) nodenum;
    strcpy(current_lastrec.name, usrsub.name);
    strcpy(current_lastrec.alias, usrsub.alias);
    strcpy(current_lastrec.city, usrsub.city);
    current_lastrec.bpsrate = bpsrate;
    current_lastrec.login = noderec.login;

    if (nodenum == 3 && !in_group("node2"))
    {
        output("\r\nYou don't have rights to call this node - use node #1 (176242) instead.\r\n");
        write_log("User had no rights to call this node.");
        sleep(3);
        close_stuff();
        return 0;
    }

    init_timer();
    user.TotalCalls++;
    user.TodayCalls++;
    checked_newfiles = 0;

    /* Save lastread pointers */
    ptrs_this_call = (unsigned long *) _malloc(msg_areas*sizeof(unsigned long));
    if (get_ptrs)
    {
        output(lang[LANG_READING_LASTREAD]);
        update_jam_lastread(lo_crc32(name),0);
    }

    output("@CLR@");

    select_farea("/");
    read_marea_record(1); memcpy(&msg_area,&marea,sizeof(msg_area));
    open_msgarea(marea.path,TYPE_JAM);

    last_callers();

    if (get_filemail())
    {
        /* Filemail found */
        output(lang[LANG_FILEMAIL_FOUND]);
        strcpy(str, "/tmp");
        list_files(str);
    }

    /* Read personal messages */
    show_mareas_status();
    //read_personal_msgs();

    /* New files search! */
    strcpy(str, ",");
    newfiles_search(str);

    /* Save user lastread pointers */
    save_pointers(ptrs_this_call,0);

    /* Display news */
    show_file("news.ans");

    output(lang[LANG_HAVE_A_NICE_DAY]);

    /* Update node file */
    noderec.doing = DOING_NOTHING;
    update_nodefile(0);

    /* Execute TOP menu */
    strcpy(menuname, user_lang.mainmenu);
    run_auto = 1;
    do
    {
        ret = execute_menu(menuname,0);
        if (ret == 0)
        {
            if (strcmp(menuname, user_lang.mainmenu) == 0)
            {
                /* First menu not found! */
                output("FATAL: Can't read main menu!\r\n");
                write_log("Can't read main menu file");
                break;
            }
            strcpy(menuname, user_lang.mainmenu);
        }
    } while (ret != 1);

    if (checked_newfiles != 0) user.LastFileChk = checked_newfiles;

    /* Write user info */
    if (write_user() == 0)
    {
        write_log("Error writing user to userbase");
        output("\r\nError writing user to userbase!\r\n");
    }

    modem_setdtr(0);
    /*printf("\r\nUpdating JAM lastread pointers..\r\n");
    update_rbbs_lastread(lo_crc32(usrsub.name));*/

    /* Write user to last callers list */
    if (!real_carrier) current_lastrec.done_flags |= DONE_CARRIER_LOST;
    current_lastrec.logoff = time(NULL);
    write_lastcaller();

    close_stuff();
    write_log("Logoff");

#ifdef __linux__
    if (dosemu_pid != -1) kill(dosemu_pid,SIGKILL);
#endif

    return 0;
}

static char str[512],data[256],key[256],menutype[256],type[11];

typedef char define_type[41];
#define MAX_DEFINES 512
#define MAX_IFDEFS 32

static define_type *def_buf;
static int defines;

static char ifdef_buf[MAX_IFDEFS];
static int ifdefs,found;

static int executing_autos;

int execute_menu(char *filename, char included)
{
    int Fmenu;
    char *strp,fname[256];
    int slen,chr,num,fields_got,line,ifdef;
    unsigned mtype;

    sprintf(fname, "%s%s", user_lang.menupath, filename);

    if (!included)
    {
        def_buf = (define_type *) _malloc(sizeof(define_type)*MAX_DEFINES); /* Allocate memory for defines */
        defines = 0;

        if (answer[0] == '\0')
        {
            run_auto = 1;
            executing_autos = 1;
        }
        ifdefs = 0;
        quit = 0;
    }

    /* Open menu file */
    Fmenu = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    if (Fmenu == -1)
    {
        /* Not found */
        write_log("Menu file '%s' not found", fname);
        output("\r\nMenu file '%s' not found\n", filename);
        return 0;
    }

    while (!quit)
    {
        if (!carr_det())
        {
            if (!included) _free(def_buf);
            return 1;
        }

        /* Execute menu file */
        FileSeek(Fmenu,0,SEEK_SET);
        line = 0;
        found = 0;

        if (!run_auto && !included)
        {
            strp = answer;
            while (*strp != '\0' && *strp != ' ' && *strp != ',' && *strp != ';') strp++;
            if (*strp == '\0')
            {
                parms[0] = '\0';
            }
            else
            {
                strcpy(parms, strp+(*strp != ';'));
                *strp = '\0';
            }
        }

        if (run_auto) executing_autos = 1;

        /* Read and process line */
        while (_fgets(str,sizeof(str),Fmenu) != NULL)
        {
            line++;
            
            /* Examine menu file line */
            data[0] = '\0'; key[0] = '\0'; menutype[0] = '\0';
            fields_got = sscanf(str,"%s %s %s %[^\n]",type,key,menutype,data);

            if ((fields_got >= 1) && (str[0] != ';')/* && ((answer[0] != '\0') || (run_auto))*/)
            {
                /* If defined .. */
                if ((stricmp(type,"IFDEF") == 0) || (stricmp(type,"IFNDEF") == 0))
                {
                    if (fields_got != 2)
                    {
                        write_log("Error in menu file '%s' line %d",fname,line);
                        printf("\r\nError in menu file '%s' line %d\n",fname,line);
                    }
                    else
                    {
                        if (stricmp(type,"IFDEF") == 0)
                        {
                            ifdef = 1;
                            ifdef_buf[ifdefs] = 0;
                        }
                        else
                        {
                            ifdef = 0;
                            ifdef_buf[ifdefs] = 1;
                        }

                        num = 0;
#ifdef __linux__
                        if (strcmp("LINUX",key) == 0)
#elif defined (__OS2__)
                        if (strcmp("OS2",key) == 0)
#elif defined (__DOS__)
                        if (strcmp("DOS",key) == 0)
#elif defined (__NT__)
                        if (strcmp("NT",key) == 0)
#else
#  error Unknown platform
#endif
                        {
                            /* Define found */
                            if (ifdef == 1)
                            {
                                ifdef_buf[ifdefs] = 1;
                            }
                            else
                            {
                                ifdef_buf[ifdefs] = 0;
                            }
                            num = defines;
                        }

                        for (; num<defines; num++)
                        {
                            strp = strchr(def_buf[num],' ');
                            if (strp != NULL) *strp = '\0';
                            if (strcmp(def_buf[num],key) == 0)
                            {
                                /* Define found */
                                if (ifdef == 1)
                                {
                                    ifdef_buf[ifdefs] = 1;
                                }
                                else
                                {
                                    ifdef_buf[ifdefs] = 0;
                                }
                                if (strp != NULL) *strp = ' ';
                                break;
                            }
                            if (strp != NULL) *strp = ' ';
                        }
                        ifdefs++;
                    }
                    continue;
                }
                
                /* Else .. */
                if (stricmp(type,"ELSE") == 0)
                {
                    ifdef_buf[ifdefs] = (char) (1-ifdef_buf[ifdefs]);
                    continue;
                }
                
                /* Else if .. */
                if (stricmp(type,"ELIF") == 0)
                {
                    if (fields_got != 2)
                    {
                        write_log("Error in menu file '%s' line %d",fname,line);
                        printf("\r\nError in menu file '%s' line %d\n",fname,line);
                    }
                    else
                    {
                        for (num=0; num<defines; num++)
                        {
                            strp = strchr(def_buf[num],' ');
                            if (strp != NULL) *strp = '\0';
                            if (strcmp(def_buf[num],key) == 0)
                            {
                                /* Define found */
                                ifdef_buf[ifdefs] = 0;
                                if (strp != NULL) *strp = ' ';
                                break;
                            }
                            if (strp != NULL) *strp = ' ';
                        }
                    }
                    continue;
                }
                
                /* Endif .. */
                if (stricmp(type,"ENDIF") == 0)
                {
                    ifdefs--;
                    continue;
                }
                
                if ((ifdefs == 0) || ((ifdefs > 0) && (ifdef_buf[ifdefs-1] == 1)))
                {
                    /* Include new file */
                    if (stricmp(type,"INCLUDE") == 0)
                    {
                        if (key[0] != '"')
                        {
                            write_log("Error in menu file '%s' line %d",fname,line);
                            printf("\r\nError in menu file '%s' line %d\n",fname,line);
                        }
                        else
                        {
                            slen = strlen(key)-1;
                            if (key[slen] != '"')
                            {
                                write_log("Error in menu file '%s' line %d",fname,line);
                                printf("\r\nError in menu file '%s' line %d\n",fname,line);
                            }
                            else
                            {
                                key[slen] = '\0';
                                execute_menu(key+1,1);
                            }
                        }
                        continue;
                    }
                    
                    /* Define commands */
                    if (stricmp(type,"DEFINE") == 0)
                    {
                        if (defines == MAX_DEFINES)
                        {
                            printf("\r\nToo many defines!\n");
                        }
                        else
                        {
                            if (fields_got < 2)
                            {
                                printf("\r\nError in menu file '%s' line %d\n",fname,line);
                            }
                            else
                            {
                                sprintf(def_buf[defines],"%s %s %s",key,menutype,data);
                                slen = strlen(def_buf[defines])-1;
                                while ((def_buf[defines][slen] == ' ') && (slen > 0)) slen--;
                                def_buf[defines][slen+1] = '\0';
                            }
                            defines++;
                        }
                        continue;
                    }
                    
                    if (fields_got < 3)
                    {
                        write_log("Error in menu file '%s' line %d",fname,line);
                        printf("\r\nError in menu file '%s' line %d\n",fname,line);
                        continue;
                    }

                    /* Auto execute? */
                    if (run_auto == 1)
                    {
                        if (stricmp(type,"AUTO") == 0)
                        {
                            /* Check if "menutype" has defines */
                            for (num=0; num<defines; num++)
                            {
                                strp = strchr(def_buf[num],' ');
                                if (strp != NULL) *strp = '\0';
                                if (strcmp(def_buf[num],key) == 0)
                                {
                                    /* Define found */
                                    if (strp != NULL) *strp = ' ';
                                    strcpy(key,strp+1);
                                    break;
                                }
                                if (strp != NULL) *strp = ' ';
                            }
                            
                            if (sscanf(key,"%u",&mtype) != 1)
                            {
                                write_log("Error in menu file '%s' line %d",fname,line);
                                printf("\r\nError in menu file '%s' line %d: Invalid menutype\n",fname,line);
                            }
                            else
                            {
                                sprintf(str,"%s %s",menutype,data);
                                slen = strlen(str)-1;
                                while ((str[slen] == ' ') && (slen > 0)) slen--;
                                str[slen+1] = '\0';

                                quit = run_menutype(mtype,str);
                                if (!run_auto) break;
                                if (quit) break;
                            }
                        }
                        continue;
                    }

                    if (run_auto == 2)
                    {
                        /* Run error */
                        if (stricmp(type,"ERR") == 0)
                        {
                            /* Check if "menutype" has defines */
                            for (num=0; num<defines; num++)
                            {
                                strp = strchr(def_buf[num],' ');
                                if (strp != NULL) *strp = '\0';
                                if (strcmp(def_buf[num],key) == 0)
                                {
                                    /* Define found */
                                    if (strp != NULL) *strp = ' ';
                                    strcpy(key,strp+1);
                                    break;
                                }
                                if (strp != NULL) *strp = ' ';
                            }

                            if (sscanf(key,"%u",&mtype) != 1)
                            {
                                write_log("Error in menu file '%s' line %d",fname,line);
                                printf("\r\nError in menu file '%s' line %d: Invalid menutype\n",fname,line);
                            }
                            else
                            {
                                sprintf(str,"%s %s",menutype,data);
                                slen = strlen(str)-1;
                                while ((str[slen] == ' ') && (slen > 0)) slen--;
                                str[slen+1] = '\0';

                                quit = run_menutype(mtype,str);
                                run_auto = 1;
                                executing_autos = 0;
                                found = 1;
                                break;
                            }
                        }
                        continue;
                    }
                    else
                    {
                        /* Command? */
                        if (stricmp(type,"CMD") == 0)
                        {
                            /* Key matches answer? */
                            num = 0; found = 0; str[0] = '\0'; slen = 0; chr = 0;
                            while (key[num] != '\0')
                            {
                                if (found > 0 && (key[num] < '0' || key[num] > '9')) found = 0;

                                if (found > 0)
                                {
                                    found++;
                                    chr = chr*10+key[num]-'0';
                                    if (found == 4)
                                    {
                                        found = 0;
                                        str[slen++] = (char) chr;
                                    }
                                    num++;
                                    continue;
                                }

                                if (key[num] == '\\')
                                {
                                    found = 1;
                                    chr = 0;
                                }
                                else
                                {
                                    str[slen++] = key[num];
                                }
                                num++;
                            }
                            found = 0; str[slen] = '\0';

                            if (stricmp(str,answer) == 0)
                            {
                                /* Check if "menutype" has defines */
                                for (num=0; num<defines; num++)
                                {
                                    strp = strchr(def_buf[num],' ');
                                    if (strp != NULL) *strp = '\0';
                                    if (strcmp(def_buf[num],menutype) == 0)
                                    {
                                        /* Define found */
                                        if (strp != NULL) *strp = ' ';
                                        strcpy(menutype,strp+1);
                                        break;
                                    }
                                    if (strp != NULL) *strp = ' ';
                                }
                                
                                if (sscanf(menutype,"%u",&mtype) != 1)
                                {
                                    write_log("Error in menu file '%s' line %d",fname,line);
                                    printf("\r\nError in menu file '%s' line %d: Invalid menutype\n",fname,line);
                                }
                                else
                                {
                                    /* Yeah! */
                                    found = 1;
                                    quit = run_menutype(mtype,data);
                                    if (parms[0] == '\0') run_auto = 1;
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                }
            }
        }

        if (included) break;

        if ((!run_auto) && (!found) && (!quit))
        {
            /* No keys matched, run "err" command */
            run_auto = 2;
        }
        else
        {
            if (parms[0] != '\0')
            {
                strcpy(answer, parms+(parms[0] == ';'));
                parms[0] = '\0';
                continue;
            }

            if (executing_autos)
            {
                run_auto = 0;
                executing_autos = 0;
            }
        }
    }

    if (!included) _free(def_buf);

    /* Close menu file */
    FileClose(Fmenu);
    return quit;
}
