/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* bbs.c - Main BBS file */
void testi(void);

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifndef __linux__
#  include <process.h>
#endif

#include "os.h"
#include "memory.h"
#include "bbs_func.h"
#include "output.h"
#include "files.h"
#include "userbase.h"
#include "nodes.h"
#include "getdescs.h"
#include "logfile.h"
#include "modem.h"
#include "buildfb.h"
#include "waitcall.h"
#include "config.h"

#define NEXT_NONE 0
#define NEXT_NAME 1

int bbs_pack_userbase(void)
{
    if (!pack_userbase())
    {
        printf("Could not pack userbase!\n");
        return 1;
    }
    printf("OK. Userbase packed\n");
    return 0;
}

int bbs_create_userbase_indexes(void)
{
    if (!create_useridx())
    {
        printf("Could not create userbase indexes!\n");
        return 1;
    }
    printf("OK. Userbase.idx created\n");
    return 0;
}

int bbs_set_nodestat(char *argv[])
{
    int doing;

    /* Get node number */
    if (sscanf(argv[2], "%u", &nodenum) != 1 || nodenum == 0)
    {
        printf("Invalid node number: %s\n",argv[2]);
        return 1;
    }

    /* Open node file */
    if (!open_nodefile())
   {
        printf("Could not open node file.\n");
        return 1;
    }

    /* Read node status */
    if (!read_nodefile(nodenum,&noderec)) memset(&noderec,0,sizeof(noderec));

    /* Get "doing number" */
    if (sscanf(argv[3], "%d", &doing) != 1) return 1;
    noderec.doing = (unsigned char) doing;

    /* Update node file */
    update_nodefile(1);

    /* Close node file */
    close_nodefile();

    /* And nice little text last. := */
    printf("Ok. Node #%d status is now '%s'\n",nodenum,node_doing[noderec.doing]);
    return 0;
}

int bbs_main(int argc, char *argv[])
{
    char username[81], device[20], *strp;
    int local,next,handle,num,wait,ret; /* Return value */

#ifdef __linux__
    struct stat statbuf;
#endif


    if (!read_config(DEFAULT_CONFIG))
#ifdef __linux__
        return 1;
#else
    {
        char *env, path[256];

        env = getenv("YAK");
        if (env == NULL) return 1;

        if (env[strlen(env)-1] == SLASH)
            sprintf(path, "%s"DEFAULT_CONFIG, env);
        else
            sprintf(path, "%s"SSLASH DEFAULT_CONFIG, env);
        if (!read_config(path)) return 1;
    }
#endif

    if (argc > 1)
    {
        if (stricmp(argv[1],"node") == 0)
        {
            /* Set node status */
            return bbs_set_nodestat(argv);
        }

        if (stricmp(argv[1],"packuser") == 0)
        {
            /* Pack userbase */
            return bbs_pack_userbase();
        }

        if (stricmp(argv[1],"useridx") == 0)
        {
            /* Create userbase.idx from userbase.dat */
            return bbs_create_userbase_indexes();
        }
        
        if (stricmp(argv[1],"buildfb") == 0)
        {
            /* Build filebase */
            return build_filebase(argc,argv);
        }

        if (stricmp(argv[1],"joinfb") == 0)
        {
            /* Join filebases together (for cdrom filebases..) */
            return join_filebase(argc,argv);
        }

        if (stricmp(argv[1],"getdescs") == 0)
        {
            /* Get file descriptions */
            return get_file_descriptions();
        }
    }

    local = 0; handle = 0; bpsrate = 0; nodenum = 1; next = NEXT_NONE;
    ttynum = 0; comport = 0; wait = 0;
    username[0] = '\0'; device[0] = '\0';
    for (num=1; num<argc; num++)
    {
        if (strnicmp(argv[num],"-h:",3) == 0)
        {
            if (sscanf(argv[num]+3,"%d",&handle) != 1) handle = 0;
#ifdef __linux__
            strcpy(device, ttyname(handle));
            // n config fileeseen
            if (strcmp(device, "/dev/ttyS1") == 0)
            {
                nodenum = 2;
                ttynum = 7;
                comport = 2;
            }
            else if (strcmp(device, "/dev/ttyS3") == 0)
            {
                nodenum = 3;
                ttynum = 8;
                comport = 4;
            }
#endif
            hCom = 0;
            next = NEXT_NONE;
        }
        else if (strnicmp(argv[num],"-c:",3) == 0)
        {
            if (sscanf(argv[num]+3,"%d",&comport) != 1) comport = 0;
            next = NEXT_NONE;
        }
        else if (strnicmp(argv[num],"-t:",3) == 0)
        {
            if (sscanf(argv[num]+3,"%d",&ttynum) != 1) ttynum = 0;
            next = NEXT_NONE;
        }
        else if (strnicmp(argv[num],"-p:",3) == 0)
        {
            strcpy(device,argv[num]+3);
            handle = 0;
            hCom = 0;
            next = NEXT_NONE;
        }
        else if (strnicmp(argv[num],"-b:",3) == 0)
        {
            strp = strchr(argv[num], '/');
            if (strp != NULL) *strp = '\0';
            bpsrate = atol(argv[num]+3);
            next = NEXT_NONE;
        }
        else if (strnicmp(argv[num],"-n:",3) == 0)
        {
            if (sscanf(argv[num]+3,"%d",&nodenum) != 1) nodenum = 1;
            next = NEXT_NONE;
        }
        else if (stricmp(argv[num],"-l") == 0)
        {
            local = 1; hCom = 0; handle = 0; device[0] = '\0';
            next = NEXT_NONE;
        }
        else if (stricmp(argv[num],"-w") == 0)
        {
            wait = 1;
            next = NEXT_NONE;
        }
        else if (stricmp(argv[num],"-u") == 0)
        {
            username[0] = '\0';
            next = NEXT_NAME;
        }
        else
        {
            if (next == NEXT_NONE)
            {
                printf("Unknown parameter: %s\n",argv[num]);
                handle = 0;
                break;
            }
            switch (next)
            {
                case NEXT_NAME:
                    if (username[0] == '\0')
                        sprintf(username,"%s",argv[num]);
                    else
                        sprintf(username+strlen(username)," %s",argv[num]);
                    break;
            }
        }
    }

    if (handle == 0 && device[0] == '\0' && !local)
    {
#ifdef __DOS__
        printf("Usage: BBS -h:<port> -b:<bps rate> [-n:<node number>] [-l] [-u <user name>]\n");
#else
        printf("Usage: BBS -p:<device> or -h:<handle> -b:<bps rate> [-n:<node number>] [-l] [-u <user name>]\n");
#endif
        return 0;
    }

    if (!open_logfile(nodenum))
        printf("WARNING: Couldn't open log file!\n");

    if (!init_output())
    {
        write_log("Couldn't initialize keyboard or screen");
        printf("FATAL: Couldn't initialize keyboard or screen\n");
        return 1;
    }

#ifndef __DOS__
    /* Initialize modem */
    if (!init_modem(handle, device) && !local)
    {
        printf("FATAL: Could not open handle %u\n",handle);
        return 0;
    }
#endif

    if (firstlang == NULL)
    {
        output("FATAL: No language files set in configuration file!\n");
        write_log("No language files set in configuration file");
        ret = 1;
    }
    else
    {

        if (!wait)
            ret = 0;
        else
        {
            ret = wait_caller();
        }
    }

    write_log("--------- BBS started, %lu BPS ------------------------",bpsrate);

    /* Jump to BBS */
    if (ret == 0) ret = goto_bbs(username);

    /* Deinitialize modem */
#ifndef __DOS__
    if (!local) deinit_modem();
#endif

#ifndef __DOS__
    printf("\x1b[0m\x1b[H\x1b[2J\n");
#endif

#ifdef __linux__
    if (stat("/tmp/messages.jam", &statbuf) == 0)
        system("/usr/local/bin/xtoss scan > /dev/null");
    if (stat("/tmp/buildfb.sem", &statbuf) == 0)
        system("/usr/local/bin/buildfb.sh");
#endif

    deinit_output();

    return ret;
}

int main(int argc, char *argv[])
{
    int ret;

#ifdef __WATCOMC__
    _grow_handles(50);
#endif

    _meminit();
    ret = bbs_main(argc, argv);
    close_config();
    _memdeinit();

    close_logfile();

    return ret;
}
