/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993, 1994 Alex Wetmore.  
 * email: alex@phred.org
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define FALSE 0
#define TRUE 1

/* function prototypes for all of the functions to handle various messages.
 * they should take the client number as the first parameter, and their
 * parameter list as the second one.
 */
int c_yabbshi(char **argv);             /* server version/welcome msg       */
int c_bad(char **argv);                 /* server error message             */
int c_talk(char **argv);                /* cmd, chn, user, msg              */
int c_page(char **argv);                /* from name                        */
int c_who(char **argv);                 /* cmd, name, tty, time             */
int c_channels(char **argv);            /* channel name, users              */
int c_msg(char **argv);                 /* see documentation                */
int c_msghdr(char **argv);              /* from, to, deleted, title         */
int c_msgnum(char **argv);              /* baseid, number of messages       */
int c_delmsgret(char **argv);           /* baseid, mnum, status (Y/N/P)     */
int c_basetitle(char **argv);           /* baseid, base title               */
int c_useropts(char **argv);            /* name, scrlen, options, subs      */
int c_login(char **argv);               /* OK = valid login, otherwise not  */
int c_lastmsg(char **argv);             /* baseid, msgnum                   */
int c_newuser(char **argv);             /* OK = valid name, otherwise ermsg */
int c_userexist(char **argv);           /* username, OK=exists              */
int c_founduser(char **argv);           /* count, username NULL=end of list */
int c_txtfile(char **argv);             /* see protocol specs               */
int c_planfile(char **argv);            /* see protocol specs               */
int c_gfileindex(char **argv);          /* see specs                        */
int c_gfile(char **argv);               /* see specs                        */
int c_shutdown(char **argv);            /* shutdown message                 */
int c_announce(char **argv);            /* type, arg1, arg2                 */

struct ctype {
    char cname[16];                     /* command name                     */
    int  (*f)(char **argv);             /* function to call                 */
};

#define C_CNUM 24
struct ctype s_ctable[] = { 
    { "YABBSHI",    c_yabbshi   },
    { "BAD",        c_bad       },
    { "TALK",       c_talk      },
    { "PAGE",       c_page      },
    { "WHO",        c_who       },
    { "CHANNELS",   c_channels  },
    { "MSG",        c_msg       },
    { "MSGHDR",     c_msghdr    },
    { "MSGNUM",     c_msgnum    },
    { "DELMSGRET",  c_delmsgret },
    { "BASETITLE",  c_basetitle },
    { "USEROPTS",   c_useropts  },
    { "LOGIN",      c_login     },
    { "LASTMSG",    c_lastmsg   },
    { "NEWUSER",    c_newuser   },
    { "USEREXIST",  c_userexist },
    { "FOUNDUSER",  c_founduser },
    { "TXTFILE",    c_txtfile   },
    { "PLANFILE",   c_planfile  },
    { "GFILEINDEX", c_gfileindex},
    { "GFILE",      c_gfile     },
    { "SHUTDOWN",   c_shutdown  },
    { "ANNOUNCE",   c_announce  }
};

#define DEBUG
#ifdef DEBUG
#define dbg(x) x
#else
#define dbg(x)
#endif
