/*
 * this file is a part of yabbs - yet another bulletin board system.
 * Copyright (C) 1993 Alex Wetmore.  
 * email: aw2t@andrew.cmu.edu
 * address: 6 rech ave
 *          oreland pa 19075
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "bbsdefs.h"
#define KEEPUSERS "keepusers.txt"

void purgeusers(void){ 
    FILE *keep;
    int u, i, keepnum, found, oldusernum;
    char *keepu[1024][10];

    keep = fopen(KEEPUSERS, "r");
    if (keep == NULL) exit(1);
    u = 0;
    while (!feof(keep)) {
        fscanf(keep, "%s\n", keepu[u++]);
    }
    keepnum = u;
    fclose(keep);

    oldusernum = usernum;
    for (u = 0; u < usernum; u++) {
        found = FALSE;
        printf("%s...", user[u].name);
        for (i = 0; (i < keepnum) && (!found); i++) 
            if (strcmp((char *) keepu[i], user[u].name) == 0) found = TRUE;
        if (!found) {
            printf("dies", user[u].name);
            for (i = u; i < usernum; i++)
                user[i] = user[i + 1];
            usernum--;
        }
        printf("\n");
    }
    printf("old user count: %i\n", oldusernum);
    printf("new user count: %i\n", usernum);
}

void upurgemain(int argc, char **argv) {
    readusers();
    purgeusers();
    writeusers(FALSE); 
}
