/*
 * The yell daemon. This utility is used to deliver "Yell/Operate SysOp"
 * calls made by user to the SysOp working at console or such.
 *
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>

#include "proto.h"

int sock;
int ponce=0;						// Play sample only once
int beep=0;							// Use beeping

void killsock(int);					// Signal handler
	
void usage(void)
{
	printf( "VMatik BBS SysOp yelling daemon.\n\n"
			"Usage:\n"
			"-b                - use beeping.\n"
			"-o [file/tty]     - message output.\n"
			"-s [sample]       - AU-file to play\n"
			"-1                - play sample only ONCE\n\n");
}

int main(int argc, char *argv[])
{
	char output[PATH_MAX];
	char sample[PATH_MAX];
	int go=1;
		
	output[0]=sample[0]=0;

	if(argc<2)
	{
		usage();
		exit(0);
	}
	
	while(go)
	{
		switch(getopt(argc, argv, "1bo:s:"))
		{
			case '1':
				ponce=1;
				break;
			case 'b':
				beep=1;
				break;
			case 'o':
				strcpy(output, optarg);
				break;
			case 's':
				strcpy(sample, optarg);
				break;
			case -1:
				go=0;
				break;
			case 'h':
			default:
				usage();
				exit(0);
				break;
		}
	}

	if (!output[0]) {
		printf("No output specified -- exiting!\n\n");
		exit(0);
	}

	if (fork()==0)						// Child
	{
		struct sockaddr_un name;
		struct VMatik_PageMsg pm;
		FILE *outfd;
		int  samplefd;
		char *samplem=NULL;
		struct stat st;
	
		signal(SIGPIPE,killsock);
		signal(SIGINT,killsock);
		signal(SIGTERM,killsock);

		outfd=fopen(output,"w");
		if (!outfd) {
			perror("Can't open output file/tty!\n\n");
			exit(0);
		}
		
		if(sample[0]) 
		{
			samplefd=open(sample,O_RDONLY);
			if (samplefd==-1) {
				perror("Can't open sample!\n\n");
				exit(0);
			}

			fstat(samplefd,&st);
			samplem=(char *)malloc(st.st_size);
			read(samplefd,samplem,st.st_size);
			close(samplefd);
		
			samplefd=open("/dev/audio",O_WRONLY);
			if (samplefd==-1) {
				perror("Can't open /dev/audio!\n\n");
				exit(0);
			}
			close(samplefd);
		}
		
		umask(777);
		sock=socket(AF_UNIX, SOCK_DGRAM, 0);
		if (sock < 1) {
			perror("error opening socket!\n\n");
			exit(0);
		}
		
		strcpy(name.sun_path, YELLD_SOCKET);
		name.sun_family=AF_UNIX;
		if (bind(sock,(struct sockaddr *)&name, sizeof(struct sockaddr_un))) {
			perror("Can't bind socket!\n\n");
			exit(0);
		}

//		puts("\nyelld active!\n\n");
		
		while (1)
		{
			read(sock,&pm,sizeof(struct VMatik_PageMsg));
			if (pm.pm_cmd==1) {
				if (beep) {
					fputs("beep\007\007\007",outfd);
					fflush(outfd);
				}
				if (sample[0] && ponce < 2) {
					samplefd=open("/dev/audio",O_WRONLY);
					if (samplefd!=-1) {
					write(samplefd,samplem,st.st_size);
					if (ponce==1) ponce=2;
					close(samplefd);
					}
				}
			} else if (pm.pm_cmd==2) {
				fputs(pm.pm_string,outfd);
			}
		
		}	
	}
	
	return(0);
}

void killsock(int sig)
{
	close(sock);
	unlink(YELLD_SOCKET);

	exit(0);
}
