/*
 * This displays who's online from a shell.
 *
 */
#include "struct.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct VMatik_Node *mn;
struct VMatik_MainConfig maincfg;

char *whlinestr = "%-2.2d %-20.20s %-25.25s %-20.20s %s\n";

int shownodes(void);
int who_show(struct VMatik_Node *cn, int num);
int isnode(int nod, struct VMatik_NodeInfo *ndnfo);

MYSQL db;

int main(int argc, char *argv[])
{
	char *env;
	char bufa[1024];
	struct stat st;
	int fd;

	env=getenv("VMATIK");
	if(!env)
	{
		fprintf(stderr, "Unable to get $VMATIK env variable!\n");
		return(-1);
	}
	
	sprintf(bufa,"%s/data/multinode.dat",env);
	if (stat(bufa,&st)!=0) {
		perror("Unable to stat() $VMATIK/data/multinode.dat");
		return(-1);
	}
	mn=malloc(st.st_size+2);
	memset(mn,0,st.st_size+2);
	fd=open(bufa,O_RDONLY);
	if (fd < 0) {
		perror("open $VMATIK/data/multinode.dat");
		return -1;
	}
	read(fd,mn,st.st_size);
	close(fd);
	
	sprintf(bufa,"%s/data/vmatik.dat",env);
	fd=open(bufa,O_RDONLY);
	if (fd < 0) {
		perror("open $VMATIK/data/vmatik.dat");
		return -1;
	}
	read(fd,&maincfg,sizeof(struct VMatik_MainConfig));
	close(fd);

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(-1);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(-1);
	}

	shownodes();

	mysql_close(&db);
	return(0);
}

int shownodes()
{
	struct VMatik_Node *cn;

	cn=mn;
	
	printf("N  Account Name         Org. / Location           Activity             Bps\n-----------------------------------------------------------------------------\n");

	while(cn->Node_ID)
	{
		if (cn->Node_TTYType == NODETYPE_TELNET) {
			int j=maincfg.CFG_TELNETMAX;
			int i=maincfg.CFG_TELNET1ST;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else if (cn->Node_TTYType == NODETYPE_LOCAL) {
			int j=maincfg.CFG_LOCALMAX;
			int i=maincfg.CFG_LOCAL1ST;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else {
			who_show(cn,cn->Node_ID);
		}
		cn++;
	}
	printf("-----------------------------------------------------------------------------\n\n");

	return(1);
}

int who_show(struct VMatik_Node *cn, int num)
{
	struct VMatik_NodeInfo myn;
	char *orgn=NULL, *activity, *usern=NULL;
	char dabps[30];
	int showent=1;
	char query[QUERY_MAX];
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;

	if (isnode(num,&myn)) {
		if (cn->Node_Flags & NODE_HIDECALL) {
			showent=0;
		} else {
			if (myn.ddn_userslot > -1) {
				
				sprintf(query, "SELECT user_handle, user_name, user_org, 
								user_city
								FROM vmatik_user
								WHERE user_id=%d", myn.ddn_userslot);
				mysql_query(&db, query);
				sql_res=mysql_store_result(&db);
				if(!sql_res)
					return(-1);
				sql_row=mysql_fetch_row(sql_res);
				if(!sql_row)
					return(-1);
				
				if (maincfg.CFG_FLAGS & FLAG_HANDLE)
					usern=sql_row[0]; 
				else 
					usern=sql_row[1];
				if (maincfg.CFG_FLAGS & FLAG_ORGANIZATION)
					orgn=sql_row[2]; 
				else 
					orgn=sql_row[3];
				
				mysql_free_result(sql_res);
			}

			activity=myn.ddn_activity;
			sprintf(dabps,"%d",myn.ddn_bpsrate);
		} 
	} else {
		if (cn->Node_Flags & NODE_HIDEWAIT) showent=0;
		else {
			activity="Waiting for a call...";
			sprintf(dabps," ");
		}
	}
	if (showent) {
		switch (cn->Node_TTYType)
		{
			case NODETYPE_LOCAL:
				strcpy(dabps,"LOCAL");
				break;
			case NODETYPE_TELNET:
				strcpy(dabps,"TELNET");
				break;
			case NODETYPE_NORMAL:
			default:
				break;
		}
		
		printf(whlinestr,num,(usern ? usern : ""),(orgn ? orgn : ""),
				activity,dabps);
	}
	return 1;
}

int ispid(pid_t pid)
{
	char ibuf[1024];
	struct stat st;
	
	sprintf(ibuf,"/proc/%d",pid);

	if (stat(ibuf,&st)==-1) 
		return(0); 
		
	return(1);
}

int isnode(int nod, struct VMatik_NodeInfo *ndnfo)
{
	char infoname[1024];
	int nodefd;
		
	sprintf(infoname,"%snodeinfo%d.data",VMTMP,nod);
	nodefd=open(infoname,O_RDONLY);
	if (nodefd!=-1) {
		read(nodefd,ndnfo,sizeof(struct VMatik_NodeInfo));
		close(nodefd);
		if(ispid(ndnfo->ddn_pid)) return 1;
	}
//	printf("Node: %d Isnode: 0\n", nod);
	return 0;
}


