/*
 * Vuohimatik toplist creator by ~g (10-Oct-1998)
 *
 * Usage: vuohitop <cfgfile>
 *
 * Default cfgfile is "vuohitop.cfg" in the current directory.
 *
 * Note: This util was done in a couple of hours. It is
 *       a bare bones example, just to show how to
 *       create a topten lister for vuohimatik.
 *
 *       If someone wishes to add colors, more functionality
 *       etc nice stuff, please do so and send me the source
 *       to be included with vmatik distribution... Along
 *       with proper credits to you, of course. :)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "proto.h"

#define DEF_AMOUNT 10
#define BUFFSIZE 512

int flag_excludesysop=0;
int flag_usereal=0;
int flag_useloc=0;

int print_tailer(FILE *dp);

struct columninfos
{
	char column_realname[100];
	char column_displayname[100];
	int column_divider;
};

char *fgetsnolf(char *buf, int n, FILE *fh);

int parse_cfgfile(FILE *fp, struct columninfos *column1, 
				struct columninfos *column2, char *outfile)
{
	char buffer[BUFFSIZE];
	int amount=DEF_AMOUNT,success=0;

	memset(column1, 0, sizeof(struct columninfos));
	memset(column2, 0, sizeof(struct columninfos));
	
	flag_excludesysop=flag_usereal=flag_useloc=0;

	while(fgetsnolf(buffer, 512, fp))
	{
		if(buffer[0]=='#')
			continue;
		if(!strncasecmp(buffer, "OUTFILE ", 8)) {
			strcpy(outfile, &buffer[8]);
		} else if (!strncasecmp(buffer, "COLUMN1 ", 8)) {
			strcpy(column1->column_realname, &buffer[8]);
		} else if (!strncasecmp(buffer, "COLUMN1NAME ", 12)) {
			strcpy(column1->column_displayname, &buffer[12]);
		} else if (!strncasecmp(buffer, "COLUMN1DIVIDER ", 15)) {
			column1->column_divider=atoi(&buffer[15]);
		} else if (!strncasecmp(buffer, "COLUMN2 ", 8)) {
			strcpy(column2->column_realname, &buffer[8]);
		} else if (!strncasecmp(buffer, "COLUMN2NAME ", 12)) {
			strcpy(column2->column_displayname, &buffer[12]);
		} else if (!strncasecmp(buffer, "COLUMN2DIVIDER ", 15)) {
			column2->column_divider=atoi(&buffer[15]);
		} else if (!strncasecmp(buffer, "MAXUSERS ", 9)) {
			amount=atoi(&buffer[9]);
		} else if (!strncasecmp(buffer, "EXCLUDESYSOP", 12)) {
			flag_excludesysop=1;
		} else if (!strncasecmp(buffer, "USEREALNAMES", 12)) {
			flag_usereal=1;
		} else if (!strncasecmp(buffer, "USEREALLOCATIONS", 16)) {
			flag_useloc=1;
		} else if (buffer[0]=='+') {
			success=1;
			break;
		}
	}

	if(success)
		return(amount);
	
	return(0);
}

/*
 * This prints a somewhat formatted line from the sql_row input.
 *
 */
int print_formatted_row(int position, struct columninfos *column1, 
						struct columninfos *column2, 
						MYSQL_ROW sql_row, FILE *dp)
{
	int value1, value2;
	char valbuf1[20], valbuf2[20];

	value1=atoi(sql_row[2]);
	if(column1->column_divider)
	{
		value1=value1/column1->column_divider;
	}
	sprintf(valbuf1, "%9d", value1);
	
	if(column2->column_realname[0])
	{
		value2=atoi(sql_row[3]);
		if(column2->column_divider)
		{
			value2=value2/column2->column_divider;
		}
		sprintf(valbuf2, "%9d", value2);
	}

	fprintf(dp, " %2d. %-26.26s %-26.26s %9.9s %9.9s\n", 
			position, sql_row[0], sql_row[1], valbuf1,
			(column2->column_realname[0] ? valbuf2 : ""));
	
	return(1);
}

/*
 * Prints out a header
 *
 */
int print_header(char *displayname1, char *displayname2, FILE *dp)
{
	fprintf(dp, "[2J[H\n\n");
	fprintf(dp, " %2s  %-26.26s %-26.26s %9.9s %9.9s\n",
			"##", 
			(flag_usereal ? "Name" : "Handle"), 
			(flag_useloc ? "Location" : "Organization"),
			(displayname1[0] ? displayname1 : ""),
			(displayname2[0] ? displayname2 : ""));
	
	print_tailer(dp);

	return(1);
}

/*
 * Prints out a tailer
 *
 */
int print_tailer(FILE *dp)
{
	int i;

	for(i=0;i<80;i++)
		fprintf(dp,"-");
	fprintf(dp, "\n");
	
	return(1);
}

/*
 * Makes the toplist.
 *
 */
int make_toplist(struct columninfos *column1, struct columninfos *column2, 
				int amount, char *outfile)
{
	MYSQL db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	char namebuf[512];
	char locbuf[512];
	FILE *dp;

	dp=fopen(outfile, "w");
	if(!dp)
	{
		fprintf(stderr, "Unable to open %s\n", outfile);
		return(0);
	}

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		fprintf(stderr, "%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		fprintf(stderr, "%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

	if(flag_usereal)
		strcpy(namebuf, "user_name");
	else
		strcpy(namebuf, "user_handle");

	if(flag_useloc)
		strcpy(locbuf, "user_city");
	else
		strcpy(locbuf, "user_org");

	if(!column2->column_realname[0])
	{
		sprintf(query, "SELECT %s,%s,%s 
						FROM vmatik_user %s
						ORDER BY %s DESC",
						namebuf, locbuf, column1->column_realname, 
						(flag_excludesysop ? "WHERE user_id<>1 " : ""),
						column1->column_realname);
	}
	else
	{
		sprintf(query, "SELECT %s,%s,%s,%s
						FROM vmatik_user %s
						ORDER BY %s DESC", 
						namebuf, locbuf, column1->column_realname, 
						column2->column_realname, 
						(flag_excludesysop ? "WHERE user_id<>1 " : ""),
						column1->column_realname);
	}
	mysql_query(&db, query);
	if(mysql_error(&db)[0])
		fprintf(stderr, "%s\n", mysql_error(&db));

	sql_result=mysql_use_result(&db);
	if(sql_result)
	{
		int i=1;

		print_header(column1->column_displayname, 
					column2->column_displayname, dp);
	
		while((sql_row=mysql_fetch_row(sql_result)))
		{
			if(amount>0)
			{
				print_formatted_row(i, column1, column2, sql_row, dp);

				amount--;
			}
			i++;
		}

		print_tailer(dp);
		
		mysql_free_result(sql_result);
	}
	
	mysql_close(&db);	
	fclose(dp);

	fprintf(stderr, "Top '%s' written into %s\n", 
			column1->column_realname, outfile);

	return(1);
}

int main(int argc, char *argv[])
{
	struct columninfos column1;
	struct columninfos column2;
	int amount;
	char outfile[PATH_MAX];
	char *cfgfile;
	FILE *fp;

	if(argc==1)
		cfgfile="vuohitop.cfg";
	else
		cfgfile=argv[1];	

	fp=fopen(cfgfile, "r");
	if(!fp)
	{
		fprintf(stderr, "Unable to open %s\n", cfgfile);
		return(0);
	}	

	while((amount=parse_cfgfile(fp, &column1, &column2, outfile)))
	{
		make_toplist(&column1, &column2, amount, outfile);
	}

	fclose(fp);

	return(1);

}

/*
 * fgets without the LineFeed in end of result
 *
 */
char *fgetsnolf(char *buf, int n, FILE *fh)
{
	char *hih, *s;

	hih=fgets(buf,n,fh);
	if(!hih)
		return(0);
	s=buf;
	while(*s)
	{
		if(*s==13 || *s==10)
		{
			*s=0;
			break;
		}
		s++;
	}
	return(hih);
}

