/*
 * Compiles "vmatik.cfg" into binary used by the vmatik executable.
 *
 */
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include "proto.h"
#include "struct.h"
#include <math.h>
#include <pwd.h>
#include <grp.h>

char *findtxt(char *, char*);
char *nextspace(char *);
char *cfgcopy(char *, int);
char cfgchar(void);
int cfgconf(void);
int cfgflag(char *on);
int mymkdir(char *dir);

char homedir[512];
char group[512];
char luser[512];
char perm[512];
char olddir[1024];

gid_t gid=-1;
uid_t uid=-1;
mode_t mode;
mode_t dmode;

int cfgint(void);
 
char *src;
char *ecfg(char *, char *);
void backtoold(void);
int cfgfnadd(char *s, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point);
char *cfgfnadd2(char *s, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point);

void backtoold(void)
{
	chdir(olddir);
}


int main(int argc, char *argv[])
{
	int infile;
	int outfile;
	char *inmem;
	struct stat fib;
	struct VMatik_MainConfig maincfg;
	struct VMatik_Conference conf;
	struct VMatik_MsgBase base;
	struct VMatik_ExternalCommand extcom;
	struct VMatik_Archiver arc;
	struct VMatik_DisplayMode disp;
	struct VMatik_Node node;
	struct VMatik_Protocol proto;
	struct VMatik_Seclevel sec;
	struct List *SelectList;
	struct Selected *selp;
	int dodirs=1;
	int j;
		
	SelectList=NewList();

	memset(&maincfg, 0, sizeof(struct VMatik_MainConfig));
	
	if (argc < 2) {
		printf("Usage: %s [configfile] <-d>\n\n", argv[0]);
		exit(0);
	}

	umask(0000);
	
	infile = open(argv[1],O_RDONLY);
	if (infile == -1) {
		fprintf(stderr, "Unable to open %s\n", argv[1]);
		exit(-1);
	}

	if (argc == 3 && !strcasecmp(argv[2],"-d")) {
		dodirs=0;
	}
	fstat(infile,&fib);
	inmem=(char *)malloc(fib.st_size+2);
	inmem[fib.st_size]=0;
	inmem[fib.st_size+1]=0;
	read(infile,inmem,fib.st_size);
	close(infile);
	
	src=ecfg(inmem,"HOMEDIR ");
	if (!src) {
		*homedir=0;
	} else {
		cfgcopy(homedir,sizeof(homedir));
	}

	src=ecfg(inmem,"FILEPERMISSION ");
	if (!src) {
		*perm=0;
	} else {
		cfgcopy(perm,sizeof(perm));
		sscanf(perm,"%o",&mode);
	}

	src=ecfg(inmem,"DIRPERMISSION ");
	if (!src) {
		*perm=0;
	} else {
		cfgcopy(perm,sizeof(perm));
		sscanf(perm,"%o",&dmode);
	}

	src=ecfg(inmem,"OWNERUSER ");
	if (!src) {
		*luser=0;
	} else {
		cfgcopy(luser,sizeof(luser));
	}

	src=ecfg(inmem,"OWNERGROUP ");
	if (!src) {
		*group=0;
	} else {
		cfgcopy(group,sizeof(group));
	}
	
	if (*homedir) {
		getcwd(olddir,sizeof(olddir));
		chdir(homedir);
		atexit(backtoold);
	}

	if (*luser) {
		struct passwd *pw;
		setpwent();
		while ((pw=getpwent())) {
			if (!(strcmp(luser,pw->pw_name))) {
				uid=pw->pw_uid;
				break;
			}
		}
		endpwent();
	}

	if (*group) {
		struct group *gr;
		setgrent();
		while ((gr=getgrent())) {
			if (!(strcmp(group,gr->gr_name))) {
				gid=gr->gr_gid;
				break;
			}
		}
		endgrent();
	}
	
	src=findtxt(inmem,"!VMATIK.DAT");

	if (src==0) {
		fprintf(stderr,"Can't find definitions for VMATIK.DAT!\n\n");
		return(-1);
	}
	
	src=nextspace(src);

	cfgcopy(maincfg.CFG_BOARDNAME,sizeof(maincfg.CFG_BOARDNAME));
	cfgcopy(maincfg.CFG_SYSOPNAME,sizeof(maincfg.CFG_SYSOPNAME));
	cfgcopy(maincfg.CFG_CHATDLPATH,sizeof(maincfg.CFG_CHATDLPATH));
	cfgcopy(maincfg.CFG_SYSTEMPW,sizeof(maincfg.CFG_SYSTEMPW));
	cfgcopy(maincfg.CFG_NEWUSERPW,sizeof(maincfg.CFG_NEWUSERPW));
	cfgcopy(maincfg.CFG_OLUSEREDPW,sizeof(maincfg.CFG_OLUSEREDPW));
	maincfg.CFG_NEWUSERPRESETID=cfgint();
	maincfg.CFG_IDLETIMEOUT=cfgint();
	maincfg.CFG_JOINIFAUTOJOINFAILS=cfgint();
	maincfg.CFG_FREEHDDSPACE=cfgint();
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_REASON;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_HANDLE;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ORGANIZATION;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_QUESTIONS;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_QUICKLINEED;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASKHANDLE1ST;
	cfgcopy(maincfg.CFG_COLORSYSOP,sizeof(maincfg.CFG_COLORSYSOP));
	cfgcopy(maincfg.CFG_COLORUSER,sizeof(maincfg.CFG_COLORUSER));
	cfgcopy(maincfg.CFG_SHELLPW,sizeof(maincfg.CFG_SHELLPW));
	cfgcopy(maincfg.CFG_ALIENS,sizeof(maincfg.CFG_ALIENS));
	maincfg.CFG_LINEEDCHAR=cfgchar();
	cfgcopy(maincfg.CFG_FSEDCOMMAND,sizeof(maincfg.CFG_FSEDCOMMAND));
	maincfg.CFG_CHATMODE=cfgchar();
	maincfg.CFG_LOCALSCREEN=cfgint();
	maincfg.CFG_COSYSOPLEVEL=cfgint();
	cfgcopy(maincfg.CFG_HOMES,sizeof(maincfg.CFG_HOMES));
	maincfg.CFG_GID=cfgint();
	maincfg.CFG_UID=cfgint();
	cfgcopy(maincfg.CFG_CHATCMD,sizeof(maincfg.CFG_CHATCMD));
	cfgcopy(maincfg.CFG_TELNETPAT,sizeof(maincfg.CFG_TELNETPAT));
	maincfg.CFG_TELNET1ST=cfgint();
	maincfg.CFG_TELNETMAX=cfgint();
	cfgcopy(maincfg.CFG_LOCALPAT,sizeof(maincfg.CFG_LOCALPAT));
	maincfg.CFG_LOCAL1ST=cfgint();
	maincfg.CFG_LOCALMAX=cfgint();
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ALLOW2LOGINS;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASKNEWUSER;

	if (cfgflag("Y")) maincfg.CFG_DEFAULTS |= TOGGLE_EXPERT;
	if (cfgflag("N")) maincfg.CFG_DEFAULTS |= TOGGLE_NOMAILCHECK;
	if (cfgflag("Y")) maincfg.CFG_DEFAULTS |= TOGGLE_NEWSCAN_ON;
	if (cfgflag("Y")) maincfg.CFG_DEFAULTS |= TOGGLE_ALLOWNODE;
	if (cfgflag("Y")) maincfg.CFG_DEFAULTS |= TOGGLE_FSED;
	if (cfgflag("Y")) maincfg.CFG_DEFAULTS |= TOGGLE_QUICK_UL;

	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_REALNAME;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_HANDLE;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_ORG;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_EMAIL;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_CITY;	
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_VPHONE;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_DPHONE;
	if (cfgflag("Y")) maincfg.CFG_FLAGS |= FLAG_ASK_COMPUTER;

	if ( (!(maincfg.CFG_FLAGS & FLAG_ASK_REALNAME)) &&
	     (!(maincfg.CFG_FLAGS & FLAG_ASK_HANDLE)))
	{
		fprintf(stderr,"Error: You can't have both ASK_REALNAME & ASK_HANDLE disabled!\n");
		return(-1);
	}

	if ( (!(maincfg.CFG_FLAGS & FLAG_ASK_ORG)) &&
		 (!(maincfg.CFG_FLAGS & FLAG_ASK_CITY)))
	{
		printf("Warning: You shouldn't have both ASK_CITY & ASK_ORG disabled!\n");
	}

	maincfg.CFG_BBSUID=uid;
	maincfg.CFG_BBSGID=gid;
	
	if (*src!='~') {
		fprintf(stderr, "%30.30s",src);
		fprintf(stderr, "Error in vmatik.dat!\n");
		return(-1);
	}
	
	outfile = open("data/vmatik.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr, "Can not open output file!\n\n");
		return(-1);
	}
		
	write(outfile,&maincfg,sizeof(struct VMatik_MainConfig));
	close(outfile);
	chown("data/vmatik.dat",uid,gid);
	
	src=findtxt(inmem,"!CONFERENCES.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for CONFERENCES.DAT!\n\n");
		return(-1);
	}
	
	outfile = open("data/conferences.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}
nextconf:
	j=0;
	src=nextspace(src);

	memset(&conf, 0, sizeof(struct VMatik_Conference));

	conf.CONF_NUMBER=cfgint();
	cfgcopy(conf.CONF_NAME,sizeof(conf.CONF_NAME));
	cfgcopy(conf.CONF_PATH,sizeof(conf.CONF_PATH));
	if (dodirs) {
		char tbu[600];

		if(!mymkdir(conf.CONF_PATH))
			return(-1);
		
		sprintf(tbu,"%sfileareas",conf.CONF_PATH);
		if(!mymkdir(tbu))
			return(-1);
		
		sprintf(tbu,"%smessages",conf.CONF_PATH);
		if(!mymkdir(tbu))
			return(-1);
		
		sprintf(tbu,"%sdisplay",conf.CONF_PATH);
		if(!mymkdir(tbu))
			return(-1);
	}
	conf.CONF_UL_TIMEREWARD=cfgint();
	conf.CONF_UPLOADAREA=cfgint();
	conf.CONF_STARTAREA=cfgint();
	conf.CONF_MSGBASES=cfgint();
	conf.CONF_COMMENTAREA=cfgint();
	if (cfgflag("Y")) {
		conf.CONF_ATTRIBUTES |= CONF_PRIVATE_FLAG;
		selp=malloc(sizeof(struct Selected));
		selp->type=SEL_CONF;
		selp->conf_nr=conf.CONF_NUMBER;
	
		AddTail(SelectList, (struct Node *)selp);
	}
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_FREELEECH;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_NO_CREDITS;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_ASK_DESCRIPTION;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_VALIDATE_UPLOADS;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_NO_DUPECHECK;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_NO_FILECHECK;
	if (cfgflag("Y")) conf.CONF_ATTRIBUTES |= CONF_GLOBAL_DUPECHECK;
	cfgcopy(conf.CONF_PASSWD,sizeof(conf.CONF_PASSWD));

	write(outfile,&conf,sizeof(struct VMatik_Conference));
crossconf:
	if (*src=='~') goto confsdone;
	if (*src=='+') goto dobase;
	if (*src=='*')
	{
		if(j!=conf.CONF_MSGBASES)
		{
			fprintf(stderr,"Msgarea amount mismatch in conf %d!\n", conf.CONF_NUMBER);
			return(-1);
		}
		goto nextconf;
	}
	
	fprintf(stderr,"Error in conferences.dat!\n");
	fprintf(stderr,"%30.30s",src);
	return(-1);

dobase:
	src=nextspace(src);

	memset(&base, 0, sizeof(struct VMatik_MsgBase));

	base.MSGBASE_NUMBER=cfgint();
	if (dodirs) {
		char tbu[600];

		sprintf(tbu,"%smessages/base%3.3ld",conf.CONF_PATH,(long)base.MSGBASE_NUMBER);
		if(!mymkdir(tbu))
			return(-1);
	}
	base.MSGBASE_FN_FLAGS=cfgchar();
	base.MSGBASE_MSGLIMIT=cfgint();
	cfgcopy(base.MSGBASE_NAME,sizeof(base.MSGBASE_NAME));
	cfgcopy(base.MSGBASE_FN_TAG,sizeof(base.MSGBASE_FN_TAG));
	cfgcopy(base.MSGBASE_FN_ORIGIN,sizeof(base.MSGBASE_FN_ORIGIN));
	cfgfnadd(src,&base.MSGBASE_FN_ZONE,&base.MSGBASE_FN_NET,&base.MSGBASE_FN_NODE,&base.MSGBASE_FN_POINT);
	if (cfgflag("Y")) base.MSGBASE_FLAGS |= MSGB_ALLOW_PUBLIC;
	if (cfgflag("Y")) base.MSGBASE_FLAGS |= MSGB_ALLOW_PRIVATE;
	if (cfgflag("Y")) base.MSGBASE_FLAGS |= MSGB_FILE_ATTACHS;
	if (cfgflag("H")) base.MSGBASE_FLAGS |= MSGB_USE_HANDLES;
	if (cfgflag("Y")) base.MSGBASE_FLAGS |= MSGB_ALL_IS_EALL;
	switch(cfgchar())
	{
		case 'B':
		case 'b':
			base.MSGBASE_FLAGS |= MSGB_BLOCK_QUOTE;
			break;
		case 'I':
		case 'i':
			base.MSGBASE_FLAGS |= MSGB_USE_INITIALS;
			break;
		default:
			break;
	}
	
	if (cfgflag("Y")) {
		base.MSGBASE_FLAGS |= MSGB_DEFAULT_TAGGED;
		selp=malloc(sizeof(struct Selected));
		selp->type=SEL_MSGBASE;
		selp->conf_nr=conf.CONF_NUMBER;
		selp->ID=base.MSGBASE_NUMBER;
	
		AddTail(SelectList, (struct Node *)selp);
	}
	write(outfile,&base,sizeof(struct VMatik_MsgBase));
	j++;
	goto crossconf;
	
confsdone:
	close(outfile);
	chown("data/conferences.dat",uid,gid);
	
	outfile = open("data/selected.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}

	selp=(struct Selected *)SelectList->lh_Head;
	while(selp->shead.ln_Succ)
	{
		write(outfile, selp, sizeof(struct Selected));
		selp=(struct Selected *)selp->shead.ln_Succ;
	}
	
	close(outfile);
	chown("data/selected.dat",uid,gid);
	src=findtxt(inmem,"!EXTERNALCOMMANDS.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for EXTERNALCOMMANDS.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/externalcommands.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}
nextdoor:

	src=nextspace(src);

	memset(&extcom, 0, sizeof(struct VMatik_ExternalCommand));

	cfgcopy(extcom.EXT_NAME,sizeof(extcom.EXT_NAME));
	extcom.EXT_CMDTYPE=cfgint();
	extcom.EXT_SECLEVEL=cfgint();
	if(extcom.EXT_SECLEVEL>31)
		printf("Warning: Max seclevel is 31!\n");
	cfgcopy(extcom.EXT_COMMAND,sizeof(extcom.EXT_COMMAND));
	extcom.EXT_CONF1=cfgconf();
	extcom.EXT_CONF2=cfgconf();
	
	write(outfile,&extcom,sizeof(struct VMatik_ExternalCommand));
	if (*src=='+') goto nextdoor;
	if (*src!='~') {
		fprintf(stderr,"Error in externalcommands.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/externalcommands.dat",uid,gid);
	src=findtxt(inmem,"!ARCHIVERS.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for ARCHIVERS.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/archivers.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr, "Can not open output file!\n\n");
		return(-1);
	}
nextarc:

	src=nextspace(src);

	memset(&arc, 0, sizeof(struct VMatik_Archiver));

	if (cfgflag("D")) arc.ARC_FLAGS |= ARC_DISK_ARCHIVER;
	cfgcopy(arc.ARC_PATTERN,sizeof(arc.ARC_PATTERN));
	cfgcopy(arc.ARC_NAME,sizeof(arc.ARC_NAME));
	cfgcopy(arc.ARC_CMD_TEST,sizeof(arc.ARC_CMD_TEST));
	cfgcopy(arc.ARC_CORRUPTED1,sizeof(arc.ARC_CORRUPTED1));
	cfgcopy(arc.ARC_CORRUPTED2,sizeof(arc.ARC_CORRUPTED2));
	cfgcopy(arc.ARC_CORRUPTED3,sizeof(arc.ARC_CORRUPTED3));
	cfgcopy(arc.ARC_TRANSFORM_TO, sizeof(arc.ARC_TRANSFORM_TO));
	cfgcopy(arc.ARC_CMD_TRANSFORM,sizeof(arc.ARC_CMD_TRANSFORM));
	cfgcopy(arc.ARC_CMD_VIRUSCHECK,sizeof(arc.ARC_CMD_VIRUSCHECK));
	cfgcopy(arc.ARC_INFECTED1,sizeof(arc.ARC_INFECTED1));
	cfgcopy(arc.ARC_INFECTED2,sizeof(arc.ARC_INFECTED2));
	cfgcopy(arc.ARC_INFECTED3,sizeof(arc.ARC_INFECTED3));
	cfgcopy(arc.ARC_EXTRACTFILEID,sizeof(arc.ARC_EXTRACTFILEID));
	cfgcopy(arc.ARC_ADDFILEID,sizeof(arc.ARC_ADDFILEID));
	cfgcopy(arc.ARC_VIEW,sizeof(arc.ARC_VIEW));
	if (cfgflag("Y")) arc.ARC_FLAGS |= ARC_OFFLINE;
	if (cfgflag("Y")) arc.ARC_FLAGS |= ARC_GETDATE;
	if (cfgflag("Y")) arc.ARC_FLAGS |= ARC_DELETECORRUPT;
	if (cfgflag("Y")) arc.ARC_FLAGS |= ARC_DISPLAY;
	arc.ARC_VIEWSEC=cfgint();
	if(arc.ARC_VIEWSEC>31)
		printf("Warning: Max seclevel is 31!\n");

	write(outfile,&arc,sizeof(struct VMatik_Archiver));
	if (*src=='+') goto nextarc;
	if (*src!='~') {
		fprintf(stderr,"Error in archiver.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/archivers.dat",uid,gid);
	src=findtxt(inmem,"!DISPLAY.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for DISPLAY.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/display.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}
nextdisp:

	src=nextspace(src);

	memset(&disp, 0, sizeof(struct VMatik_DisplayMode));

	disp.DISPLAY_ID=cfgint();
	cfgcopy(disp.DISPLAY_PATH,sizeof(disp.DISPLAY_PATH));
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_ENABLE_ANSI;
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_INCOMING_CONV;
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_OUTGOING_CONV;
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_FILE_CONV;
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_STRIP_ANSI;
	if (cfgflag("Y")) disp.DISPLAY_ATTRIBUTES |= DISP_NO_GFX_IS_TXT;
	disp.DISPLAY_INCOMING_TABLEID=cfgint();	
	disp.DISPLAY_OUTGOING_TABLEID=cfgint();
	disp.DISPLAY_STRINGS=cfgint();

	write(outfile,&disp,sizeof(struct VMatik_DisplayMode));
	if (*src=='+') goto nextdisp;
	if (*src!='~') {
		fprintf(stderr,"Error in display.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/display.dat",uid,gid);
	src=findtxt(inmem,"!MULTINODE.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for MULTINODE.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/multinode.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}
nextnode:

	src=nextspace(src);

	memset(&node, 0, sizeof(struct VMatik_Node));

	{
		char buf[10];
		cfgcopy(buf,4);
		if (*buf=='T' || *buf=='t') {
			node.Node_ID=maincfg.CFG_TELNET1ST;
			node.Node_TTYType=NODETYPE_TELNET;
		} else if (*buf=='L' || *buf=='l') {
			node.Node_ID=maincfg.CFG_LOCAL1ST;
			node.Node_TTYType=NODETYPE_LOCAL;
		} else {
			node.Node_ID=atoi(buf);
			node.Node_TTYType=NODETYPE_NORMAL;
		}
	}
	node.Node_MinBaud=cfgint();
	node.Node_MinBaudNew=cfgint();
	if (cfgflag("Y")) node.Node_Flags |= NODE_OWNDIR;
	if (cfgflag("Y")) node.Node_Flags |= NODE_NOTIFY;
	if (cfgflag("Y")) node.Node_Flags |= NODE_HIDEINACTIVE;
	if (cfgflag("Y")) node.Node_Flags |= NODE_HIDEWAIT;
	if (cfgflag("Y")) node.Node_Flags |= NODE_HIDECALL;
	if (cfgflag("Y")) node.Node_Flags |= NODE_NOPASSWD;
	cfgcopy(node.Node_TempDir,sizeof(node.Node_TempDir));
	cfgcopy(node.Node_TTYName,sizeof(node.Node_TTYName));
	node.Node_TTYSpeed=cfgint();
				
	write(outfile,&node,sizeof(struct VMatik_Node));
	if (*src=='+') goto nextnode;
	if (*src!='~') {
		fprintf(stderr,"Error in multinode.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/multinode.dat",uid,gid);
	src=findtxt(inmem,"!SECURITY.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for SECURITY.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/security.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr, "Can not open output file!\n\n");
		return(-1);
	}
nextsec:

	src=nextspace(src);

	memset(&sec, 0, sizeof(struct VMatik_Seclevel));

	sec.SEC_SECLEVEL=cfgint();
	if(sec.SEC_SECLEVEL>31)
		printf("Error: Max seclevel is 31!\n");
	sec.SEC_FILERATIO=cfgint();
	sec.SEC_BYTERATIO=cfgint();
	sec.SEC_PAGESPERCALL=cfgint();
	sec.SEC_DAILYTIME=cfgint();
	sec.SEC_CONFACC=((bint)cfgconf());
	sec.SEC_CONFACC|=((bint)cfgconf()<<32);
	
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_DOWNLOAD;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_UPLOAD;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_READMSG;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_ENTERMSG;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_PAGE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_COMMENT;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_BULLETINS;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_FILESCAN;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_NEWFILES;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_ZIPPYSEARCH;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_RUNDOOR;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_JOINCONF;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_CHANGEMSGAREA;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_CHANGEINFO;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_RELOGIN;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_TAGEDITOR;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_USERSTATS;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_VIEWTIME;
	if (cfgflag("Y")); // unused
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_EXPERTMODE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_EALLMESSAGE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_FIDOMESSAGE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_PUBLICMESSAGE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_READALL;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_USERED;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_VIEWLOG;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_SYSOPDL;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_USERLIST;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_DELETEANYMSG;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_REMOTESHELL;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_WHO;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_MOVEFILE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_SELECTFILECONFS;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_SELECTMSGBASES;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_SENDNETMAIL;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_OLM;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_PVTATTACH;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_PUBATTACH;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_VIEWFILE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_EDITREALNAME;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_EDITHANDLE;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_FREEFILES;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_FREEBYTES;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_COSYSOP;
	if (cfgflag("Y")) sec.SEC_ACCESSBITS |= SECB_SYSOP;
	
	write(outfile,&sec,sizeof(struct VMatik_Seclevel));
	if (*src=='+') goto nextsec;
	if (*src!='~') {
		fprintf(stderr,"Error in security.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/security.dat",uid,gid);
	
	src=findtxt(inmem,"!PROTOCOLS.DAT");
	if (src==0) {
		fprintf(stderr,"Can't find definitions for PROTOCOLS.DAT!\n\n");
		return(-1);
	}

	outfile = open("data/protocols.dat",O_CREAT|O_TRUNC|O_RDWR,mode);
	if (outfile == -1) {
		fprintf(stderr,"Can not open output file!\n\n");
		return(-1);
	}
nextproto:

	src=nextspace(src);

	memset(&proto, 0, sizeof(struct VMatik_Protocol));

	proto.Protocol_ID=cfgchar();
	cfgcopy(proto.Protocol_Name,
			sizeof(proto.Protocol_Name));
	cfgcopy(proto.Protocol_SendCommand,
			sizeof(proto.Protocol_SendCommand));
	cfgcopy(proto.Protocol_ReceiveCommand,
			sizeof(proto.Protocol_ReceiveCommand));
	proto.Protocol_Efficiency=cfgint();
	proto.Protocol_Type=cfgint();

	write(outfile,&proto,sizeof(struct VMatik_Protocol));
	if (*src=='+') goto nextproto;
	if (*src!='~') {
		fprintf(stderr,"Error in protocols.dat!\n\n%30.30s",src);
		close(outfile);
		return(-1);
	}	
	close(outfile);
	chown("data/protocols.dat",uid,gid);
	if(!mymkdir("bulletins"))
		return(-1);
	if(!mymkdir("logfiles"))
		return(-1);
	if(!mymkdir("questionnaire"))
		return(-1);
	if(!mymkdir("users"))
		return(-1);
	if(!mymkdir("temp"))
		return(-1);
	if(!mymkdir("configs"))
		return(-1);

	return(0);
}

int cfgconf(void)
{
	int confs=0;
	int i;
	
	for (i=0; i != 32 ; i++)
	{
		if(*src=='X') confs |= (1L << i);
		src++;
	}
	while(*src!=10 && *src!=13) src++;
	src=nextspace(src);
	return confs;
}

char cfgchar()
{
	char charru;
	
	charru=src[0];
	while(*src!=10 && *src!=13) src++;
	src=nextspace(src);
	return charru;
}
 
int cfgflag(char *on)
{
	int res=0;
	
	if (src[0]==on[0]) res=1;

	while(*src!=10 && *src!=13) src++;
	src=nextspace(src);

	return res;
}

int cfgint()
{
	char	intb[50];
	int i;
	for(i=0;i<50; i++) {
		if (src[i]==10 || src[i]==13) break;
		intb[i]=src[i];
	}
	intb[i]=0;
	while(src[i]==' ') i++;
	
	src=nextspace(&src[i]);
	return atoi(intb);

}


int cfgfnadd(char *s, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point)
{
	s=cfgfnadd2(s,zone,net,node,point);
	src=nextspace(s);

	return(1);
}

char * cfgfnadd2(char *s, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point)
{
	char cb[1024];
	char *t;
	*zone=*net=*node=*point=0;
	
	if (*s=='-'||*s==10||*s==13||*s < '0' || *s > '9') {
		return s;
	}
	
	t=cb;
	while(*s!=':' && *s) *t++=*s++;
	*t=0;
	*zone=atoi(cb);
	if (!*s) return s; else s++;
	
	t=cb;
	while(*s!='/' && *s) *t++=*s++;
	*t=0;
	*net=atoi(cb);
	if (!*s) return s; else s++;

	t=cb;
	while(*s!='.' && *s && *s!=13 && *s!=10) *t++=*s++;
	*t=0;
	*node=atoi(cb);
	if (!*s || *s==13 || *s==10) return s; else s++;

	t=cb;
	while(*s && *s!=10 && *s!=13) *t++=*s++;
	*t=0;
	*point=atoi(cb);
	return s;

}
 
char *cfgcopy(char *dest, int max)
{
	int i;

	if (src[0]=='-' && src[1]==10) {
		dest[0]=0;
		src=nextspace(&src[1]);
		return(dest);
	}
	
	for (i=0;i < max ; i++) {
		if (src[i]==10 || src[i]==13) break;
		dest[i]=src[i];
	}
	dest[i]=0;
	if (i==max) {
		src=&src[i];
		while(*src!=10 && *src!=13) src++;
		i=0;
	}
	removespaces(dest);
	src=nextspace(&src[i]);
	return(dest);
}

void removespaces(char *strh)
{
	char *s;
	s=strh;
	if (!*s) return;
	while(*s) s++;
	s--;
	while (*s==' ') s--;
	*(s+1)=0;
}

char *nextspace(char *s)
{
	while (*s!=' ') {
		if (*s==10 && s[1] == '~') break;
		if (*s==10 && s[1] == '+') break;
		if (*s==10 && s[1] == '*') break;
		if (*s==10 && s[1] == '&') break;
		s++;
	}
	s++;
	return s;
}

char *findtxt(char *buffer, char *text)
{
	char *s;
	char *buffb;
nextline:
	while(*buffer!=10) {
		if (*buffer==0) return 0;
		buffer++;
	}
	
	buffer++;
	s=text;
	buffb=buffer;
	
	for(;;)
	{
		if (*s==0) return buffb;
		if (*buffer!=*s) goto nextline;
		s++; buffer++;
	}
}

char *ecfg(char *hay, char *need)
{
	char *s;
	while(1)
	{
		s=need;
		if (*hay==0) return 0;
		if (*hay==';') { 
			while(*hay!=10) {
				if(*hay==0) return 0;
				hay++;
			}
			continue;
		}
		while (1) {
			if (*s++==*hay++) {
				if (*s==0) return hay;
			} else {
				break;
			}
		}
	}
}

/*
 * Makes a directory, changes permissions
 *
 * Returns 0 on failure, 1 on success.
 *
 */
int mymkdir(char *dir)
{
	int result1,result2;
	struct stat st;

	if(stat(dir, &st)==0)
		return(1);

	result1=mkdir(dir,dmode);
	result2=chown(dir,uid,gid);

	if(result1!=0 || result2!=0)
	{
		fprintf(stderr, "Failed to create %s directory!\n",dir);
		return(0);
	}
	
	return(1);
}

