/* 
 * Messagebase optimizer/maintainer for VMatik
 *
 * Note: it hasn't been tested ... You shouldn't execute it
 * unless you know what you're doing. I don't.
 *
 */

#include "../lib/ddlib.h"
#include "struct.h"
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <dirent.h>

int massmode=0;
int eallage=0;
int confn, basen;

struct VMatik_MainConfig maincfg;

int usage();
int optbase(struct VMatik_Conference *conf, struct VMatik_MsgBase *base);
int deldir(char *dir);

int main(int argc, char *argv[])
{
	int cfgfd;
	char buf[512];

	if (argc<2) {
		usage();
		return 0;
	}
	if (!strcasecmp(argv[1],"all")) {
		massmode++;
		if (argc==3) eallage=atoi(argv[2]);
	} else if (argc>2) {
		confn=atoi(argv[1]);
		basen=atoi(argv[2]);
		if (argc==4) eallage=atoi(argv[3]);
	} else {
		usage();
	}

        sprintf(buf,"%s/data/vmatik.dat",getenv("VMATIK"));
        cfgfd=open(buf,O_RDONLY);
        if (cfgfd < 0) {
                perror("Can't open DD datafiles");
                exit(0);
        }
        read(cfgfd,&maincfg,sizeof(struct VMatik_MainConfig));
        close(cfgfd);

        setgid(maincfg.CFG_BBSGID);
        setegid(maincfg.CFG_BBSGID);
        setuid(maincfg.CFG_BBSUID);
        seteuid(maincfg.CFG_BBSUID);

	eallage=eallage*60*60*24;

	if (massmode) {
		struct VMatik_Conference *cd;
		struct VMatik_Conference *confs;
		struct VMatik_MsgBase *bd;

		confs=(struct VMatik_Conference *)VMatik_getconfdata();
	
		if (!confs) exit (0);
		cd=confs;

		while(1)
		{
			int bcnt;
		
			if (cd->CONF_NUMBER==255) break;
		
			(struct VMatik_Conference *)bd=cd+1;
			bcnt=cd->CONF_MSGBASES;

			for(bcnt=cd->CONF_MSGBASES;bcnt;bcnt--,bd++)
			{
				optbase(cd,bd);
			}
			(struct VMatik_MsgBase *)cd=bd;
		}
	} else {
		struct VMatik_Conference *cd;
		struct VMatik_MsgBase *bd;

		cd=VMatik_getconf(confn);
		bd=VMatik_getbase(confn,basen);
		if(!bd || !cd) {
			fprintf(stderr,"No such msgbase!\n");
			return 0;
		}
		optbase(cd,bd);
	}

	return(0);
}


int usage()
{
	fprintf(stderr,"Usage:\n"
		"Single base mode: msgbaseopt [conf] [base] {max age in days for eall msgs}\n"
		"Mass mode:        msgbaseopt all {max age in days for eall msgs}\n");
		return 0;

}

int optbase(struct VMatik_Conference *conf, struct VMatik_MsgBase *base)
{
	char buf1[512];
	char buf2[512];
	char buf3[512];
	struct stat st;
	int i;
	int dc=0;
	int oldf, newf;
	struct VMatik_Message msg;
	struct VMatik_MsgPointers mp;
	struct VMatik_LRP lrp;
	printf("%s/%s: ",conf->CONF_NAME,base->MSGBASE_NAME);

	sprintf(buf1,"%smessages/base%3.3d/msgbase.dat",conf->CONF_PATH,base->MSGBASE_NUMBER);
	oldf=open(buf1,O_RDONLY);
	if (oldf<0) {
		printf("can't open msgbase.\n");
		return 0;
	}
	sprintf(buf2,"%smessages/base%3.3d/msgbase.new",conf->CONF_PATH,base->MSGBASE_NUMBER);
	newf=open(buf2,O_WRONLY|O_CREAT|O_TRUNC,0644);
	if (newf<0) {
		close(oldf);
		printf("can't open msgbase.\n");
		return 0;
	}

	/* remove deleted msgs */
	while(read(oldf,&msg,sizeof(struct VMatik_Message))) {
		sprintf(buf3,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg.MSG_NUMBER);
		if (stat(buf3,&st)==-1) continue;
		if (*msg.MSG_RECEIVER==-1 && eallage) {
			if (msg.MSG_CREATION < (time(0)-eallage)) *msg.MSG_RECEIVER=0;
		}
		write(newf,&msg,sizeof(struct VMatik_Message));
	}
	close(oldf);
	close(newf);
	unlink(buf1);
	rename(buf2,buf1);

	/* Recycle */
	if (stat(buf1,&st)==-1) return 0;
	if (st.st_size/sizeof(struct VMatik_Message) > base->MSGBASE_MSGLIMIT) {

		oldf=open(buf1,O_RDONLY);
		newf=open(buf2,O_WRONLY|O_CREAT|O_TRUNC,0644);

		for( (i=st.st_size/sizeof(struct VMatik_Message));i>base->MSGBASE_MSGLIMIT ; i--) {
			if (read(oldf,&msg,sizeof(struct VMatik_Message))==sizeof(struct VMatik_Message)) {
				sprintf(buf3,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg.MSG_NUMBER);
				unlink(buf3);
				if (*msg.MSG_ATTACH == 1) {
					sprintf(buf3,"%smessages/base%3.3d/fa%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg.MSG_NUMBER);
					deldir(buf3);
					unlink(buf3);
					sprintf(buf3,"%smessages/base%3.3d/msf%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg.MSG_NUMBER);
					unlink(buf3);
				}
				dc++;
			}
			

		}
		while(read(oldf,&msg,sizeof(struct VMatik_Message))) {
			write(newf,&msg,sizeof(struct VMatik_Message));
		}
		close(oldf);
		close(newf);
		unlink(buf1);
		rename(buf2,buf1);

	}
	/* Fix pointers */

	oldf=open(buf1,O_RDONLY);
	if (oldf < 0) return 0;
			
	read(oldf,&msg,sizeof(struct VMatik_Message));
	mp.msp_low=msg.MSG_NUMBER;
	lseek(oldf,-(sizeof(struct VMatik_Message)),SEEK_END);
	read(oldf,&msg,sizeof(struct VMatik_Message));
	mp.msp_high=msg.MSG_NUMBER;

	close(oldf);

	sprintf(buf3,"%smessages/base%3.3d/msgbase.ptr",conf->CONF_PATH,base->MSGBASE_NUMBER);
	newf=open(buf3,O_WRONLY|O_TRUNC|O_CREAT,0644);
	if (newf < 0) return dc;
	write(newf,&mp,sizeof(struct VMatik_MsgPointers));
	close(newf);
	
	/* Fix lrps */

	sprintf(buf3,"%smessages/base%3.3d/msgbase.lrp",conf->CONF_PATH,base->MSGBASE_NUMBER);
	
	oldf=open(buf3,O_RDWR);
	if (oldf < 0) return 0;
	while(read(oldf,&lrp,sizeof(struct VMatik_LRP))) {
		if (lrp.lrp_read > mp.msp_high) lrp.lrp_read=mp.msp_high;
		if (lrp.lrp_scan > mp.msp_high) lrp.lrp_scan=mp.msp_high;
		lseek(oldf,-sizeof(struct VMatik_LRP),SEEK_CUR);
		write(oldf,&lrp,sizeof(struct VMatik_LRP));
	}
	close(oldf);
	printf("%d deleted\n",dc);
	return dc;

}

int deldir(char *dir)
{
	DIR *dirfd;
	struct dirent *ent;
	char tempbuf[1024];
	
	if ((dirfd=opendir(dir)))
	{
		while((ent=readdir(dirfd)))
		{
			struct stat st;

			if ( (ent->d_name[0]=='.' && ent->d_name[1]==0) || (ent->d_name[0]=='.' && ent->d_name[1]=='.' && ent->d_name[2]==0)) continue;
			sprintf(tempbuf,"%s/%s",dir,ent->d_name);
			stat(tempbuf,&st);

			if (S_ISDIR(st.st_mode)) {
				deldir(tempbuf);
				rmdir(tempbuf);
			} else {
				unlink(tempbuf);
			}
		}
		closedir(dirfd);
	} 

	return(1);
}






