/*
 * Goes through the filebase and determines which files
 * are not available and marks them as FILE_OFFLINE.
 *
 */

#include "proto.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

struct markedfiles
{
	unsigned long file_id;
	struct markedfiles *next;
};

int mark_offline(void)
{
	MYSQL db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	unsigned long marked_files=0;
	unsigned long total_files=0;
	struct markedfiles *marked=NULL;
	struct markedfiles *tmp;
	struct stat st;

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

/******** reset the current offline settings ********/

	fprintf(stderr, "Resetting all offline values...\n");
	sprintf(query, "UPDATE vmatik_filelist 
					SET file_flags=(file_flags & %ld)",
					~FILE_OFFLINE);
	mysql_query(&db, query);
		
/******** check if files really exist *******/

	fprintf(stderr, "Checking files...\n");

	sprintf(query, "SELECT file_name, file_id, area_filepath 
					FROM vmatik_filelist, vmatik_fileareas 
					WHERE file_area=area_id");
	mysql_query(&db, query);
	if(mysql_error(&db)[0])
		return(-1);
	sql_res=mysql_use_result(&db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		sprintf(query, "%s%s", sql_row[2], sql_row[0]);
		if(stat(query, &st)!=0)
		{
			tmp=malloc(sizeof(struct markedfiles));
			if(!tmp)
			{
				printf("Eeek, out of mem!\n");
				break;
			}
				
			tmp->file_id=atoi(sql_row[1]);
			tmp->next=NULL;

			if(!marked)
				marked=tmp;
			else
			{
				tmp->next=marked;
				marked=tmp;
			}

			marked_files++;
		}
		total_files++;
		if(total_files%500==0)
			printf("[%6ld/%6ld] offline\n", marked_files, total_files);
	}

	mysql_free_result(sql_res);
	
/**** assign FILE_OFFLINE for marked files ******/

	fprintf(stderr, "Assigning FILE_OFFLINE for them...\n");

	tmp=marked;
	while(tmp)
	{
		sprintf(query, "UPDATE vmatik_filelist
						SET file_flags=(file_flags | %ld)
						WHERE file_id=%ld", FILE_OFFLINE, tmp->file_id);
		mysql_query(&db, query);
		if(mysql_error(&db)[0])
			fprintf(stderr, "%s\n", mysql_error(&db));
		tmp=tmp->next;
		free(marked);
		marked=tmp;
	}

	mysql_close(&db);
	return(marked_files);
}
	

int main(int argc, char *argv[])
{
	int marked_files;

	printf("Checking & marking offline files...\n");
		
	marked_files=mark_offline();

	fprintf(stderr, "Done, %d files marked as offline.\n", marked_files);
		
	return(0);
}

