/* 
 * Takes a pattern as argument, returns matched filenames from database
 *
 * Note: Wildcards valid
 *
 * Usage: Add -p to print pathnames as well
 *
 */

#include <stdio.h>
#include "proto.h"
#include "struct.h"

void usage(char *com)
{
	printf("Usage: %s [-p] <file pattern>\n", com);
}

int main(int argc, char *argv[])
{
	char query[QUERY_MAX];
	char temp_fn[NAME_MAX];
	MYSQL vm_database;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int i=0,j=0,files_found=0;
	int go=1,path_too=0;
	
	if(argc<2)
	{
		usage(argv[0]);
		return(0);
	}

	while(go)
	{
		switch(getopt(argc, argv, "hp"))
		{
			case 'p':
				path_too=1;
				break;
			case -1:
				go=0;
				break;
			case 'h':
				usage(argv[0]);
				return(0);
				break;
			default:
				break;
		}
	}
	

	mysql_connect(&vm_database, NULL, SQL_USER, SQL_PASSWD);
	mysql_select_db(&vm_database, "vmatik");

//	mysql_escape_string(escaped_fn, argv[1], strlen(argv[1]) );
	
	while(argv[path_too+1][i]!=0)
	{
		switch(argv[path_too+1][i])
		{
			case '*':
				temp_fn[j++]='%';
				break;
			case '?':
				temp_fn[j++]='_';
				break;
			case '%':
				temp_fn[j++]='\\';
				temp_fn[j++]='%';
				break;
			case '_':
				temp_fn[j++]='\\';
				temp_fn[j++]='_';
				break;
			default:
				temp_fn[j++]=argv[path_too+1][i];
				break;
		}
		i++;
	}
	temp_fn[j]=0;

	do
	{
		go=0;

		sprintf(query, "SELECT file_name %s
						FROM vmatik_filelist %s
						WHERE file_name like '%s' %s
						ORDER BY file_name", 
						(path_too ? ",area_filepath" : ""),
						(path_too ? ",vmatik_fileareas" : ""),
						temp_fn,
						(path_too ? "AND file_area=area_id" : ""));
//		printf("%s\n", query);
		mysql_query(&vm_database,query);
		
		if(mysql_error(&vm_database)[0])
		{
			printf("%s\n", mysql_error(&vm_database));
			break;
		}
		sql_result=mysql_use_result(&vm_database);
		if(sql_result)
		{
			while((sql_row=mysql_fetch_row(sql_result)))
			{
				if(path_too)
					printf("%s %s\n", sql_row[1], sql_row[0]);
				else
					printf("%s\n", sql_row[0]);
				files_found++;
			}	
			
			mysql_free_result(sql_result);
		}
		if(path_too && files_found==0)
		{
			path_too=0;
			go=1;
		}
	} while (go);
	
	mysql_close(&vm_database);
		
	return(0);
}


			
