/*
 *
 * Changes backup ids in filebases.
 *
 * Takes command line argument in the form of "<dir> <area_id> <backup_id>"
 *
 * Operation: Parses through the directory <dir>. For every file
 *            found, the backup_id in database is set to <backup_id>, 
 *            if that file exists on area with id <area_id>.
 *
 */

#include "proto.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <dirent.h>

#define BUFFSIZE 512

char *str2lc(char *src)
{
	char *temp=src;

	if(!temp)
		return(0);
	
	while(*temp)
	{
		*temp=tolower(*temp);
		temp++;
	}

	return(src);
}

int main(int argc, char *argv[])
{
	MYSQL db;
	char buffer[BUFFSIZE];
	char query[QUERY_MAX];
	int area_id,backup_id;
	int total_files=0;
	DIR *dirri;
	struct dirent *dentry;

	if(argc!=4)
	{
		fprintf(stderr, "Usage: <dir> <area_id> <backup_id>\n");
		return(0);
	}

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

	dirri=opendir(argv[1]);
	if(!dirri)
	{
		fprintf(stderr, "Unable to open %s\n", argv[1]);
		mysql_close(&db);
		return(0);
	}

	area_id=atoi(argv[2]);
	backup_id=atoi(argv[3]);

	while((dentry=readdir(dirri)))
	{
		mysql_escape_string(buffer, dentry->d_name, strlen(dentry->d_name));
		
		sprintf(query, "UPDATE vmatik_filelist SET file_backup=%d
						WHERE file_name='%s' AND file_area=%d",
						backup_id, buffer, area_id);
		mysql_query(&db, query);
		if(mysql_error(&db)[0])
			fprintf(stderr, "%s\n", mysql_error(&db));
		else
			total_files++;
	}

	mysql_close(&db);

	fprintf(stderr, "%d files in dir processed\n", total_files);
	
	return(0);
}
	
