/*
 * Exterminator deletes all actual files associated with <backup_id>,
 * and gives them a FILE_OFFLINE status to database.
 *
 */

#include "proto.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

struct deldfiles
{
	unsigned long file_id;
	struct deldfiles *next;
};

int exterminate(int backup_id)
{
	MYSQL db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	int deleted_files=0;
	struct deldfiles *deleted=NULL;
	struct deldfiles *tmp;

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

/******** fetch files with suitable backup id's *******/

	fprintf(stderr, "Deleting files...\n");

	sprintf(query, "SELECT file_name, file_area, file_id,
					area_filepath FROM
					vmatik_filelist, vmatik_fileareas WHERE 
					file_backup=%d AND file_area=area_id",
					backup_id);
	mysql_query(&db, query);
	if(mysql_error(&db)[0])
		return(-1);
	sql_res=mysql_use_result(&db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		sprintf(query, "%s%s", sql_row[3], sql_row[0]);
		unlink(query);
//		printf("%s\n", query);

		tmp=malloc(sizeof(struct deldfiles));
		if(!tmp)
		{
			printf("Aeee! Out of memory!\n");
			break;
		}
		tmp->file_id=atoi(sql_row[2]);
		tmp->next=NULL;

		if(!deleted)
			deleted=tmp;
		else
		{
			tmp->next=deleted;
			deleted=tmp;
		}

		deleted_files++;
	}

	mysql_free_result(sql_res);
	
/**** assign FILE_OFFLINE for deleted files ******/

	fprintf(stderr, "Assigning FILE_OFFLINE for them...\n");

	tmp=deleted;
	while(tmp)
	{
		sprintf(query, "UPDATE vmatik_filelist
						SET file_flags=(file_flags | %ld)
						WHERE file_id=%ld", FILE_OFFLINE, tmp->file_id);
		mysql_query(&db, query);
		if(mysql_error(&db)[0])
			fprintf(stderr, "%s\n", mysql_error(&db));
		tmp=tmp->next;
		free(deleted);
		deleted=tmp;
	}

	mysql_close(&db);
	return(deleted_files);
}
	

int main(int argc, char *argv[])
{
	int deleted_files;

	if(argc!=2)
	{
		fprintf(stderr, "Usage: %s <backup_id>\n", argv[0]);
		return(-1);
	}

	if(atoi(argv[1])<=0)
	{
		fprintf(stderr, "Only accepts backup_ids >0\n");
		return(-1);
	}
		
	deleted_files=exterminate(atoi(argv[1]));

	fprintf(stderr, "Done, %d files deleted.\n", deleted_files);
		
	return(0);
}

