/* 
 * Checks if file exists in vmatik databases
 * 
 * Should receive a single filename as input
 *
 * Returns 1 if file found, 0 if not
 *
 * Note: It doesn't count files which are broken (INTEGRITY_FAILED)
 *
 */

#include <stdio.h>
#include "proto.h"
#include "struct.h"

int main(int argc, char *argv[])
{
	char query[QUERY_MAX];
	MYSQL vm_database;
	MYSQL_RES *sql_result;
	
	if(argc!=2)
		return(0);
	
	mysql_connect(&vm_database, NULL, SQL_USER, SQL_PASSWD);
	mysql_select_db(&vm_database, "vmatik");

	sprintf(query, "SELECT 1 
					FROM vmatik_filelist 
					WHERE file_name='%s' AND file_integrity!=%d",
					argv[1], INTEGRITY_FAILED);
	mysql_query(&vm_database,query);
	sql_result=mysql_store_result(&vm_database);
	if(!sql_result)
	{
		mysql_close(&vm_database);
		return(0);
	}

	if(mysql_num_rows(sql_result)>0)
	{
		mysql_free_result(sql_result);
		mysql_close(&vm_database);
		return(1);
	}
	
	mysql_free_result(sql_result);
	mysql_close(&vm_database);

//	printf("NotFound!\n");
	
	return(0);
}


			
