/*
 * clist v0.02
 *
 * Filelist creator for vmatik
 *
 * Usage: clist <cfg_file>
 *
 * Default cfg file is "clist.cfg" in the current directory. Check
 * it out for examples.
 *
 * It's year 2000 compatible! OH YEAH! =)
 *
 */

#include "proto.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define LINEBUFSIZE 1024

char def_cfgfile[]="clist.cfg";

char *fgetsnolf(char *buf, int n, FILE *fh);

int output_formatted_row(FILE *dp, MYSQL_ROW second_row)
{
	int kilobytes,i=0,c=0;
	char kbs_string[20];

	kilobytes=atoi(second_row[1])/1000;
	if(kilobytes<1000)
		sprintf(kbs_string, "%dk", kilobytes);
	else
	{	
		kilobytes=kilobytes/1000;
		sprintf(kbs_string, "%3dM", kilobytes);
	}

	second_row[2][4]=0;			// To display date in euro format DD-MM-YYYY
	second_row[2][7]=0;
					
	fprintf(dp, "%-19.19s %4.4s %2.2s-%2.2s-%4.4s ",
				second_row[0], kbs_string, 
				&second_row[2][8], &second_row[2][5], second_row[2]);

	while(second_row[3][i])
	{
		if(second_row[3][i]=='\n' || c==45)
		{	
			fprintf(dp,"\n                                    ");
			c=0;
		}
		if(second_row[3][i]!='\n')
			fputc(second_row[3][i], dp);
		i++;c++;
	}
	fprintf(dp, "\n");
	
	return(1);
}

int parse_cfgfile(char *cfgfile)
{
	MYSQL db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	char linebuffer[LINEBUFSIZE];
	char shortbuf[120];
	char emptybuf[120];
	FILE *fp;
	FILE *dp=NULL;
	int k;

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

	fp=fopen(cfgfile, "r");
	if(!fp)
	{
		mysql_close(&db);
		fprintf(stderr, "Unable to open %s.\n", cfgfile);
		return(0);
	}

	shortbuf[0]='+';			// +----------+ 
	shortbuf[79]='+';
	for(k=1;k<79;k++)
		shortbuf[k]='-';
	shortbuf[80]=0;

	emptybuf[0]='+';			// +          +
	emptybuf[79]='+';
	for(k=1;k<79;k++)
		emptybuf[k]=' ';
	emptybuf[80]=0;
	
	fprintf(stderr, "Using '%s'...\n", cfgfile);

	while(fgetsnolf(linebuffer, LINEBUFSIZE, fp))
	{
		if(linebuffer[0]=='#') {								// A comment
			continue;
		} else if(!strncasecmp(linebuffer, "HEADER ", 7)) {
			FILE *hf;

			if(!dp)
			{
				fprintf(stderr, "Error: Header can't append before OUTFILE is defined!\n");
				continue;
			}

			hf=fopen(&linebuffer[7], "r");
			if(!hf)
			{
				fprintf(stderr, "Unable to open %s.\n", &linebuffer[8]);
				continue;
			}
		
			while(fgetsnolf(linebuffer, LINEBUFSIZE, hf))
			{
				fprintf(dp, linebuffer);
			}
	
			fclose(hf);
		
		} else if(!strncasecmp(linebuffer, "OUTFILE ", 8)) {
			if(dp)
				fclose(dp);
			dp=fopen(&linebuffer[8], "w");
			if(!dp)
			{
				fprintf(stderr, "Unable to open %s.\n", &linebuffer[8]);
				mysql_close(&db);
				return(0);
			}
			fprintf(stderr, "Outputting into '%s'\n", &linebuffer[8]);
		} else if(!strncasecmp(linebuffer, "PATTERN ", 8)) {
			fprintf(stderr, "Parsing %s ...\n", &linebuffer[8]);
			if(!dp)
			{
				fprintf(stderr, "Yikes, no OUTFILE specified in %s\n", 
								cfgfile);
				mysql_close(&db);
				return(0);
			}

			sprintf(query, "SELECT area_id, area_name FROM vmatik_fileareas
							WHERE area_name LIKE '%s'
							ORDER BY area_displayat", &linebuffer[8]);
			mysql_query(&db, query);
			sql_result=mysql_store_result(&db);
			if(sql_result)
			{
				MYSQL_RES *second_res;
				MYSQL_ROW second_row;
				int i,spaces,tempnum,areaheaderput;

				for(i=0;i<mysql_num_rows(sql_result);i++)
				{
					areaheaderput=0;	
					sql_row=mysql_fetch_row(sql_result);
					fprintf(stderr, " - %s\n", sql_row[1]);

					sprintf(query, "SELECT file_name, file_size, file_uldate, 
									file_description
									FROM vmatik_filelist 
									WHERE file_area=%d 
									AND (file_flags & %ld) 
									AND NOT (file_flags & %ld)
									ORDER BY file_name",
									atoi(sql_row[0]),
									FILE_VALIDATED,
									FILE_OFFLINE);
					mysql_query(&db, query);
					if(mysql_error(&db)[0])
						break;

					second_res=mysql_use_result(&db);
					
					while((second_row=mysql_fetch_row(second_res)))
					{
						if(!areaheaderput)
						{
							tempnum=strlen(sql_row[1]);
							fputc('\n', dp);
							fprintf(dp, "%s\n%s\n", 
									shortbuf, emptybuf);
							
							spaces=(80-tempnum)/2;
							fputc('+', dp);
							for(k=1;k<spaces;k++)
								fputc(' ', dp);
							fprintf(dp, "%s", sql_row[1]);
							for(k=1;k<spaces;k++)
								fputc(' ', dp);
							if((tempnum % 2) != 0)
								fputc(' ', dp);
							fputc('+', dp);
							fputc('\n', dp);
	
							fprintf(dp, "%s\n", emptybuf);
							fprintf(dp, "%s\n", shortbuf);
							areaheaderput=1;	
						}	
						output_formatted_row(dp, second_row);
					}

					if(areaheaderput)
						fprintf(dp, "\n\n");

					mysql_free_result(second_res);
					
				}
				mysql_free_result(sql_result);
			}
		}
	}

	fclose(fp);

	if(dp)
		fclose(dp);

	mysql_close(&db);
	
	return(1);
}
	

int main(int argc, char *argv[])
{
	char *cfgfile;

	if(argc>2)
	{
		printf("Usage: clist <cfg_file>\n");
		return(0);
	}
	
	if(argc==2)
		cfgfile=argv[1];
	else
		cfgfile=def_cfgfile;

	parse_cfgfile(cfgfile);

	fprintf(stderr, "Done.\n");
		
	return(1);
}

/*
 * fgets without the LineFeed in end of result
 *
 */
char *fgetsnolf(char *buf, int n, FILE *fh)
{
	char *hih, *s;

	hih=fgets(buf,n,fh);
	if(!hih)
		return(0);
	s=buf;
	while(*s)
	{
		if(*s==13 || *s==10)
		{
			*s=0;
			break;
		}
		s++;
	}
	return(hih);
}

