/* 
 * This util deletes files from <area_id> which exist on other
 * areas. Works on filename basis only.
 *
 * Use with caution!
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "proto.h"
#include "struct.h"

int main(int argc, char *argv[])
{
	char query[QUERY_MAX];
	char nambuf[PATH_MAX];
	char nambuf2[2*PATH_MAX];
	MYSQL vm_database;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	FILE *fp;
	int area_id,len;
	
	if(argc!=2)
	{
		printf("Usage: %s <area_id>\n", argv[0]);
		return(0);
	}
	
	area_id=atoi(argv[1]);
	if(area_id<1)
	{
		printf("Area id %d not allowed\n", area_id);
		return(-1);
	}
	
	mysql_connect(&vm_database, NULL, SQL_USER, SQL_PASSWD);
	mysql_select_db(&vm_database, "vmatik");

	sprintf(query, "SELECT file_name 
					FROM vmatik_filelist
					WHERE file_area<>%d", area_id);
	mysql_query(&vm_database, query);
	sql_res=mysql_use_result(&vm_database);
	if(!sql_res)
	{
		printf("Nothing found...\n");
		mysql_close(&vm_database);
		return(-1);
	}	

	fp=tmpfile();
	if(!fp)
	{
		printf("Unable to use tmpfile()\n");
		mysql_close(&vm_database);
		return(-1);
	}

	printf("Reading all filenames (skipping %d)\n", area_id);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		fprintf(fp, "%s\n", sql_row[0]);
	}

	mysql_free_result(sql_res);

	rewind(fp);

	printf("Deleting found files from %d\n", area_id);

	while(fgets(nambuf, PATH_MAX, fp))
	{
		len=strlen(nambuf)-1;
		nambuf[len]=0;

		mysql_escape_string(nambuf2, nambuf, len); 

		sprintf(query, "DELETE FROM vmatik_filelist
						WHERE file_name='%s' AND file_area=%d",
						nambuf2, area_id);
		mysql_query(&vm_database, query);
	}

	fclose(fp);

	mysql_close(&vm_database);

	return(0);
}
			
