/*
 * Adopter goes through every filearea and adds missing files to the
 * filedatas. (==File exists in directory, but not in database)
 *
 * Files are added unvalidated as default.
 * -a toggles automatic validation.
 *
 */

#include "proto.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

int Verbose=0;
int Validate=0;

struct fileareas
{
	char area_filepath[PATH_MAX];
	int area_id;
	struct fileareas *next;
};

int adopt(void)
{
	MYSQL db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	int added_files=0,inserted_per_area;
	struct fileareas *areas=NULL;
	struct fileareas *tmp;
	DIR *dirri;
	struct dirent *dirdata;
	struct stat st;

	mysql_connect(&db, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		return(0);
	}
	mysql_select_db(&db, "vmatik");
	if(mysql_error(&db)[0])
	{
		printf("%s\n", mysql_error(&db));
		mysql_close(&db);
		return(0);
	}

/******** find directories of all fileareas  *******/

	fprintf(stderr, "Browsing fileareas...\n");

	mysql_query(&db, "SELECT area_filepath, area_id FROM vmatik_fileareas");
	if(mysql_error(&db)[0])
		return(-1);
	sql_res=mysql_use_result(&db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		tmp=malloc(sizeof(struct fileareas));
		strcpy(tmp->area_filepath, sql_row[0]);
		tmp->area_id=atoi(sql_row[1]);
		tmp->next=NULL;

		if(!areas)
			areas=tmp;
		else
		{
			tmp->next=areas;
			areas=tmp;
		}
	}
	mysql_free_result(sql_res);
	
/**** go through the areas ******/

	tmp=areas;
	while(tmp)
	{
		fprintf(stderr, "Checking %s\n", tmp->area_filepath);
		inserted_per_area=0;
		
		chdir(tmp->area_filepath);

		dirri=opendir(tmp->area_filepath);
		if(!dirri)
		{	
			fprintf(stderr, "Unable to open dir %s\n", tmp->area_filepath);
			tmp=tmp->next;
			free(areas);
			areas=tmp;
			continue;
		}

		while((dirdata=readdir(dirri)))
		{
			if(stat(dirdata->d_name, &st)!=0)
			{
				fprintf(stderr, "stat() error on %s%s\n", 
						tmp->area_filepath, dirdata->d_name);
				continue;
			}
			
			if(!(S_ISREG(st.st_mode) || S_ISLNK(st.st_mode))
				|| S_ISDIR(st.st_mode))
				continue;

			sprintf(query, "SELECT 1 FROM vmatik_filelist
							WHERE file_name='%s' AND file_area=%d",
					dirdata->d_name, tmp->area_id);
			mysql_query(&db, query);
			if(mysql_error(&db)[0])
				fprintf(stderr, "%s\n", mysql_error(&db));
			sql_res=mysql_store_result(&db);
			if(mysql_num_rows(sql_res)>0)			// File exists?
			{
				mysql_free_result(sql_res);
				continue;
			}
			mysql_free_result(sql_res);

			if(Verbose)
				printf("On %d found %s missing, adding\n", 
						tmp->area_id, dirdata->d_name);
			
			sprintf(query, "INSERT INTO vmatik_filelist 
							(file_name, file_area, file_size, file_flags, file_uldate) 
							VALUES ('%s',%d,%d,%ld,FROM_UNIXTIME(%ld))",
							dirdata->d_name, tmp->area_id, (int)st.st_size,
							(Validate ? FILE_VALIDATED : 0),
							st.st_mtime);
			mysql_query(&db, query);
			if(mysql_error(&db)[0])
				fprintf(stderr, "Unable to add %s to %d (%s)\n", 
						dirdata->d_name, tmp->area_id, mysql_error(&db));
			else
			{
				inserted_per_area++;
				added_files++;
			}
		}
		closedir(dirri);
		
		if(inserted_per_area>0)
		{
			sprintf(query, "UPDATE vmatik_fileareas SET area_lasttouch=NOW()
							WHERE area_id=%d", tmp->area_id);
			mysql_query(&db, query);
		}
			
		tmp=tmp->next;
		free(areas);
		areas=tmp;
	}

	mysql_close(&db);
	return(added_files);
}
	

int main(int argc, char *argv[])
{
	int added_files;
	int go=1;
	char olddir[PATH_MAX];

	while(go)
	{
		switch(getopt(argc, argv, "avh"))
		{
			case 'v':
				Verbose=1;
				break;
			case 'a':
				Validate=1;
				break;
			case 'h':
				printf("Usage: %s <options>\n\n", argv[0]);
				printf("-a     Autovalidate added files\n");
				printf("-v     Verbose execution\n");
				return(0);
				break;
			default:
				go=0;
				break;
		}
	}	

	getcwd(olddir, PATH_MAX);

	added_files=adopt();

	chdir(olddir);

	fprintf(stderr, "Done, %d files added.\n", added_files);
		
	return(0);
}

