/*
 * The faker was used in daydream to let other users & sysops to
 * complain about files in filelists. Complaints were added to
 * the filelist after the description, and sysop could take the
 * credits away from uploader if he wished.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "../lib/ddlib.h"
#include "struct.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define WORD short
#define SendString dd_sendstring
#define Open open
#define MODE_OLDFILE O_RDONLY
#define MODE_READWRITE O_RDWR | O_CREAT, 0664
#define Read read
#define Close close
#define BPTR int
#define Seek lseek
#define OFFSET_END SEEK_END
#define OFFSET_BEGINNING SEEK_SET
#define MODE_NEWFILE O_RDWR | O_CREAT | O_TRUNC, 0664
#define Write write
#define DeleteFile unlink
#define strcmpi strcasecmp
#define stricmp strcmpi
#define ChangeActivity dd_changestatus
#define Pause dd_pause
#define JoinConference dd_joinconf

struct FakerDataFile {
	WORD df_Type;
	char df_FileName[32];
	ULONG df_FileSize;
	WORD  df_CreditFactor;
};

struct Fakerdata {
	UWORD FD_Conf;
	char  FD_Filename[26];
	char  FD_Informer[26];
};

char * ExamineCfg( char *, char *);

void strupr(char *);
void clearflist(void);
void CloseMe(void);
void CpyToEOL(char *, char *);
void CpyToLAINA(char *, char *);
int ProcessLine(char *);
void ProcessFile(void);
void FmtDirName(char *dirikka);
char *Fnd(char *, char *);
int FindFile(char *);
char * GetFe(char *);
void GenComline(char *source, char *dest);
void SaveDir(char *dirikka);
void Delete(int);
void FreeFile(void);
void NukeFile(void);
void copytonuke(char *);
void CommentFile(void);
void ReturnCreds(void);
void Reward(void);

char username[40];
char tbuf[200];
char ubname[200];
char ullog[200];
char dllog[200];

int userlen;
int node;

int quitme=0;
char *fptr;
char *feptr;
char * DirMem =0;
int DirSize;
char * CfgMem =0;
struct	Library	*DDBase;
struct	dif	*d;
int ConfigSize=0;

struct StringMem {
	char descbuffer[10000];
	char comline1[200];
	char comline2[200];
	char comline3[200];
	char delline[500];
	char freeline[100];
	char credline[500];
	struct DD_UploadLog logbuffer[401];
	};

struct FileInfoBlock *FBlock = NULL;

char BUFFER[2048];
char BUFFER2[2048];
UWORD SysOpAccess;
UWORD RewardPercentage;
char CurrFile[40];
char CurrPath[260];
ULONG CurrSize;
char rewarded[30];

struct DayDream_Conference *thisconf;

char origdir[130];
int updatedir;
char namecol[20];
char flagcol[20];
char sizecol[20];
char datecol[20];
char desccol[20];

struct StringMem *sta;

int main(int argc, char *argv[])
{
	int CfgHandle;
	char cmdline[512];
	int i;
	char *CfgPtr;
	int goon=1;
	struct FakerDataFile dfentry;
	struct Fakerdata fdentry;
	struct stat st;
	
	if (argc==1) {
		printf("Brr.. Requires DD!\n");
		exit(0);
	}
	d=dd_initdoor(argv[1]);		/* Establish link with DD */

	node=atoi(argv[1]);
	
	if(d==NULL) {
		printf("Hey Asswipe, this program requires DayDream BBS!\n");
	        exit(10);
        }
	dd_changestatus(d,"Faking Files");
	
	dd_getstrval(d,cmdline,DOOR_PARAMS);

	atexit(CloseMe);

	dd_getstrval(d,BUFFER,DD_ORIGDIR);
	sprintf(origdir,"%s/",BUFFER);
	strcat(BUFFER,"/configs/dreamfaker.cfg");

	if (stat(BUFFER,&st)==-1) {
		SendString(d,"[37mCouldn't find configfile!\n\n");
		exit(0);
	}
	CfgMem=(char *)malloc(st.st_size+2);
	sprintf(tbuf,"%s/data/dreamfaker.dat",origdir);
	sprintf(ubname,"%s/data/userbase.dat",origdir);
	sprintf(ullog,"%s/logfiles/uploadlog.dat",origdir);
	sprintf(dllog,"%s/logfiles/downloadlog.dat",origdir);
		
	CfgHandle=open(BUFFER,O_RDONLY);
	i=read(CfgHandle,CfgMem,st.st_size);
	close(CfgHandle);
	CfgMem[i]=0;
	
	if (!(CfgPtr=ExamineCfg(CfgMem,"ACCESS "))) {
		SendString(d,"[37mCan't find ACCESS-variable in configfile!\n\n");
	}
	
	CpyToEOL(CfgPtr,BUFFER2);
	SysOpAccess=atoi(BUFFER2);

	if (!(CfgPtr=ExamineCfg(CfgMem,"REWARD "))) {
		RewardPercentage=0;
	} else {
		CpyToEOL(CfgPtr,BUFFER2);
		RewardPercentage=atoi(BUFFER2);
	}

	sta=(void *)malloc(sizeof(struct StringMem));
	memset(sta,0,sizeof(struct StringMem));
	
	dd_getstrval(d,username,USER_HANDLE);
	strupr(username);
	username[14]=0;
	userlen=strlen(username);

	if (argc==3) {
		sprintf(BUFFER,"%s/users/%d/faker.dat",origdir,dd_getintval(d,USER_ACCOUNT_ID));
		CfgHandle=open(BUFFER,O_RDONLY);
		if (CfgHandle!=-1) { 
			SendString(d,"\n[0mYour up/download status has changed since the last call!\n\n[36mFilename               Size  Credits  U/L bytes change  D/L bytes change\n[35m========================================================================\n");
			while (read(CfgHandle,&dfentry,sizeof(struct FakerDataFile)))
			{
				if (dfentry.df_Type==0) {
					sprintf(BUFFER,"[36m%-18s %8ld      %3ld          %8ld          %8ld\n",dfentry.df_FileName,dfentry.df_FileSize,dfentry.df_CreditFactor,dfentry.df_CreditFactor*dfentry.df_FileSize,0); 
				} else if (dfentry.df_Type==1) {
					sprintf(BUFFER,"[36m%-18s %8ld      %3ld          %8ld          %8ld\n",dfentry.df_FileName,dfentry.df_FileSize,0,0,-dfentry.df_FileSize); 
				} else {
					sprintf(BUFFER,"[36m%-18s %8ld     0.%2ld          %8ld          %8ld\n",dfentry.df_FileName,dfentry.df_FileSize,RewardPercentage,(dfentry.df_FileSize/100)*RewardPercentage,0);
				}
				SendString(d,BUFFER);
			}
			close (CfgHandle);
			SendString(d,"[35m========================================================================\n[34m                                                         DreamFaker V3.0[0m\n");
			Pause(d);
			SendString(d,"\n");
			sprintf(BUFFER,"%s/users/%ld/faker.dat",origdir,dd_getintval(d,USER_ACCOUNT_ID));
			unlink(BUFFER);			
		}
		if (SysOpAccess > dd_getintval(d,USER_SECURITYLEVEL)) {
			exit(0);
		} else {
			CfgHandle=Open(tbuf,MODE_OLDFILE);
			if (CfgHandle!=-1) { 
				SendString(d,"\n[0mFollowing files have been commented!\n\n[36mFilename               Conf      Who                                        \n[35m========================================================================\n");
				while (Read(CfgHandle,&fdentry,sizeof(struct Fakerdata)))
				{
					sprintf(BUFFER,"[36m%-18s %8ld      %s\n",fdentry.FD_Filename,fdentry.FD_Conf,fdentry.FD_Informer); 
					SendString(d,BUFFER);
				}
				Close (CfgHandle);
				SendString(d,"[35m========================================================================\n[34m                                                         DreamFaker V3.0[0m\n");
				Pause(d);
				SendString(d,"\n");
			}
			exit(0);
		}
	}

	thisconf=dd_getconf(dd_getintval(d,VCONF_NUMBER));
	if (!thisconf) {
		SendString(d,"[37mCouldn't get conference!\n\n");
		exit(0);
	}

	SendString(d,"\n                    [36mDreamFaker [0mV3.0 [36m- Code by Hydra[0m/[36mInsane\n\n");

	ChangeActivity(d,"Faking files");

	if (thisconf->CONF_FILEAREAS==0) {
		SendString(d,"[37mNo files in this conference!\n\n");
		exit(0);
	}

	if (SysOpAccess <= dd_getintval(d,USER_SECURITYLEVEL)) {
		BPTR datahandle;
		struct Fakerdata datamem;
		int oldconf;

		oldconf=thisconf->CONF_NUMBER;

		datahandle=Open(tbuf,MODE_OLDFILE);
		if (datahandle!=-1) {
			SendString(d,"[36mAutoprompt faked files? [35m(Yes/no) [0m: ");

			if (dd_hotkey(d,HOT_YESNO)==1) {

				while (Read(datahandle,&datamem,sizeof(struct Fakerdata)))
				{
					strcpy(rewarded,datamem.FD_Informer);
					JoinConference(d,datamem.FD_Conf,JC_SHUTUP|JC_QUICK);
					thisconf=dd_getconf(dd_getintval(d,VCONF_NUMBER));
					ProcessLine(datamem.FD_Filename);
				}
				Close(datahandle);		
				DeleteFile(tbuf);
				JoinConference(d,oldconf,JC_SHUTUP|JC_QUICK);
			} else {
				Close(datahandle);
				SendString(d,"\n[36mDelete list? [35m(Yes/no) [0m: ");

				if (dd_hotkey(d,HOT_YESNO)==1) {
					DeleteFile(tbuf);
				}
				SendString(d,"\n\n");
			}
		}
	}
	rewarded[0]=0;

	ProcessLine(cmdline);
	if (quitme) exit(0);

	while (goon) {
		SendString(d,"[36mEnter Filename(s) to Fake[34m: [0m");

		*cmdline=0;
		if (!(dd_prompt(d,cmdline,80,PROMPT_FILE))) goon=0; else {
			if (cmdline[0]) {
				SendString(d,"\n");
				ProcessLine(cmdline);
				if (quitme) goon=0;
			} else goon=0;
		}
	}
	exit(0);		
}

int lookdata(char *file)
{
	BPTR datahandle;
	int  pos=0;
	struct Fakerdata datamem;

	datahandle=Open(tbuf,MODE_OLDFILE);
	if (datahandle!=-1) {
		while (Read(datahandle,&datamem,sizeof(struct Fakerdata)))
		{
			if (!strcmpi(file,datamem.FD_Filename)) {
				Close(datahandle);
				return pos;					
			}
			pos++;
		}
		Close(datahandle);		
	}
	return -1;
}

void adddata(int confn, char *file, char *info)
{
	BPTR datahandle;
	struct Fakerdata datamem;

	if (lookdata(file)!=-1) return;

	datahandle=open(tbuf,MODE_READWRITE);
	if (datahandle!=-1) {
		datamem.FD_Conf=confn;
		strcpy(datamem.FD_Filename,file);
		strcpy(datamem.FD_Informer,info);
		lseek(datahandle,0,OFFSET_END);
		Write(datahandle,&datamem,sizeof(struct Fakerdata));
		Close(datahandle);
	}
}


int ProcessLine(char *line)
{
	char *token;
	struct Fakenode *fn;

	token=strtok(line," ");
 	while(token != NULL) {

		CurrFile[0]=0;
		if (LookForFile(token)) {
//			ProcessFile();
		} else {
			SendString(d,"\n[35mFile not found!\n\n");
		}
		if (quitme) return 0;
	  	token=strtok(0," ");
 	}
	return 0;
}

char * fgetsnolf(char *buf, int n, FILE *fh)
{
	char *hih;
	char *s;
	
	hih=fgets(buf,n,fh);
	if (!hih) return 0;
	s=buf;
	while (*s)
	{
		if (*s==13 || *s==10) {
			*s=0;
			break;
		}
		s++;
	}
	return hih;
}

void _splitpath(char *file, char *drive, char *path, char *name, char *ext)
{
	char *s, *t;
	if (ext) *ext=0;
	if (drive) *drive=0;

	s=file;
	while(*s) s++;
	
	while (*s!='/') {
		if (s==file) {
			*path=0;
			strcpy(name,file);
			return;
		} else {
			s--;
		}		
	}
	s++;
	t=file;
	while(t!=s) {
		*path++=*t++;
	}
	*path=0;
	strcpy(name,t);
}

int LookForFile(char *fname)
{
	char buf1[512];
	char buf2[512];
	FILE *plist;
	struct stat st;
	int fd1;
	int fi=0;
			
	sprintf(buf1,"/tmp/dd/faker%d",node);
	if (dd_findfilestolist(d,fname,buf1)) {
		plist=fopen(buf1,"r");
		if (plist) {
			while(fgetsnolf(buf2,512,plist) && !quitme) {
				_splitpath(buf2,0,CurrPath,CurrFile,0);
				stat(buf2,&st);
				CurrSize=st.st_size;
				ProcessFile();
				fi++;
			}
			fclose(plist);
		}	
	
	} else {
		unlink(buf1);
	}
	return fi;
}

void ProcessFile(void)
{
	int currdir;
	int dirsleft;

	updatedir=0;
	sta->comline1[0]=0;
	sta->comline2[0]=0;
	sta->comline3[0]=0;
	sta->delline[0]=0;
	sta->credline[0]=0;

	dirsleft=thisconf->CONF_FILEAREAS;
	currdir=dirsleft;
	sprintf(BUFFER,"%sdata/directory.%3.3d",thisconf->CONF_PATH,thisconf->CONF_UPLOADAREA);
	
	if (FindFile(BUFFER)) return;

	while(dirsleft)
	{
		if (currdir==thisconf->CONF_UPLOADAREA) {
			currdir--; dirsleft--;
		} else {
			sprintf(BUFFER,"%sdata/directory.%3.3d",thisconf->CONF_PATH,currdir);
			if (FindFile(BUFFER)) return;
			currdir--; dirsleft--;
		}						
	}
}

int FindFile(char * dirikka)
{
	BPTR dirhandle;
	char fndbuf[40];
	int  Hot;
	int nukeloop=1;
	struct stat st;
	
	if (stat(dirikka,&st)==-1) return 0;

	DirSize=st.st_size;

	if (!(DirMem=malloc(DirSize+2))) {
		SendString (d,"\n[35mOut of memory!\n\n");
 		return 0;
	}

	dirhandle=Open(dirikka,MODE_OLDFILE);
	Read(dirhandle,&DirMem[1],DirSize);
	Close(dirhandle);
	DirMem[0]=10;

/*	strupr(CurrFile); */

	sprintf(fndbuf,"\n%s ",CurrFile);
	if (fptr=Fnd(fndbuf,DirMem)) {
		fptr++;
		feptr=GetFe(fptr);

		strcpy(sta->descbuffer,fptr);

		SendString(d,"[0m\n");
		SendString(d,fptr);
		SendString(d,"\n\n");
		free(DirMem);

		if (SysOpAccess > dd_getintval(d,USER_SECURITYLEVEL)) {
			CommentFile();
		} else {
			nukeloop=1;
			while (nukeloop) {
				SendString(d,"[0mWhat shall I do for this file [35m[[36mn/d/r/c/f/o/W/s/q/?[35m] [0m?: ");
uglycoding:
				Hot=dd_hotkey(d,0);
				switch (Hot)
				{
					case 13:
					case 10:
					case 'w':
					case 'W':
						SendString(d,"Write it!\n\n");
						nukeloop=0;
						break;
					case 'N':
					case 'n':
						SendString(d,"Nuke it!\n\n");
						NukeFile();
						break;
					case 'R':
					case 'r':
						SendString(d,"Return credits!\n\n");
						ReturnCreds();
						break;
					case 'o':
					case 'O':
						SendString(d,"Reward informer!\n");
						Reward();
						break;
					case 's':
					case 'S':
						SendString(d,"Skip it!\n\n");
						updatedir=0;
						nukeloop=0;
						break;
					case 0:
					case -1:
					case 'q':
					case 'Q':
						SendString(d,"Quit!\n\n");
						nukeloop=0;
						quitme=1;
						break;
					case '?':
						SendString(d,"Help!\n\n[36mN [35m- [0m Nuke file. Use this to reward/punish user.\n[36md [35m- [0m Delete file (Uppercase D to rm)\n[36mR [35m- [0m Return credits to downloaders.\n[36mC [35m- [0m Comment file.\n[36mO [35m- [0m Reward Informer.\n[36mF [35m- [0m Make file free download.\n[36mW [35m- [0m Write file. (Saves modifications)\n[36mS [35m- [0m Skip current file. (Abandon changes)\n[36mQ [35m- [0m Quit.\n\n");
						break;
					case 'c':
					case 'C':
						SendString(d,"Comment!\n\n");
						CommentFile();
						break;
					case 'D':
						SendString(d,"Delete!\n\n");
						Delete(1);
						break;
					case 'd':
						SendString(d,"Delete!\n\n");
						Delete(0);
						break;
					case 'f':
					case 'F':
						SendString(d,"Free it!\n\n");
						FreeFile();
						break;
					default:
						goto uglycoding;
				}
			}
		}
		SaveDir(dirikka);
		return 1;
	}
	else {
		free(DirMem);
		return 0;
	}
}

void Reward(void)
{
	BPTR NukeHandle;
	int offset;
	struct userbase NukeUser;
	struct FakerDataFile dfentry;
	char nukebuf[500];

	if (rewarded[0]==0) {
		SendString(d,"[0mNo-one to be rewarded!\n\n");	
		return;
	}

	if (!RewardPercentage) {
		SendString(d,"[0mRewarding is not in use!\n\n");
		return;
	}

	offset=dd_findusername(d,rewarded);
	if (offset==-1) {
		SendString(d,"[0mError - couldn't find user to reward!\n\n");	
		return;
	}

	NukeHandle=open(ubname,O_RDWR);
	if (NukeHandle==-1) {
		SendString(d,"[31mCouldn't access userbase!!\n\n");
		return;
	}
	Seek(NukeHandle,offset*sizeof(struct userbase),OFFSET_BEGINNING);
	Read(NukeHandle,&NukeUser,sizeof(struct userbase));
	Close(NukeHandle);

	sprintf(nukebuf,"\n[36mHandle   [35m:[0m %-23s     [36mOrg.  [35m:[0m %s\n",NukeUser.user_handle,NukeUser.user_organization);
	SendString(d,nukebuf);
	sprintf(nukebuf,"\n[36mUploads  [35m:[0m %8Lu kB (%5ld files)   [36mFakes [35m:[0m %7ld kB (%5ld files)\n",NukeUser.user_ulbytes/1024,NukeUser.user_ulfiles,NukeUser.user_fakedbytes/1024,NukeUser.user_fakedfiles);
	SendString(d,nukebuf);
	sprintf(nukebuf,"[36mDownloads[35m:[0m %8Lu kB (%5ld files)   [36mRatios[35m:[0m 1:%ld (byte), 1:%ld (file)\n\n",NukeUser.user_dlbytes/1024,NukeUser.user_dlfiles,NukeUser.user_byteratio,NukeUser.user_fileratio);
	SendString(d,nukebuf);

	SendString(d,"[36mReward user? [35m(Yes/no) [0m: ");

	if (dd_hotkey(d,HOT_YESNO)==1) {

		sprintf(nukebuf,"\n[36mUploaded bytes             [35m:[0m %12Lu   [36mUploaded files             [35m:[0m %5ld \n",NukeUser.user_ulbytes,NukeUser.user_ulfiles);
		SendString(d,nukebuf);
		sprintf(nukebuf,"[36m   Changed bytes           [35m:[0m %12d   [36m   Changed files           [35m:[0m %5ld \n",(CurrSize/100)*RewardPercentage,0);
		SendString(d,nukebuf);
		SendString(d,"                             [35m------------                                -----\n");
		sprintf(nukebuf,"[36m     Bytes after           [35m:[0m %12Lu   [36m     Files after           [35m:[0m %5ld \n\n",NukeUser.user_ulbytes+(CurrSize/100)*RewardPercentage,NukeUser.user_ulfiles);
		SendString(d,nukebuf);
	
		NukeUser.user_ulbytes=NukeUser.user_ulbytes+ (CurrSize/100)*RewardPercentage;

		
		NukeHandle=open(ubname,O_RDWR);
		if (NukeHandle==-1) {
			SendString(d,"[31mCouldn't access userbase!!\n\n");
			return;
		}
		Seek(NukeHandle,offset,OFFSET_BEGINNING);
		Write(NukeHandle,&NukeUser,sizeof(struct userbase));
		Close(NukeHandle);

		sprintf(nukebuf,"%s/users/%ld/faker.dat",origdir,NukeUser.user_account_id);
		NukeHandle=Open(nukebuf,MODE_READWRITE);
		if (NukeHandle!=-1) { 

			dfentry.df_Type=2;
			strcpy(dfentry.df_FileName,CurrFile);
			dfentry.df_FileSize=CurrSize;
			Seek(NukeHandle,0,OFFSET_END);
			Write(NukeHandle,&dfentry,sizeof(struct FakerDataFile));
			Close (NukeHandle);
		}
	}
}

void ReturnCreds(void)
{
	BPTR NukeHandle;
	BPTR LogHandle;
	char nukebuf[256];
	int  loglen;
	struct DD_UploadLog *dllogentry;
	struct userbase NukeUser;
	struct FakerDataFile dfentry;

	SendString(d,"[0mLooking for downloaders...");

	LogHandle=open(dllog,O_RDONLY);
	if (LogHandle==-1) {
		SendString(d,"[31m Error! Could not access log file!!\n\n");
		return;
	}

	while (loglen=Read(LogHandle,sta->logbuffer,sizeof(struct DD_UploadLog)*350))
	{
		dllogentry=sta->logbuffer+loglen/(sizeof(struct DD_UploadLog));		
		dllogentry->UL_SLOT=65535;

		dllogentry=sta->logbuffer;

		while (dllogentry->UL_SLOT!=65535)
		{
			if (!(stricmp(dllogentry->UL_FILENAME,CurrFile)))
			{
				NukeHandle=open(ubname,O_RDWR);
				
				if (NukeHandle==-1) {
					SendString(d,"[31mCouldn't access userbase!!\n\n");
					return;
				}
				Seek(NukeHandle,sizeof(struct userbase)*dllogentry->UL_SLOT,OFFSET_BEGINNING);
				Read(NukeHandle,&NukeUser,sizeof(struct userbase));
				Close(NukeHandle);

				sprintf(nukebuf,"\n\n[36mHandle   [35m:[0m %-23s     [36mOrg.  [35m:[0m %s\n",NukeUser.user_handle,NukeUser.user_organization);
				SendString(d,nukebuf);
				sprintf(nukebuf,"\n[36mUploads  [35m:[0m %8Lu kB (%5ld files)   [36mFakes [35m:[0m %7ld kB (%5ld files)\n",NukeUser.user_ulbytes/1024,NukeUser.user_ulfiles,NukeUser.user_fakedbytes/1024,NukeUser.user_fakedfiles);
				SendString(d,nukebuf);
				sprintf(nukebuf,"[36mDownloads[35m:[0m %8Lu kB (%5ld files)   [36mRatios[35m:[0m 1:%ld (byte), 1:%ld (file)\n\n",NukeUser.user_dlbytes/1024,NukeUser.user_dlfiles,NukeUser.user_byteratio,NukeUser.user_fileratio);
				SendString(d,nukebuf);

				SendString(d,"[36mReturn credits? [35m(Yes/no) [0m: ");

				if (dd_hotkey(d,HOT_YESNO)==1) {

					sprintf(nukebuf,"\n[36mDownloaded bytes           [35m:[0m %12Lu   [36mDownloaded files           [35m:[0m %5ld \n",NukeUser.user_dlbytes,NukeUser.user_dlfiles);
					SendString(d,nukebuf);
					sprintf(nukebuf,"[36m   Changed bytes           [35m:[0m %12d   [36m   Changed files           [35m:[0m %5ld \n",dllogentry->UL_FILESIZE,1);
					SendString(d,nukebuf);
					SendString(d,"                             [35m------------                                -----\n");
					sprintf(nukebuf,"[36m     Bytes after           [35m:[0m %12Lu   [36m     Files after           [35m:[0m %5ld \n\n",(long long)(NukeUser.user_dlbytes-(long long)dllogentry->UL_FILESIZE),NukeUser.user_dlfiles-1);
					SendString(d,nukebuf);

					NukeUser.user_dlbytes=NukeUser.user_dlbytes-dllogentry->UL_FILESIZE;

					NukeUser.user_dlfiles--;

					NukeHandle=open(ubname,O_RDWR);
					if (NukeHandle==-1) {
						SendString(d,"[31mCouldn't access userbase!!\n\n");
						return;
					}
					Seek(NukeHandle,sizeof(struct userbase)*dllogentry->UL_SLOT,OFFSET_BEGINNING);
					Write(NukeHandle,&NukeUser,sizeof(struct userbase));
					Close(NukeHandle);

					sprintf(nukebuf,"%d/users/%ld/faker.dat",origdir,dllogentry->UL_SLOT);
					NukeHandle=Open(nukebuf,MODE_READWRITE);
					if (NukeHandle!=-1) { 

						dfentry.df_Type=1;
						strcpy(dfentry.df_FileName,CurrFile);
						dfentry.df_FileSize=dllogentry->UL_FILESIZE;
						Seek(NukeHandle,0,OFFSET_END);
						Write(NukeHandle,&dfentry,sizeof(struct FakerDataFile));
						Close (NukeHandle);
					}

				}
			}
			dllogentry++;
		}		
	}
	Close(LogHandle);
	SendString(d,"\n\n");
}


void NukeFile(void)
{
	BPTR NukeHandle;
	char nukebuf[512];
	int  loglen;
	struct DD_UploadLog *ullogentry;
	struct userbase NukeUser;
	int creditfaktor;
	long long newbytes;
	struct FakerDataFile dfentry;

	char *cptr;

	SendString(d,"[0mLooking for uploader...");

	NukeHandle=Open(ullog,MODE_OLDFILE);
	if (NukeHandle==-1) {
		SendString(d,"[31m Error! Could not access log file!!\n\n");
		return;
	}

	while (loglen=Read(NukeHandle,sta->logbuffer,sizeof(struct DD_UploadLog)*350))
	{
		ullogentry=sta->logbuffer+loglen/(sizeof(struct DD_UploadLog));		
		ullogentry->UL_SLOT=65535;

		ullogentry=sta->logbuffer;

		while (ullogentry->UL_SLOT!=65535)
		{
			if (!(stricmp(ullogentry->UL_FILENAME,CurrFile)))
			{
				Close(NukeHandle);
				NukeHandle=Open(ubname,MODE_READWRITE);
				if (NukeHandle==-1) {
					SendString(d,"[31mCouldn't access userbase!!\n\n");
					return;
				}
				Seek(NukeHandle,sizeof(struct userbase)*ullogentry->UL_SLOT,OFFSET_BEGINNING);
				Read(NukeHandle,&NukeUser,sizeof(struct userbase));
				Close(NukeHandle);

				sprintf(nukebuf,"\n\n[36mHandle   [35m:[0m %-23s     [36mOrg.  [35m:[0m %s\n",NukeUser.user_handle,NukeUser.user_organization);
				SendString(d,nukebuf);
				sprintf(nukebuf,"\n[36mUploads  [35m:[0m %8Lu kB (%5d files)   [36mFakes [35m:[0m %7ld kB (%5ld files)\n",NukeUser.user_ulbytes/1024,NukeUser.user_ulfiles,NukeUser.user_fakedbytes/1024,NukeUser.user_fakedfiles);
				SendString(d,nukebuf);
				sprintf(nukebuf,"[36mDownloads[35m:[0m %8Lu kB (%5ld files)   [36mRatios[35m:[0m 1:%ld (byte), 1:%ld (file)\n\n",NukeUser.user_dlbytes/1024,NukeUser.user_dlfiles,NukeUser.user_byteratio,NukeUser.user_fileratio);
				SendString(d,nukebuf);

				SendString(d,"[36mGive how many times extra credits [35m(Negative=deduct) [0m: ");
				*nukebuf=0;
				if (!(dd_prompt(d,nukebuf,3,0))) return;
				creditfaktor=atoi(nukebuf);

				if (!creditfaktor) { SendString(d,"\n"); return; }

				sprintf(nukebuf,"\n[36m  Uploaded bytes           [35m:[0m %12Lu   [36m  Uploaded files           [35m:[0m %5ld \n",NukeUser.user_ulbytes,NukeUser.user_ulfiles);
				SendString(d,nukebuf);
				sprintf(nukebuf,"[36m   Changed bytes           [35m:[0m %12d   [36m   Changed files           [35m:[0m %5ld \n",ullogentry->UL_FILESIZE*creditfaktor,creditfaktor);
				SendString(d,nukebuf);
				SendString(d,"                             [35m------------                                -----\n");
				sprintf(nukebuf,"[36m     Bytes after           [35m:[0m %12Lu   [36m     Files after           [35m:[0m %5ld \n\n",NukeUser.user_ulbytes+(long long)ullogentry->UL_FILESIZE*creditfaktor,NukeUser.user_ulfiles+creditfaktor);
				SendString(d,nukebuf);

				if (cptr=ExamineCfg(CfgMem,"CREDSTRING '")) {
					CpyToLAINA(cptr,sta->credline);
				}

				if (creditfaktor > 0 ) sprintf(nukebuf,"%ld * EXTRA CREDITS!!!",creditfaktor);
				if (creditfaktor > 9 ) sprintf(nukebuf,"%ld * EXTRA CREDITS!!",creditfaktor);

				if (creditfaktor < 0 ) sprintf(nukebuf,"%ld * CREDITS TAKEN!!!",creditfaktor);
				if (creditfaktor < -9 ) sprintf(nukebuf,"%ld * CREDITS TAKEN!!",creditfaktor);

				if (creditfaktor > 0) copytonuke(nukebuf); else copytonuke(&nukebuf[1]);
								
				if (creditfaktor < 0) {
					NukeUser.user_fakedbytes=NukeUser.user_fakedbytes+ullogentry->UL_FILESIZE;
					newbytes= -(creditfaktor * ullogentry -> UL_FILESIZE);
					if (newbytes > NukeUser.user_ulbytes) newbytes=0; else newbytes= NukeUser.user_ulbytes+(long long)creditfaktor * ullogentry -> UL_FILESIZE;
				} else newbytes= NukeUser.user_ulbytes+(long long)(creditfaktor * ullogentry -> UL_FILESIZE);

				NukeUser.user_ulbytes=newbytes;

				if (creditfaktor < 0) {
					NukeUser.user_fakedfiles++;
					newbytes= - (creditfaktor);
					if (newbytes > NukeUser.user_ulfiles) newbytes=0; else newbytes= NukeUser.user_ulfiles+creditfaktor;
				} else newbytes= NukeUser.user_ulfiles+creditfaktor;

				NukeUser.user_ulfiles=newbytes;

				NukeHandle=Open(ubname,MODE_READWRITE);
				if (NukeHandle==-1) {
					SendString(d,"[31mCouldn't access userbase!!\n\n");
					return;
				}
				Seek(NukeHandle,sizeof(struct userbase)*ullogentry->UL_SLOT,OFFSET_BEGINNING);
				Write(NukeHandle,&NukeUser,sizeof(struct userbase));
				Close(NukeHandle);
				
				sprintf(nukebuf,"%s/users/%ld/faker.dat",origdir,ullogentry->UL_SLOT);
				NukeHandle=Open(nukebuf,MODE_READWRITE);
				if (NukeHandle!=-1) { 
					dfentry.df_Type=0;
					strcpy(dfentry.df_FileName,CurrFile);
					dfentry.df_FileSize=ullogentry->UL_FILESIZE;
					dfentry.df_CreditFactor=creditfaktor;
					Seek(NukeHandle,0,OFFSET_END);
					Write(NukeHandle,&dfentry,sizeof(struct FakerDataFile));
					Close (NukeHandle);
				}
				updatedir=1;
				return;
			}
			ullogentry++;
		}		
	}
	Close(NukeHandle);
}

void copytonuke(char *src)
{
	char *dest;

	dest=&sta->credline[12];

	while (*src) *dest++=*src++;
}

void FreeFile(void)
{
	FILE *FreeHandle;
	char freebuf[256];

	sprintf(freebuf,"%sdata/freedownloads.dat",thisconf->CONF_PATH,CurrFile);

	if (FreeHandle=fopen(freebuf,"a")) {
		sprintf(freebuf,"%s\n",CurrFile);
		fputs(freebuf,FreeHandle);
		fclose(FreeHandle);
	}

	if (thisconf->CONF_ATTRIBUTES & (1<<3)) {
	sta->descbuffer[36]='F'; } else { sta->descbuffer[14]='F'; }

/*	strcpy(sta->freeline,Pointers->dp_DayDream->CFG_FREEDLLINE); */
	updatedir=1;
}

void Delete(int tapa)
{
	BPTR DelHandle;
	char delbuf[256];
	char *cptr;

	sprintf(delbuf,"%s%s",CurrPath,CurrFile);

	DelHandle=Open(delbuf,MODE_NEWFILE);
	if (DelHandle!=-1) {
		Write(DelHandle,"NUKED!\n",7);
		Close(DelHandle);

		if (tapa) DeleteFile(delbuf);

		if (thisconf->CONF_ATTRIBUTES & (1<<3)) {
		sta->descbuffer[36]='D'; } else { sta->descbuffer[14]='D'; }

		if (cptr=ExamineCfg(CfgMem,"DELLINE '")) {
			CpyToLAINA(cptr,sta->delline);
		}			
		updatedir=1;
	}
}

void SaveDir(char *dirikka)
{
	BPTR dirhandle;
	char fndbuf[40];
	struct stat st;
	char str[80];	
	if (!updatedir) return;

	dd_getstrval(d,str,USER_HANDLE);
	
	if (SysOpAccess > dd_getintval(d,USER_SECURITYLEVEL)) {
		adddata(thisconf->CONF_NUMBER,CurrFile,str);
	}

	
	if (stat(dirikka,&st)==-1) return;

	DirSize=st.st_size;

	if (!(DirMem=malloc(DirSize+2))) {
		SendString (d,"\n[35mOut of memory!\n\n");
		return;
	}

	dirhandle=Open(dirikka,MODE_READWRITE);
	if (dirhandle!=-1) {

		Read(dirhandle,&DirMem[1],DirSize);
		DirMem[0]=10;

		sprintf(fndbuf,"\n%s ",CurrFile);
		if (fptr=Fnd(fndbuf,DirMem)) {
			fptr++;
			feptr=GetFe(fptr);

			Seek(dirhandle,(fptr-1)-DirMem,OFFSET_BEGINNING);
			Write(dirhandle,sta->descbuffer,strlen(sta->descbuffer));
			Write(dirhandle,"\n",1);
			if (sta->comline1[0]) {
				sprintf(BUFFER2,"                                   %s",sta->comline1);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			if (sta->comline2[0]) {
				sprintf(BUFFER2,"                                   %s",sta->comline2);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			if (sta->comline3[0]) {
				sprintf(BUFFER2,"                                   %s",sta->comline3);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			if (sta->credline[0]) {
				sprintf(BUFFER2,"                                   %s\n",sta->credline);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			if (sta->delline[0]) {
				sprintf(BUFFER2,"                                   %s\n",sta->delline);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			if (sta->freeline[0]) {
				sprintf(BUFFER2,"                                   %s\n",sta->freeline);
				Write(dirhandle,BUFFER2,strlen(BUFFER2));
			}
			Write(dirhandle,feptr+1,strlen(feptr+1));
		}
	Close(dirhandle);
	}
	free(DirMem);
}

void CommentFile(void)
{
	char combuff[200];
	char *cptr;
	int i=0;

	SendString(d,"[36mPlease enter your comment now. You have three lines.\nMacros [35m: [0mA[35m)[36mncient [0mB[35m)[36mroken [0mC[35m)[36mrap [0mF[35m)[36make [0mL[35m)[36mame [0mO[35m)[36mld [0mR[35m)[36menamed\n[0m");

	cptr=combuff;

	for (i=0;i!=34;i++) *cptr++ =' ';
	*cptr++ ='[';
	for (i=0;i!=35-userlen;i++) *cptr++ ='-';
	*cptr++ =']'; *cptr++=10; *cptr++=0;

	SendString(d,combuff);

	SendString(d,"                                  [0m:[35m");
	*combuff=0;
	dd_prompt(d,combuff,35-userlen,0);
	if (combuff[0]==0) return;

	if (strlen(combuff)==1)
	{
		switch (*combuff)
		{
		case 'a':
		case 'A':
			GenComline("Ancient!",sta->comline1);
			return;
		break;
		case 'b':
		case 'B':
			GenComline("Broken!",sta->comline1);
			return;
		break;
		case 'c':
		case 'C':
			GenComline("Crap!",sta->comline1);
			return;
		break;
		case 'f':
		case 'F':
			GenComline("Fake!",sta->comline1);
			return;
		break;
		case 'l':
		case 'L':
			GenComline("Lame!",sta->comline1);
			return;
		break;
		case 'o':
		case 'O':
			GenComline("Old!",sta->comline1);
			return;
		break;
		case 'r':
		case 'R':
			GenComline("Rename!",sta->comline1);
			return;
		break;
		}
	}
	GenComline(combuff,sta->comline1);
	SendString(d,"                                  [0m:[35m");
	*combuff=0;
	dd_prompt(d,combuff,35-userlen,0);
	if (combuff[0]==0) return;
	GenComline(combuff,sta->comline2);
	SendString(d,"                                  [0m:[35m");
	*combuff=0;
	dd_prompt(d,combuff,35-userlen,0);
	if (combuff[0]==0) return;
	GenComline(combuff,sta->comline3);

}

void GenComline(char *source, char *dest)
{
	int i=0;
	int j=0;

	if (i=strlen(source))
	{
		updatedir=1;

		strcpy(dest,"``                                        ''\n");
		j=23-(3+(userlen+i)/2);
		i=0;
		while (username[i])
		{
			dest[j]=username[i]; j++; i++;
		}
		i=0;
		dest[j]=' '; j++;
		dest[j]=':'; j++;
		dest[j]=' '; j++;

		while (source[i])
		{
			dest[j]=source[i]; j++; i++;
		}
		if (ExamineCfg(CfgMem,"UPPERCASE")) strupr(dest);
	}
	else dest[0]=0;
}

char * GetFe(char *entry)
{
	for (;;)
	{
		while (*entry!=10) entry++;
		entry++;
		switch (*entry)
		{
			case ' ':
				break;
			default:
				entry--;
				*entry=0;
				return entry;
				break;
		}
	}
}

/*
void ActivateFile(register __a0 char *path, register __a1 char *filename, register __d0 ULONG fsize, register __d1 ULONG unused)
{
	struct Fakenode *fakenod;

	fakenod=AllocMem(sizeof(struct Fakenode),MEMF_PUBLIC);

	strcpy(fakenod->FN_Path,path);
	strcpy(fakenod->FN_Name,filename);
	fakenod->FN_Size=fsize;

	AddTail(&Fakelist,fakenod);
}

void clearflist(void)
{
	struct Fakenode *fakenod;

	while (fakenod=RemTail((struct List *)&Fakelist))
	{
		FreeMem(fakenod,sizeof(struct Fakenode));
	}
}

*/
void CpyToEOL(char *src, char *dest)
{
int i=0;

	while (src[i]!=10) {
		dest[i]=src[i];
		i++;
	}
	dest[i]=0;
}

void CpyToLAINA(char *src, char *dest)
{
int i=0;

	while (src[i]!=39) {
		dest[i]=src[i];
		i++;
	}
	dest[i]=0;
}

void CloseMe(void)
{
	if (sta) free(sta);
	if (CfgMem) free(CfgMem);
	dd_close(d);
}

void strupr (char *str)
{
	while (*str)
	{
		*str=toupper(*str);
		str++;
	}
}

char *ExamineCfg(char *hay, char *need)
{
	char *s;
	while(1)
	{
		s=need;
		if (*hay==0) return 0;
		if (*hay==';') { 
			while(*hay!=10) {
				if(*hay==0) return 0;
				hay++;
			}
			continue;
		}
		while (1) {
			if (*s++==*hay++) {
				if (*s==0) return hay;
			} else {
				break;
			}
		}
	}
}

char * Fnd(char *needle, char *haystack)
{
	return strstr(haystack, needle);
}
