/* 
 * Displays a list of users online
 *
 */
#include "proto.h"
#include <fcntl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>

/* 
 * Displays a list of users that are online.
 *
 */
void who(void)
{
	struct VMatik_Node *cn;
	
	cn=nodes;
	
	changenodestatus("Viewing who's online");
	
	DDPut(sd[whheadstr]);

	while(cn->Node_ID)
	{
		if (cn->Node_TTYType == NODETYPE_TELNET) {
			int j=maincfg.CFG_TELNETMAX;
			int i=maincfg.CFG_TELNET1ST;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else if (cn->Node_TTYType == NODETYPE_LOCAL) {
			int j=maincfg.CFG_LOCALMAX;
			int i=maincfg.CFG_LOCAL1ST;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else {
			who_show(cn,cn->Node_ID);
		}
		cn++;
	}
	DDPut(sd[whtailstr]);
}

int who_show(struct VMatik_Node *cn, int num)
{
	MYSQL_RES *sql_result=NULL;
	MYSQL_ROW sql_row;
	struct VMatik_NodeInfo myn;
	char *usern, *orgn, *activity;
	char dabps[30];
	char blabuf[500];       
	int showent=1;
	
	if (isnode(num,&myn)) {
		if (cn->Node_Flags & NODE_HIDECALL) {
			showent=0;
		} else {
			if (myn.ddn_userslot) 
			{
				char query[QUERY_MAX];
				
				sprintf(query, "SELECT user_handle, user_name,
								user_org, user_city
								FROM vmatik_user WHERE user_id=%d",
								myn.ddn_userslot);
				mysql_query(&vm_database, query);
				sql_result=mysql_store_result(&vm_database);
				if(sql_result)
				{
					sql_row=mysql_fetch_row(sql_result);
				
					if (maincfg.CFG_FLAGS & FLAG_HANDLE) 
						usern=sql_row[0]; 
					else 
						usern=sql_row[1];

					if (maincfg.CFG_FLAGS & FLAG_ORGANIZATION) 
						orgn=sql_row[2];
					else 
						orgn=sql_row[3];
				}
				else
				{
					usern=" "; 
					orgn=" ";
				}

				activity=myn.ddn_activity;
				sprintf(dabps,"%d",myn.ddn_bpsrate);
			} else {
				usern=" "; orgn=" ";
				activity=myn.ddn_activity;
				sprintf(dabps,"%d",myn.ddn_bpsrate);
			}
		} 
	} else {
		if (cn->Node_Flags & NODE_HIDEWAIT) showent=0;
		else {
			usern=" "; orgn=" "; activity="Waiting for a call...";
			sprintf(dabps,"%d",0);
		}
	}
	if (showent) {
		switch (cn->Node_TTYType)
		{
			case NODETYPE_LOCAL:
				strcpy(dabps,"LOCAL");
			break;
			case NODETYPE_TELNET:
				strcpy(dabps,"TELNET");
			break;
		}
		sprintf(blabuf,sd[whlinestr],num,usern,orgn,activity,dabps);
		DDPut(blabuf);
	}

	if(sql_result)
		mysql_free_result(sql_result);
	
	return 1;
}

/* 
 * Checks if there exists a process with id "pid"
 *
 * 1==yes, 0==no
 *
 */
int wh_ispid(pid_t pid)
{
	char procpath[PATH_MAX];
	struct stat st;
	
	sprintf(procpath,"/proc/%d",pid);

	if (stat(procpath,&st)==-1) 
		return(0); 
	
	return(1);
}

/* 
 * Checks if node "nod" is active. Returns node info as "*ndnfo"
 *
 * 1==yes, 0==no
 *
 */
int isnode(int nod, struct VMatik_NodeInfo *ndnfo)
{
	char infoname[PATH_MAX];
	int nodefd;
		
	sprintf(infoname,"%snodeinfo%d.data",VMTMP,nod);
	nodefd=open(infoname,O_RDONLY);
	if (nodefd!=-1) 
	{
		read(nodefd,ndnfo,sizeof(struct VMatik_NodeInfo));
		close(nodefd);

		if(wh_ispid(ndnfo->ddn_pid)) 
			return(1);
	}
	return(0);
}

