/*
 * Lists the users in the system. 
 *
 */
#include <fcntl.h>
#include "proto.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void userlist(MYSQL *db, char *cmppat)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	struct userbase luser;
	int lcount;
	char userbuf[500];
	int usercnt=0, frozcnt=0, sysopcnt=0, cosysopcnt=0;
	int disp;
		
	changenodestatus("Listing users");
	
	lcount=user.user_screenlength-3;

	DDPut(sd[userlheadstr]);
	
	mysql_query(db, "SELECT user_id FROM vmatik_user");
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		while((sql_row=mysql_fetch_row(sql_result)))
		{
			memset(&luser, 0, sizeof(struct userbase));
			mi_loaduser(atol(sql_row[0]), &luser);

			disp=0;
			sprintf(userbuf,sd[userllinestr],luser.user_realname,luser.user_handle,luser.user_organization,luser.user_securitylevel,luser.user_connections);
			if (cmppat!=0)
			{
				if (mi_wildcmp(luser.user_realname,cmppat) || 
					mi_wildcmp(luser.user_handle,cmppat)) {
					disp=1;
				}
			} else {
				disp=1;
			}

			if ( (luser.user_toggles & TOGGLE_ACC_STAT_1) && 
				 ( (luser.user_toggles & TOGGLE_ACC_STAT_2) == 0) ) 
				 disp=0;
		
			if (disp)
			{
				usercnt++;
				if (!( luser.user_toggles & TOGGLE_ACC_STAT_1) && 
					((luser.user_toggles & TOGGLE_ACC_STAT_2))) {
					DDPut("[34m");
					frozcnt++;
				} else if (luser.user_securitylevel==31) {
					DDPut("[32m");
					sysopcnt++;
				} else if (luser.user_securitylevel==maincfg.CFG_COSYSOPLEVEL) {
					DDPut("[33m");
					cosysopcnt++;
				} else {
					DDPut("[0m");
				}                       
				DDPut(userbuf);
				lcount--;

				if (lcount==0) {
					int hot;
				
					DDPut(sd[morepromptstr]); 
					hot=HotKey(0);
					DDPut("\r                                                         \r");
					if (hot=='N'||hot=='n') 
						break;
					if (hot=='C'||hot=='c') 
						lcount=-1;
					else
						lcount=user.user_screenlength;
				}
			}
		}
		mysql_free_result(sql_result);
	}
	sprintf(userbuf,sd[userltailstr],sysopcnt,usercnt,cosysopcnt,frozcnt);
	DDPut(userbuf);
}
