/*
 * Sysop's User Editor here.
 *
 */
#include "proto.h"
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

int usereditor(struct userbase *);
void uemove(int, int);
int uedask(struct userbase *);
bint strtoconfs(char *str);
void confstostr(bint confacc, char *str);

struct flagstr {
	char *fl_desc;
	int fl_num;					// Number in the shown list
	int fl_field;				// Obsolete?
	bint fl_bit;				// The real bit used
	int fl_x;
	int fl_y;
};


struct flagstr fl[]={
	{ "Download",6,1,SECB_DOWNLOAD,22,6 } ,
	{ "Upload",7,1,SECB_UPLOAD,48,6 },
	{ "Read Message",8,1,SECB_READMSG,74,6 },
	{ "Enter Message",9,1,SECB_ENTERMSG,22,7 },
	{ "Page SysOp",10,1,SECB_PAGE,48,7},
	{ "Comment",11,1,SECB_COMMENT,74,7},
	{ "Bulletins",12,1,SECB_BULLETINS,22,8},
	{ "List Files",13,1,SECB_FILESCAN,48,8},
	{ "New Files",14,1,SECB_NEWFILES,74,8},
	{ "Zippy Search",15,1,SECB_ZIPPYSEARCH,22,9},
	{ "Run Door",16,1,SECB_RUNDOOR,48,9},
	{ "Join Conference",17,1,SECB_JOINCONF,74,9},
	{ "Change Msg Area",18,1,SECB_CHANGEMSGAREA,22,10},
	{ "Change Info",19,1,SECB_CHANGEINFO,48,10},
	{ "Relogin",20,1,SECB_RELOGIN,74,10},
	{ "Tag Editor",21,1,SECB_TAGEDITOR,22,11},
	{ "User Stats",22,1,SECB_USERSTATS,48,11},
	{ "View Time",23,1,SECB_VIEWTIME,74,11},
	{ "--",24,1,18,22,12},
	{ "Expert Mode",25,1,SECB_EXPERTMODE,48,12},
	{ "Eall-Message",26,1,SECB_EALLMESSAGE,74,12},
	{ "Fidomessage",27,1,SECB_FIDOMESSAGE,22,13},
	{ "Public Message",28,1,SECB_PUBLICMESSAGE,48,13},
	{ "Privateread",29,1,SECB_READALL,74,13},
	{ "User Editor",30,1,SECB_USERED,22,14},
	{ "View Log",31,1,SECB_VIEWLOG,48,14},
	{ "SysOp DL",32,1,SECB_SYSOPDL,74,14},
	{ "Userlist",33,1,SECB_USERLIST,22,15},
	{ "Delete Any Msg",34,1,SECB_DELETEANYMSG,48,15},
	{ "Remote Shell",35,1,SECB_REMOTESHELL,74,15},
	{ "Who is online",36,1,SECB_WHO,22,16},
	{ "Move file",37,1,SECB_MOVEFILE,48,16},
	{ "Select FConfs",38,2,SECB_MOVEFILE,74,16},
	{ "Select Bases",39,2,SECB_SELECTMSGBASES,22,17},
	{ "Send Netmail",40,2,SECB_SENDNETMAIL,48,17},
	{ "Online Message",41,2,SECB_OLM,74,17},
	{ "Prv file attach",42,2,SECB_PVTATTACH,22,18},
	{ "Pub file attach",43,2,SECB_PUBATTACH,48,18},
	{ "View File",44,2,SECB_VIEWFILE,74,18},
	{ "Edit real name",45,2,SECB_EDITREALNAME,22,19},
	{ "Edit handle",46,2,SECB_EDITHANDLE,48,19},
	{ "Free FileDL",47,2,SECB_FREEFILES, 74, 19},
	{ "Free ByteDL",48,2,SECB_FREEBYTES, 22, 20},
	{ "CoSysOp", 49, 2, SECB_COSYSOP, 48, 20},
	{ "SysOp", 50, 2, SECB_SYSOP, 74, 20},
	{ 0,0,0,0,0,0} , 
};

/*
 * Sets user security data to database
 *
 * Includes fileratio1, byteratio1, timelimit, confacc, secflags
 *          and seclevel.
 *
 */
int ue_set_secdata_to_db(struct userbase *luser)
{
	char query[QUERY_MAX];

	sprintf(query, "UPDATE vmatik_user SET 
					user_seclevel=%d,
					user_fileratio1=%d,
					user_byteratio1=%d, user_timelimit=%d,
					user_confacc=%lld, user_secflags=%lld
					WHERE user_id=%d",
					luser->user_securitylevel,
					luser->user_fileratio1,
					luser->user_byteratio1, luser->user_dailytimelimit,
					luser->user_confacc, luser->user_secflags,
					luser->user_serial_id);
	mysql_query(&vm_database, query);
	if(mysql_error(&vm_database)[0])
	{
		DDPut(mysql_error(&vm_database));
		return(0);
	}

	return(1);
}

/*
 * Frontend for usereditor()
 *
 */
void usered(void)
{
	struct userbase euser;
	char uedbuf[300];
	int go=1;
	
	memset(&euser, 0, sizeof(struct userbase));
		
	while (go)
	{
		DDPut("[2J[H\n[0;36mVMatik BBS On-Line User Editor\n[0m~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n[32mC[0m)urrent User\n[32mS[0m)earch from UserBase\n[32mQ[0m)uit\n");

		DDPut("\n[33mOn-Line user editor> [0m");
		
		uedbuf[0]=0;
		if (!(Prompt(uedbuf,3,0))) break;
		
		if (!strcasecmp(uedbuf,"c")) {
			if (!onlinestat) {
				DDPut("\n[35mNo user online!\n");
				continue;
			}
			euser=user;
			if (usereditor(&euser)) {
				user=euser;
				access_flags=eb_getsec(&vm_database, user.user_serial_id);
			}		
		} else if (!strcasecmp(uedbuf,"q")) {			// Quit
			go=0;
		} else if (!strcasecmp(uedbuf,"s")) {			// Search
			MYSQL_RES *sql_result;
			MYSQL_ROW sql_row;
			char query[QUERY_MAX];
			char orders[QUERY_MAX];
			int do_edit;

			orders[0]=0;
			ue_parse_orders(orders);	
			if(!orders[0])
				continue;	

			sprintf(query, "SELECT user_id FROM vmatik_user
							WHERE %s",
							orders);
			mysql_query(&vm_database, query);
			if(mysql_error(&vm_database)[0])
			{
				DDPut(mysql_error(&vm_database));
				return;
			}
			sql_result=mysql_store_result(&vm_database);
			if(sql_result)
			{
				while((sql_row=mysql_fetch_row(sql_result)))
				{
					mi_loaduser(atoi(sql_row[0]), &euser);
					do_edit=uedask(&euser);
					if(do_edit==2)
						break;

					if(do_edit)
					{
						if (euser.user_serial_id==user.user_serial_id)
							usereditor(&user);
						else
						{
							if(usereditor(&euser))
							{
								int online_node;
								
								online_node=mi_isonline(euser.user_serial_id);
								if(online_node)
								{
									struct VMatik_nodemessage olm;
					
									memset(&olm, 0, sizeof(struct VMatik_nodemessage));
									olm.dn_command=NODEMSG_RELOAD_USER;
									ol_send_defined(online_node, &olm);
								}
							}
						}
					}
				}
				mysql_free_result(sql_result);
			}
		}
	}
}

/*
 * Asks if this is the correct user
 *
 */
int uedask(struct userbase *auser)
{
	char buff[300];
	unsigned char hot;
	
	sprintf(buff,"\r                                                      \r[0m%s [32m/ [0m%s [35m([36mYes[35m/[36mno[35m/[36mquit[35m)[0m: ",auser->user_realname,auser->user_handle);
	DDPut(buff);
	
	while (1) {
		if ( (hot=HotKey(0)) ) {
			if (hot=='q' || hot =='Q') {
				DDPut("Quit!");
				return 2;
			} else if (hot=='n' || hot=='N') {
				DDPut("No!");
				return 0;
			} else if (hot=='y' || hot=='Y' || hot == 13 ||hot == 10) {
				DDPut("Yes!");
				return 1;
			}		
		} else return 2;
	}
}

/*
 * The actual user editor for datas in "euser"
 *
 */
int usereditor(struct userbase *euser)
{
	int go=1;
	char uebuf[300];
	char *astat;
	char tempbuf[512];
	char useridbuf[100];

	sprintf(useridbuf, "user_id=%d", euser->user_serial_id);
			
	while (go)
	{
		DDPut("[2J[H\n[0m");
		
		sprintf(uebuf,"[32mA[0m) Name         : [33m%-29.29s[32mH[0m) Security    : [33m%d\n",euser->user_realname,euser->user_securitylevel);
		DDPut(uebuf);
		
		sprintf(uebuf,"[32mB[0m) Handle       : [33m%-29.29s[32mI[0m) Time Left   : [33m%d\n",euser->user_handle,euser->user_timeremaining);
		DDPut(uebuf);
		
		sprintf(uebuf,"[32mC[0m) Organization : [33m%-29.29s[32mJ[0m) Calls Made  : [33m%d\n",euser->user_organization,euser->user_connections);
		DDPut(uebuf);
		
		sprintf(uebuf,"[32mD[0m) Zip & City   : [33m%-29.29s[32mK[0m) Protocol    : [33m%c\n",euser->user_zipcity,euser->user_protocol);
		DDPut(uebuf);
		
		sprintf(uebuf,"[32mE[0m) Voice Phone  : [33m%-29.29s[32mL[0m) Auto-Join   : [33m%d\n",
		euser->user_voicephone,euser->user_defconf_id);
		DDPut(uebuf);
		
		sprintf(uebuf,"[32mF[0m) PassWord     : [33m%-29.29s[32mM[0m) Screenlength: [33m%d\n","(encrypted)", euser->user_screenlength);
		DDPut(uebuf);

		if (euser->user_toggles & TOGGLE_ACC_STAT_1) {
			if (euser->user_toggles & TOGGLE_ACC_STAT_2) 
				astat="New"; 
			else 
				astat="Deleted";
		} else {
			if (euser->user_toggles & TOGGLE_ACC_STAT_2) 
				astat="Frozen"; 
			else 
				astat="Active";
		}

		sprintf(uebuf,"[32mG[0m) Uploaded     : [33m%12Lu[0m | [33m%-5u         [32mN[0m) Acc. Status : [33m%s\n",
		euser->user_bytesup,euser->user_filesup,astat);
		DDPut(uebuf);
		
		sprintf(uebuf,"[0m   Downloaded   : [33m%12Lu[0m | [33m%-5u\n",
		euser->user_bytesdn,euser->user_filesdn);
		DDPut(uebuf);
		
		sprintf(uebuf,"                                               [0mID number : [33m%d\n",euser->user_serial_id);
		DDPut(uebuf);
		
		{
			struct tm *tm1;
			struct tm tmt;
			struct tm *tm2;
			
			tm1=localtime(&euser->user_firstcall);
			memcpy(&tmt,tm1,sizeof(struct tm));
			tm1=&tmt;
			tm2=localtime(&euser->user_lastcall);
			sprintf (uebuf,"[0m   Firstcall    : [33m%d.%d.%d\n",tm1->tm_mday,tm1->tm_mon+1,tm1->tm_year+1900); 
			DDPut(uebuf);
			sprintf (uebuf,"[0m   Lastcall     : [33m%d.%d.%d\n",tm2->tm_mday,tm2->tm_mon+1,tm2->tm_year+1900); 
			DDPut(uebuf);
		}
		sprintf(uebuf,"\n[32mP[0m) Edit security flags\n\n");
		DDPut(uebuf);

		uebuf[0]=0;
		DDPut("[18H[0mSelect field to be altered (or [36mQ[0muit):     [4D");

		if (!(Prompt(uebuf,3,0))) return(0);

		if (!strcasecmp(uebuf,"q")) {
			return(1);
		} else if (!strcasecmp(uebuf,"a")) {
			uemove(19,2);
			if (!(Prompt(euser->user_realname,sizeof(euser->user_realname),0)))
				return(0);
			mysql_escape_string(tempbuf, euser->user_realname, 
								strlen(euser->user_realname));
			mi_sql_setstr(&vm_database, "user_realname", "vmatik_user",
						useridbuf, tempbuf); 
		} else if (!strcasecmp(uebuf,"b")) {
			uemove(19,3);
			if (!(Prompt(euser->user_handle,sizeof(euser->user_handle),0))) 
				return(0);
			mysql_escape_string(tempbuf, euser->user_handle, 
								strlen(euser->user_handle));
			mi_sql_setstr(&vm_database, "user_handle", "vmatik_user",
						useridbuf, tempbuf); 
		} else if (!strcasecmp(uebuf,"c")) {
			uemove(19,4);
			if (!(Prompt(euser->user_organization,
				sizeof(euser->user_organization),0))) 
				return(0);
			mysql_escape_string(tempbuf, euser->user_organization, 
								strlen(euser->user_organization));
			mi_sql_setstr(&vm_database, "user_org", "vmatik_user",
						useridbuf, tempbuf); 
		} else if (!strcasecmp(uebuf,"d")) {
			uemove(19,5);
			if (!(Prompt(euser->user_zipcity,sizeof(euser->user_zipcity),0))) 
				return(0);
			mysql_escape_string(tempbuf, euser->user_zipcity, 
								strlen(euser->user_zipcity));
			mi_sql_setstr(&vm_database, "user_city", "vmatik_user",
						useridbuf, tempbuf); 
		} else if (!strcasecmp(uebuf,"e")) {
			uemove(19,6);
			if (!(Prompt(euser->user_voicephone,
				sizeof(euser->user_voicephone),0))) 
				return(0);
			mysql_escape_string(tempbuf, euser->user_voicephone, 
								strlen(euser->user_voicephone));
			mi_sql_setstr(&vm_database, "user_voicephone", "vmatik_user",
						useridbuf, tempbuf); 
		} else if (!strcasecmp(uebuf,"f")) {
			MD_CTX context;

			uemove(19,7);
			DDPut("              ");
			uemove(19,7);
			uebuf[0]=0;
			if (!(Prompt(uebuf,sizeof(euser->user_password),0))) 
				return(0);
			mi_strupr(uebuf);

			MDInit(&context);
			MDUpdate(&context,uebuf,strlen(uebuf));
			MDFinal(euser->user_password,&context);
			
			mysql_escape_string(tempbuf, euser->user_password, 
								sizeof(euser->user_password));
			mi_sql_setstr(&vm_database, "user_password", "vmatik_user",
						useridbuf, tempbuf); 

		} else if (!strcasecmp(uebuf,"g")) {
			uemove(19,9);
			DDPut("            ");
			uemove(19,9);
			sprintf(uebuf,"%Lu",euser->user_bytesup);
			if (!(Prompt(uebuf,12,0)))
				return(0);
			sscanf(uebuf,"%Lu",&euser->user_bytesup);

			uemove(34,9);
			DDPut("     ");
			uemove(34,9);
			sprintf(uebuf,"%u",euser->user_filesup);
			if (!(Prompt(uebuf,5,0))) 
				return(0);
			euser->user_filesup=atoi(uebuf);

			uemove(19,10);
			DDPut("            ");
			uemove(19,10);
			sprintf(uebuf,"%Lu",euser->user_bytesdn);
			if (!(Prompt(uebuf,12,0))) return (0);
			sscanf(uebuf,"%Lu",&euser->user_bytesdn);

			uemove(34,10);
			DDPut("     ");
			uemove(34,10);
			sprintf(uebuf,"%u",euser->user_filesdn);
			if (!(Prompt(uebuf,5,0))) return (0);
			euser->user_filesdn=atoi(uebuf);
		} else if (!strcasecmp(uebuf,"h")) {
			int sectmp;
			
			uemove(65,2);
			sprintf(uebuf,"%d",euser->user_securitylevel);
			if (!(Prompt(uebuf,3,0))) return(0);
 			sectmp=atoi(uebuf);
			if(sectmp>=0 && sectmp<=31)
			{
				if(nu_setaccess(euser, sectmp))
					ue_set_secdata_to_db(euser);
			}
		} else if (!strcasecmp(uebuf,"i")) {
			time_t curr;
			uemove(65,3);
			sprintf(uebuf,"%d",euser->user_timeremaining);
			if (!(Prompt(uebuf,5,0))) return(0);
 			euser->user_timeremaining=atoi(uebuf);
 			if (euser->user_serial_id==user.user_serial_id) {
 				timeleft=euser->user_timeremaining*60;
				curr=time(0);
				endtime=curr+timeleft;
			}
		} else if (!strcasecmp(uebuf,"j")) {
			uemove(65,4);
			sprintf(uebuf,"%d",euser->user_connections);
			if (!(Prompt(uebuf,5,0))) return(0);
 			euser->user_connections=atoi(uebuf);
		} else if (!strcasecmp(uebuf,"l")) {
			uemove(65,6);
			sprintf(uebuf,"%d",euser->user_defconf_id);
			if (!(Prompt(uebuf,3,0))) return(0);
 			euser->user_defconf_id=atoi(uebuf);
		} else if (!strcasecmp(uebuf,"m")) {
			uemove(65,7);
			sprintf(uebuf,"%d",euser->user_screenlength);
			if (!(Prompt(uebuf,3,0))) return(0);
 			euser->user_screenlength=atoi(uebuf);
		} else if (!strcasecmp(uebuf,"n")) {
askst:
			uemove(1, 19);
			DDPut("[A[33mChange account status: [36mN[0m)ew, [36mA[0m)ctive, [36mD[0m)eleted, [36mF[0m)rozen or [36mQ)[0muit:  [D");
			uebuf[0]=0;
			if (!(Prompt(uebuf,1,0))) return(0);
			if (!strcasecmp(uebuf,"q")) {
				mi_sql_setuser(&vm_database, "user_toggles", 
								euser->user_serial_id, 
								'=', euser->user_toggles);
				DDPut("[A                                                                  ");
				printf("%lu\n", euser->user_toggles);
				DDPut("TOGGLES SAVED!\n");
				sleep(5);
				continue;
			} else if (!strcasecmp(uebuf,"a")) {
                euser->user_toggles &= ~TOGGLE_ACC_STAT_1;
                euser->user_toggles &= ~TOGGLE_ACC_STAT_2;
				DDPut("[A                                                                     ");
                uemove(65,8);         
				DDPut("Active  ");
			} else if (!strcasecmp(uebuf,"n")) {
                euser->user_toggles |= TOGGLE_ACC_STAT_1;
                euser->user_toggles |= TOGGLE_ACC_STAT_2;
				DDPut("[A                                                                     ");
                uemove(65,8);         
				DDPut("New user");
			} else if (!strcasecmp(uebuf,"f")) {
                euser->user_toggles &= ~TOGGLE_ACC_STAT_1;
                euser->user_toggles |= TOGGLE_ACC_STAT_2;
				DDPut("[A                                                                     ");
                uemove(65,8);         
				DDPut("Frozen  ");
			} else if (!strcasecmp(uebuf,"d")) {
                euser->user_toggles |= TOGGLE_ACC_STAT_1;
                euser->user_toggles &= ~TOGGLE_ACC_STAT_2;
				DDPut("[A                                                                     ");
                uemove(65,8);         
				DDPut("Deleted");

				/* deletion lacks nuking of user's dir.. DO! */ 
			}
			goto askst;
		} else if (!strcasecmp(uebuf,"p")) {
			if(ue_seceditor(euser))				// Save changes?
			{
				int online_node;
				
				ue_set_secdata_to_db(euser);
				online_node=mi_isonline(euser->user_serial_id);
				if(online_node)
				{
					struct VMatik_nodemessage olm;
					
					memset(&olm, 0, sizeof(struct VMatik_nodemessage));
					olm.dn_command=NODEMSG_RELOAD_USER;
					ol_send_defined(online_node, &olm);
				}
			}
		}				
	}
	return(0);
}

/*
 * The SECB_* flags editor
 *
 */
int ue_seceditor(struct userbase *euser)
{
	char buf1[800];
	char cbuf1[80];
	char uebuf[80];
	int ret=0;
	int i;
	struct flagstr *cf;

	while(!ret)
	{
		int ec=0;
		cf=fl;
		confstostr(euser->user_confacc,cbuf1);
		sprintf(buf1,"[2J[H\n[32m1[0m) Security Level  : [33m%-3d            [32m2[0m) Daily Time      : [33m%d\n[32m3[0m) Byte Ratio      : [33m%-3d            [32m4[0m) File Ratio      : [33m%d\n[32m5[0m) CA (01-64): [33m%s\n\n",euser->user_securitylevel,euser->user_dailytimelimit,euser->user_fileratio1,euser->user_byteratio1,cbuf1);
		DDPut(buf1);
		while(cf->fl_desc) 
		{
			bint bfield;

			bfield=euser->user_secflags;
			sprintf(buf1,"[32m%2d[0m) %-15.15s: [33m%s",cf->fl_num,cf->fl_desc,(bfield & cf->fl_bit) ? "Yes  " : "No   ");
			DDPut(buf1);
			ec++;
			if (ec==3) {
				DDPut("\n");
				ec=0;
			}
			cf++;
		}

		while(1)
		{
			DDPut("[22;1H[0mSelect field to be altered ([36mSA[0mve, [36mAB[0mort or [36mVI[0mew):     [4D");
			*uebuf=0;
			if (!(Prompt(uebuf,3,0))) return 0;

			if (!strcasecmp(uebuf,"sa")) {
				ret=1;
				break;
			} else if (!strcasecmp(uebuf,"ab")) {
				ret=2;
				break;
			} else if (!strcasecmp(uebuf,"vi")) {
				break;
			} else if ((i=atoi(uebuf))) {
				switch (i)
				{
					case 1:
					uemove(22,2);
					sprintf(uebuf,"%d",euser->user_securitylevel);
					if (!(Prompt(uebuf,3,0))) return 0;
					euser->user_securitylevel=atoi(uebuf);
					break;
					
					case 2:
					uemove(58,2);
					sprintf(uebuf,"%u",euser->user_dailytimelimit);
					if (!(Prompt(uebuf,5,0))) return 0;
					euser->user_dailytimelimit=atoi(uebuf);
					break;
					
					case 3:
					uemove(22,3);
					sprintf(uebuf,"%u",euser->user_byteratio1);
					if (!(Prompt(uebuf,3,0))) return 0;
					euser->user_byteratio1=atoi(uebuf);
					break;
					
					case 4:
					uemove(58,3);
					sprintf(uebuf,"%u",euser->user_fileratio1);
					if (!(Prompt(uebuf,3,0))) return 0;
					euser->user_fileratio1=atoi(uebuf);
					break;

					case 5:
					uemove(16,4);
					if (!(Prompt(cbuf1,64,0))) return 0;
					euser->user_confacc=strtoconfs(cbuf1);
					break;
					
				}
				if (i > 5 && i < 51) {
					cf=fl;
					while(cf->fl_num!=i) cf++;
					if (euser->user_secflags & cf->fl_bit) 
					{
						euser->user_secflags &= ~cf->fl_bit;
						uemove(cf->fl_x,cf->fl_y);
						DDPut("No ");	  
                   	} else {
						euser->user_secflags |= cf->fl_bit;
						uemove(cf->fl_x,cf->fl_y);
						DDPut("Yes");	  
                   	}
				}
			}
		}
	}
	
	if (ret==1) {
		return(1);					// Save changes
	} else {
		return(0);					// Abort
	}
}

/*
 * Convers a confss to string *str
 *
 */
void confstostr(bint confacc, char *str)
{
	int i;
//	char buffer[512];
	
	for (i=0; i!=64; i++)
	{
		if (confacc & (1LL<<i)) 
		{
//			sprintf(buffer, "%d set\n", i);
//			DDPut(buffer);
			*str++='X';
		}
		else
			*str++='_';
	}
	*str=0;
}

bint strtoconfs(char *str)
{
	int i;
	bint confd=0;

	for (i=0;i!=64;i++)
	{
		if (*str++=='X') confd |= (1LL<<i);
	}
	return confd;
}

void uemove(int x, int y)
{
	char movebuf[30];
	
	sprintf(movebuf,"[33m[%d;%dH",y,x);
	DDPut(movebuf);
}

/*
 * This creates some user search criterions
 *
 */
int ue_parse_orders(char *orders)
{
	char buffer[512];

	DDPut("By\n\nA) All\nH) Handle <handle>\nR) Realname <name>\nI) ID num <num>\n\n? ");
	buffer[0]=0;
	if(!Prompt(buffer, 80, 0))
		return(0);

	switch(buffer[0])
	{
		case 'h':
		case 'H':
			if(strlen(buffer)<3)
			{
				DDPut("\nArgument missing...\n\n");
				return(0);
			}
			sprintf(orders, "user_handle='%s'", &buffer[2]);
			break;
		case 'r':
		case 'R':
			if(strlen(buffer)<3)
			{
				DDPut("\nArgument missing...\n\n");
				return(0);
			}
			sprintf(orders, "user_realname='%s'", &buffer[2]);
			break;
		case 'I':
		case 'i':
			if(strlen(buffer)<3)
			{
				DDPut("\nArgument missing...\n\n");
				return(0);
			}
			sprintf(orders, "user_id=%s", &buffer[2]);
			break;
		case 'a':
		case 'A':
			sprintf(orders, "1");					// Always true :)
			break;
		default:
			DDPut(sd[euabortedstr]);
			return(0);
			break;
	}
	return(1);
}

