/*
 * Functions related to displaying strings and textfiles to user.
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>

#include "proto.h"

int dotype (char *file, int flags);

int doconv=1;

/*
 * DDPut is the function to output a string to user
 *
 */
void DDPut(unsigned char * typeme)
{
	unsigned char *tempmem;
  
	int len1;
	int i=0;
	int k=0;
	int s=0;
	int t=0;
  	int u;
  	int go=1;

	if (bgmode) return;
	if (*typeme==1) {
		typeme++;
		TypeFile(typeme,TYPE_MAKE|TYPE_WARN|TYPE_CONF);
		return;
	}
	
  	len1=strlen(typeme);
  	tempmem=(void *)malloc(len1*2);

  	while (typeme[i]!=0)
  	{
  		if (typeme[i]==10) 
		{ 
    			tempmem[k]=13;
    			tempmem[k+1]=10;
    			i++;
    			k=k+2;
    	} 
		else 
		{
    			tempmem[k]=typeme[i];
    			k++; 
    			i++;
    	}
    }

  	tempmem[k]=0;

  	if (!ansi) {
  		while (go)
  		{
   			if (tempmem[s]==27) {
	    			u=s;
    				s=s+2;
 skiploop:
				if (s) goto go1;
				go=0;
				goto gooff;
go1:
				if (tempmem[s] >= 'A') goto go2;
				s++;
				goto skiploop;
go2:
				if (tempmem[s] == 'm') goto go3;
				s=u; tempmem[t]=tempmem[s]; t++;
go3:
				s++;
gooff:;
			} else {
				tempmem[t]=tempmem[s]; t++;s++; 
 				if(tempmem[s]==0) go=0; 
    			}
		}
		tempmem[t]=0;
	}
	if (conon&&conout) write(conout,tempmem,strlen(tempmem));
	if (doconv && display && display->DISPLAY_ATTRIBUTES & DISP_OUTGOING_CONV) 
	{
		unsigned char *s;
		s=tempmem;
		while (*s) {
			*s=outconvtab[*s];
			s++;
		}
	}
	if (userinput && checkcarrier() && serhandle!=conin) write(serhandle,tempmem,strlen(tempmem));
	free(tempmem);
}

void stripansi(char *tempmem)
{

	int go=1;
	int s=0;
	int t=0;
	int u;
	
  	while (go)
  	{
   		if (tempmem[s]==27) {
    			u=s;
  			s=s+2;
skiploop:
			if (s) goto go1;
			go=0;
			goto gooff;
go1:
			if (tempmem[s] >= 'A') goto go2;
			s++;
			goto skiploop;
go2:
			if (tempmem[s] == 'm') goto go3;
			s=u; tempmem[t]=tempmem[s]; t++;
go3:
			s++;
gooff:;
		} else {
			tempmem[t]=tempmem[s]; t++;s++; 
			if(tempmem[s]==0) go=0; 
    		}
	}
	tempmem[t]=0;
}

/*
 * This types some file for user to see. As default, the
 * file should be located in the global display/ dir.
 * 
 * flags: TYPE_CONF == file is located in this conference's display
 *                     directory
 *        TYPE_SEC  == check for security level
 *        TYPE_MAKE == not sure about this (yet)
 *        TYPE_WARN == warning if the file is missing
 *
 */
int TypeFile(char *typethis, int flags)
{
	char buffer[300];
	
	if ((flags & TYPE_CONF) && (flags & TYPE_SEC)) {
		sprintf(buffer,"%sdisplay/%s%s.%d.%s",conf->CONF_PATH, display->DISPLAY_PATH,typethis, user.user_securitylevel,ansi ? "gfx" : "txt");
		if (dotype(buffer,flags))
			return 1;
		if (ansi && display->DISPLAY_ATTRIBUTES & DISP_NO_GFX_IS_TXT) 
		{
			sprintf(buffer,"%sdisplay/%s%s.%d.txt",conf->CONF_PATH,
					display->DISPLAY_PATH,typethis,user.user_securitylevel);
			if (dotype(buffer,flags)) return 1;
		}
	}
	if (flags & TYPE_CONF) 
	{
		sprintf(buffer,"%sdisplay/%s%s.%s", conf->CONF_PATH, 
				display->DISPLAY_PATH,typethis, ansi ? "gfx" : "txt");
		if (dotype(buffer,flags)) 
			return 1;
		if (ansi && display->DISPLAY_ATTRIBUTES & DISP_NO_GFX_IS_TXT) 
		{
			sprintf(buffer,"%sdisplay/%s%s.txt",conf->CONF_PATH, display->DISPLAY_PATH,typethis);
			if (dotype(buffer,flags)) 
				return 1;
		}
	}

	if ((flags & TYPE_MAKE) && (flags & TYPE_SEC)) {
		sprintf(buffer,"display/%s%s.%d.%s",display->DISPLAY_PATH,typethis, user.user_securitylevel,ansi ? "gfx" : "txt");	
		if (dotype(buffer,flags)) return 1;
		if (ansi && display->DISPLAY_ATTRIBUTES & DISP_NO_GFX_IS_TXT)
		{
			sprintf(buffer,"display/%s%s.%d.txt",display->DISPLAY_PATH,
					typethis,user.user_securitylevel);
			if (dotype(buffer,flags)) return 1;
		}
	}
	if (flags & TYPE_MAKE) {
		sprintf(buffer,"display/%s%s.%s",display->DISPLAY_PATH,typethis, ansi ? "gfx" : "txt");	
		if (dotype(buffer,flags)) 
			return 1;
		if (ansi && display->DISPLAY_ATTRIBUTES & DISP_NO_GFX_IS_TXT) 
		{
			sprintf(buffer,"display/%s%s.txt",display->DISPLAY_PATH,typethis);
			if (dotype(buffer,flags)) 
				return 1;
		}
	} else {
		if (dotype(typethis,flags))
			return 1;
	}
	if (flags & TYPE_WARN) {
		sprintf(buffer,sd[missingtextstr],typethis);
		DDPut(buffer);
	}
	return 0;
}

/*
 * This handles for example the input #XX conversion
 *
 */
int dotype(char *fileh, int flags)
{
	FILE *kala;
	char buffer[3000];
	int sl;
	unsigned char hot;
	unsigned char *s, *t;
	char codebuf[512];
	int nocodes=0;
	int olda;
		
	if(flags & TYPE_NOCODES) 
		nocodes=1;
		
	if(onlinestat) 
		sl=user.user_screenlength;
	else 
		sl=-1;

	if ( (kala=fopen(fileh,"r")) ) {
		olda=ansi;
		if (flags & TYPE_NOSTRIP) {
			ansi=1;
		}
		while (fgets(buffer,2900,kala)) {
			if (nocodes) {
				if (display && 
					(display->DISPLAY_ATTRIBUTES & DISP_FILE_CONV)) 
				{
					doconv=0;
				}
				DDPut(buffer);
				doconv=1;
			} else {
				s=buffer;
				t=s;
				while(*t)
				{
					if (*t=='~' && *(t+1)=='#') {
						*t=0;
						DDPut(s);
						t=t+2;

						if (*t=='P' && *(t+1)=='A') {
							HotKey(0);
						} else if (*t=='R' && *(t+1)=='E') {
							DDPut(sd[pausestr]);
							HotKey(0);
						} else if (*t=='R' && *(t+1)=='N') {
							DDPut(user.user_realname);
						} else if (*t=='H' && *(t+1)=='A') {
							DDPut(user.user_handle);
						} else if (*t=='O' && *(t+1)=='R') {
							DDPut(user.user_organization);
						} else if (*t=='L' && *(t+1)=='O') {
							DDPut(user.user_zipcity);
						} else if (*t=='P' && *(t+1)=='V') {
							DDPut(user.user_voicephone);
						} else if (*t=='P' && *(t+1)=='D') {
							DDPut(user.user_dataphone);
						} else if (*t=='S' && *(t+1)=='L') {
							sprintf(codebuf,"%d",user.user_screenlength);
							DDPut(codebuf);
						} else if (*t=='P' && *(t+1)=='R') {
							if (protocol) DDPut(protocol->Protocol_Name);
						} else if (*t=='S' && *(t+1)=='I') {
							DDPut(user.user_signature);
						} else if (*t=='E' && *(t+1)=='M') {
							DDPut(user.user_email);
						} else if (*t=='D' && *(t+1)=='A') {
                            time_t aika;
                            char *aikas;
                                    
                            aika=time(0);
                            aikas=ctime(&aika);
                            aikas[24]=0;
                            DDPut(aikas);
						} else if (*t=='I' && *(t+1)=='D') {
							sprintf(codebuf,"%d",user.user_serial_id);
							DDPut(codebuf);
						} else if (*t=='D' && *(t+1)=='T') {
							sprintf(codebuf,"%d",user.user_dailytimelimit);
							DDPut(codebuf);
						} else if (*t=='F' && *(t+1)=='C') {
							sprintf(codebuf,"%24.24s",ctime(&user.user_firstcall));
							DDPut(codebuf);
						} else if (*t=='L' && *(t+1)=='C') {
							sprintf(codebuf,"%24.24s",ctime(&user.user_lastcall));
							DDPut(codebuf);
						} else if (*t=='O' && *(t+1)=='L') {
							sprintf(codebuf,"%d",bpsrate);
							DDPut(codebuf);
						} else if (*t=='S' && *(t+1)=='E') {
							sprintf(codebuf,"%d",user.user_securitylevel);
							DDPut(codebuf);
						} else if (*t=='U' && *(t+1)=='B') {
							sprintf(codebuf,"%Lu",user.user_bytesup);
							DDPut(codebuf);
						} else if (*t=='U' && *(t+1)=='F') {
							sprintf(codebuf,"%d",user.user_filesup);
							DDPut(codebuf);
						} else if (*t=='M' && *(t+1)=='L') {
							if (user.user_flines)
							  sprintf(codebuf,"%d",user.user_flines);
							else strcpy(codebuf,"Unlimited");
							DDPut(codebuf);
						} else if (*t=='D' && *(t+1)=='B') {
							sprintf(codebuf,"%Lu",user.user_bytesdn);
							DDPut(codebuf);
						} else if (*t=='D' && *(t+1)=='F') {
							sprintf(codebuf,"%d",user.user_filesdn);
							DDPut(codebuf);
						} else if (*t=='B' && *(t+1)=='A') {
							dl_freebstr(codebuf);
							DDPut(codebuf);
						} else if (*t=='F' && *(t+1)=='A') {
							dl_freefstr(codebuf);
							DDPut(codebuf);
						} else if (*t=='M' && *(t+1)=='P') {
							sprintf(codebuf,"%d",user.user_pubmessages+user.user_prvmessages);						
							DDPut(codebuf);
						} else if (*t=='T' && *(t+1)=='C') {
							sprintf(codebuf,"%d",user.user_connections);
							DDPut(codebuf);
						} else if (*t=='P' && *(t+1)=='A') {
							sprintf(codebuf,"%d",pages);
							DDPut(codebuf);
						} else if (*t=='C' && *(t+1)=='N') {
							DDPut(conf->CONF_NAME);
						} else if (*t=='C' && *(t+1)=='U') {
							sprintf(codebuf,"%d",conf->CONF_NUMBER);
							DDPut(codebuf);						
						} else if (*t=='M' && *(t+1)=='C') {

							char *cm, *sr;
							cm=codebuf;
							sr=t+2;
							while (*sr!='|') *cm++=*sr++;
							*cm=0;
							t=sr-1;
							docmd(codebuf,0);
						} else if (*t=='T' && *(t+1)=='F') {

							char *cm, *sr;
							cm=codebuf;
							sr=t+2;
							while (*sr!='|') *cm++=*sr++;
							*cm=0;
							t=sr-1;
							TypeFile(codebuf,0);
						} else if (*t=='N' && *(t+1)=='M') {
							sl=-1;
						} else if (*t=='N' && *(t+1)=='C') {
							nocodes=1;
						} else if (*t=='R' && *(t+1)=='A') {
							char rbuf[1024];
							char randbuf[10];
							char *cm;
							char *sr=t+2;
							int rmax;
							time_t rtime;
							
							cm=codebuf;
							while (*sr!='|') *cm++=*sr++;
							*cm=0;
							sr++;
							cm=randbuf;
							while (*sr!='|') *cm++=*sr++;
							*cm=0;
							rmax=atoi(randbuf);
							t=sr-1;
							rtime=time(0);
							srand(rtime);
							sprintf(rbuf,codebuf,(rand()%rmax)+1);
							TypeFile(rbuf,TYPE_WARN);
						}
						t=t+2;
						s=t;
					} else t++;			
				}			
				if (display && 
					!(display->DISPLAY_ATTRIBUTES & DISP_FILE_CONV))
				{
					doconv=0;
				}
				DDPut(s);
				doconv=1;
			}
			sl--;

			if (sl==0) {
				DDPut(sd[morepromptstr]); 
				hot=HotKey(0);
				DDPut("\r                                                         \r");
				if (hot=='N'||hot=='n'||hot=='q'||hot=='Q') break;
				if (hot=='C'||hot=='c') {
					sl=-1;
				} else {
					sl=user.user_screenlength;
				}
			}
       	}
   		fclose(kala);
		ansi=olda;
		return 1;
  	} 
	else 
	{
		return 0;
	}
}

/*
 * This processes a nodemessage. In addition to sending "OLM"s from
 * user to another, a nodemessage can be used to get a running 
 * vmatik node alter its status.
 *
 */
int processmsg(struct VMatik_nodemessage *ddm)
{
	struct olm *myolm;
	char buf[1024];
	
//	DDPut("Got message!\n");
		
	switch (ddm->dn_command) {
		case NODEMSG_PRIVATE:
			if(ddm->dn_data1!=user.user_serial_id)  // If != then Discard, 
				break;								// else fall through
		case NODEMSG_NORMAL:
			myolm=malloc(sizeof(struct olm));
			strcpy(myolm->olm_msg,ddm->dn_string);
			myolm->olm_number=0;
			AddTail(olms,(struct Node*)myolm);
			break;
		case NODEMSG_NUMBERED:
			myolm=malloc(sizeof(struct olm));
			strcpy(myolm->olm_msg,ddm->dn_string);
			myolm->olm_number=ddm->dn_data1;
			AddTail(olms,(struct Node*)myolm);
			break;
		case NODEMSG_CHAT:
			LineChat();
			break;
		case NODEMSG_DROPCARRIER:
			ma_dropcarrier();

			sprintf(buf,"User kicked out at %s\n",currt());
			writelog(buf);
			break;
		case NODEMSG_USEREDITOR:
			usered();
			break;
		case NODEMSG_RELOAD_USER:
			mi_loaduser(user.user_serial_id, &user);
			break;
		case NODEMSG_RELOAD_STRINGS:
			// Disabled at the moment
			break;
		case NODEMSG_NEW_TIMELEFT:
			endtime=time(NULL)+(ddm->dn_data1*60)+59;
			break;
		default:
			break;
	}

	return(1);
}

