/*
 * "flagged files" editing related
 *
 */
#include "proto.h"
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>

extern char *Desc;

int te_taged(MYSQL *db, char *params, int flags)
{
	char buf[512];
	char parbuf[512];
	char *srcstrh;
	char *kelos;
	
	setprotocol();  
	srcstrh=params;

	if (!(kelos=strspa(srcstrh,parbuf))) 
	{
		te_listflagged(db);
	}

	while(1)
	{
		if (!(srcstrh=strspa(srcstrh,parbuf)))
		{
			DDPut(sd[tepromptstr]);
			buf[0]=0;
			parbuf[0]=0;
			if (!(Prompt(buf,100,0))) return 0;                     
			srcstrh=buf;
			srcstrh=strspa(srcstrh,parbuf);
		}
		if (!strcasecmp(parbuf,"q") || parbuf[0]==0) {
			te_recountfiles();
			return(0);
		} else if (!strcasecmp(parbuf,"r")) {
			if (!(srcstrh=strspa(srcstrh,parbuf)))
			{
				DDPut(sd[teremprstr]);
				buf[0]=0;
				if (!(Prompt(buf,100,0))) return 0;                     
				srcstrh=buf;
				srcstrh=strspa(srcstrh,parbuf);
			}

			DDPut("\n");
			do 
			{
				MYSQL_RES *sql_result;
				MYSQL_ROW sql_row;
				char sqlbuf[QUERY_MAX];
				char query[QUERY_MAX];
				char query2[QUERY_MAX];
				int wild_found;

				wild_found=mi_wild2sql(sqlbuf, parbuf);

				sprintf(query, "SELECT file_id 
								FROM vmatik_filelist, vmatik_flagged
								WHERE file_name%s'%s' AND
								file_id=flagged_id AND flagged_user=%d",
								(wild_found ? " like " : "="), sqlbuf,
								user.user_serial_id);
				mysql_query(db, query);
				sql_result=mysql_store_result(db);
				if(sql_result)
				{
					while((sql_row=mysql_fetch_row(sql_result)))
					{
						sprintf(query2, "DELETE FROM vmatik_flagged
										WHERE flagged_id=%s AND
										flagged_user=%d",
										sql_row[0], user.user_serial_id);
						mysql_query(db, query2);
					}
//					DDPut(query);
//					DDPut("\n\n");
					mysql_free_result(sql_result);
				}
			
			} while((srcstrh=strspa(srcstrh,parbuf)));
			
			te_recountfiles();
		} else if (!strcasecmp(parbuf,"l")) {
			te_listflagged(db);
		} else {
			te_flagfile(parbuf,1);
		}
	}
}

int flagres(int res, char *file, int size)
{
	char buf[512];
	switch(res)
	{
		case 0:
		case 4:
			sprintf(buf,sd[tetaggedstr],file,size);
			if (res==4) strcat(buf,sd[tefreestr]); else strcat(buf,"\n");
			DDPut(buf);
		break;
		case 1:
			sprintf(buf,sd[teulratstr],file);
			DDPut(buf);
		break;
		case 2:
			sprintf(buf,sd[teulbratstr],file);
			DDPut(buf);
		break;
		case 3:
			sprintf(buf,sd[tealflagstr],file);
			DDPut(buf);
		break;
	}
	return res;
}

/*
 * This function flags a file :)
 *
 */
int te_flagfile(char *file, int mode)
{
	struct SystemFunctions func;
	
	memset(&func, 0, sizeof(struct SystemFunctions));
	func.displayfunction=fl_display_dummy;
	func.maintfunction=fl_flagfile;

	return(fl_browselist(file, &func, "Flag", mode|MODE_SHUTUP,&vm_database));
}

void secstosentence(int secs, char *buf)
{

	char buffa[30];
	int hr=0;
	int min=0;
	int sec=0;
	
	buf[0]=0;
	
	while (secs > 3599) {
		hr++;
		secs-=3600;
	}
	while (secs > 59) {
		min++;
		secs-=60;
	}
	sec=secs;
	
	if (hr > 1) {
		sprintf(buf,"%d hours",hr);
	} else if (hr==1) {
		strcat(buf,"1 hour");
	}

	if (min) {
		if (hr) strcat(buf,", ");
		if (min > 1) {
			sprintf(buffa,"%d minutes",min);
			strcat(buf,buffa);
		} else strcat(buf,"1 minute");
	}

	if (sec || (!min && !hr)) {
		if (hr || min) strcat(buf,", ");
		if (sec != 1) {
			sprintf(buffa,"%d seconds",sec);
			strcat(buf,buffa);
		} else strcat(buf,"1 second");
	}  
}

int estimsecs(int bytes)
{
	if (!bpsrate) return 0;
	return bytes/(((bpsrate/9)*protocol->Protocol_Efficiency)/100);
}

/*
 * Recounts the amounts of tagged files and bytes
 *
 */
void te_recountfiles(void)
{
	char buffer[QUERY_MAX];

	filestagged=bytestagged=0;
	ffilestagged=fbytestagged=0;

	sprintf(buffer, "flagged_user=%d", user.user_serial_id);
	
	filestagged=mi_sql_getnum(&vm_database, "count(*)" , "vmatik_flagged",
	buffer);

	strcat(buffer, " AND flagged_id=file_id");	
	bytestagged=mi_sql_getnum(&vm_database, "sum(file_size)", 
				"vmatik_flagged,vmatik_filelist", buffer);
	
	sprintf(buffer, "flagged_user=%d AND flagged_id=file_id AND (file_flags &
			%ld)", user.user_serial_id, FILE_FREEDL);

	ffilestagged=mi_sql_getnum(&vm_database, "count(*)", "vmatik_flagged,
	vmatik_filelist", buffer);

	fbytestagged=mi_sql_getnum(&vm_database, "sum(file_size)", "vmatik_flagged,
	vmatik_filelist", buffer);
}

/*
 * Checks if user has the file tagged
 * 
 * Returns: 1 == true, 0 == false
 *
 * BUGS: Out of order
 *
 */
int te_isfiletagged(char *fn)
{
	return(0);
}

/*
 * Lists the files flagged by user
 *
 */
int te_listflagged(MYSQL *db)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	char buf[512];
	char tb[50];
	
	sprintf(query, "SELECT file_name, file_size, if((file_flags & %ld)<>0 || 
						(area_flags & %ld)<>0,'1','0') 
					FROM vmatik_filelist, vmatik_flagged, vmatik_fileareas
					WHERE flagged_id=file_id AND flagged_user=%d AND
					      area_id=file_area
					ORDER BY file_name",
					FILE_FREEDL, AREA_FREEDL, user.user_serial_id);
	mysql_query(db, query);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		int i,total_bytes=0,temp_size;
		
		sprintf(buf,sd[telisthstr],bpsrate,protocol->Protocol_Name);
		DDPut(buf);     
		
		for(i=0;i<mysql_num_rows(sql_result);i++)
		{
			sql_row=mysql_fetch_row(sql_result);
			
			temp_size=atoi(sql_row[1]);
			secstosentence(estimsecs(temp_size),tb);
			
			total_bytes+=temp_size;
			sprintf(buf,"[33m%-16.16s [35m%-13d [36m%s ",
						sql_row[0], temp_size,tb);
			if (sql_row[2][0]=='1') 
				strcat(buf,sd[tefreestr]); 
			else 
				strcat(buf,"\n");
	
			DDPut(buf);
			
//			sprintf(buf, "%3d %-18.18s %10d\n", i+1, sql_row[0],
//					temp_size);
//			DDPut(buf);
		}
		
		mysql_free_result(sql_result);
		
		DDPut(sd[tetailstr]);
		secstosentence(estimsecs(total_bytes),tb);
		sprintf(buf,sd[tetotstr],total_bytes,tb);
		DDPut(buf);
	
		return(1);
	}
		
	return(0);
}

/*
 * BUGS: Out of order
 *
 */
int te_unflagfile(char *file)
{
	return(1);
}

/*
 * Removes all selected files
 *
 */
int te_clearflagged(MYSQL *db, int user_id)
{
	char query[QUERY_MAX];

	sprintf(query, "DELETE FROM vmatik_flagged WHERE
			flagged_user=%d", user_id);
	mysql_query(db, query);

	return(1);
}
