/*
 * This file contains all the data structures and #defines (macros)
 *
 */

#ifndef	VMATIK_STRUCT_H
#define	VMATIK_STRUCT_H

#include <mysql/mysql.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <limits.h>

#include "config.h"

#define versionstring "0.2.0"

#ifndef VMTMP
#define VMTMP "/tmp/vmatik/"
#endif

#ifndef YELLD_SOCKET
#define YELLD_SOCKET "/tmp/vmatik_yelld"
#endif

#define DESC_MAX 20						// Max lines in file description
#define DESC_LINELENGTH 44				// Length of a desc line
#define ED_DEFAULT_MAX_LINES  500		// Just that :)
#define ED_DEFAULT_MAX_COLUMNS 80		// Can't be more currently

#define QUERY_MAX		4096			// MySQL query string length
#define COPY_BUFSIZE	65536			// When internally copying files
#define	NODEMSGSIZE_MAX	200				// Note: this might be socket-
                                        // related, and not changeable
										// at free will.

#define bint unsigned long long

#define UBYTE unsigned char
#define UWORD unsigned short
#define ULONG unsigned long
#define BYTE char

#define PASSWD_SIZE		16				// For MD5 functions

struct List {
	struct Node *lh_Head;
	struct Node *lh_Tail;
	struct Node *lh_TailPred;
};

struct Node {
	struct Node *ln_Succ;
	struct Node *ln_Pred;
};

struct olm {
	struct Node olm_head;
	char olm_msg[200];
	int olm_user;
	int olm_number;
};

struct cursordat {
	int cd_line;
	char cd_file[40];
};

struct Selected {
	struct Node shead;
	char	type;			// See below for types
	ULONG	ID;
	ULONG	conf_nr;
};

#define SEL_FILEAREA		1
#define SEL_MSGBASE         2
#define SEL_CONF			3

struct VMatik_nodemessage {
	UWORD dn_command;
	ULONG dn_data1;
	ULONG dn_data2;
	ULONG dn_data3;
	char  dn_string[NODEMSGSIZE_MAX];
};

#define	NODEMSG_NORMAL			1
#define NODEMSG_NUMBERED		2
#define	NODEMSG_CHAT			3
#define NODEMSG_DROPCARRIER		4
#define	NODEMSG_USEREDITOR		5
#define NODEMSG_PRIVATE     	6		// It's meant for a specific user_id
#define NODEMSG_RELOAD_USER 	7       // Reload the current user infos
#define NODEMSG_RELOAD_STRINGS  8 		// Reload the display/strings.???
#define NODEMSG_NEW_TIMELEFT    9       // Alter users time remaining

#define JC_LIST		(1L<<0)
#define JC_SHUTUP	(1L<<1)
#define JC_QUICK	(1L<<2)
#define JC_ABSOLUTE (1L<<3)

#define FLAG_FREE	(1L<<0)

#define HOT_CURSOR	(1L<<0)
#define HOT_YESNO	(1L<<1)
#define HOT_NOYES	(1L<<2)
#define HOT_QUICK	(1L<<3)
#define HOT_RE		(1L<<4)
#define HOT_DELAY	(1L<<5)
#define HOT_MAIN	(1L<<6)

#define PROMPT_SECRET	(1L<<0)
#define PROMPT_NOCRLF	(1L<<1)
#define PROMPT_FILE		(1L<<2)
#define PROMPT_WRAP		(1L<<3)
#define PROMPT_MAIN		(1L<<4)

#define	STATE_NEXT_SERIAL_ID	(1L<<0)

#define TYPE_MAKE		(1L<<0)
#define TYPE_WARN		(1L<<1)
#define TYPE_NOCODES	(1L<<2)
#define TYPE_CONF		(1L<<3)
#define TYPE_NOSTRIP	(1L<<4)
#define TYPE_SEC		(1L<<5)

#define RESULT_NO			0
#define RESULT_YES			1
#define RESULT_QUIT			2
#define RESULT_CONTINUOUS	3
#define RESULT_INVALID		4

#define MC_QUICK	(1L<<0)
#define MC_NOSTAT	(1L<<1)

struct VMatik_NodeInfo
{
	pid_t ddn_pid;
	int   ddn_userslot;						/* -1 == no user on node */
	char  ddn_activity[80];
	int   ddn_bpsrate;
	char  ddn_pagereason[80];
	char  ddn_path[80];
	int   ddn_timeleft;
	ULONG ddn_flags;
};

struct VMatik_PageMsg
{
	UWORD pm_cmd;
	char  pm_string[300];
};

struct VMatik_MsgPointers
{
	UWORD  msp_low;
	UWORD  msp_high;
};

/*
 * "Last Read Pointer"s for messageareas
 *
 */
struct VMatik_LRP
{
	UWORD lrp_read;
	UWORD lrp_scan;
};

/*
 * This structure stores a RANGE. The idea of range is that some
 * commands affect just those files which the range covers.
 *
 * For example, user input "53-66,100-110" would be interpreted as
 * 
 * Range->range_start=53;
 * Range->range_stop=66;
 * Range->range_next->range_start=100;
 * Range->range_next->range_start=110;
 * Range->range_next->range_next=NULL;
 *
 * In case of just range of single number (example: "55"), both
 * start and stop will be the same. NULL as next ends the range.
 *
 */ 
struct Range
{
	struct Node head;
	ULONG range_start;
	ULONG range_stop;
};

/*
 * This is a simulacrum of the datas stored in vmatik_filelist sql table. 
 * 
 */
struct FileType
{
	char 	Name[256];			// File name
	ULONG   Size;				// File size
	ULONG 	ByID;				// Uploader's account serial#
	ULONG	ToID;				// Receiver's account serial#
	ULONG	Flags;              
	
	short	Downloads;			// How many times has it been DLed?

	UBYTE	Backuped;			// 0 == nope, >0 == backup_id

	BYTE	Integrity;			/*  -1 == failed, 
									 0 == not tested,
                                     1 == passed,
									 2 == not testable */
	time_t	UploadDate;			// When was it uploaded?
	time_t	DownloadDate;		// Last DL date?

	ULONG	Bytes_To_ULer;		// byte credz given
	UWORD	Files_To_ULer;		// file credz given

	char	*Description;		// OBS! Just a pointer!
};

#define		INTEGRITY_NOT_TESTED		0
#define		INTEGRITY_PASSED			1
#define		INTEGRITY_NOT_TESTABLE		2
#define		INTEGRITY_FAILED			3

#define		SORT_CONF_DEFAULT	0			// Filelist sort orders
#define		SORT_ALPHA			1
#define		SORT_REV_ALPHA		2
#define		SORT_CHRONO			3
#define		SORT_REV_CHRONO 	4

/*
 * This idiotically named structure contains the functions provided
 * for fl_filelist to make it perform different actions.
 *
 */
struct SystemFunctions
{
	int (*maintfunction)(MYSQL *db, MYSQL_ROW sql_row);
	int (*displayfunction)(char *display, char *filename, struct cursordat
							*cdat, struct cursordat *currc);
	int (*initfunction)(MYSQL *db);
	int (*exitfunction)(MYSQL *db);
};

#define 	MAINT_UPDATE	-2	// Means that maintfunction made modifications

struct callerslog 
{
	UWORD cl_userid;
	time_t cl_firstcall; /* Just to be sure we have the right user */
	time_t cl_logon;
	time_t cl_logoff;
	ULONG  cl_ulbytes;
	ULONG  cl_dlbytes;
	UWORD  cl_ulfiles;
	UWORD  cl_dlfiles;
	UWORD  cl_pvtmessages;
	UWORD  cl_pubmessages;
	int    cl_bpsrate;
	int    cl_flags;
};

#define CL_CARRIERLOST	(1L<<0)
#define CL_NEWUSER		(1L<<1)
#define CL_CHAT			(1L<<2)
#define CL_PASSWDFAIL	(1L<<3)
#define CL_PAGEDSYSOP	(1L<<4)
#define CL_RELOGIN		(1L<<5)

struct gcallerslog 
{
	UWORD cl_node;
	struct callerslog cl;
};

/*
 * Note: This does NOT reflect the real userbase stored in SQL database.
 *       It is just meant to be a structure to keep some of the users
 *       data in memory while the user is online.
 *
 */
struct userbase
{
	char	user_realname[26];
	char	user_handle[26];
	char	user_organization[26];
	char	user_email[40];
	char	user_zipcity[21];
	char	user_voicephone[21];
	char	user_dataphone[21];
	UBYTE	user_password[PASSWD_SIZE];	// Binary! Never use w/ string funct!
	UBYTE	user_screenlength;
	UBYTE	user_protocol;
	ULONG	user_toggles;
	char	user_signature[45];
	UBYTE	user_flines;
	bint	user_bytesup;					// Bytes uploaded	
	bint    user_bytesdn;					// Bytes downloaded
	UWORD	user_filesup;					// Files uploaded
	UWORD	user_filesdn;					// Files downloaded
	UWORD	user_filecred;					// Available download credits
	bint	user_bytecred;
	UWORD	user_filesup_bad;				// Amount of bad uploads
	bint	user_bytesup_bad;
	UWORD	user_pubmessages;
	UWORD	user_prvmessages;
	UWORD	user_connections;
	UBYTE	user_fileratio1;
	UBYTE	user_byteratio1;
	UBYTE	user_fileratio2;
	UBYTE	user_byteratio2;
	UBYTE	user_fileratio3;
	UBYTE	user_byteratio3;
	char	user_computermodel[21];
	UBYTE	user_failedlogins;
	UBYTE	user_securitylevel;
	UBYTE	user_defconf_id;
	UBYTE	user_defarea_id;
	time_t	user_firstcall;
	time_t	user_lastcall;
	time_t  user_logontime;
	bint	user_confacc;
	bint    user_secflags;
	UWORD	user_dailytimelimit;
	int		user_serial_id;
	UWORD	user_timeremaining;
	char	user_inetname[9];
	char 	user_freeblock[23];
};

#define		TOGGLE_FSED			(1L<<0)		// Default editor is FullScreenED
#define		TOGGLE_EXPERT		(1L<<1)		// No automatic menu display
#define		TOGGLE_NOMAILCHECK	(1L<<2)
#define		TOGGLE_NEWSCAN_ON	(1L<<3)
#define		TOGGLE_ALLOWNODE	(1L<<4)		// What's this?
#define		TOGGLE_ANSWERED_NQ	(1L<<5)
#define		TOGGLE_NO_OLMS		(1L<<6)
#define		TOGGLE_NO_CLS_IN_F	(1L<<7)		// No CLS's in filelists?
#define		TOGGLE_ASK_EDITOR	(1L<<8)
#define		TOGGLE_ASK_MAILSCAN	(1L<<9)
#define		TOGGLE_ASK_FILESCAN	(1L<<10)
#define		TOGGLE_QUICK_UL		(1L<<11)	// Don't ask about file_id.diz
#define		TOGGLE_ACC_STAT_1	(1L<<30)
#define		TOGGLE_ACC_STAT_2	(1L<<31)


/* user_toggles:
BIT  0:MEANING                    1:MEANING                  ON/OFF TOGGLES #1
==============================================================================
030  Account Status #1 \ 0 = Active  0 = Frozen  1 = Deleted  1 = New Account
031  Account Status #2 / 0           1           0            1
==============================================================================
*/

struct VMatik_DoorMsg
{
	UWORD ddm_command;
	ULONG ddm_data1;
	ULONG ddm_data2;
	ULONG ddm_data3;
	bint ddm_ldata;
	char  ddm_string[300];
};

struct VMatik_Conference
{
	struct Node chead;
	UBYTE	CONF_NUMBER;
	char CONF_NAME[40];
	char CONF_PATH[40];
	UWORD CONF_UL_TIMEREWARD;
	struct VMatik_MsgBase *Conf_MsgBases;
	UBYTE CONF_MSGBASES;
	UBYTE	CONF_UPLOADAREA;
	UBYTE CONF_STARTAREA;
	UBYTE	CONF_COMMENTAREA;
	UWORD	CONF_ATTRIBUTES;
	char CONF_PASSWD[16];
	char CONF_FREEBLOCK[116];
};

#define CONF_FREELEECH				(1L<<0)
#define CONF_NO_CREDITS				(1L<<1)
#define CONF_USE_SENT_BY			(1L<<2)		// Unused
#define CONF_ASK_DESCRIPTION		(1L<<3)
#define CONF_VALIDATE_UPLOADS		(1L<<4)
// (1L<<5) free
// (1L<<6) free
#define CONF_NO_DUPECHECK			(1L<<7)
#define	CONF_NO_FILECHECK			(1L<<8)
#define CONF_GLOBAL_DUPECHECK		(1L<<9)
#define CONF_PRIVATE_FLAG			(1L<<10)

/* CONF_ATTRIBUTES:
BIT   MEANING WHEN SET AS PRESENTED BELOW                     CONFERENCE FLAGS
==============================================================================
000   FREE-DOWNLOAD ON ALL FILES IN THIS CONFERENCE
001   NO FILE OR BYTE CREDITS FOR UPLOADING
002   USE SENT-BY LINES
003   ASK DESCRIPTIONS FROM UPLOADERS
004   UPLOADS REQUIRE SYSOP'S VALIDATION
005   DO NOT ALLOW WILDCARDS IN FILENAMES (UPLOAD)
006   DO NOT ALLOW WILDCARD FILEFLAGGING
007   NO DUPECHECK (SKIP THIS CONF IN GLOBAL DUPE CHECK)
008   NO FILECHECK
010   PRIVATE FLAG -- DO NOT USE
 :
 :
 
 .
015
==============================================================================
*/

#define MODE_CURRENT		(1L<<0)		// Current area
#define MODE_ALL			(1L<<1)		// All areas
#define MODE_SHUTUP			(1L<<2)		// No output
#define MODE_NOPROMPT		(1L<<3)		// No prompting

#define AREA_NEEDVALIDATE	(1L<<0)		// 1
#define	AREA_FREEDL			(1L<<1)		// 2
#define AREA_CLOSED         (1L<<2)		// 4
#define AREA_NOTRANSFORM    (1L<<3)		// 8

#define FILE_VALIDATED		(1L<<0)		// 1
#define FILE_PRIVATE		(1L<<1)		// 2
#define FILE_FAVORITE		(1L<<2)		// 4
#define FILE_TRANSFORMED	(1L<<3)		// 8
#define FILE_OFFLINE		(1L<<4)		// 16
#define FILE_FREEDL			(1L<<5)		// 32

struct VMatik_MsgBase
{
  UBYTE	MSGBASE_FLAGS;
  UBYTE	MSGBASE_NUMBER;
  UWORD	MSGBASE_LOWEST;
  UWORD	MSGBASE_HIGHEST;
  UWORD	MSGBASE_MSGLIMIT;
  char MSGBASE_NAME[21];
  char MSGBASE_FREEBLOCK2[8];
  char MSGBASE_FN_TAG[26];
  char MSGBASE_FN_ORIGIN[58];
  UBYTE MSGBASE_FN_FLAGS;
  UWORD MSGBASE_FN_ZONE;
  UWORD MSGBASE_FN_NET;
  UWORD	MSGBASE_FN_NODE;
  UWORD	MSGBASE_FN_POINT;
  UBYTE	MSGBASE_READACCESS;
  UBYTE	MSGBASE_POSTACCESS;
  struct VMatik_LRP MSGBASE_LRP;
  char MSGBASE_FREEBLOCK1[168];
};

#define MSGB_ALLOW_PUBLIC		(1L<<0)
#define MSGB_ALLOW_PRIVATE		(1L<<1)
#define MSGB_USE_HANDLES		(1L<<2)
#define MSGB_BLOCK_QUOTE		(1L<<3)
#define MSGB_USE_INITIALS		(1L<<4)
#define MSGB_FILE_ATTACHS		(1L<<5)
#define MSGB_ALL_IS_EALL		(1L<<6)
#define MSGB_DEFAULT_TAGGED     (1L<<7)

/* MSGBASE_FLAGS:
BIT   MEANING WHEN SET AS PRESENTED BELOW                   MESSAGE BASE FLAGS
==============================================================================
 0    0: DO NOT ALLOW PUBLIC MESSAGES  1: ALLOW PUBLIC MESSAGES
 1    0: DO NOT ALLOW PRIVATE MESSAGES 1: ALLOW PRIVATE MESSAGES
 2    0: MESSAGES USE REAL NAMES       1: MESSAGES USE HANDLES / ALIASES
 3    0: USE THE "> " QUOTING METHOD   1: USE BLOCK QUOTE
 4    0: A PLAIN "> " WILL DO          1: INSERT INITIALS BEFORE THE "> "
 5    0: DO NOT ALLOW FILE ATTACHS     1: ALLOW FILE ATTACHS
 6    0: "ALL" IS JUST PLAIN "ALL"     1: MSGS AS "ALL" WILL BE "EALL"
 7    PRIVATE FLAG -- DO NOT USE
==============================================================================
*/

struct VMatik_Message
{
  UWORD	MSG_NUMBER;
  UWORD	MSG_NEXTREPLY;
  UWORD	MSG_FLAGS;
  char MSG_AUTHOR[26];
  char MSG_RECEIVER[26];
  char MSG_SUBJECT[68];
  time_t MSG_CREATION;
  time_t MSG_RECEIVED;
  UWORD	MSG_READCOUNT;
  UWORD	MSG_ORIGINAL;
  char MSG_PASSWORD[16];
  UWORD	MSG_FN_PACKET_ORIG_ZONE;
  UWORD	MSG_FN_PACKET_ORIG_NET;
  UWORD	MSG_FN_PACKET_ORIG_NODE;
  UWORD	MSG_FN_PACKET_ORIG_POINT;
  UWORD	MSG_FN_ORIG_ZONE;
  UWORD	MSG_FN_ORIG_NET;
  UWORD	MSG_FN_ORIG_NODE;
  UWORD	MSG_FN_ORIG_POINT;
  ULONG	MSG_FN_MSGID;
  UWORD	MSG_FN_DEST_ZONE;
  UWORD	MSG_FN_DEST_NET;
  UWORD	MSG_FN_DEST_NODE;
  UWORD	MSG_FN_DEST_POINT;
  char MSG_ATTACH[33];
  char MSG_FREEBLOCK[85];
};

#define MSG_FLAGS_PRIVATE	(1L<<0)
#define MSG_FLAGS_DELETED	(1L<<1)
#define MSG_FLAGS_FIDOMSG	(1L<<2)

struct VMatik_Protocol
{
  UBYTE		Protocol_ID;
  char		Protocol_Name[20];
  UBYTE		Protocol_Efficiency;
  char		Protocol_SendCommand[150];				// User download
  char		Protocol_ReceiveCommand[150];			// User upload
  char		Protocol_InitString[30];
  UBYTE		Protocol_Type;
  char		Protocol_FreeBlock[117];
};

#define PROTOCOL_ONEDIR		0			// Protocol types
#define	PROTOCOL_BIDIR		1
#define PROTOCOL_PSEUDO		2

#define XFER_UPLOAD			0			// Xfer types, for bgchecker
#define XFER_DOWNLOAD		1
#define XFER_UP_ERROR       2
#define XFER_DOWN_ERROR		3
#define XFER_UNKNOWN        4

struct VMatik_DisplayMode
{
  UBYTE DISPLAY_ID;
  char DISPLAY_PATH[9];
  UWORD DISPLAY_ATTRIBUTES;
  UBYTE DISPLAY_INCOMING_TABLEID;
  UBYTE DISPLAY_OUTGOING_TABLEID;
  char DISPLAY_FONT[20];
  UWORD DISPLAY_FONTSIZE;
  UBYTE DISPLAY_STRINGS;
  char DISPLAY_FREEBLOCK[63];
};

#define DISP_ENABLE_ANSI	(1L<<0)
#define DISP_INCOMING_CONV	(1L<<1)
#define	DISP_OUTGOING_CONV	(1L<<2)
#define DISP_FILE_CONV		(1L<<3)
#define	DISP_STRIP_ANSI		(1L<<4)
#define DISP_NO_GFX_IS_TXT	(1L<<5)

/* DISPLAY_ATTRIBUTES:
==============================================================================
000   0: NO ANSI SUPPORT               1: ANSI CONTROL CODES ENABLED
001   0: NO INCOMING CONVERSION        1: ACTIVATE INCOMING CONVERSION
002   0: NO OUTGOING CONVERSION        1: ACTIVATE OUTGOING CONVERSION
003   0: NO CONVERSION IN FILES        1: ACTIVATE CONVERSION IN FILES
004   0: NO STRIP                      1: STRIP ANSICODES FROM TXT FILES
005   1: IF GFX DOESN'T EXIST, CHECK IF TXT DOES
 .
 .
015                                                                 
==============================================================================
*/

struct VMatik_MainConfig
{
	char	CFG_BOARDNAME[26];
	char	CFG_SYSOPNAME[26];
	UBYTE	CFG_CHATMODE;
	UBYTE	CFG_LOCALSCREEN;
	char	CFG_SERIALCODE[9];
	char	CFG_DEFAULTASCPATH[21];
	char	CFG_CHATDLPATH[41];
	UBYTE	CFG_DISPLAYMODE;
	ULONG	CFG_COPYBUFFER;
	UBYTE	CFG_JOINIFAUTOJOINFAILS;
	char	CFG_COLORSYSOP[11];
	char	CFG_COLORUSER[11];
	UBYTE	CFG_LINEEDCHAR;
	char	CFG_SYSTEMPW[16];
	char	CFG_NEWUSERPW[16];
	char	CFG_OLUSEREDPW[16];
	ULONG	CFG_UNIQUEMSGNUMBER;
	UBYTE	CFG_DIRFILEBUFFERSIZE;
	UBYTE	CFG_NEWUSERPRESETID;
	ULONG	CFG_IDLETIMEOUT;
	ULONG	CFG_FREEHDDSPACE;
	ULONG	CFG_FLAGS;
	char	CFG_SHELLPW[16];
	char  CFG_ALIENS[40];
	char  CFG_FSEDCOMMAND[71];
	char  CFG_OLMS[41];
	UBYTE CFG_COSYSOPLEVEL;
	UBYTE CFG_CONTROLCODE;
	char  CFG_HOMES[40];
	UWORD CFG_GID;
	UWORD CFG_UID;
	char  CFG_CHATCMD[71];
	char  CFG_TELNETPAT[80];
	UBYTE   CFG_TELNET1ST;
	UBYTE   CFG_TELNETMAX;
	char  CFG_LOCALPAT[80];
	UBYTE   CFG_LOCAL1ST;
	UBYTE  CFG_LOCALMAX;
	uid_t CFG_BBSUID;
	gid_t CFG_BBSGID;
	ULONG   CFG_DEFAULTS;
	char	CFG_FREESLOT1[3158];
};

#define		FLAG_ASK_REASON		(1L<<0)
#define		FLAG_HANDLE			(1L<<1)
#define		FLAG_ORGANIZATION	(1L<<2)
// (1L<<3) free
#define		FLAG_QUESTIONS		(1L<<4)
#define		FLAG_QUICKLINEED	(1L<<5)
#define		FLAG_ASKHANDLE1ST	(1L<<6)
#define		FLAG_ALLOW2LOGINS	(1L<<7)
#define		FLAG_ASKNEWUSER		(1L<<8)
// (1L<<9) free
// (1L<<10) free
#define		FLAG_BGCHECKER		(1L<<10)
#define		FLAG_ASK_REALNAME	(1L<<11)	// For newuser questions
#define		FLAG_ASK_HANDLE		(1L<<12)
#define		FLAG_ASK_ORG		(1L<<13)
#define		FLAG_ASK_EMAIL		(1L<<14)
#define		FLAG_ASK_CITY		(1L<<15)
#define		FLAG_ASK_VPHONE		(1L<<16)
#define		FLAG_ASK_DPHONE		(1L<<17)
#define		FLAG_ASK_COMPUTER	(1L<<18)

/* CFG_FLAGS:
BIT   MEANING WHEN SET AS PRESENTED BELOW                         SYSTEM FLAGS
==============================================================================
 0    0: DO NOT ASK CHAT REASON          1: ASK CHAT REASON
 1    0: REAL NAMES IN WHO ETC           1: HANDLES IN WHO ETC
 2    0: LOCATION IN WHO ETC             1: ORGANIZATION IN WHO ETC
 3    0: ENABLE WILDCARDS IN LOGON       1: DISABLE WILDCARDS IN LOGON
 4    0: QUESTIONAIRE ONLY FOR NEW USERS 1: ASK Q IF NOT ANSWERED YET
 6    0: $ ENTERS COMMAND MODE IN MSG-ED 1: CR ENTERS COMMAND MODE IN MSGED
 7    0: ASK REAL NAME FIRST (NEW USERS) 1: ASK HANDLE FIRST
 10   0: NORMAL DUPECHECKER              1: CATALOG DUPECHECKER
 11   0: NORMAL CHECKER                  1: BACKGROUND CHECKER
 * 
 ==============================================================================
*/

struct	VMatik_Node
{
  UBYTE	Node_ID;						// Node number, 253 & 254 reserved
  UWORD	Node_MinBaud;
  UWORD	Node_MinBaudNew;
  ULONG Node_TTYSpeed;
  char	Node_TTYName[20];
  UWORD	Node_TTYType;
  ULONG	Node_Flags;
  char	Node_Command[32];
  BYTE	Node_Priority;
  char	Node_TempDir[33];
  char	Node_Free[88];
};

#define NODETYPE_NORMAL		1
#define NODETYPE_TELNET		2
#define NODETYPE_LOCAL		3

#define	NODE_OWNDIR			(1L<<0)
#define NODE_NOTIFY			(1L<<1)
#define NODE_HIDEINACTIVE	(1L<<2)
#define NODE_HIDEWAIT		(1L<<3)
#define NODE_HIDECALL		(1L<<4)
#define NODE_NOPASSWD		(1L<<5)

struct	VMatik_Archiver
{
  UBYTE	ARC_FLAGS;
  char	ARC_PATTERN[20];
  char	ARC_NAME[21];
  char	ARC_CMD_TEST[80];
  char	ARC_CMD_TRANSFORM[80];
  char	ARC_CMD_VIRUSCHECK[80];
  char	ARC_EXTRACTFILEID[80];
  char	ARC_ADDFILEID[80];
  char  ARC_VIEW[80];
  char	ARC_CORRUPTED1[16];
  char	ARC_CORRUPTED2[16];
  char	ARC_CORRUPTED3[16];
  char	ARC_INFECTED1[16];
  char	ARC_INFECTED2[16];
  char	ARC_INFECTED3[16];
  char  ARC_TRANSFORM_TO[21];
  UBYTE ARC_VIEWSEC;
  char	ARC_FREEBLOCK[3];
};

#define ARC_DISK_ARCHIVER	(1L<<0)
#define	ARC_OFFLINE			(1L<<1)
#define ARC_GETDATE			(1L<<2)
#define ARC_DELETECORRUPT	(1L<<3)
#define ARC_DISPLAY			(1L<<4)

struct	VMatik_ExternalCommand
{
  char		EXT_NAME[11];
  UBYTE		EXT_CMDTYPE;
  UBYTE		EXT_SECLEVEL;
  char		EXT_COMMAND[87];
  ULONG		EXT_CONF1;
  ULONG		EXT_CONF2;
  char		EXT_FREEBLOCK1[92];
};

#define EXT_VMATIK		1
#define EXT_STDIO       2
#define EXT_TEXT        3
#define EXT_OTHER       4

struct VMatik_Seclevel
{
  UBYTE	SEC_SECLEVEL;
  UBYTE	SEC_FILERATIO;
  UBYTE	SEC_BYTERATIO;
  UBYTE	SEC_PAGESPERCALL;
  UWORD	SEC_DAILYTIME;
  bint	SEC_CONFACC;
  bint	SEC_ACCESSBITS;
  char	SEC_FREE[20];
};

#define		UPLOAD_NORMAL		0
#define		UPLOAD_JUSTCHECK	2
#define		UPLOAD_RZ			3		

#define SECB_DOWNLOAD			(1LL<<0)
#define SECB_UPLOAD				(1LL<<1)
#define SECB_READMSG			(1LL<<2)
#define SECB_ENTERMSG			(1LL<<3)
#define SECB_PAGE				(1LL<<4)
#define SECB_COMMENT			(1LL<<5)
#define SECB_BULLETINS			(1LL<<6)
#define SECB_FILESCAN			(1LL<<7)
#define SECB_NEWFILES			(1LL<<8)
#define SECB_ZIPPYSEARCH		(1LL<<9)
#define SECB_RUNDOOR			(1LL<<10)
#define SECB_JOINCONF			(1LL<<11)
#define SECB_CHANGEMSGAREA		(1LL<<12)
#define SECB_CHANGEINFO			(1LL<<13)
#define SECB_RELOGIN			(1LL<<14)
#define SECB_TAGEDITOR			(1LL<<15)
#define SECB_USERSTATS			(1LL<<16)
#define SECB_VIEWTIME			(1LL<<17)
// (1LL<<18) free 
#define SECB_EXPERTMODE			(1LL<<19)
#define SECB_EALLMESSAGE		(1LL<<20)
#define SECB_FIDOMESSAGE		(1LL<<21)
#define SECB_PUBLICMESSAGE		(1LL<<22)
#define SECB_READALL			(1LL<<23)
#define SECB_USERED				(1LL<<24)
#define SECB_VIEWLOG			(1LL<<25)
#define SECB_SYSOPDL			(1LL<<26)
#define SECB_USERLIST			(1LL<<27)
#define SECB_DELETEANYMSG       (1LL<<28)
#define SECB_REMOTESHELL        (1LL<<29)
#define SECB_WHO				(1LL<<30)
#define SECB_MOVEFILE			(1LL<<31)
#define SECB_SELECTFILECONFS	(1LL<<32)
#define SECB_SELECTMSGBASES		(1LL<<33)
#define SECB_SENDNETMAIL       	(1LL<<34)
#define SECB_OLM			    (1LL<<35)
#define SECB_PVTATTACH          (1LL<<36)
#define SECB_PUBATTACH          (1LL<<37)
#define SECB_VIEWFILE           (1LL<<38)
#define SECB_EDITREALNAME       (1LL<<39)
#define SECB_EDITHANDLE         (1LL<<40)
#define SECB_FREEFILES          (1LL<<41)
#define SECB_FREEBYTES          (1LL<<42)
#define SECB_COSYSOP			(1LL<<43) // Some filearea maintenance access
#define SECB_SYSOP              (1LL<<44) // This is a HEAVY flag! Caution!

#define SECB_HIGHEST                44

#endif
