/*
 * Shows some statistics to user
 *
 */
#include "proto.h"
#include <string.h>

int st_userstats(int user_id)
{
	struct userbase luser;
	char buf[10000];
	char extrabuf[100];

	memset(&luser, 0, sizeof(struct userbase));
	if(!mi_loaduser(user_id, &luser))
		return(0);
	
	sprintf(buf,sd[stats1str],luser.user_realname,luser.user_screenlength);
	DDPut(buf);
	sprintf(buf,sd[stats2str],luser.user_handle,luser.user_securitylevel);
	DDPut(buf);

	sprintf(buf,sd[stats3str],luser.user_zipcity,luser.user_timeremaining,0);
	DDPut(buf);
	sprintf(buf,sd[stats4str],luser.user_organization);
	DDPut(buf);
	sprintf(buf,sd[stats5str],luser.user_pubmessages,luser.user_prvmessages);
	DDPut(buf);
	
	sprintf(extrabuf,"%-24.24s",ctime(&luser.user_firstcall));
	sprintf(&extrabuf[30],"%-24.24s",ctime(&luser.user_lastcall));
	
	sprintf(buf,sd[stats8str],&extrabuf[4],&extrabuf[34],luser.user_connections);
	DDPut(buf);

	sprintf(buf,sd[stats9str],luser.user_voicephone, luser.user_protocol);
	DDPut(buf);
	
	sprintf(buf,sd[stats10str],luser.user_computermodel);
	DDPut(buf);
	sprintf(buf,sd[stats11str],luser.user_signature);
	DDPut(buf);

	return(1);
}

/*
 * This shows the file credits user has
 *
 */
int st_show_credits(int user_id)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];

	sprintf(query, "SELECT user_filesup, user_bytesup, user_filesdn,
					user_bytesdn, user_filesup_bad, user_bytesup_bad,
					user_filecred, user_bytecred, user_pubmessages,
					user_prvmessages FROM vmatik_user WHERE user_id=%d",
					user_id);
	mysql_query(&vm_database, query);
	sql_result=mysql_store_result(&vm_database);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		sprintf(query, "\nMessages written: %s public, %s private\n\n",
				sql_row[8], sql_row[9]);
		DDPut(query);
				 DDPut("Stats           Files          Bytes\n");
     			 DDPut("------------------------------------\n");
		sprintf(query, "Uploads         %5s      %9s\n", 
				sql_row[0], sql_row[1]);
		DDPut(query);
		sprintf(query, "Downloads       %5s      %9s\n",
				sql_row[2], sql_row[3]);
		DDPut(query);
		sprintf(query, "Bad uploads     %5s      %9s\n\n",
				sql_row[4], sql_row[5]);
		DDPut(query);
		
		sprintf(query, "Credits left    %5s      %9s\n\n",
				(access_flags & SECB_FREEFILES) ? "Unl" : sql_row[6], 
				(access_flags & SECB_FREEBYTES) ? "Unl" : sql_row[7]);
		DDPut(query);
		mysql_free_result(sql_result);
	
		return(1);
	}

	return(0);
}
