/*
 * Replying to already existing messages
 *
 */
#include "proto.h"
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int replymessage(struct VMatik_Message *msgd)
{
	char qbuffer[4096];
	char input[2048];
	char msgin[10];
	FILE *msgfd;
	FILE *quotefd;
	char *s, *t;
	int i;
	int l=0;
	struct VMatik_Message header;
		
	memset(&header, 0, sizeof(struct VMatik_Message));
	s=(char *)&header;
		
	sprintf(qbuffer,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msgd->MSG_NUMBER);

	if (!(msgfd=fopen(qbuffer,"r"))) return 0;
	
	sprintf(qbuffer,"%sVMatik%d.mtm",VMTMP,node);
	unlink(qbuffer);

	if (!(quotefd=fopen(qbuffer,"w"))) {
		fclose(msgfd);
		return 0;
	}	

	if (base->MSGBASE_FLAGS & MSGB_BLOCK_QUOTE)
		msgin[0]=0;
	else
	{
		if (base->MSGBASE_FLAGS & MSGB_USE_INITIALS) 
		{
			s=msgd->MSG_AUTHOR;
			t=msgin;
			*t++=*s++;
			while (*s)
			{
				if (*s==' ' && *(s+1)) {
					s++;
					*t++=*s;
				}
				s++;
			}			
			*t++='>';
			*t=0;
		} else {
			msgin[0]='>';
			msgin[1]=0;
		}
	}

	
	while(fgets(input,2048,msgfd))
	{
		if (l==0 && !strncmp("AREA:",input,5)) continue;
		l++;
		if (*input==1) continue;
		if (!strncmp("SEEN-BY:",input,8)) break;
		
		stripansi(input);
		sprintf(qbuffer,"%s%s",msgin,input);
		t=qbuffer;
		while (1) {
			if (strlen(t) > 76) {
				char k;

				s=&t[75];
				while (1)
				{
					if (s==t) {
						k=t[75];
						t[75]=0;
						s=&t[75];						
						break;
					} else {
						if (*s==' ') {
							k=*s;
							*s=0;
							break;
						}
						s--;
					}
					
				}
				fputs(t,quotefd);
				fputs("\n",quotefd);
				*s=k;
				if (k==' ') s++;
				t=s;
				sprintf(qbuffer,"%s%s",msgin,t);
				t=qbuffer;
			} else {
				fputs(t,quotefd);
 				break;
 			}
		}
	}

	if (!msgin[0]) {
		sprintf(qbuffer,"---[ %s ]",msgd->MSG_AUTHOR);
		
		for (i=strlen(qbuffer);i < 75; i++) {
			strcat(qbuffer,"-");
		}
		strcat(qbuffer,"\n\n");
		fputs(qbuffer,quotefd);
	}
	fclose(msgfd);
	fclose(quotefd);

//	em_askqlines();
	
	strcpy(header.MSG_RECEIVER,msgd->MSG_AUTHOR);
	strcpy(header.MSG_SUBJECT,msgd->MSG_SUBJECT);
	header.MSG_ORIGINAL=msgd->MSG_NUMBER;
	if (msgd->MSG_FLAGS & MSG_FLAGS_PRIVATE) 
		header.MSG_FLAGS |= MSG_FLAGS_PRIVATE;
	if (toupper(base->MSGBASE_FN_FLAGS)=='N') {
		if (msgd->MSG_FN_ORIG_ZONE) {
			header.MSG_FN_DEST_ZONE=msgd->MSG_FN_ORIG_ZONE;
		} else {
			header.MSG_FN_DEST_ZONE=msgd->MSG_FN_PACKET_ORIG_ZONE;
		}
		header.MSG_FN_DEST_NET=msgd->MSG_FN_ORIG_NET;
		header.MSG_FN_DEST_NODE=msgd->MSG_FN_ORIG_NODE;
		header.MSG_FN_DEST_POINT=msgd->MSG_FN_ORIG_POINT;
		
	}
	entermsg(&header, 1, 0);
	sprintf(qbuffer,"%sVMatik%d.msg",VMTMP,node);
	unlink(qbuffer);	
	getmsgptrs();
	return 1;
		
}

