/*
 * Calling sysop to chat, e.g. "paging" stuff
 *
 */
#include "proto.h"
#include <sys/socket.h>
#include <sys/un.h>
#include <string.h>

int pageflag;
char reason[100];

int pa_pagesysop(char *reas)
{
	struct VMatik_PageMsg pm;
	struct sockaddr_un name;
	int sock,i;
	time_t ctim;
	char reabuf[120];
			
	changenodestatus("Paging SysOp");

	reason[0]=0;
	if(reas) 
		strcpy(reason,reas);

	TypeFile("pagesysop",TYPE_MAKE|TYPE_WARN);
		
	if (maincfg.CFG_FLAGS & FLAG_ASK_REASON) {
		if (reason[0]==0) {
			DDPut(sd[psreasonstr]);
			if (!(Prompt(reason,75,0))) 
				return 0;
			if (reason[0]==0) {
				DDPut("\n");
				return 0;
			}
		}
	}

	writelog("Paged sysop: ");
	writelog(reason);
	writelog("\n");
	clog.cl_flags |= CL_PAGEDSYSOP;
	
	sock = socket(AF_UNIX, SOCK_DGRAM, 0);
	if (sock < 0) {
		return 0;
	}
	pm.pm_cmd=2;
	ctim=time(0);
	*pm.pm_string=0;
	if (onlinestat)
		sprintf(pm.pm_string,"\n\n%s / %s (node %d) paged you on %s\n",user.user_realname,user.user_handle,node,ctime(&ctim));
	if (reason[0]) {
		strcat(pm.pm_string,"Reason: ");
		strcat(pm.pm_string,reason);
		strcat(pm.pm_string,"\n\n");
	}

	name.sun_family = AF_UNIX;
	strcpy(name.sun_path, YELLD_SOCKET);

	if (sendto(sock, &pm, sizeof(struct VMatik_PageMsg), 0, (struct sockaddr *)&name, sizeof(struct sockaddr_un)) < 0) {
		DDPut(sd[pspageoffstr]);
		close(sock);
		return 0;
	}
	
	pages--;
	sprintf(reabuf,sd[pspagingstr],maincfg.CFG_SYSOPNAME);
	DDPut(reabuf);

	pageflag=0;     
	for (i=0;i < 20;i++)
	{
		unsigned char c;
		DDPut(".");
		delayt=1;
		while ((c=HotKey(HOT_QUICK)))
		{
			if (c==255) break;
			if (c==3) {
				DDPut(sd[psabortstr]);
				i=21;
				break;
			}
		}
		if (pageflag) break;
		
		pm.pm_cmd=1;
		name.sun_family = AF_UNIX;
		strcpy(name.sun_path, YELLD_SOCKET);
		sendto(sock, &pm, sizeof(struct VMatik_PageMsg), 0, (struct sockaddr *)&name, sizeof(struct sockaddr_un));
		sleep(1);       
	}
	if (i==20) DDPut(sd[psnosysopstr]);
	close(sock);
	return 0;
	
}
