/*
 * OLM=OnLineMessage
 *
 * A message which user can send to another user on another node.
 * OLMs are also used to send control information to other node. 
 * (Like kicking user out, modifying timeleft, etc)
 *
 */
#include "proto.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

int ol_miniolm(int dnode, char *ms);

/*
 * This function asks for an "OnLineMessage" from user and
 * sends it.
 *
 */
int ol_olmsg(char *params)
{
	char obuf[1024];
	int destnode;
	char *srcstrh;
	char parbuf[1024];
	
	srcstrh=params;

	if (!(srcstrh=strspa(srcstrh,parbuf))) {
asknode:
		*obuf=0;
		DDPut(sd[olmdstr]);
		if (!(Prompt(obuf,80,0))) return 0;
		srcstrh=strspa(obuf,parbuf);
	}
	if (*parbuf=='*') {
		destnode=-1;
	} else if (toupper(*parbuf)=='V') {
		who();
		goto asknode;
	} else destnode=atoi(parbuf);

	if (destnode==0) return 0;

	if (destnode>0) {
		struct VMatik_NodeInfo ninfo;
		
		if (!isnode(destnode,&ninfo)) {
			DDPut(sd[olmnouserstr]);
			return 1;
		}
		
	}	
	if (srcstrh && *srcstrh && *++srcstrh) {
		if (destnode==-1) {
			olmall(0,srcstrh);
		} else {
			if (!lineolm(destnode,srcstrh)) {
				DDPut(sd[olmnomsgstr]);
			}
		}
		
	} else {
		char mem[40000];
		int lins;
		lins=edfile(mem,0,0);
		if (!lins) return 1;
		if (destnode==-1) {
			olmall(lins,mem);
		} else {
			if (!bigolm(destnode,lins,mem)) {
				DDPut(sd[olmnomsgstr]);
			}
		}
		
	}
	return 1;
}

int olmall(int l, char *ms)
{
	struct VMatik_Node *cn;
	
	cn=nodes;
	
	while(cn->Node_ID)
	{
		struct VMatik_NodeInfo nin;
		if (cn->Node_TTYType == NODETYPE_TELNET) {
			int j=maincfg.CFG_TELNETMAX;
			int i=maincfg.CFG_TELNET1ST;
			
			while(j) {
				if (isnode(i,&nin)) { 	
					if (l==1) 
					  bigolm(i,l,ms);
					else if (l==2) 
					  ol_miniolm(i,ms);
					else
					  lineolm(i,ms);
				}
				j--;
				i++;
			}
		} else if (cn->Node_TTYType == NODETYPE_LOCAL) {
			int j=maincfg.CFG_LOCALMAX;
			int i=maincfg.CFG_LOCAL1ST;
			
			while(j) {
				if (isnode(i,&nin)) { 
					if (l==1) 
					  bigolm(i,l,ms);
					else if (l==2)
					  ol_miniolm(i,ms);
					else lineolm(i,ms);
				}
				j--;
				i++;
			}
		} else if (node!=cn->Node_ID && isnode(cn->Node_ID,&nin)) {
			if (l==1) 
				bigolm(cn->Node_ID,l,ms);
			else if (l==2)
			  ol_miniolm(cn->Node_ID,ms);
			else
				lineolm(cn->Node_ID,ms);
		}
		cn++;
	}
	return 1;
}

int bigolm(int dnode, int l, char *ms)
{
	struct VMatik_nodemessage ddn;
	struct timeval tv;
	char bbuf[1024];
	int olfd;
	struct VMatik_NodeInfo nin;
	
	isnode(dnode,&nin);
	if (nin.ddn_flags & TOGGLE_NO_OLMS) 
		return(0); 
	
	memset(&ddn,0,sizeof(struct VMatik_nodemessage));
	ddn.dn_command=NODEMSG_NUMBERED;
	sprintf(ddn.dn_string,"[36m\nMessage from %s (%s) on node %d:\n[0m",user.user_handle,user.user_realname,node);
	
	gettimeofday(&tv,0);
	ddn.dn_data1=tv.tv_usec;
	sprintf(bbuf,"%solm%d.%d",VMTMP,dnode,(int)tv.tv_usec);
	
	olfd=open(bbuf,O_WRONLY|O_CREAT|O_TRUNC,0664);
	if (olfd!=-1) {
		char *s;
		s=ms;	
		while(l)
		{
			sprintf(bbuf,"%s\n",s);
			write(olfd,bbuf,strlen(bbuf));
			l--;
			s=&s[80];
		}
		close(olfd);
	}
	sendtosock(dnode,&ddn);
	return 1;
}

int lineolm(int dnode, char *ms)
{
	struct VMatik_nodemessage ddn;
	struct VMatik_NodeInfo nin;
	
	isnode(dnode,&nin);
	if (nin.ddn_flags & TOGGLE_NO_OLMS) 
		return(0); 

	memset(&ddn,0,sizeof(struct VMatik_nodemessage));
	ddn.dn_command=NODEMSG_NORMAL;
	sprintf(ddn.dn_string,"[36m\nMessage from %s (%s) on node %d:\n[0m%-80.80s\n\n",user.user_handle,user.user_realname,node,ms);
	sendtosock(dnode,&ddn);
	return 1;
}

int ol_miniolm(int dnode, char *ms)
{
	struct VMatik_nodemessage ddn;
	struct VMatik_NodeInfo nin;
	
	isnode(dnode,&nin);
	if (nin.ddn_flags & TOGGLE_NO_OLMS) 
		return(0); 

	if (dnode==node) return 0;
	memset(&ddn,0,sizeof(struct VMatik_nodemessage));
	ddn.dn_command=NODEMSG_NORMAL;
	strcpy(ddn.dn_string,ms);
	
	sendtosock(dnode,&ddn);
	return 1;
}

/*
 * This sends a predefined nodemessage.
 *
 * It should have all necessary fields already set.
 *
 */
int ol_send_defined(int dnode, struct VMatik_nodemessage *msg)
{
	struct VMatik_NodeInfo nin;
	
	if(!isnode(dnode,&nin))				// Inactive node?
		return(0);

	sendtosock(dnode,msg);
	
	return(1);
}

/*
 * This sends a private olm for a specific user_id. Its
 * used by bgchecker to report results.
 *
 */
int ol_privateolm(int dnode, int receiver_id, char *msg)
{
	struct VMatik_nodemessage olm;

	if(!dnode || !receiver_id || !msg)
		return(0);

	memset(&olm, 0, sizeof(struct VMatik_nodemessage));
	olm.dn_data1=receiver_id;
	olm.dn_command=NODEMSG_PRIVATE;
	strcpy(olm.dn_string, msg);

	return(ol_send_defined(dnode, &olm));
}


