/*
 * Functions related to newuser first time sign-on procedure
 *
 */
#include "proto.h"
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*
 * Asks about user information and creates an account
 *
 */
int nu_create_account(MYSQL *db)
{
	char	passwd[PASSWD_SIZE];
	int		hotti;
	MD_CTX 	context;
			
	changenodestatus("Creating an account");

	if (*maincfg.CFG_NEWUSERPW) {
		char b[80];
		int i;

		TypeFile("newuserpassword",TYPE_MAKE);
		for (i=3;i;i--) {
			*b=0;
			DDPut(sd[nupstr]);
			if (!(Prompt(b,16,PROMPT_SECRET))) 
				return(0);
			if (!strcasecmp(b,maincfg.CFG_NEWUSERPW))
				break;
			
			sleep(1);
			DDPut(sd[tryagainstr]);
		}
		if (i==0)
			return(0);
	}
	memset(&user, 0, sizeof(struct userbase));
	
	TypeFile("newuser",TYPE_MAKE|TYPE_WARN);
	DDPut(sd[newsure1str]);
			
	hotti=HotKey(HOT_YESNO);
	if (hotti==0||hotti==2) return 0;

	if((!(maincfg.CFG_FLAGS & FLAG_ASK_REALNAME)) &&
	   (!(maincfg.CFG_FLAGS & FLAG_ASK_HANDLE)))
	{
		DDPut("Error in VMatik config, notify SysOp...\n\n");
		writelog("Error in .cfg: both ASK_REALNAME & ASK_HANDLE defined!\n");
		maincfg.CFG_FLAGS |= FLAG_ASK_REALNAME;
	}

	if (maincfg.CFG_FLAGS & FLAG_ASKHANDLE1ST) {
		if (!nu_ask_handle(user.user_handle, sizeof(user.user_handle))) 
			return 0;
		if (!nu_ask_name(user.user_realname, sizeof(user.user_realname))) 
			return 0;
	} else {        
		if (!nu_ask_name(user.user_realname, sizeof(user.user_handle)))
			return 0;
		if (!nu_ask_handle(user.user_handle, sizeof(user.user_realname)))
			return 0;
	}

	if(maincfg.CFG_FLAGS & FLAG_ASK_EMAIL)
	{
		TypeFile("reg_email",TYPE_MAKE);
		DDPut(sd[newemailstr]);
		if (!(Prompt(user.user_email,sizeof(user.user_email)-1,0))) return 0;
	}

	if(maincfg.CFG_FLAGS & FLAG_ASK_ORG)
	{
		TypeFile("reg_organization",TYPE_MAKE);
		DDPut(sd[neworgstr]);
		if
		(!(Prompt(user.user_organization,sizeof(user.user_organization)-1,0)))
			return(0);
	}

	if(maincfg.CFG_FLAGS & FLAG_ASK_CITY)
	{
		TypeFile("reg_zipcode",TYPE_MAKE);
		DDPut(sd[newzipstr]);
		if (!(Prompt(user.user_zipcity,sizeof(user.user_zipcity)-1,0))) return 0;
	}

	if(maincfg.CFG_FLAGS & FLAG_ASK_VPHONE)
	{
		TypeFile("reg_voicephone",TYPE_MAKE);
		DDPut(sd[newvoicestr]);
		if (!(Prompt(user.user_voicephone,sizeof(user.user_voicephone)-1,0))) return 0;
	}

	if(maincfg.CFG_FLAGS & FLAG_ASK_DPHONE)
	{
		TypeFile("reg_dataphone",TYPE_MAKE);
		DDPut(sd[newdatastr]);
		if (!(Prompt(user.user_dataphone,sizeof(user.user_dataphone)-1,0))) return 0;
	}

askpw:
	TypeFile("reg_password",TYPE_MAKE);
	DDPut(sd[newpasswdstr]);
	*passwd=0;
	if (!(Prompt(passwd,PASSWD_SIZE,0))) return 0;
	if(!passwd[0]) goto askpw;      

	mi_strupr(passwd);
	MDInit(&context);
	MDUpdate(&context,passwd,strlen(passwd));
	MDFinal(user.user_password,&context);

/*
	if(maincfg.CFG_FLAGS & FLAG_ASK_COMPUTER)
	{
		TypeFile("reg_computer",TYPE_MAKE);
		DDPut(sd[newcpustr]);
		if (!(Prompt(user.user_computermodel,20,0))) return 0;
	}
*/

	TypeFile("reg_screenlength",TYPE_MAKE);

	user.user_screenlength=nu_ask_screenl();

/*
	sprintf(user.user_signature,"-%s",user.user_handle);
*/
	if(mi_sql_getnum(&vm_database, "user_id", "vmatik_user", "1"))
		nu_setaccess(&user, maincfg.CFG_NEWUSERPRESETID);
	else
		nu_setaccess(&user, 31);			// First user gets sysop access
	
	hotti=0;

	questionnaire();
		
	user.user_toggles |= maincfg.CFG_DEFAULTS;
	user.user_toggles |= TOGGLE_ACC_STAT_1;			// Toggle newuser on
	user.user_toggles |= TOGGLE_ACC_STAT_2;
	user.user_protocol=protocols->Protocol_ID; 

//	printf("Def:%d\n", maincfg.CFG_DEFAULTS);
	
	DDPut(sd[newsavingstr]);

	if(!checkcarrier())
		return(0);

	hotti=mi_add_user(db, &user);
	if(!hotti)
	{
		writelog(sd[newfailsavestr]);
		DDPut(sd[newfailsavestr]);
		return(0);
	}

	DDPut(sd[newsaveokstr]);
	
	return(1);
}

/*
 * Asks terminal screen length from the user.
 *
 */
int nu_ask_screenl(void)
{
	char askbuf[10];
	int newlength;

	askbuf[0]=0;
asksl:

	DDPut(sd[eu7str]);
	if(!(Prompt(askbuf, 3, 0)))
		return(0);
	if(askbuf[0]=='t' || askbuf[0]=='T')
	{
		nu_testscreenl();
		goto asksl;
	}
	newlength=atoi(askbuf);
	if(newlength<10)
	{
		DDPut(sd[newminslstr]);
		goto asksl;
	}
	
	return(newlength);
}

void nu_testscreenl(void)
{
	int hotti;
	char passwd[16];
	
	for(hotti=66;hotti>2;hotti--) {
		sprintf(passwd,"%d\n",hotti);
		DDPut(passwd);
	}
	DDPut(sd[newslhelpstr]);
}

/*
 * Sets user access data to defaults of "new_level"
 *
 * Returns pointer to the found accesslevel, or NULL if failed.
 *
 * Note: the values assigned here can be set to the actual 
 *       database with ue_set_secdata_to_db()
 *
 */
struct VMatik_Seclevel *nu_setaccess(struct userbase *dst, int new_level)
{
	struct VMatik_Seclevel *sectmp;

	sectmp=mi_findsecdata(new_level);
	if(sectmp)
	{
			dst->user_securitylevel=new_level;
			dst->user_fileratio1=sectmp->SEC_FILERATIO;
			dst->user_byteratio1=sectmp->SEC_BYTERATIO;
			dst->user_dailytimelimit=sectmp->SEC_DAILYTIME;
			dst->user_confacc=sectmp->SEC_CONFACC;
			dst->user_secflags=sectmp->SEC_ACCESSBITS;
	}

	return(sectmp);
}

void questionnaire(void)
{
	FILE *questfd;
	FILE *ansfd;
	char qbuffer[1000];
	char abuffer[100];
	char *s, *t;
	time_t fallos;
	int hins;
			
askag:

	TypeFile("questionnaire",TYPE_MAKE);
	
	questfd=fopen("questionnaire/questions","r");
	if (questfd==0) {
		DDPut(sd[newqerrorstr]);
		return;
	}

	sprintf(qbuffer,"%squest.%d",VMTMP,user.user_serial_id);

	ansfd=fopen(qbuffer,"w+");

	if (ansfd==0) {
		fclose(questfd);
		return;
	}

	fallos=time(0);
	sprintf(qbuffer,"\n==========================================================================\nAnswers from %s (%s) %s\n",user.user_realname,user.user_handle,ctime(&fallos));
	fputs(qbuffer,ansfd);
	
	while(fgets(qbuffer,1000,questfd)) {
		s=qbuffer;
		t=s;
		while(*t) {
			if (*t=='~') {
				*t=0;
				DDPut(s);
				stripansi(s);
				fputs(s,ansfd);
				t++;
				s=t;

				abuffer[0]=0;
				if (!(Prompt(abuffer,80,0))) {
					fclose(ansfd);
					fclose(questfd);
				}
				fputs(abuffer,ansfd);
				fputs("\n",ansfd);
				break;
			} else t++;
		}
		if (*t==0) {
			DDPut(s);
			stripansi(s);
			fputs(s,ansfd);
		}
	}
	fclose(ansfd);
	fclose(questfd);

	DDPut(sd[newverifystr]);
	hins=HotKey(HOT_YESNO);
	if (hins==0) return;

	if (hins==2) goto askag;
	
	if (hins==1) {
		sprintf(qbuffer,"%squest.%d",VMTMP,user.user_serial_id);
		questfd=fopen(qbuffer,"r");
		
		ansfd=fopen("questionnaire/answers","a+");
		if (ansfd==0) {
			fclose(questfd);
			return;
		}       

		while(fgets(qbuffer,1000,questfd)) {
			fputs(qbuffer,ansfd);
		}
		fclose(questfd);
		fclose(ansfd);
	}       
}

	
int nu_ask_name(char *name, int size)
{      
	if(!(maincfg.CFG_FLAGS & FLAG_ASK_REALNAME))
		return(1);

askreal:
	TypeFile("reg_realname",TYPE_MAKE);
	DDPut(sd[newrealstr]);
	if (!(Prompt(name,size-1,0))) return 0;
	removespaces(name);
	if (!name[0]) return 0;
	if (mi_findusername(name)) {
		DDPut(sd[newalreadystr]);
		goto askreal;
	}
	return 1;
}

int nu_ask_handle(char *handle, int size)
{   
	if(!(maincfg.CFG_FLAGS & FLAG_ASK_HANDLE))
		return(1);

askhandle:
	TypeFile("reg_handle",TYPE_MAKE);
	DDPut(sd[newhandlestr]);
	if (!(Prompt(handle,size-1,0)))
		return 0;
	removespaces(handle);
	if (!handle[0]) 
		return 0;
	if (mi_findusername(handle)) {
		DDPut(sd[newalreadystr]);
		goto askhandle;
	}
	return(1);
}       
