/*
 * Miscellaneous functions
 *
 */
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h> 
#include <unistd.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>

#include "proto.h"

#ifndef UTMP_FILE
#define UTMP_FILE _PATH_UTMP
#endif

int node;
int bpsrate;

int mktempdir(void)
{
	return mkdir(currnode->Node_TempDir,0755);
}

int mi_is_range(char *string)
{
	while(*string && *string!=' ')
	{
		if(!(isdigit(*string) || *string=='-' || *string==','))
			return(0);
		string++;
	}
	return(1);
}
/*
 * This creates a "Range"-list from a string which should look like
 * "121,192-200,210,230-500" etc...
 *
 */
struct List *mi_make_range(char *string)
{
	struct List *allocated;
	struct Range *temp2=NULL;
	int cont=1;
	int read_start=1;

	if(!string) 
		return(NULL);
	if(!mi_is_range(string))
		return(NULL);

	allocated=NewList();
	
	while(*string && cont)
	{
#ifdef DEBUG
		DDPut("\nString: ");
		DDPut(string);
		DDPut("\n");
#endif

		if(read_start)
		{
			if(!isdigit(*string))
			{
				cont=0;
				break;
			}
			
			temp2=malloc(sizeof(struct Range));
			temp2->range_start=atoi(string);
			temp2->range_stop=temp2->range_start;			// for starters :)
		}
		else
		{
			if(isdigit(*string))
			{
				temp2->range_stop=atoi(string);
			}
			else
			{
				temp2->range_stop=INT_MAX;
				cont=0;
			}
			
			read_start=1;
		}

		while(*string && isdigit(*string))			// skip the used value
			string++;

		switch(*string)
		{
			case '-':
				read_start=0;
				break;
			case ',':
				read_start=1;
				break;
			default:
				cont=0;
				break;
		}

		string++;

		if(!*string && !read_start)
		{
			temp2->range_stop=INT_MAX;
			AddTail(allocated, (struct Node *)temp2);
		}

		if(read_start || (!(read_start) && !*string))
			AddTail(allocated, (struct Node *)temp2);
	}
	
/*** DEBUG
	temp=allocated;
	while(temp)
	{
		char buffer[10];
		
		sprintf(buffer, "\n%d %d\n", temp->range_start, temp->range_stop);
		DDPut(buffer);
		temp=temp->range_next;
	}
***/
		
	return(allocated);
}

/*
 * This function copies a string to uppercase,
 * replacing 1st null in "src" with a space in "dest".
 *
 */
/*
void mi_strcupr_skip1null(char *dest, char *src)
{
	while (*src)
	{
		*dest++=toupper(*src++);
	}
	*dest++=' ';
	src++;
	while (*src)
	{
		*dest++=toupper(*src++);
	}
	*dest=0;
}
*/

char *mi_nextword(char *string)
{
	char *result=NULL;
	
	if(!string)
		return(NULL);

	while(*string && *string!=' ')		// skip to first space
		string++;
	
	while(*string && *string==' ')		// skip the spaces
		string++;

	result=string;

	return(result);
}
	
int mi_runlogoffbatch(void)
{
	char buf[512];

	sprintf(buf,"batch/batch%d.logoff %d",node,node);
	runstdio(buf,0,3);
	
	return(1);
}

void removespaces(char *strh)
{
	char *s;
	s=strh;
	if (!*s) return;
	while(*s) s++;
	s--;
	while (*s==' ') s--;
	*(s+1)=0;
}

void changenodestatus(char *newstatus)
{
	struct VMatik_NodeInfo ddn;
	char infoname[80];
	int myfd;
		
	if(bgmode)
		return; 
	
	ddn.ddn_pid=getpid();
	ddn.ddn_flags=0;
	if (onlinestat) {
		ddn.ddn_userslot=user.user_serial_id;
		if (user.user_toggles & TOGGLE_NO_OLMS) {
			ddn.ddn_flags |= TOGGLE_NO_OLMS;
		}
	} else 
	  ddn.ddn_userslot=0;
	strcpy(ddn.ddn_activity,newstatus);
	ddn.ddn_bpsrate=bpsrate;
	strncpy(ddn.ddn_pagereason,reason,79);
	strncpy(ddn.ddn_path,origdir,79);
	ddn.ddn_timeleft=timeleft;
	
	sprintf(infoname,"%snodeinfo%d.data",VMTMP,node);	
	myfd=open(infoname,O_WRONLY|O_CREAT,0640);
	if (myfd!=-1) {
		write(myfd,&ddn,sizeof(struct VMatik_NodeInfo));
		close(myfd);
	}
}

char *currt(void)
{
	time_t tt;
	
	tt=time(0);
	return ctime(&tt);
}

/*
 * This writes a string to the "main" log
 *
 * BUGS: No concurrency control whatsoever
 *
 *
 */
void writelog(char *strh)
{
	char buffer[PATH_MAX];
	int  logfd;
	
	sprintf(buffer,"%s/logfiles/vmatik%d.log",origdir,node);
	logfd = open(buffer,O_WRONLY|O_CREAT,0660);
	if (logfd < 0) return;
	
	lseek(logfd,0,SEEK_END);
	write(logfd,strh,strlen(strh));
	close(logfd);
}


char *nextword(char *strh)
{
	for (;;)
	{
		if (*strh==' ') {
			while (*strh==' ') strh++;
			return strh;
		}		
		if (*strh==0) return strh;
		strh++;
	}
}

/*
 * Compares a wildcard (*) containing string "pat" to
 * normal string "nam".
 *
 * Note: case-insensitive.
 */
int mi_wildcmp (char *nam, char *pat)
{
	register char *p;              /* Thu Jan 16 14:50:30 1992 */

	for (;;)
	{
		if (tolower(*nam) == tolower(*pat)) {
			if(*nam++ == '\0')  return(1);
			pat++;
		} else if (*pat == '?' && *nam != 0) {
		    	nam++;
		    	pat++;
		} else	break;
	}

	if (*pat != '*') return(0);

	while (*pat == '*') {
		if (*++pat == '\0')  return(1);
	}

	for (p=nam+strlen(nam)-1;p>=nam;p--) {
		if (tolower(*p) == tolower(*pat))
			if (mi_wildcmp(p,pat) == 1) return(1);
	}
	return(0);
}


void strcupr (char *dest, char *strh)
{
	while (*strh)
	{
		*dest++=toupper(*strh++);
	}
	*dest=0;
}


int iswilds (char *strh)
{
	while (*strh) 
	{
		if (*strh=='*' || *strh=='?') return 1;
		strh++;
	}
	return 0;
}

/*
 * Looks for user from the userbase. 
 *
 * Returns user's serial_id or 0 on failure
 *
 */
ULONG mi_findusername(char *name)
{
	ULONG 		serial_id;
	char		buffer[PATH_MAX];

	sprintf(buffer, "user_name='%s' OR user_handle='%s'", name, name);
	serial_id=mi_sql_getnum(&vm_database, "user_id", "vmatik_user", buffer); 
	
	return(serial_id);								// Return the serial ID
}

/*
 * Checks if user exists in userbase, and copies users datas
 * into "user". 
 *
 * Returns 
 *			1 on success, -1 on failure. 0 == user not found
 *			2 user is already online
 *
 */
int mi_checklogon(char *name)
{
	int serial_id;

	serial_id=mi_findusername(name);
	
	if (!serial_id)
		return(0);

//	if ( 	(maincfg.CFG_FLAGS & FLAG_ALLOW2LOGINS)==0 && 

	if(mi_isonline(serial_id)) 
		return(2);

	if(!mi_loaduser(serial_id, &user))
		return(-1);									// Oops!

	clog.cl_userid=user.user_serial_id;
	clog.cl_firstcall=user.user_firstcall;
	clog.cl_logon=time(0);
	if (user.user_connections==0) 
		clog.cl_flags |= CL_NEWUSER;
	clog.cl_bpsrate=bpsrate;

	return(1);
}

/*
 * Compares passwords.
 *
 * "passwd" == given unencrypted password
 * "thepw" == encrypted password to be compared with
 *
 * Returns 1 if password ok, 0 otherwise
 *
 */
int mi_cmppasswds(char *passwd, unsigned char *thepw)
{
	MD_CTX context;
	unsigned char digest[16];
	char newpw[30];

	memset(&newpw, 0, 30);
	strcpy(newpw,passwd);
	mi_strupr(newpw);

    MDInit (&context);
    MDUpdate (&context, newpw, strlen(newpw));
    MDFinal (digest, &context);

	if(memcmp(thepw, digest, PASSWD_SIZE)==0)
		return(1);
	
	return(0);
}

/*
 * Is user with serial_id "id" online?
 *
 * Stupid: goes through all nodes, tries to match user
 * 
 * Returns node number if yes, 0 otherwise.
 *
 */
int mi_isonline(int id)
{
	struct VMatik_Node *cn=nodes;
	
	while(cn->Node_ID)
	{
		if (cn->Node_TTYType == NODETYPE_TELNET) 
		{
			int i=maincfg.CFG_TELNET1ST;
			int j=maincfg.CFG_TELNETMAX;
			
			while(j) {
				j--;
				if (mi_isonck(i,id)) return(i);
				i++;
			}
		} else if (cn->Node_TTYType == NODETYPE_LOCAL) {
			int i=maincfg.CFG_LOCAL1ST;
			int j=maincfg.CFG_LOCALMAX;
			
			while(j) {
				j--;
				if (mi_isonck(i,id)) return(i);
				i++;
			}
		} else {
			if (mi_isonck(cn->Node_ID,id)) return(cn->Node_ID);
		}
		cn++;
	}
	return(0);
}

/*
 * Is user with serial_id "id" on node "num"?
 *
 * 1==yes, 0==no
 * 
 */
int mi_isonck(int num, int id)
{
	struct VMatik_NodeInfo myn;
	
	if(isnode(num,&myn)) 
	{
		if (myn.ddn_userslot==id) 
			return(1);
	}
	return(0);
}

/*
 * Loads an user from userbase according to serial_id.
 * Space for "to_load" must be already allocated.
 *
 */
int mi_loaduser(int serial_id, struct userbase *to_load)
{
	MYSQL_RES	*sql_result;
	MYSQL_ROW	sql_row;
	char query[QUERY_MAX];
	
	sprintf(query, "SELECT user_name, user_handle, user_org,
			user_email, user_city, user_voicephone, user_dataphone,
			user_password, user_screenlength, user_protocol, user_toggles,
			user_seclevel, UNIX_TIMESTAMP(user_firstcall), user_id,
			user_defconf_id, user_defarea_id, user_fileratio1,
			user_byteratio1, user_confacc, user_timeremain, user_calls,
			UNIX_TIMESTAMP(user_lastcall), user_secflags,
			user_timelimit, user_pubmessages, user_prvmessages
			FROM vmatik_user WHERE user_id=%d",	serial_id);
	mysql_query(&vm_database, query);
	if(mysql_error(&vm_database)[0])
		DDPut(mysql_error(&vm_database));

	sql_result=mysql_store_result(&vm_database);
	if(!sql_result)
		return(0);

	sql_row=mysql_fetch_row(sql_result);
	if(!sql_row)
	{
		mysql_free_result(sql_result);
		return(0);
	}

	strcpy(to_load->user_realname, sql_row[0]);
	strcpy(to_load->user_handle, sql_row[1]);
	strcpy(to_load->user_organization, sql_row[2]);
	strcpy(to_load->user_email, sql_row[3]);
	strcpy(to_load->user_zipcity, sql_row[4]);
	strcpy(to_load->user_voicephone, sql_row[5]);
	strcpy(to_load->user_dataphone, sql_row[6]);
	memcpy(to_load->user_password, sql_row[7], PASSWD_SIZE);
	to_load->user_screenlength=atoi(sql_row[8]);
	to_load->user_protocol=atoi(sql_row[9]);
	sscanf(sql_row[10], "%lu", &to_load->user_toggles);
	to_load->user_securitylevel=atoi(sql_row[11]);
	to_load->user_firstcall=atol(sql_row[12]);
	to_load->user_serial_id=atol(sql_row[13]);
	to_load->user_defconf_id=atol(sql_row[14]);
	to_load->user_defarea_id=atol(sql_row[15]);
	to_load->user_fileratio1=atoi(sql_row[16]);
	to_load->user_byteratio1=atoi(sql_row[17]);
	to_load->user_confacc=mi_atob(sql_row[18]);
	to_load->user_timeremaining=atoi(sql_row[19]);
	to_load->user_connections=atoi(sql_row[20]);
	to_load->user_lastcall=atoi(sql_row[21]);
	to_load->user_secflags=mi_atob(sql_row[22]);
	to_load->user_dailytimelimit=atoi(sql_row[23]);
	to_load->user_pubmessages=atoi(sql_row[24]);
	to_load->user_prvmessages=atoi(sql_row[25]);

	mysql_free_result(sql_result);
	
	return(1);
}

int mi_add_user(MYSQL *db, struct userbase *to_save)
{
	char query[QUERY_MAX];
	char newpasswd[sizeof(to_save->user_password)*3];
	int new_id=0;

	mysql_escape_string(newpasswd, user.user_password,
						sizeof(to_save->user_password));

	sprintf(query, "INSERT INTO vmatik_user (user_name, user_handle, user_org,
	user_email, user_city, user_voicephone, user_dataphone, user_password,
	user_screenlength, user_protocol, user_toggles, user_confacc,
	user_defconf_id, user_timelimit, user_secflags, user_fileratio1,
	user_byteratio1) VALUES
	('%s','%s','%s','%s','%s','%s','%s','%s',%d,%d,%lu,%lld,%d,%d,%lld,
	%d,%d)",
	user.user_realname,
	user.user_handle,
	user.user_organization,
	user.user_email,
	user.user_zipcity,
	user.user_voicephone,
	user.user_dataphone,
	newpasswd,	
	user.user_screenlength,
	user.user_protocol,
	user.user_toggles,
	user.user_confacc,
	user.user_defconf_id,
	user.user_dailytimelimit,
	user.user_secflags,
	user.user_fileratio1,
	user.user_byteratio1
	);

	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		DDPut(mysql_error(db));
		return(0);
	}
	new_id=mysql_insert_id(db);

	return(new_id);	
}

/*
 * This function returns a pointer to the filename component
 * (==last component) of a path.
 *
 */
char *mi_filepart(char *path)
{
	char *t;

	t=&path[strlen(path)];

	while(path!=t) 
	{
		if(*t=='/') return(t+1);
		t--;
	}
	return(t);
}

/*
 * Converts string to upper case
 *
 */
void mi_strupr (char *string)
{
	while (*string)
	{
		*string++=toupper(*string);
	}
}

/*
 * Converts string to lower case
 *
 */
void mi_strlwr (char *string)
{
	while (*string)
	{
		*string++=tolower(*string);
	}
}

/*
 * Returns a single string from database in 'result'. It must
 * contain enough space.
 *
 */
int mi_sql_getstr(MYSQL *db, char *column, char *tables, 
				char *where, char *result)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];

	sprintf(query, "SELECT %s FROM %s WHERE %s", column, tables,
			where);
	mysql_query(db, query);
	sql_result=mysql_store_result(db); 
	if(!sql_result)
		return(0);
	sql_row=mysql_fetch_row(sql_result);
	if(!sql_row)
	{
		mysql_free_result(sql_result);
		return(0);
	}

	strcpy(result, sql_row[0]);
	
	mysql_free_result(sql_result);
	
	return(1);
}

/*
 * Modifies some user attribute according to "value"
 *
 */
int mi_sql_setuser(MYSQL *db, char *column, int user_id, char rel_type, 
					ULONG value)
{
	char where[100];
	
	sprintf(where, "user_id=%d", user_id);
	
	return(mi_sql_setval(db, column, "vmatik_user", where, rel_type, value));
}

/*
 * Gets a numeric user attribute value
 *
 */
ULONG mi_sql_getuser(MYSQL *db, char *column, int user_id)
{
	char where[100];
	sprintf(where, "user_id=%d", user_id);

	return(mi_sql_getnum(db, column, "vmatik_user", where));
}

/*
 * Returns a single number value, 0 on failure
 *
 * Bugs: Error returning / reporting is not very graceful
 *
 */
ULONG mi_sql_getnum(MYSQL *db, char *column, char *tables,
				char *where)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];
	long temp_num=0;

	if(!column || !tables || !where)
		return(0);

	sprintf(query, "SELECT %s FROM %s WHERE %s", column, tables,
			where);
	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "ERROR: %s\n", mysql_error(db));
		DDPut(mysql_error(db));
		return(0);
	}

	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row && sql_row[0])
			sscanf(sql_row[0], "%lu", &temp_num);
	
		mysql_free_result(sql_result);
	}
	return(temp_num);
}

/* 
 * Sets a single number value relative to the previous value,
 * eg. downloads+=1, or equal to "rel_value", if rel_type==NULL or '='
 *
 */
int mi_sql_setval(MYSQL *db, char *column, char *table, char *where,
				char rel_type, ULONG rel_value)
{
	char query[QUERY_MAX];

	if(rel_type=='=' || rel_type==0)
	{
		sprintf(query, "UPDATE %s SET %s=%lu WHERE %s", table, column,
				rel_value, where);
	}
	else
	{
		sprintf(query, "UPDATE %s SET %s=%s%c%lu WHERE %s", table, column, 
				column, rel_type, rel_value, where);
	}
	mysql_query(db, query);
	
	return(1);
}

/*
 * Makes sure that last character in a path is '/'
 *
 * Warning: May enlarge the "path" with 1 char
 *
 */
int mi_correct_path(char *path)
{
	if(!path)
		return(0);
	if(!path[0])
		return(0);

	while(*path!=0)
		path++;

	path--;
	
	if(*path=='/')
		return(1);
	
	path++;
	*path='/';
	*(path+1)=0;

	return(1);
}

/*
 * Sets a single text column "column" to string "to_set"
 *
 */
int mi_sql_setstr(MYSQL *db, char *column, char *table, 
				char *where, char *to_set)
{
	char query[QUERY_MAX];
	
	if(!db || !column || !table || !where || !to_set)
		return(0);

	sprintf(query, "UPDATE %s SET %s='%s' WHERE %s", 
					table, column, to_set, where);
	mysql_query(db, query);

	if(mysql_error(db)[0])
		return(0);
	
	return(1);
}

/*
 * This makes an ASCII range string from "input_val"
 *
 */
int mi_long2ascii_range(ULONG input_val, char *outbuf)
{
	int i,loc=0,gotmany=0,was_set_last_round=0,first=1;

	if(!outbuf)
		return(0);

	outbuf[0]=0;

/*
	for(i=0;i<32;i++)
	{
		if(input_val & 1L<<i)
			DDPut("X");
		else
			DDPut("-");
	}
	DDPut("\n");
*/

	for(i=0;i<32;i++)
	{
		if(input_val & 1L<<i)
		{
			if(!was_set_last_round)
			{
				gotmany=0;
				if(first)
				{
					first=0;
					loc+=sprintf(&outbuf[loc], "%d", i);
				}
				else
				{
					loc+=sprintf(&outbuf[loc], ",%d", i);
				}
			}
			else
			{
				gotmany=1;
			}
			was_set_last_round=1;
		}
		else
		{
			if(was_set_last_round && gotmany)
			{
				loc+=sprintf(&outbuf[loc], "-%d", i-1);
			}
			was_set_last_round=0;
		}
	}
//	DDPut(outbuf);
	return(1);
}

/*
 * This creates a bitfield of 32 bits from the input range. 
 * Naturally the range should only have numbers
 * from 0 to 31. Others are ignored.
 *
 */
ULONG mi_range2long(struct List *range)
{
	struct Range *rangetmp;
	ULONG retval=0, maxim, minim;
	int i;

	if(!range)
		return(0);

	rangetmp=(struct Range *)range->lh_Head;
	while(rangetmp->head.ln_Succ)
	{
		if(rangetmp->range_start>31)
			minim=31;
		else
			minim=rangetmp->range_start;
		if(rangetmp->range_stop>31)
			maxim=31;
		else
			maxim=rangetmp->range_stop;
			
		for(i=minim;i<=maxim;i++)
			retval |= (1L<<i);
			
		rangetmp=(struct Range *)rangetmp->head.ln_Succ;
	}

	return(retval);
}

/*
 * Converts an ascii string to "unsigned long long" (aka bint)
 *
 */
bint mi_atob(char *str)
{
	bint temp=0;
	int first=1;

	if(!str)
		return(0);

	while(*str)
	{
		if(isdigit(*str))
		{
			if(first)
			{
				first=0;
				temp=*str-'0';    		// What a hack. ugh
			}
			else
			{
				temp=(temp*10)+(*str-'0');
			}
		}
		str++;
	}

	return(temp);
}

/* 
 * Retrieves a user bigint from db
 *
 */
bint mi_sql_getuserb(MYSQL *db, char *column, int user_id)
{
	char query[QUERY_MAX];
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	bint temp;

	sprintf(query, "SELECT %s FROM vmatik_user WHERE user_id=%d",
					column, user_id);
	mysql_query(db, query);
	sql_result=mysql_store_result(db);
	if(!sql_result)
		return(0);

	sql_row=mysql_fetch_row(sql_result);

	temp=mi_atob(sql_row[0]);

	mysql_free_result(sql_result);

	return(temp);
}

/*
 * Returns a pointer to the correct seclevel data, or NULL
 *
 */
struct VMatik_Seclevel *mi_findsecdata(int sec_level)
{
	struct VMatik_Seclevel *sectmp;

	sectmp=secs;
	while(sectmp->SEC_SECLEVEL<=31)
	{
		if(sectmp->SEC_SECLEVEL==sec_level)
			return(sectmp);
		sectmp++;
	}

	return(NULL);
}

/*
 * This asks some node to reload the user data
 * 
 * Note: It does no harm because any important values subject
 *       to change (credits/upbytes, calls etc) are always saved
 *       to database directly on modification.
 *
 */
int mi_ask_user_reload(char *params)
{
	char *srcstrh;
	char parbuf[1024];
	char buffer[80];
	struct VMatik_nodemessage olm;
	int destnode;

	srcstrh=params;

	if(!(srcstrh=strspa(srcstrh, parbuf)))
	{
		DDPut("\nWhich node? : ");
		buffer[0]=0;
		if (!(Prompt(buffer, 3, 0)))
			return(0);
		srcstrh=strspa(buffer, parbuf);
	}
	
	if(!isdigit(parbuf[0]))
	{
		DDPut(sd[euabortedstr]);
		return(0);
	}
		
	destnode=atoi(parbuf);
	if(destnode==0)
		return(0);

	memset(&olm, 0, sizeof(struct VMatik_nodemessage));
	olm.dn_command=NODEMSG_RELOAD_USER;

	DDPut("\nOk.\n\n");

	return(ol_send_defined(destnode, &olm));
}

/*
 * This modifies the timeremaining of user on some node.
 *
 */
int mi_dumpuser(char *params)
{	
	char *srcstrh;
	char parbuf[1024];
	char buffer[80];
	struct VMatik_nodemessage olm;
	int destnode;

	srcstrh=params;

	if(!(srcstrh=strspa(srcstrh, parbuf)))
	{
		DDPut("\nWhich node? : ");
		buffer[0]=0;
		if (!(Prompt(buffer, 3, 0)))
			return(0);
		srcstrh=strspa(buffer, parbuf);
	}
	
	if(!isdigit(parbuf[0]))
	{
		DDPut(sd[euabortedstr]);
		return(0);
	}
		
	destnode=atoi(parbuf);
	if(destnode==0)
		return(0);

	if(!(srcstrh=strspa(srcstrh, parbuf)))
	{
		buffer[0]=0;
		DDPut("Minutes left? : ");
		if(!(Prompt(buffer, 4, 0)))
			return(0);
		srcstrh=strspa(buffer, parbuf);
	}
	
	if(!isdigit(parbuf[0]))
	{
		DDPut(sd[euabortedstr]);
		return(0);
	}

	memset(&olm, 0, sizeof(struct VMatik_nodemessage));
	olm.dn_data1=atoi(parbuf);
	olm.dn_command=NODEMSG_NEW_TIMELEFT;

	DDPut("\nOk.\n\n");

	return(ol_send_defined(destnode, &olm));

}

int mi_wild2sql(char *sqlstring, char *wildstring)
{
	int wild_found=0;

	if(!sqlstring || !wildstring)
		return(0);
	
	while(*wildstring)								// Check for wildcard
	{
		switch(*wildstring)							// Convert to SQL
		{
			case '*':
				*sqlstring++='%';
				wild_found=1;
				break;
			case '_':
				*sqlstring++='\\';
				*sqlstring++='_';
				break;
			case '?':
				*sqlstring++='_';
				wild_found=1;
				break;
			default:
				*sqlstring++=*wildstring;
				break;
		}
		wildstring++;
	}
	*sqlstring=0;

	return(wild_found);
}
