/*
 * The main() and some initialization stuff is located here.
 *
 */
#include "proto.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_SGTTY
#include <sgtty.h>
#endif

int lmode=0;

int conin=0;
int conout=0;
int serhandle=0;
char keysrc;
int ansi;
int carrier;
int conon=0;
int timeleft;							// Time the user has left
time_t endtime;
int highest;
int lowest;
int bytestagged, fbytestagged;
int delayt;
int doquit;
UWORD filestagged, ffilestagged;

MYSQL vm_database;							// Main MySQL handle

int Current_FileAreaID=0;					// Real area_id
int Current_FileAreaNumber=0;				// Value shown to user

struct List *confs=NULL;
struct List *olms=NULL;
struct List *SelectList=NULL;

struct VMatik_MainConfig maincfg;
struct VMatik_Conference *conf;
struct VMatik_MsgBase *base;
struct VMatik_DisplayMode *displays;
struct VMatik_DisplayMode *display;
struct VMatik_Node *nodes;
struct VMatik_Node *currnode;
struct VMatik_Seclevel *secs;
struct VMatik_Archiver *arcs;
struct VMatik_ExternalCommand *exts;
struct VMatik_Protocol *protocols;			// All protocols?
struct VMatik_Protocol *protocol=NULL;		// Current protocol?
struct callerslog clog;

int pages;
bint access_flags;					// User's access flags
struct userbase user;				// Current online user
int onlinestat=0;

// char puskuri[100];
int userinput;
char origdir[PATH_MAX];				// == $VMATIK env setting

char *sd[MAXSTRS];
unsigned char inconvtab[256];
unsigned char outconvtab[256];

int ma_getin(void);

int main(int argc, char *argv[])
{
	int datafd;
  	struct stat fib;
 	unsigned char *s;
	
	ffilestagged=filestagged=bytestagged=fbytestagged=0;
	userinput=1;
	*reason=0;
	
	memset(&clog,0,sizeof(struct callerslog));
				 
	if (!un_getcmdline(argc, argv)) 
		return(0);

	mkdir(VMTMP,0755);

/***************** Connect to mysql server **********************************/

	mysql_connect(&vm_database, NULL, SQL_USER, SQL_PASSWD);
	if(mysql_error(&vm_database)[0])
	{
		printf("Error: %s\n",
				mysql_error(&vm_database));
		return(0);
	}
	mysql_select_db(&vm_database, "vmatik");
	if(mysql_error(&vm_database)[0])
	{
		printf("Error: %s\n",
				mysql_error(&vm_database));
		return(0);
	}

/********************* Read main config *************************************/

	datafd=open("data/vmatik.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open vmatik.dat. Please whip the root!\n");
		exit(0);
	}
	read(datafd,&maincfg,sizeof(struct VMatik_MainConfig));
	close(datafd);

/********************* Install conferences **********************************/

	ma_install_conferences("data/conferences.dat");

/********************* Init node information ********************************/

	datafd=open("data/multinode.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open multinode.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	nodes=(struct VMatik_Node *)malloc(fib.st_size+2);
	read(datafd,nodes,fib.st_size);
	close(datafd);
	s=(char *)nodes;
	s[fib.st_size]=0;

/********************* Init security information ****************************/

	datafd=open("data/security.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open security.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	secs=(struct VMatik_Seclevel *)malloc(fib.st_size+2);
	read(datafd,secs,fib.st_size);
	close(datafd);
	s=(char *)secs;
	s[fib.st_size]=255;

/********************* Init display information *****************************/

	datafd=open("data/display.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open display.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	displays=(struct VMatik_DisplayMode *)malloc(fib.st_size+2);
	read(datafd,displays,fib.st_size);
	close(datafd);
	s=(char *)displays;
	s[fib.st_size]=0;
	display=0;

/********************* Init external command info ***************************/

	datafd=open("data/externalcommands.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open externalcommands.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	exts=(struct VMatik_ExternalCommand *)malloc(fib.st_size+2);
	read(datafd,exts,fib.st_size);
	close(datafd);
	s=(char *)exts;
	s[fib.st_size]=0;

/********************* Init archiver data ***********************************/

	datafd=open("data/archivers.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open archivers.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	arcs=(struct VMatik_Archiver *)malloc(fib.st_size+2);
	read(datafd,arcs,fib.st_size);
	close(datafd);
	s=(char *)arcs;
	s[fib.st_size]=255;

/************************* Init protocol data *******************************/

	datafd=open("data/protocols.dat",O_RDONLY);
	if (datafd==-1) {
		printf("Can't open protocols.dat. Aiee!\n");
		exit(0);
	}

	fstat(datafd,&fib);
	
	protocols=(struct VMatik_Protocol *)malloc(fib.st_size+2);
	read(datafd,protocols,fib.st_size);
	close(datafd);
	s=(char *)protocols;
	s[fib.st_size]=0;

/***************** Check if we know which TTY we're using.. ******************/

	if(!initterm())
		exit(0);

	olms=NewList();
	mktempdir();

/************************* Initialize carrier loss handler *******************/

	signal(SIGHUP,carrieroff);
	signal(SIGTERM,carrieroff);
	signal(SIGINT,carrieroff);

	signal(SIGPIPE,un_sigpipe_handler);		// May cause problems!!!

//	signal(SIGINT, un_sigint_handler);

/*************************** Enter the system ********************************/

	ma_visitbbs(0);

	mysql_close(&vm_database);	

	/* Exit this lousy establishment */

	return(0);
}

int ma_visitbbs(int m)
{
	time_t aika;
	char *aikas;
	int tmp;
 	char puskur[300];
	char buffer[512];
	
	changenodestatus("Logging in...");
	
	ffilestagged=filestagged=bytestagged=fbytestagged=0;
	*reason=0;

	memset(&clog,0,sizeof(struct callerslog));
	memset(&user,0,sizeof(struct userbase));
	onlinestat=0;
	display=0;
	ClearList(olms);

	carrier=1;
	aika=time(0);
	aikas=ctime(&aika);
	aikas[24]=0;
	
	switch(currnode->Node_TTYType)
	{
		case NODETYPE_LOCAL:
			sprintf(buffer, "Local");
			break;
		case NODETYPE_TELNET:
			sprintf(buffer, "From %s", remotehost);
			break;
		case NODETYPE_NORMAL:
			sprintf(buffer, "Normal node");
			break;
		default:
			sprintf(buffer, "Unknow nodetype!");
			break;
	}
		
	sprintf(puskur,"===============================================[ %s ]===\n%d BPS connection on line #%d (%s)\n\n",
		aikas,bpsrate,node, buffer);
	writelog(puskur);
		
//	sprintf(puskur,"[2J[HVMatik BBS/Unix %s\nby ~g 1998-1999\nYou are connected to node #%d at %d BPS.\n\n",versionstring,node,bpsrate);
//	DDPut(puskur);
		
	dp_rundoorbatch("data/frontends.dat",0);

	if (!display) 
		if (getdisplaymode(0,0)<1) 
		{
			DDPut("Failed to load displaymode... disconnecting!\n\n");
			return 0;
		}
//	changemode(4);

	if (!syspw()) 
		return(0);

	TypeFile("banner",TYPE_MAKE|TYPE_WARN);
	
	tmp=0;
/*
	if (m) {
		switch(mi_checklogon("sysop")) {
		 case '1':
			sleep(2);
			ma_getin();
			break;
		}
		return(1);
	}
*/
	while (!tmp)
	{
		DDPut(sd[usernamestr]);  
		buffer[0]=0;
		Prompt(buffer,25,0);
		removespaces(buffer);
		if (!checkcarrier()) tmp=1;
		if (!buffer[0]) DDPut("");
		else if (!strcasecmp("new",buffer))
		{
			if(nu_create_account(&vm_database)==0)
				tmp=1;
		}
		else if (!strcasecmp("logoff",buffer) || !strcasecmp("exit", buffer)
				|| !strcasecmp("quit", buffer))
			tmp=1;
		else if (!strcasecmp("chat",buffer)) pa_pagesysop(0);
		else {
			int passwdcnt;

			writelog("Login attempt: ");
			writelog(buffer);
			writelog("\n");
	
			switch(mi_checklogon(buffer)) {
				case 1:
				for (passwdcnt=0;passwdcnt < 3; passwdcnt ++) {
					buffer[0]=0;
					DDPut(sd[passwordstr]);
					
					Prompt(buffer, 25,PROMPT_SECRET);
					if (!checkcarrier()) {
						tmp=1; break;
					}
					if (mi_cmppasswds(buffer,user.user_password)) {

						tmp=1;
						ma_getin();
						break;
					} else {
						if (passwdcnt<2)
						{
							sleep(1);
							DDPut(sd[tryagainstr]);
						}
//						killflood();
						clog.cl_flags |= CL_PASSWDFAIL;
						writelog("Password failure.\n");
					}
				}
				if (!tmp) {
					TypeFile("passwordfailure",TYPE_MAKE);
					DDPut(sd[excessivepwfailstr]);
					sprintf(buffer, "Excessive failure for %s (%s, %d)\n",
							user.user_handle, user.user_realname, 
							user.user_serial_id);
					writelog(buffer);
					tmp=1;
				}
				break;
				case 0:
					writelog("Tried login: ");
					writelog(buffer);
					writelog("\n");
					if (maincfg.CFG_FLAGS & FLAG_ASKNEWUSER) {
						DDPut(sd[newucstr]);
						switch(HotKey(HOT_NOYES)) {
							case 1:
							writelog("Newuser procedure started\n");
							if (nu_create_account(&vm_database)) {
								clog.cl_userid=user.user_serial_id;
								clog.cl_firstcall=user.user_firstcall;
								clog.cl_logon=time(0);
								if (user.user_connections==0) clog.cl_flags |= CL_NEWUSER;
								clog.cl_bpsrate=bpsrate;

								ma_getin();
								tmp=1;
							}
							else
							{
								tmp=1;						// Newuser failed!
							}
							case 2:
								DDPut("\n");
							break;
							default:
								tmp=1;
							break;
						
						}
					} else {
						DDPut(sd[unknownuserstr]);
					}
				break;
				case 2:
					DDPut(sd[alreadyonlinestr]);
					tmp=1;
				break;
			}
		}
  	}

	DDPut(sd[disconnectingstr]);
	ma_dropcarrier();

	return(1);
}

int ma_getin(void)
{
	int clfd;
	char buffer[512];
	char query[QUERY_MAX];
	struct gcallerslog gcl;

	onlinestat=1;
	
	eb_enterbbs();					// Contains the main bbs menu loop
	
// Here user has already logoffed.

	sprintf(query, "UPDATE vmatik_user
					SET user_lastcall=FROM_UNIXTIME(%d)
					WHERE user_id=%d", 
					(int)user.user_logontime,
					user.user_serial_id);
	mysql_query(&vm_database, query);

	fl_free_precalcs(&vm_database, user.user_serial_id);

	sprintf(buffer, "user_id=%d", user.user_serial_id);
	mi_sql_setuser(&vm_database, "user_defconf_id", user.user_serial_id,
					'=', conf->CONF_NUMBER);
	mi_sql_setuser(&vm_database, "user_defarea_id", user.user_serial_id,
					'=', Current_FileAreaID);

	jc_changemsgbase(base->MSGBASE_NUMBER,MC_QUICK|MC_NOSTAT);
	mi_sql_setuser(&vm_database, "user_timeremain", user.user_serial_id,
					'=', timeleft/60);

	clog.cl_logoff=time(0);
	sprintf(buffer,"%s/logfiles/callerslog%d.dat",origdir,node);
	clfd=open(buffer,O_WRONLY|O_CREAT,0644);
	if (clfd!=-1) {
		lseek(clfd,0,SEEK_END);
		write(clfd,&clog,sizeof(struct callerslog));
		close(clfd);
	}

	sprintf(buffer,"%s/logfiles/callerslog.dat",origdir);
	clfd=open(buffer,O_WRONLY|O_CREAT,0644);
	if (clfd!=-1) {
		gcl.cl_node=node;
		gcl.cl=clog;
		lseek(clfd,0,SEEK_END);
		write(clfd,&gcl,sizeof(struct gcallerslog));
		close(clfd);
	}

	if (currnode->Node_Flags & NODE_NOTIFY) {
		char mesbuf[1024];
		sprintf(mesbuf,"\n[0m%s from %s logged off from node #%d\n",
			maincfg.CFG_FLAGS & FLAG_HANDLE ? user.user_handle : user.user_realname,
			maincfg.CFG_FLAGS & FLAG_ORGANIZATION ? user.user_organization : user.user_zipcity,
			node);
		
		olmall(2,mesbuf);
	}

	mi_runlogoffbatch();
	onlinestat=0;

	return(1);
}

void carrieroff(int sig)
{
	char buf[80];

	signal(sig,carrieroff);
	if (!carrier) return;
	carrier=0;

	sprintf(buf,"Carrier lost at %s\n",currt());
	writelog(buf);
	clog.cl_flags |= CL_CARRIERLOST;
}

int syspw(void)
{
	char b[80];
	int i;
	
	if (*maincfg.CFG_SYSTEMPW) {
		TypeFile("systempassword",TYPE_MAKE);
		for (i=2;i;i--) {
			*b=0;
			DDPut(sd[syspwstr]);
			if (!(Prompt(b,16,PROMPT_SECRET))) return 0;
			if (!strcasecmp(b,maincfg.CFG_SYSTEMPW)) return 1;
		}
		return 0;
	}
	return 1;
}

int checkcarrier(void)
{
	if (lmode) 
		return(1);

	if (!carrier) 
		return(0);

	return(1);
}

int ma_dropcarrier(void)
{
	if (!checkcarrier()) return 0;
	
	if (!lmode) {
		struct termios tty;
		speed_t sp;
		
		tcgetattr(serhandle,&tty);
		sp=cfgetospeed(&tty);
		cfsetospeed(&tty,B0);
		tcsetattr(serhandle,TCSANOW,&tty);
//		close(serhandle);
		sleep(2);
//		serhandle=open(currnode->MULTI_TTYNAME,O_RDWR|O_NOCTTY);
		cfsetospeed(&tty,sp);
		tcsetattr(serhandle,TCSANOW,&tty);
	}
	carrier=0;
	return 1;
}

/*
 * This reads the conference datas to memory.
 *
 */
int ma_install_conferences(char *filename)
{
	int datafd, i;
	struct VMatik_Conference tconf;
	struct VMatik_Conference *confp;

	datafd=open(filename,O_RDONLY);
	if (datafd==-1) {
		printf("Can't open %s. Aiee!\n", filename);
		exit(0);
	}

	confs=NewList();

	while(read(datafd, &tconf, sizeof(struct VMatik_Conference)))
	{
		if(tconf.CONF_MSGBASES>0)
		{
//			DDPut("Msgbases found!");
			i=tconf.CONF_MSGBASES*sizeof(struct VMatik_MsgBase);
			tconf.Conf_MsgBases=malloc(i);
			read(datafd, tconf.Conf_MsgBases, i);
		}
		
		confp=malloc(sizeof(struct VMatik_Conference));
	
		memcpy(confp, &tconf, sizeof(struct VMatik_Conference));

		AddTail(confs, (struct Node *)confp);
	}

	close(datafd);

	return(1);
}
