/*
 * Functions related to scanning new mail
 *
 */
#include "proto.h"
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

int sfnmjoin(int);


struct MsgScanDat
{
	int ms_seekp;
	int ms_number;
	char ms_sender[26];
	char ms_subject[60];
	int ms_status;
};

int sfnmjoin(int confn)
{
	if (!isanybasestagged(confn)) 			// No bases tagged?
		return(0);
		
	if (!jc_joinconf(confn,JC_QUICK|JC_SHUTUP)) 
		return(0);

//	DDPut("Anal!\n");
	return(1);
}

int ms_scanfornewmail(void)
{
	int oldconf;
	int datafd;
	char mailbuf[PATH_MAX];
	struct VMatik_Conference *mconf;
	struct VMatik_MsgBase *mbase;
	struct MsgScanDat dat;

	changenodestatus("Scanning for new mail");
	
	sprintf(mailbuf,"%sVMatik%d.mail",VMTMP,node);
	unlink(mailbuf);
	datafd=open(mailbuf,O_RDWR|O_CREAT,0664);
	if (datafd==-1) {
		DDPut("Can't open datafile! Whip root!\n\n");
		return 0;
	}
	close(datafd);
	datafd=-1;
	
	oldconf=user.user_defconf_id;
	
	DDPut(sd[msheadstr]);

	mconf=(struct VMatik_Conference *)confs->lh_Head;
	
	while(mconf->chead.ln_Succ)
	{
		int newcnt;
		int bcnt;
		int delcnt=0;
		int ddir=0;
		int seekp;
		struct stat st;
		struct VMatik_Message msg;

//		DDPut("Molomoo!\n");

		newcnt=0;
		if (sfnmjoin(mconf->CONF_NUMBER)) 
		{
			char buffer[512];

//			DDPut("Pilipali\n");
		
			sprintf(buffer,sd[ms1str],conf->CONF_NAME);
			DDPut(buffer);
			mbase=conf->Conf_MsgBases;
			bcnt=conf->CONF_MSGBASES;
			while(bcnt)
			{
				int basefd;
			
				if (isbasetagged(conf->CONF_NUMBER,mbase->MSGBASE_NUMBER)) {
					if (delcnt) multibackspace(delcnt);
					jc_changemsgbase(mbase->MSGBASE_NUMBER,MC_QUICK|MC_NOSTAT);
					sprintf(buffer,sd[ms2str],base->MSGBASE_NAME);
					DDPut(buffer);
					delcnt=22;

//					sprintf(buffer, "lsp: %d, lrp: %d\n", 
//						base->MSGBASE_LRP.lrp_scan, base->MSGBASE_LRP.lrp_read); 
//					DDPut(buffer);

					if (base->MSGBASE_LRP.lrp_scan >= highest) {
						base->MSGBASE_LRP.lrp_scan=highest;
					} else {
						sprintf(buffer,"%smessages/base%3.3d/msgbase.dat",conf->CONF_PATH,base->MSGBASE_NUMBER);
						basefd=open(buffer,O_RDONLY);
						if (basefd!=-1) {
							fstat(basefd,&st);
							seekp=st.st_size-(highest-(base->MSGBASE_LRP.lrp_scan)+2)*sizeof(struct VMatik_Message);
							if (seekp < 0) seekp=0;
							lseek(basefd,seekp,SEEK_SET);                                           
							while(read(basefd,&msg,sizeof(struct VMatik_Message)))
							{
								if (ddir)
								{
									if (delcnt==22) {
										ddir=0;
										DDPut("*");
										delcnt++;
									} else {
										DDPut("[D [D");
										delcnt--;
									}
								} else {
									if (delcnt==30) {
										ddir=1;
										DDPut("[D [D");
										delcnt--;
									} else {
										DDPut("*");
										delcnt++;
									}
								}
								if (msg.MSG_NUMBER > base->MSGBASE_LRP.lrp_scan ) {
									if (msg.MSG_RECEIVER[0]==-1 || (!strcasecmp(msg.MSG_RECEIVER,user.user_handle)) || (!strcasecmp(msg.MSG_RECEIVER,user.user_realname))) {
										int msgfd;
										sprintf(buffer,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg.MSG_NUMBER);
										msgfd=open(buffer,O_RDONLY);
										if (msgfd!=-1) {
											close(msgfd);
											newcnt++;
											if (datafd==-1) {
												sprintf(buffer,"%sVMatik%d.mail",VMTMP,node);
												datafd=open(buffer,O_RDWR|O_CREAT|O_TRUNC,0660);
											}
											dat.ms_seekp=seekp;
											dat.ms_number=msg.MSG_NUMBER;
											strcpy(dat.ms_sender,msg.MSG_AUTHOR);
											strcpy(dat.ms_subject,msg.MSG_SUBJECT);
											dat.ms_status=msg.MSG_FLAGS;
											write(datafd,&dat,sizeof(struct MsgScanDat));
										}
									} else {
										if (!(msg.MSG_FLAGS & MSG_FLAGS_PRIVATE)) 
											newcnt++;
									}
								}
								seekp+=sizeof(struct VMatik_Message);

							}
							close(basefd);
							if (datafd!=-1) {
								int screenl=user.user_screenlength;
								int hot;
								DDPut(sd[mslheadstr]);
								lseek(datafd,0,SEEK_SET);

								while(read(datafd,&dat,sizeof(struct MsgScanDat)))
								{
									char *sta;
									
									if (dat.ms_status & MSG_FLAGS_PRIVATE) 
										sta="Private";
									else 
										sta="Public";
								
									screenl--;
									sprintf(buffer,sd[mslliststr],dat.ms_number,dat.ms_sender,dat.ms_subject,sta);
									DDPut(buffer);
									if (screenl==0) {
				
										DDPut(sd[morepromptstr]); 
										hot=HotKey(0);
										DDPut("\r                                                         \r");
										if (hot=='N'||hot=='n') break;
										if (hot=='C'||hot=='c') {
											screenl=-1;
										} else {
											screenl=user.user_screenlength;
										}
									}

							
								}
								DDPut(sd[mslpromptstr]);
								hot=HotKey(0);
								if (hot=='Y' || hot == 'y' || hot == 13 || hot == 10) {
									lseek(datafd,0,SEEK_SET);
									while(read(datafd,&dat,sizeof(struct MsgScanDat)))
									{
										if (dat.ms_number >= base->MSGBASE_LRP.lrp_scan) {
											if ((readmessages(dat.ms_seekp,dat.ms_number))==2) break;
										} 
									}
								} else if (hot == 'M' || hot == 'm') {
									base->MSGBASE_LRP.lrp_scan=highest;
								}
								DDPut(sd[msheadstr]);
								sprintf(buffer,sd[ms3str],conf->CONF_NAME,base->MSGBASE_NAME);
								DDPut(buffer);
								delcnt=22;
								close(datafd);
								datafd=-1;
								ddir=0;

							} else base->MSGBASE_LRP.lrp_scan=highest;
						}
					}       
				}
				mbase++;
				bcnt--;
	
			}
			multibackspace(delcnt-22);
			if (newcnt) {
				sprintf(buffer,sd[msnewstr],newcnt);
				DDPut(buffer);
			} else {
				DDPut(sd[msnonewstr]);
			}
		}
//		DDPut("Taraa\n");
		mconf=(struct VMatik_Conference *)mconf->chead.ln_Succ;
	}
	DDPut(sd[mstailstr]);
	unlink(mailbuf);

	jc_joinconf(oldconf,JC_QUICK|JC_SHUTUP);
	return 1;
}

void multibackspace(int bscnt)
{
	char mbs[500];
	int kelas;
	
	if (bscnt < 1) return;
	
	mbs[0]=0;
	for(kelas=bscnt;kelas;kelas--)
	{
		strcat(mbs,"[D [D");
	}
	DDPut(mbs);
}
