/*
 * Dynamic list handling routines
 *
 * These look just like AmigaOS implementation of exec's dynamic lists :)
 *  
 */

#include "proto.h"
#include <stdlib.h>

struct List * NewList(void)
{
	struct List *myl;
	
	myl=(struct List *)malloc(sizeof(struct List));
	myl->lh_Head=(struct Node *)&myl->lh_Tail;
	myl->lh_Tail=0;
	myl->lh_TailPred=(struct Node *)&myl->lh_Head;
	return myl;
}  

void AddHead(struct List *myl, struct Node *myn)
{
	struct Node *tnod;
	
	if (myl->lh_TailPred==(struct Node *)&myl->lh_Head) myl->lh_TailPred=myn;
	tnod=myl->lh_Head;
	myl->lh_Head=myn;
	myn->ln_Succ=tnod;
	myn->ln_Pred=(struct Node *)myl;
	tnod->ln_Pred=myn;
} 

void AddTail(struct List *myl, struct Node *myn)
{
	struct Node *tnod;
	
	tnod=myl->lh_TailPred;
	tnod->ln_Succ=myn;
	myl->lh_TailPred=myn;
	myn->ln_Succ=(struct Node *)&myl->lh_Tail;
	myn->ln_Pred=tnod;
}

void Remove(struct Node *myn)
{
	struct Node *pnod;
	struct Node *pnod2;
	
	pnod=myn->ln_Pred;
	pnod->ln_Succ=myn->ln_Succ;
	pnod2=myn->ln_Succ;
	pnod2->ln_Pred=pnod;
}

struct Node *RemTail(struct List *myl)
{
	struct Node *tnod;
	struct Node *pnod;
	
	if (myl->lh_TailPred == (struct Node *)&myl->lh_Head) return 0;
	
	tnod=myl->lh_TailPred;
	pnod=tnod->ln_Pred;
	pnod->ln_Succ=(struct Node *)&myl->lh_Tail;
	myl->lh_TailPred=pnod;
	return tnod;
}

int ClearList(struct List *myl)
{
	struct Node *nodeh;
	struct Node *onode;

	if(!myl) 
		return(0);

	nodeh=myl->lh_Head;

	while(nodeh->ln_Succ)
	{
		Remove((struct Node *)nodeh);
		onode=nodeh;
		nodeh=nodeh->ln_Succ;
		free(onode);
	}
	return(1);
}

/*
 * Copies a list. Returns a pointer to the new list. Copies the
 * contents too, not just pointers.
 */
struct List *CopyList(struct List *myl)
{
	struct List *newl;
	struct Node *tnod;
	struct Node *nnod;

	if(!myl)
		return(NULL);

	newl=NewList();
	tnod=myl->lh_Head;

	while(tnod->ln_Succ)
	{
		nnod=malloc(sizeof(tnod));
		memcpy(nnod, tnod, sizeof(tnod)); 
		AddTail(newl, nnod);
		tnod=tnod->ln_Succ;
	}

	return(newl);
}
