/*
 * Conference changing -related stuff
 *
 */
#include "proto.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/*
 * Changes the active (current) filearea of the user
 *
 * mode & JC_SHUTUP   == no output to user
 * mode & JC_ABSOLUTE == newarea is a real existing "area_id"
 *
 * Uses: GLOBAL vm_database
 *
 * BUGS: No area banner yet
 *
 */
int jc_changefilearea(int newarea, int mode)
{
	if(newarea>0)
	{
		MYSQL_RES *sql_result;
		MYSQL_ROW sql_row=NULL;
		char query[QUERY_MAX];
		int i;
		char buffer[PATH_MAX];

		sprintf(query, "SELECT area_id, area_name FROM vmatik_fileareas WHERE
						area_conf=%d AND (area_access=0 
						OR (area_access & %ld))
						ORDER BY area_displayat", 
						conf->CONF_NUMBER, (1L<<user.user_securitylevel));
		mysql_query(&vm_database,query);
		sql_result=mysql_use_result(&vm_database);
		if(!sql_result)
			return(0);

		if(mode & JC_ABSOLUTE)
		{
			i=1;
			while((sql_row=mysql_fetch_row(sql_result)) 
					&& sql_row[0] && atoi(sql_row[0])!=newarea)
				i++;
			newarea=i;

		}
		else
		{
			for(i=0;i<newarea;i++)
				sql_row=mysql_fetch_row(sql_result);
		}

		if(sql_row && sql_row[0])
		{
			Current_FileAreaID=atoi(sql_row[0]);

			if(!(mode & JC_SHUTUP))
			{
				DDPut("\n[");
				DDPut(sql_row[1]);
				DDPut("]\n");
			}

			while(mysql_fetch_row(sql_result));

			mysql_free_result(sql_result);

			if(!(mode & JC_SHUTUP))
			{
//				sprintf(buffer, "%sbanner.txt",
//					Current_FileArea->FileArea_DataPath);

//				TypeFile(buffer, 0);				// Display area banner
			}

			fl_makeprec(&vm_database, Current_FileAreaID);

			if(!(mode & JC_SHUTUP))
			{
				sprintf(query, "SELECT count(*) FROM vmatik_u%d_a%d",
						user.user_serial_id, Current_FileAreaID);
				mysql_query(&vm_database, query);
		
				sql_result=mysql_store_result(&vm_database);
				sql_row=mysql_fetch_row(sql_result);
		
				sprintf(buffer, "\nArea has %s files.\n\n", sql_row[0]);
				mysql_free_result(sql_result);

				DDPut(buffer);
			}

			Current_FileAreaNumber=newarea;
			return(1);
		}
		else
			mysql_free_result(sql_result);
	}
		
	if(!(mode & JC_SHUTUP))
		DDPut("\nNo such filearea in this conference.\n\n");
	return(0);
}	

/*
 * Shows a list of this conferences fileareas to the user
 *
 */
int jc_showfileareas(MYSQL *db, int mode)
{
	int i,found_areas,divider, no_last_line=0;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char buffer[PATH_MAX];
	char query[QUERY_MAX];

	sprintf(query, "SELECT area_name FROM vmatik_fileareas 
			WHERE area_conf=%d AND (area_access=0 OR (area_access & %ld))
			ORDER BY area_displayat", 
			conf->CONF_NUMBER, (1L<<user.user_securitylevel));
	mysql_query(db, query);
	sql_result=mysql_store_result(db);
			
	if(!sql_result)
	{
		DDPut("\nProblem with filearea datas...\n");
		return(0);
	}

	if(!(mode & JC_SHUTUP))
	{
		TypeFile("arealist_banner", TYPE_CONF);
	}

	found_areas=mysql_num_rows(sql_result);
	if(!found_areas)
	{
		if(!(mode & JC_SHUTUP))
			DDPut("\nNo fileareas in this conference...\n\n");
		mysql_free_result(sql_result);
		return(1);
	}

	divider=found_areas/2;

	if(found_areas%2!=0 || divider==0)			// Odd number, or found_areas==1
		divider++;
	else
		no_last_line=1;

	DDPut("\n");
	for(i=0;i<divider;i++)
	{
		mysql_data_seek(sql_result, i);
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row && sql_row[0])
		{
			sprintf(buffer, " %3d. %-30.30s ", i+1, sql_row[0]);
			DDPut(buffer);
		}

		mysql_data_seek(sql_result, divider+i);
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row && sql_row[0])
		{
			sprintf(buffer, " %3d. %-30.30s\n", i+divider+1, sql_row[0]);
			DDPut(buffer);
		}
	}

	DDPut("\n\n");
	mysql_free_result(sql_result);
	
	return(1);
}

/*
 * Changes users conference
 *
 */
int jc_joinconf(int confn, int flags)
{
	int newconfnum;
	struct VMatik_Conference *tconf;
	char jbuffer[100];
	
	newconfnum=confn;

	changenodestatus("Changing conference");
	
	if ((flags & JC_LIST) && newconfnum==0 && !(flags & JC_SHUTUP)) {
		TypeFile("joinconference",TYPE_WARN|TYPE_MAKE);
	}

	while (newconfnum==0 && !(flags & JC_SHUTUP))
	{
		jbuffer[0]=0;
		DDPut(sd[jcpromptstr]);
		if (!(Prompt(jbuffer,3,0))) return 0;
		if ((!strcasecmp(jbuffer,"l")) || jbuffer[0]=='?')
			TypeFile("joinconference",TYPE_WARN|TYPE_MAKE);
		else if (jbuffer[0]==0)
			return 0;
		else
			newconfnum=atoi(jbuffer);
	}

	if (!jc_checkconfaccess(newconfnum,&user)) {
		if (!(flags & JC_SHUTUP)) {
			DDPut(sd[jcnoaccessstr]);
		}
		return 0;
	}
	
//	DDPut("1\n");
	tconf=(struct VMatik_Conference *)confs->lh_Head;
	while (tconf->chead.ln_Succ)
	{
//	DDPut("2\n");
		if (tconf->CONF_NUMBER==newconfnum) {
			if (*tconf->CONF_PASSWD && 
				!(flags & JC_SHUTUP) && 
				!(flags & JC_QUICK)) 
			{
				struct VMatik_Conference *oc;
				
//	DDPut("3\n");
				
				oc=conf;
				conf=tconf;
				TypeFile("conferencepw",TYPE_CONF|TYPE_MAKE);
				conf=oc;
				DDPut("[36mConference password: [0m");
				*jbuffer=0;
				if (!(Prompt(jbuffer,16,PROMPT_SECRET))) return 0;
				if (strcasecmp(jbuffer,tconf->CONF_PASSWD)) return 0;
			}
			user.user_defconf_id=newconfnum;
			conf=tconf;
			base=conf->Conf_MsgBases;
			if(!base)
				break;
//	DDPut("4\n");
			
			if (!(flags & JC_QUICK)) { 
				TypeFile("conferencejoined",TYPE_MAKE|TYPE_CONF);
			}
//	DDPut("56\n");
	
			if (flags & JC_QUICK) 
				jc_changemsgbase(base->MSGBASE_NUMBER, MC_QUICK|MC_NOSTAT);
			else 
				jc_changemsgbase(base->MSGBASE_NUMBER, MC_QUICK);
//	DDPut("6\n");

			if(!jc_changefilearea(conf->CONF_STARTAREA, JC_SHUTUP))
				Current_FileAreaID=0;

//	DDPut("7\n");
			return(1);
		}
		tconf=(struct VMatik_Conference *)tconf->chead.ln_Succ;
	}

//	DDPut("8\n");
	if(!tconf)
		if (!(flags & JC_SHUTUP)) {
			DDPut(sd[jcnoconfstr]);
		}
	
	return(0);
}

int jc_checkconfaccess(int confn, struct userbase *usa)
{
/*
	int i;

	for(i=0;i<64;i++)
	{
		if(usa->user_confacc & (1LL<<i))
			DDPut("X");
		else
			DDPut("-");
	}
	DDPut("\n");
*/

	if(usa->user_confacc & (1LL<<(confn-1)))
		return(1);

	return(0);
	
}

int jc_nextconf(void)
{
	struct VMatik_Conference *tconf;

	tconf=(struct VMatik_Conference *)conf->chead.ln_Succ;
	
	while (tconf->chead.ln_Succ)
	{
		if (tconf && jc_checkconfaccess(tconf->CONF_NUMBER,&user))
			return(jc_joinconf(tconf->CONF_NUMBER,0));
	
		tconf=(struct VMatik_Conference *)tconf->chead.ln_Succ;
	}

	DDPut("\nThis is the last conference.\n");
	
	return(0);
}

int jc_prevconf(void)
{
	struct VMatik_Conference *tconf;

	tconf=(struct VMatik_Conference *)conf->chead.ln_Pred;

	while(tconf->chead.ln_Pred)
	{
		if(tconf && jc_checkconfaccess(tconf->CONF_NUMBER,&user))
			return(jc_joinconf(tconf->CONF_NUMBER,0));
		
		tconf=(struct VMatik_Conference *)tconf->chead.ln_Pred;
	}

	DDPut("\nThis is the first conference.\n");
	
	return(0);
}

int jc_joinconfmenu(char *jcparams)
{
	if (!jcparams) return(jc_joinconf(0,JC_LIST));
	if (jcparams[0]=='l' || jcparams[0]=='L' || jcparams[0]=='?')
		return(jc_joinconf(0,JC_LIST));
	return(jc_joinconf(atoi(jcparams),JC_LIST));
}

int cmbmenu(char *cmbparams)
{
	if (!cmbparams) 
		return(jc_changemsgbase(0,0));
		
	return(jc_changemsgbase(atoi(cmbparams),0));

}

int nextbase(void)
{
	return jc_changemsgbase(base->MSGBASE_NUMBER+1,0);
}

int prevbase(void)
{
	return jc_changemsgbase(base->MSGBASE_NUMBER-1,0);
}

/*
 * Changes the current message area
 *
 */
int jc_changemsgbase(int newb, int flags)
{
	char cbuffer[500];
	int basen;
	struct VMatik_MsgBase *cb;
	int i;

//	DDPut("Jou!\n");
	
	basen=newb;     
	if ((basen==0) && (!(flags & MC_QUICK))) {
		if (conf->CONF_MSGBASES==1) {
			DDPut(sd[cmbonlymsgsstr]);
			return 0;
		}               
		TypeFile("messagebases",TYPE_WARN|TYPE_CONF|TYPE_MAKE);
	}

	while (!basen)
	{
		DDPut(sd[cmbselectstr]);
		cbuffer[0]=0;
		if (!(Prompt(cbuffer,3,0))) return 0;
		if (!strcasecmp(cbuffer,"?") || (!strcasecmp(cbuffer,"l"))) {
			TypeFile("messagebases",TYPE_WARN|TYPE_CONF|TYPE_MAKE);
		} else if (cbuffer[0]==0) {
			return 0;
		} else basen=atoi(cbuffer);
	}

	for (i=0;i<conf->CONF_MSGBASES;i++)
	{
		cb=&base[i];
		
		if (cb->MSGBASE_NUMBER==basen) 
		{
			char query[QUERY_MAX];
			MYSQL_RES *sql_result;
			MYSQL_ROW sql_row;

			base=cb;
			getmsgptrs();
		
			if (cb->MSGBASE_LRP.lrp_read || 
				cb->MSGBASE_LRP.lrp_scan)		// Save LRP's 
			{
				sprintf(query, "REPLACE INTO vmatik_lrp 
								(lrp_user,lrp_area,lrp_conf,
								lrp_read,lrp_scan) VALUES
								(%d,%d,%d,%d,%d)",
								user.user_serial_id,
								basen, conf->CONF_NUMBER,
								cb->MSGBASE_LRP.lrp_read, cb->MSGBASE_LRP.lrp_scan);
				mysql_query(&vm_database, query);
				if(mysql_error(&vm_database)[0])
				{
					DDPut(sd[cmberrlrpstr]);
//					Prompt(query, 5, HOT_YESNO);
					return(0);
				}
			}
			else						// Load LRP's
			{
				sprintf(query, "SELECT lrp_read, lrp_scan FROM vmatik_lrp
							WHERE lrp_user=%d AND lrp_area=%d AND
							lrp_conf=%d", 
							user.user_serial_id, basen, conf->CONF_NUMBER);
				mysql_query(&vm_database, query);
				sql_result=mysql_store_result(&vm_database);
				if(sql_result)
				{
					sql_row=mysql_fetch_row(sql_result);
					if(sql_row && sql_row[0] && sql_row[1])
					{
						cb->MSGBASE_LRP.lrp_read=atoi(sql_row[0]);
						cb->MSGBASE_LRP.lrp_scan=atoi(sql_row[1]);
					}			
					mysql_free_result(sql_result);
				}
			}

			base=cb;
			getmsgptrs();
			
			if ((flags & MC_NOSTAT)==0) {
				sprintf(cbuffer,sd[cmbstat1str],base->MSGBASE_NAME,highest-lowest);
				DDPut(cbuffer);
				sprintf(cbuffer,sd[cmbstat2str],base->MSGBASE_LRP.lrp_read,
						base->MSGBASE_LRP.lrp_scan);
				DDPut(cbuffer);
				sprintf(cbuffer,sd[cmbstat3str],lowest,highest);
				DDPut(cbuffer);
			}
			return 1;
		}
	}
	DDPut(sd[cmbunkbasestr]);
	return 0;               
}

struct VMatik_Conference *jc_findconf(int cnum)
{
	struct VMatik_Conference *tconf;
	
	tconf=(struct VMatik_Conference *)confs->lh_Head;
	
	while (tconf->chead.ln_Succ)
	{
		if (tconf->CONF_NUMBER==cnum) {
			return(tconf);
		}
		tconf=(struct VMatik_Conference *)tconf->chead.ln_Succ;
	}

	return(NULL);
}
