/*
 * This file has the functions related to user accessible files
 * and their maintenance.
 *
 */
#include "proto.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

int currentyear;						// Used when making filelist
int contmode;
int destination_area;					// For movefile()
int remove_ratio=0;						// For killfile()
int flins;
int screenl;

char monthlist[] = "JanFebMarAprMayJunJulAugSepOctNovDec";

int fl_makedesc(MYSQL_ROW sql_row, char *outbuffer);
time_t fl_conv_date(char **instring);
int fl_range2sql(struct List *range, char *what, char *sql_string);

int fileprompt(int, struct cursordat *, struct cursordat *, int);
 
int fl_parseargs(char *params, struct List **itemrange, char *what_is_it,
				char *file_orders, char *area_orders)
{
	char parbuf[512];
	char readbuf[PATH_MAX];
	char buffer[PATH_MAX];
	char tempstr[PATH_MAX];
	char *srcstrh;
	int areaorder_set=0, fileorder_set=0;

	if(!file_orders || !area_orders)
		return(0);

	srcstrh=params;

	area_orders[0]=0;
	file_orders[0]=0;

	/******* Check for item range ********/

redo_range:

	if(!(srcstrh=strspa_ext(srcstrh, parbuf)))
	{
		sprintf(readbuf, "\nEnter a range to %s (?=Help)\n: ", what_is_it);
		DDPut(readbuf);
		strcpy(readbuf, "all");
		if(!(Prompt(readbuf, 78, PROMPT_FILE)))
			return(0);
		srcstrh=readbuf;
		if(!(srcstrh=strspa_ext(srcstrh,parbuf)))
			return(0);
	}

	do {
	/******* Check for item range ********/
	if(*itemrange || !(*itemrange=mi_make_range(parbuf)))
	{
		if(!strcasecmp(parbuf, "all"))	// Show all
		{}
		else
		if(!strcasecmp(parbuf, "new"))  // Show since lastcall
		{
			sprintf(buffer, "%s(area_newestfile>=FROM_UNIXTIME(%d))",
					(areaorder_set ? " AND " : ""), 
					(int)user.user_lastcall);
			strcat(area_orders, buffer);
			areaorder_set=1;
			sprintf(buffer, "%s(file_uldate>=FROM_UNIXTIME(%d))",
					(fileorder_set ? " AND " : ""),
					(int)user.user_lastcall);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "since"))		// Since date
		{
			time_t temptime;
			
			temptime=fl_conv_date(&srcstrh);

			sprintf(buffer, "%s(area_newestfile>=FROM_UNIXTIME(%d))",
					(areaorder_set ? " AND " : ""),
					(int)temptime);
			strcat(area_orders, buffer);
			areaorder_set=1;
			sprintf(buffer, "%s(file_uldate>=FROM_UNIXTIME(%d))",
					(fileorder_set ? " AND " : ""),
					(int)temptime);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "by"))			// By some ID
		{
			if(!(srcstrh=strspa_ext(srcstrh,parbuf)))
				return(0);
			
			sprintf(buffer, "%s(file_byid=%d)",
					(fileorder_set ? " AND " : ""),
					atoi(parbuf));
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "to"))			// To some ID
		{
			if(!(srcstrh=strspa_ext(srcstrh,parbuf)))
				return(0);
			
			sprintf(buffer, "%s(file_toid=%d)",
					(fileorder_set ? " AND " : ""),
					atoi(parbuf));
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "favorite"))
		{
			sprintf(buffer, "%s(file_flags & %ld)",
								(fileorder_set ? " AND " : ""),
								FILE_FAVORITE);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "untested"))
		{
			sprintf(buffer, "%s(file_integrity=%d)",
							(fileorder_set ? " AND " : ""),
							INTEGRITY_NOT_TESTED);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "untrans"))
		{
			sprintf(buffer, "%s(NOT (file_flags & %ld))",
							(fileorder_set ? " AND " : ""),
							FILE_TRANSFORMED);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "unval"))
		{
			sprintf(buffer, "%s(NOT (file_flags & %ld))",
							(fileorder_set ? " AND " : ""),
							FILE_VALIDATED);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "failed"))
		{
			sprintf(buffer, "%s(file_integrity=%d)",
							(fileorder_set ? " AND " : ""),
								INTEGRITY_FAILED);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "nodesc"))
		{
			sprintf(buffer, "%s(file_description='')",
							(fileorder_set ? " AND " : ""));
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "offline"))
		{
			sprintf(buffer, "%s(file_flags & %ld)",
							(fileorder_set ? " AND " : ""),
								FILE_OFFLINE);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "online"))
		{
			sprintf(buffer, "%sNOT (file_flags & %ld)",
							(fileorder_set ? " AND " : ""),
								FILE_OFFLINE);
			strcat(file_orders, buffer);
			fileorder_set=1;
		}
		else
		if(!strcasecmp(parbuf, "h") || !strcasecmp(parbuf,"help") 
		   || !strcasecmp(parbuf,"?"))
		{
		 	if(params)
				params[0]=0;
			TypeFile("help_fl_itemrange", TYPE_WARN|TYPE_MAKE);
			goto redo_range;
		}
		else
		{
			int wild_found=0;
			char sqlbuf[2*PATH_MAX];
		
			wild_found=mi_wild2sql(sqlbuf, parbuf);

			if(wild_found)
			{
				sprintf(buffer, "%s(file_name LIKE '%s')", 
								(fileorder_set ? " AND " : ""),
								sqlbuf);
				strcat(file_orders, buffer);
				fileorder_set=1;
			}	
			else
			{
				if(!strncasecmp(parbuf, "'", 1) || 
				   !strncasecmp(parbuf, "\"", 1))		// Text string match
				{
					int i=0,a=0, gotsep=0;

					while(parbuf[i]!=0)						// Remove ' & " s
					{
						if(parbuf[i]==' ' && !gotsep) 
							break;
						if(parbuf[i]!='\'' && parbuf[i]!='\"')
						{
							tempstr[a]=parbuf[i];
							a++;
						}
						else
						{
							if(gotsep)
								gotsep=0;
							else
								gotsep=1;
						}
						i++;
					}
					tempstr[a]=0;
					sprintf(buffer, "%s(file_description LIKE '%%%s%%')",
							(fileorder_set ? " AND " : ""),
							tempstr);
					strcat(file_orders, buffer);
					fileorder_set=1;
				}
				else								// Probably a filename
				{
					strspa_ext(parbuf, tempstr);
					sprintf(buffer, "%s(file_name='%s')", 
									(fileorder_set ? " AND " : ""), 
									tempstr);
					strcat(file_orders, buffer);
					fileorder_set=1;
				}
			}
		}
	}
//	DDPut(srcstrh);
	} while((srcstrh=strspa_ext(srcstrh,parbuf)));
//    }	while(0);

/*
	DDPut("\n\nfile: ");
	DDPut(file_orders);
	DDPut("\n\nArea: ");
	DDPut(area_orders);
	sleep(2);
*/

	if(!*itemrange)
	{
		char buffer2[PATH_MAX];
		
		sprintf(buffer2, "1-%d", INT_MAX);
		*itemrange=mi_make_range(buffer2);
	}
	return(1);
}

/*
 * Asks the bulk description to be written for all files
 * and writes it to a temp file where it will be read by
 * fl_describefile_bulk()
 *
 */
int fl_init_describe_bulk(MYSQL *db)
{
	char buffer[QUERY_MAX];
	char buffer2[QUERY_MAX];
	char dst_file[PATH_MAX];

	sprintf(dst_file,"%sbulkdesc%d.txt", VMTMP, node);
	unlink(dst_file);

	buffer[0]=buffer2[0]=0;

/*
	DDPut("\n\nGot: ");
	DDPut(desc_txt);
	DDPut("\n\n");
*/
	sprintf(buffer, "%sfsed%d.txt", VMTMP,node);
	unlink(buffer);

	sprintf(buffer2, "%s -c%d -l%d", maincfg.CFG_FSEDCOMMAND, 
			DESC_LINELENGTH, DESC_MAX);
	dp_rundoor(buffer2,buffer);

	if(newrename(buffer,dst_file)==-1)
		return(0);

	return(1);
}

/*
 * Asks if credits are to be removed from the files which will
 * be killed during the next killfile() operation.
 *
 */
int fl_init_kill(MYSQL *db)
{
	char buffer[PATH_MAX];

	buffer[0]='0';
	buffer[1]=0;

	DDPut("\nCredit removal factor [0]?: ");
	Prompt(buffer, 4, PROMPT_FILE);
	remove_ratio=atoi(buffer);
	if(remove_ratio<0)
		remove_ratio=0;

	return(1);
}

/*
 * This is the function that is performed before movefile().
 *
 * It asks about the destination filearea.
 *
 */
int fl_init_move(MYSQL *db)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row=NULL;
	char query[QUERY_MAX];
	char buffer[PATH_MAX];
	int i,go=1,oldconf;

	oldconf=conf->CONF_NUMBER;

	while(go)
	{
		jc_showfileareas(db, JC_SHUTUP);

		DDPut("Which area [/]?: ");
		buffer[0]=0;
		Prompt(buffer, 10, 0);
		if(buffer[0]=='/')
		{
			jc_joinconf(0, JC_LIST);
			continue;
		}
		destination_area=atoi(buffer);
		if(destination_area<=0)
		{
			DDPut("\nAborted...\n");
			return(-1);
		}
		else
			go=0;
	}

	sprintf(query, "SELECT area_id FROM vmatik_fileareas
					WHERE area_conf=%d AND (area_access=0 OR
					(area_access & %ld))
					ORDER BY area_displayat",
					conf->CONF_NUMBER, (1L<<user.user_securitylevel));
	
	if(oldconf!=conf->CONF_NUMBER)
		jc_joinconf(oldconf, JC_QUICK|JC_SHUTUP);
	
	mysql_query(db, query);
	sql_result=mysql_use_result(db);

	for(i=0;i<destination_area;i++)
		sql_row=mysql_fetch_row(sql_result);

	if(sql_row && sql_row[0])
	{
		destination_area=atoi(sql_row[0]);
		while(mysql_fetch_row(sql_result));
		mysql_free_result(sql_result);
	}
	else
	{
		mysql_free_result(sql_result);
		DDPut("Aborted...\n");
		return(-1);
	}

	return(destination_area);
}
		
/*
 * Converts a date given by user to time_t value.
 *
 * Input should be in form "DD-MM-YYYY", or
 *
 * "-D" days before today, where D is a number of days
 * "t"  for TODAY, t is just a char t :)
 * "n" for user's last call, n is just a char n :)
 *
 */
time_t fl_conv_date(char **instring)
{
	struct tm *myt=NULL;
	time_t temptime, outvalue=0;
	char parbuf[PATH_MAX];
	char databuf[PATH_MAX];

	if (!(*instring=strspa(*instring,parbuf)))	// Date is missing
	{
		myt=localtime(&last);
		sprintf(parbuf,sd[fldatestr],myt->tm_mday,myt->tm_mon+1,myt->tm_year);
		DDPut(parbuf);
		databuf[0]=0;
		if (!(Prompt(databuf,44,0))) return 0;
		*instring=databuf;
		*parbuf=0;
		*instring=strspa(*instring,parbuf);
	}
	if (parbuf[0]==0 || (!strcasecmp(parbuf,"s"))) 	// Since last call
	{
		myt=localtime(&last);
		myt->tm_sec=0;
		myt->tm_min=0;
		myt->tm_hour=0;
		outvalue=mktime(myt);
	} 
	else if (!strcasecmp(parbuf,"t"))				// Today 
	{
		time(&temptime);
		myt=localtime(&temptime);
		myt->tm_sec=myt->tm_min=myt->tm_hour=0;
		outvalue=mktime(myt);
	} 
	else if (parbuf[0]=='-')						// -X days 
	{
		int days;
			
		days=atoi(&parbuf[1]);
		time(&temptime);
		myt=localtime(&temptime);
		myt->tm_sec=0;
		myt->tm_min=0;
		myt->tm_hour=0;
		outvalue=mktime(myt)-(days*86400);
	} 
	else								// Eg. "10-10-1996"	(DD-MM-YYYY)
	{
		char numb[4];
		struct tm teem;
		
		if (strlen(parbuf)!=8) 
			return(0);
		numb[0]=parbuf[0];
		numb[1]=parbuf[1];
		numb[2]=0;
		teem.tm_sec=0;
		teem.tm_min=0;
		teem.tm_hour=0;
		teem.tm_mday=atoi(numb);
		numb[0]=parbuf[2];
		numb[1]=parbuf[3];
		teem.tm_mon=atoi(numb)-1;
		numb[0]=parbuf[4];
		numb[1]=parbuf[5];
		teem.tm_year=atoi(numb)-1900;
		outvalue=mktime(&teem);
	}
	return(outvalue);
}

/*
 * Prints filename, asks if it is to be included.
 *
 * Returns: 0=NO, 1=YES
 *
 */
int fl_display_ask(char *display, char *filename, struct cursordat *cdat,
					struct cursordat *currc)
{
	DDPut(display);

	DDPut("\nInclude this file [No]? ");
	
	switch(HotKey(HOT_YESNO))
	{
		case 1:
			DDPut("\n");
			return(RESULT_YES);
			break;
		case 2:
		default:
			break;
	}
	
	DDPut("\n");
	
	return(RESULT_NO);
}

int fl_display_dummy(char *display, char *filename, struct cursordat *cdat,
struct cursordat *currc)
{
	return(RESULT_YES);
}

int fl_display_normal(char *display, char *filename, struct cursordat *cdat,
struct cursordat *currc)
{
	// Is the screen full?

	if (screenl + flins - 1 > user.user_screenlength) 
	{
		int hotres;

		hotres=fileprompt(contmode,cdat,currc, 1);
		if (hotres==RESULT_CONTINUOUS) 
			contmode=1;
		if (hotres==RESULT_QUIT) 
			return(RESULT_QUIT);
		
		currc=cdat;
		screenl=1;
		currc->cd_line=0;
	}
	
	if (!contmode) 
	{
		currc->cd_line=screenl;
		screenl+=flins;
		currc++;
		currc->cd_line=0;
	} 
	else 
	{
		if (HotKey(HOT_QUICK)==3) 
		{
			currc=cdat;
			currc->cd_line=0;
			contmode=0;
			screenl=user.user_screenlength;
		}
	}
	if (!checkcarrier()) return(0);

	DDPut(display);			  	 // print the desc for this file

	return(RESULT_YES);
}

/*
 * This shows some verbose info of a file
 *
 */
int fl_show_verbose(MYSQL *db, MYSQL_ROW sql_row)
{
	char buffer[PATH_MAX];
	char uploader[28];
	char query[QUERY_MAX];
	ULONG file_flags, file_byid;
	time_t timetemp;
	char *asctimetemp;

	sprintf(query, "file_id=%s", sql_row[6]);
	file_byid=mi_sql_getnum(db, "file_byid", "vmatik_filelist", query);
	if(file_byid!=0)
	{
		sprintf(query, "user_id=%ld", file_byid);
		if(!mi_sql_getstr(db, "user_handle", "vmatik_user", query, uploader))
			file_byid=0;
	}

	timetemp=atol(sql_row[1]);
	asctimetemp=asctime(gmtime(&timetemp));
	asctimetemp[strlen(asctimetemp)-1]=0;
	
	file_flags=atol(sql_row[4]);

	sprintf(buffer, "File %-6.6s : %s\n", sql_row[0], sql_row[2]);
	DDPut(buffer);
	sprintf(buffer, "Size        : %s bytes\n", sql_row[5]);
	DDPut(buffer);
	sprintf(buffer, "Uploaded by : %s [ID# %ld] (at %s)\n", 
			(file_byid ? uploader : "Unknow"),
			file_byid,
			asctimetemp);
	DDPut(buffer);
	sprintf(buffer, "Description : %s\n", sql_row[3]);
	DDPut(buffer);
	switch(atoi(sql_row[7]))
	{
		case INTEGRITY_FAILED:
			DDPut("(Broken) ");
			break;
		case INTEGRITY_NOT_TESTED:
			DDPut("(Untested) ");
			break;
		default:
			break;
	}
	if(file_flags & FILE_PRIVATE)
		DDPut("(Private) ");
	if(!(file_flags & FILE_VALIDATED))
		DDPut("(Unvalidated) ");
	if(file_flags & FILE_FAVORITE)
		DDPut("(Favorite) ");
//	if(file_flags & FILE_TRANSFORMED)
//		DDPut("(Transformed) ");
	if(file_flags & FILE_FREEDL)
		DDPut("(Free Dl) ");
	if(file_flags & FILE_OFFLINE)
		DDPut("(Offline) ");
		
	DDPut("\n\n");
	
	return(1);
}

/*
 * This function displays the contents of a file, if the
 * archiver type is known...
 *
 */
int fl_viewfile(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[PATH_MAX];	
	char file_path[PATH_MAX];
	int file_area;

	sprintf(query, "file_id=%s", sql_row[6]);
	file_area=mi_sql_getnum(db, "file_area", "vmatik_filelist", query);
	if(!file_area)
		return(0);
	
	sprintf(query, "area_id=%d", file_area);
	if(!mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
					file_path))
		return(0);

	mi_correct_path(file_path);

	strcat(file_path, sql_row[2]);
	
	ar_viewfile(file_path);

	return(1);
}

/*
 * This is the filelist function used in "domenu.c". It calls
 * the fl_filelist() on one or more areas after the user 
 * arguments are parsed
 *
 */
int fl_browselist(char *params, struct SystemFunctions *func,
				  char *what_is_it, int mode, MYSQL *db)
{
	int i,total=0;
	struct List *itemrange=NULL;
	char file_orders[QUERY_MAX];
	char area_orders[QUERY_MAX];

	changenodestatus("Scanning filedirs");
/*
	if (!(conf->CONF_FILEAREAS)) {
		if(!(mode & MODE_SHUTUP))
			DDPut(sd[flnoareasstr]);
		return(0);
	}
*/

	if(!fl_parseargs(params, &itemrange, what_is_it, file_orders,
						area_orders))
	{
		if(!(mode & MODE_SHUTUP))
			DDPut("\nAborted...\n\n");
		
		return(0);
	}
	
	if(func->initfunction)
	{
		if(func->initfunction(db)==-1)
			return(0);
	}

	if(mode & MODE_ALL)
	{
		MYSQL_RES *sql_result;
		MYSQL_ROW sql_row;
		char query[QUERY_MAX];
		int oldarea;
	
		oldarea=Current_FileAreaID;
	
		sprintf(query, "SELECT area_id FROM vmatik_fileareas WHERE
				area_conf=%d %s %s AND (area_access=0 OR (area_access & %ld))
				ORDER BY area_displayat", 
				conf->CONF_NUMBER, 
				(area_orders[0] ? "AND" : ""), 
				(area_orders[0] ? area_orders : ""),
				(1L<<user.user_securitylevel));
//		DDPut(query);
		mysql_query(db, query);
		sql_result=mysql_store_result(db);
	
		for(i=0;i<mysql_num_rows(sql_result);i++)
		{
			sql_row=mysql_fetch_row(sql_result);
			if(!sql_row)
			{
				mysql_free_result(sql_result);
				return(total);
			}
			
			if(jc_changefilearea(atoi(sql_row[0]), JC_SHUTUP|JC_ABSOLUTE))
			{
				int res;

				res=fl_filelist(func, file_orders, itemrange, 
									what_is_it, mode,db);
				if(res==-1)							// User wishes to quit
					break;
				else
					total+=res;
			}
		}
		mysql_free_result(sql_result);
		jc_changefilearea(oldarea, JC_SHUTUP);
	}
	else
	{
		total=fl_filelist(func, file_orders, itemrange, what_is_it, mode,db);
	}

	if(!(mode & MODE_SHUTUP))
		DDPut("\n\n");

	return(total);
}

/*
 * This function lists the files of the current filearea.
 *
 * Returns the amount of displayed files
 *
 */
int fl_filelist(struct SystemFunctions *func, char *orders,
				struct List *itemrange, char *what_is_it, int mode, MYSQL *db)
{
	MYSQL_RES	*sql_result;
	MYSQL_ROW	sql_row;
	char		range_temp[PATH_MAX];
	char parbuf[PATH_MAX];
	char query[QUERY_MAX];
	char outbuf[DESC_MAX*80];
	time_t timetemp;
	int found_files=0;
	struct tm *currenttime;
	int entriesinarea=0;
	int doquit=0, do_exitf=0;
	struct cursordat *cdat;			
	struct cursordat *currc=NULL;

	if(!db)
		return(0);
	
	if(!Current_FileAreaID)
	{
		if(!(mode & MODE_SHUTUP))
			DDPut("\nEnter some real filearea first...\n");
		return(0);
	}

	timetemp=time(NULL);
	currenttime=gmtime(&timetemp);
	currentyear=currenttime->tm_year;

	contmode=0;

	cdat=(struct cursordat *)malloc((user.user_screenlength+2)*sizeof(struct cursordat));

	if(!(mode & MODE_SHUTUP) && !(mode & MODE_NOPROMPT))
	{
		char area_name[100];

		sprintf(query, "area_id=%d", Current_FileAreaID);
		mi_sql_getstr(db, "area_name", "vmatik_fileareas", query,
						area_name);

		sprintf(parbuf,sd[flscanningstr],Current_FileAreaNumber,
						area_name);
		DDPut(parbuf);
	}
	
	if(fl_makeprec(db, Current_FileAreaID)==-1)
		return(0);

/////////// Go through all the files

	if(!bgmode)
	{
		screenl=4;
		currc=cdat;
		currc->cd_line=0;
	}

	if(entriesinarea==0 && !(mode & MODE_SHUTUP))
		DDPut("\n\n");

	range_temp[0]='1';
	range_temp[1]=0;

	if(itemrange)
		fl_range2sql(itemrange, "offset", range_temp);

	sprintf(query, "SELECT offset, UNIX_TIMESTAMP(file_uldate), file_name,
			file_description, file_flags, file_size, file_id, file_integrity
			FROM vmatik_filelist, vmatik_u%d_a%d 
			WHERE (%s) %s %s AND f_id=file_id ORDER BY offset",
			user.user_serial_id, Current_FileAreaID,
			range_temp, (orders[0] ? "AND" : ""), (orders[0] ? orders : "")
			);
	mysql_query(db, query);

	sql_result=mysql_store_result(db);

	while(!doquit && (sql_row=mysql_fetch_row(sql_result)))
	{
//		DDPut("Entering makedesc!\n");
		flins=fl_makedesc(sql_row, outbuf);
//		DDPut("Exiting makedesc!\n");
		if(func->displayfunction)
			switch(func->displayfunction(outbuf, sql_row[2], cdat, currc))
			{
				case RESULT_YES:
					if(func->maintfunction)
						if(func->maintfunction(db, sql_row)==MAINT_UPDATE)
							do_exitf=1;
					found_files++;
	//				DDPut("Yes!\n");
					break;
				case RESULT_QUIT:
					found_files++;
					doquit=1;
					break;
				case RESULT_NO:
				default:
					found_files++;
					break;
			}
	}

	mysql_free_result(sql_result);

	// end of filelist, ask for tagging
	if (found_files && !doquit && !(mode & MODE_SHUTUP) &&
	   !(mode & MODE_NOPROMPT))
	{
		switch(fileprompt(contmode,cdat,currc,0))
		{
			case RESULT_CONTINUOUS:
				contmode=1;
				break;
			case RESULT_QUIT:
				doquit=1;
				break;
			default:
				break;
		}
	}
	
	// Was: && mode !=SCAN_GLOBALNEW

	if (!(mode & MODE_SHUTUP))
	{
		if (!found_files) {
			DDPut(sd[flnoentriesstr]);
		} else {
			DDPut("\n");
		}
	}

	free(cdat);

	if(do_exitf && func->exitfunction)
		func->exitfunction(db);
	
	if(doquit)
		return(-1);

	return(found_files);
}

/*
 * Sets area_lasttouch of current filearea
 *
 */
int fl_touch_currentarea(MYSQL *db)
{
	fl_touch_filearea(db, Current_FileAreaID);

	return(1);
}

/*
 * Removes the bulkdesc tmp file
 *
 */
int fl_exit_describe_bulk(MYSQL *db)
{
	char buffer[PATH_MAX];

	sprintf(buffer, "%sbulkdesc%d.txt", VMTMP, node);
	unlink(buffer);

	return(1);
}

/*
 * This function sets the area lasttouch after fl_movefile()s
 *
 */
int fl_exit_move(MYSQL *db)
{
	fl_touch_filearea(db, destination_area);
	fl_touch_filearea(db, Current_FileAreaID);

	return(1);
}

/*
 * This sets area_lasttouch + area_newestfile to current
 *
 */
int fl_exit_touch(MYSQL *db)
{
	char query[QUERY_MAX];

	sprintf(query, "UPDATE vmatik_fileareas
					SET area_newestfile=NOW(), area_lasttouch=NOW()
					WHERE area_id=%d", Current_FileAreaID);
	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		DDPut(mysql_error(db));
		return(0);
	}

	return(1);
}

/*
 * This produces the "More yes/no/flag etc" prompt.
 *
 */
int fileprompt(int contmode, struct cursordat *cdat, struct
cursordat *currc, int clear)
{
	int hotres=RESULT_INVALID;
	char parbuf[512];
	char fbuf[512];
	char *s;
	int i;
	
	if (contmode==0) {
		DDPut(sd[flmorestr]);
	} else {
		hotres=RESULT_CONTINUOUS;
	}

	while(hotres==RESULT_INVALID)
	{
		if (!checkcarrier()) 
			hotres=RESULT_QUIT;

		switch(HotKey(HOT_CURSOR))
		{
			case 0:							// Quit
			case 'n':
			case 'N':
			case 'q':
			case 'Q':
				hotres=RESULT_QUIT;
				break;
			case 13:						// Next page
			case 10:
			case 'y':
			case 'Y':
			case 251:
			case ' ':
				if (clear) DDPut("[2J[H");
				hotres=RESULT_YES;
				break;
/*
			case 250:				// UP
				if (cdat->cd_line) {
					DDPut(sd[flflagstr]);
				}
				currc--;
				while(currc->cd_line)
				{
					sprintf(parbuf,sd[fltagstr],currc->cd_line,currc->cd_file);
					DDPut(parbuf);								
					switch(HotKey(HOT_CURSOR))
					{
						int ii;
						
						case 10:					// LF, CR
						case 13:
//							ii=te_flagsingle(NULL,currc->cd_file,0);
							if (ii==0 || ii==4) {
								DDPut(sd[starstr]);
								DDPut("[D");
								sprintf(parbuf,"[%d;1H[36m%s[0m",currc->cd_line,currc->cd_file);
								DDPut(parbuf);								
								currc++;
							} else if (ii==3) {
								if (te_unflagfile(currc->cd_file)) {
									DDPut(" [D");
									sprintf(parbuf,"[%d;1H[36m%s[0m",currc->cd_line,currc->cd_file);
									DDPut(parbuf);								
									currc++;
								}
							}
						break;
						case 250:		// UP
							if (currc==cdat) break;
							sprintf(parbuf,sd[fltagoffstr],currc->cd_line,currc->cd_file);
							DDPut(parbuf);								
							currc--;
						break;										
						case 251:		// DOWN
							sprintf(parbuf,sd[fltagoffstr],currc->cd_line,currc->cd_file);
							DDPut(parbuf);								
							currc++;
						break;										
						case 'q':
						case 'Q':
							sprintf(parbuf,sd[fltagoffstr],currc->cd_line,currc->cd_file);
							DDPut(parbuf);								
							while(currc->cd_line) currc++;
						break;
					}
					if (!checkcarrier()) break;
				}
				sprintf(parbuf,"[%d;1H",screenl);
				DDPut(parbuf);
				DDPut(sd[flmorestr]);
			break;
*/
			case 'c':						// Continuous
			case 'C':
				contmode=1;
				hotres=RESULT_CONTINUOUS;
				break;
			case '*':						// Flag file(s)
			case 'f':
			case 'F':
			case 't':
			case 'T':
			{
				int old_screenl;

				DDPut(sd[flflag2str]);
				*parbuf=0;
				if (!(Prompt(parbuf,512,PROMPT_FILE|PROMPT_NOCRLF))) 
					return(0);

				s=parbuf;
				i=0;
				old_screenl=screenl;
				
				while((s=strspa(s,fbuf))) {
					i+=te_flagfile(fbuf, MODE_CURRENT);
				}

				screenl=old_screenl;
				sprintf(fbuf,sd[flresstr],i);
				DDPut(fbuf);
				HotKey(0);
				sprintf(parbuf,"[%d;1H",screenl);
				DDPut(parbuf);
				DDPut(sd[flmorestr]);
				break;
			}	
		}	
	}
	return(hotres);
}

/*
 * This transforms a file into new format.
 * Depends on ar_transform_archive()
 *
 */
int fl_transformfile(MYSQL *db, MYSQL_ROW sql_row)
{
	struct VMatik_Archiver *arc;
	char query[QUERY_MAX];
	char new_path[PATH_MAX];
	char src_path[PATH_MAX];
	int transform_result=0;
	struct stat old_st, new_st;
	ULONG flags;

	DDPut(sql_row[2]);
	DDPut("... ");

	if(atoi(sql_row[7])==INTEGRITY_FAILED ||
		atoi(sql_row[7])==INTEGRITY_NOT_TESTED)
	{
		DDPut("File must first pass integrity test!\n");
		return(0);
	}

	if((atoi(sql_row[4]) & FILE_TRANSFORMED))
	{
		DDPut("already transformed!\n");
		return(0);
	}

	sprintf(query, "area_id=%d", Current_FileAreaID);
	flags=mi_sql_getnum(db, "area_flags", "vmatik_fileareas", query);
	if(flags & AREA_NOTRANSFORM)
	{
		DDPut("transforming not allowed on this area...\n");
		return(0);
	}
	
	mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
				src_path);
	mi_correct_path(src_path);
		
	strcat(src_path, sql_row[2]);
		
	if(stat(src_path, &old_st)!=0)
	{
		DDPut("is offline...\n");
		return(1);
	}
	
	arc=ar_getarchiver(sql_row[2]);

	transform_result=ar_transform_archive(src_path, arc, new_path);
	if(transform_result)
	{
		int i;

		if(stat(new_path, &new_st)!=0)
		{
			DDPut("unable to find the transformed file!\n");
			return(0);
		}

		for(i=strlen(new_path);(i>=0 && new_path[i]!='/');i--);
		if(new_path[i]=='/');
		{
			sprintf(query, "file_id=%s", sql_row[6]);
			mi_sql_setstr(&vm_database, "file_name", "vmatik_filelist",
						query, &new_path[i+1]);
		
			mi_sql_setval(&vm_database, "file_flags", "vmatik_filelist",
						query, '|', FILE_TRANSFORMED);

			mi_sql_setval(&vm_database, "file_size", "vmatik_filelist",
						query, '=', new_st.st_size);

			sprintf(query, "transformed (%d -> %d [%ld%% gain])...\n",
							(int)old_st.st_size, (int)new_st.st_size,
							((100*old_st.st_size)/new_st.st_size)-100);
			DDPut(query);	
		
			if(strcmp(src_path, new_path)!=0)			// Delete old file
				unlink(src_path);
		
			return(1);
		}
	}

	DDPut("failed!\n");
	return(0);
}

/*
 * Tests file integrity. Depends on ar_test_archive()
 *
 */
int fl_testfile(MYSQL *db, MYSQL_ROW sql_row)
{
	struct VMatik_Archiver *arc;
	char query[QUERY_MAX];
	int test_result=0,old_integrity;
	int byid, fcreds, bcreds, fsize;

	DDPut(sql_row[2]);
	DDPut("... ");

	old_integrity=atoi(sql_row[7]);
	fsize=atoi(sql_row[5]);

	sprintf(query, "file_id=%s", sql_row[6]);
	byid=mi_sql_getnum(db, "file_byid", "vmatik_filelist", query);
	bcreds=mi_sql_getnum(db, "file_bytes2uler", "vmatik_filelist", query);
	fcreds=mi_sql_getnum(db, "file_files2uler", "vmatik_filelist", query);

	arc=ar_getarchiver(sql_row[2]);
	
	if(arc && *arc->ARC_CMD_TEST)
	{
		char src_path[PATH_MAX];
		struct stat st;
	
		sprintf(query, "area_id=%d", Current_FileAreaID);
		mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
					src_path);
		mi_correct_path(src_path);
		
		strcat(src_path, sql_row[2]);
		
		if(stat(src_path, &st)!=0)
		{
			DDPut("is offline...\n");
			return(1);
		}
		
		if(ar_test_archive(src_path, arc))
		{
			test_result=INTEGRITY_PASSED;
			if(old_integrity==INTEGRITY_FAILED)
			{
				mi_sql_setuser(db, "user_filecred", byid, '+', fcreds);
				mi_sql_setuser(db, "user_bytecred", byid, '+', bcreds);
				mi_sql_setuser(db, "user_filesup_bad", byid, '-', 1);
				mi_sql_setuser(db, "user_bytesup_bad", byid, '-', fsize);
			}
		}
		else
		{
			test_result=INTEGRITY_FAILED;
			if(old_integrity==INTEGRITY_PASSED || 
				old_integrity==INTEGRITY_NOT_TESTABLE)
			{
				mi_sql_setuser(db, "user_filecred", byid, '-', fcreds);
				mi_sql_setuser(db, "user_bytecred", byid, '-', bcreds);
				mi_sql_setuser(db, "user_filesup_bad", byid, '+', 1);
				mi_sql_setuser(db, "user_bytesup_bad", byid, '+', fsize);
			}
		}
	}
	else
	{
		test_result=INTEGRITY_NOT_TESTABLE;
		DDPut("Not testable!\n");
	}

	sprintf(query, "file_id=%s", sql_row[6]);
	mi_sql_setval(db, "file_integrity", "vmatik_filelist", query,
					'=', test_result);

	return(1);
}
	
/*
 * Deletes a file from the filelist, removes credits from uploader
 * if the file was bad.
 *
 * Note: Credits are not taken from UNVALIDATED files (because then
 *       they haven't been given)
 *
 */
int fl_killfile(MYSQL *db, MYSQL_ROW sql_row)
{
	char	query[QUERY_MAX];
	char	area_path[PATH_MAX];
	char	filename[PATH_MAX];
	int flags,byid;

	sprintf(query, "file_id=%s", sql_row[6]);
	flags=mi_sql_getnum(db, "file_flags", "vmatik_filelist", query);
	byid=mi_sql_getnum(db, "file_byid", "vmatik_filelist", query);
	
	if(remove_ratio>0 || !(flags & FILE_VALIDATED))	// Boo, it was a BAD file! 
	{
		if(atol(sql_row[7])!=INTEGRITY_FAILED) // If failed, already marked bad
		{
			mi_sql_setuser(db, "user_filesup_bad", byid, '+', 1);
			mi_sql_setuser(db, "user_bytesup_bad", byid, '+', atoi(sql_row[5]));
		}
	}

	if(remove_ratio>0 && (flags & FILE_VALIDATED))
	{
		int bcreds, fcreds;
	
		bcreds=mi_sql_getnum(db, "file_bytes2uler", "vmatik_filelist", query);
		fcreds=mi_sql_getnum(db, "file_files2uler", "vmatik_filelist", query);

		fcreds=fcreds*remove_ratio;
		bcreds=bcreds*remove_ratio;

		mi_sql_setuser(db, "user_filecred", byid, '-', fcreds);
		mi_sql_setuser(db, "user_bytecred", byid, '-', bcreds);
	}

	sprintf(query, "DELETE FROM vmatik_filelist WHERE file_id=%s",
					sql_row[6]);
	mysql_query(db, query);
	if(mysql_error(db)[0])
		return(0);
	
	/* delete the actual file */
	
	sprintf(query, "area_id=%d", Current_FileAreaID);
	mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
				area_path);
	mi_correct_path(area_path);

	sprintf(filename, "%s%s", area_path, sql_row[2]);
	unlink(filename);

	return(MAINT_UPDATE);
}

/* 
 * Flags a file for user
 *
 */
int fl_flagfile(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[QUERY_MAX];

//		DDPut(filename);
//		DDPut("...");

	sprintf(query, "INSERT INTO vmatik_flagged (flagged_id,flagged_user)
					VALUES (%s,%d)", sql_row[6], user.user_serial_id);
	mysql_query(db, query);
	if(mysql_error(db)[0]!='D')
	{
//			DDPut(" flagged\n");
		return(1);
	}

	sprintf(query, "DELETE FROM vmatik_flagged WHERE 
					flagged_id=%s AND flagged_user=%d", 
					sql_row[6], user.user_serial_id);
	mysql_query(db,query);
	
//	DDPut(" unflagged\n");
	
	return(0);
}

/*
 * Asks for a description and writes it for a file.
 *
 */
int fl_describefile(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[QUERY_MAX*2];
	char buffer[PATH_MAX];
	char buffer2[PATH_MAX];
	char ed_file[PATH_MAX];
	char desc_txt[QUERY_MAX];
	char second_txt[QUERY_MAX*2];
	int fd, bytes_read;

	sprintf(buffer, "file_id=%s", sql_row[6]);
	mi_sql_getstr(db, "file_description", "vmatik_filelist", buffer,
					desc_txt);

/*
	DDPut("\n\nGot: ");
	DDPut(desc_txt);
	DDPut("\n\n");
*/

	if(desc_txt[0])	// It actually has a desc!
	{
		sprintf(ed_file, "%sVMatik%d.msg",VMTMP,node);
		
		fd=open(ed_file, O_WRONLY|O_CREAT|O_TRUNC, 0664);
		write(fd, desc_txt, strlen(desc_txt));
		close(fd);
	}
	
	sprintf(buffer2, "%s -c%d -l%d", maincfg.CFG_FSEDCOMMAND,
			DESC_LINELENGTH, DESC_MAX);
	dp_rundoor(buffer2,buffer);

	if(desc_txt[0])
		unlink(ed_file);

	sprintf(ed_file, "%sfsed%d.txt",VMTMP,node);
	fd=open(ed_file, O_RDONLY);
	if(fd==-1)
	{
		DDPut("\n\nCan't open desc...\n\n");
		return(0);
	}
	
	bytes_read=read(fd, desc_txt, QUERY_MAX);
	if(bytes_read>0) 
		desc_txt[bytes_read-1]=0;
	close(fd);
	unlink(ed_file);

	if(bytes_read==0)				// User didn't write anything
	{
//		DDPut("\n\nGot nothing...\n");
		return(0);
	}

/*
	sprintf(buffer, "\n\nGot desc: %s\n", desc_txt);
	DDPut(buffer);
*/

	mysql_escape_string(second_txt, desc_txt, strlen(desc_txt));

	sprintf(query, "UPDATE vmatik_filelist SET file_description='%s'
			WHERE file_id=%s", second_txt, sql_row[6]);
	mysql_query(db, query);
	
	return(1);
}

/* 
 * This writes a "bulk description" for a file.
 * The description must have been created in init function
 *
 * Note: its inefficient to read the description every
 *       time... It would be better to keep it in mem
 *       using a static var or something. Got to think
 *       about this...
 *
 */
int fl_describefile_bulk(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[QUERY_MAX*2];
	char desc_txt[QUERY_MAX];
	char second_txt[QUERY_MAX];
	char src_file[PATH_MAX];
	int fd,bytes_read;
	
	sprintf(src_file, "%sbulkdesc%d.txt",VMTMP,node);
	fd=open(src_file, O_RDONLY);
	if(fd==-1)
	{
		DDPut("\n\nCan't open bulk desc...\n\n");
		return(0);
	}
	
	bytes_read=read(fd, desc_txt, QUERY_MAX);
	if(bytes_read>0) 
		desc_txt[bytes_read-1]=0;
	close(fd);

	if(bytes_read==0)				// User didn't write anything
	{
//		DDPut("\n\nGot nothing...\n");
		return(0);
	}

/*
	sprintf(buffer, "\n\nGot desc: %s\n", desc_txt);
	DDPut(buffer);
*/

	mysql_escape_string(second_txt, desc_txt, strlen(desc_txt));

	sprintf(query, "UPDATE vmatik_filelist SET file_description='%s'
			WHERE file_id=%s", second_txt, sql_row[6]);
	mysql_query(db, query);

	return(MAINT_UPDATE);
}

/*
 * Moves a file from "Current_FileAreaID" to area "destination_area"
 *
 * Moves the physical file as well, if possible
 *
 */
int fl_movefile(MYSQL *db, MYSQL_ROW sql_row)
{
	char	old_filename[PATH_MAX], new_filename[PATH_MAX];
	char	src_path[PATH_MAX];
	char	dest_path[PATH_MAX];
	char	query[QUERY_MAX];
	struct stat st;

	DDPut(sql_row[2]);
	DDPut("... ");

	sprintf(query, "area_id=%d", destination_area);
	mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
				dest_path);
	mi_correct_path(dest_path);

	sprintf(query, "area_id=%d", Current_FileAreaID);
	mi_sql_getstr(db, "area_filepath", "vmatik_fileareas", query,
				src_path);
	mi_correct_path(src_path);

	sprintf(old_filename, "%s%s", src_path, sql_row[2]);
	sprintf(new_filename, "%s%s", dest_path, sql_row[2]); 

	if(stat(new_filename, &st)==0)
	{
		DDPut("Error: Destination file already exists...\n");
		return(0);
	}
	else
	{
		if(mi_sql_getnum(db, "file_id", "vmatik_fileareas", query)>0)
		{
			DDPut("Error: Destination file already exists...\n");
			return(0);
		}
	}

	if(stat(old_filename, &st)==0)				// Stat ok! Check free space
	{
		if(getfreesp(dest_path)<=st.st_size)
		{
			DDPut("Not enough hd space on destination area...\n");
			return(0);
		}
	}

	sprintf(query, "file_id=%s", sql_row[6]);
	mi_sql_setval(db, "file_area", "vmatik_filelist", query,
					'=', destination_area);
/*
	DDPut(old_filename);
	DDPut(" -> ");
	DDPut(new_filename);
	DDPut("\n");
*/

	if(newrename(old_filename, new_filename)==-1)	// Copy failure?
		DDPut("Error moving actual file...");
	
	sprintf(query, "UPDATE vmatik_fileareas 
					SET area_newestfile=FROM_UNIXTIME(%s)
					WHERE area_id=%d AND area_newestfile<FROM_UNIXTIME(%s)",
					sql_row[1], destination_area, sql_row[1]);
	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		DDPut(mysql_error(db));
		return(0);
	}
	
	DDPut("moved\n");
	
	return(MAINT_UPDATE);
}

/*
 * Sets the file's upload date to current
 *
 */
int fl_touchfile(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[QUERY_MAX];

	DDPut(sql_row[2]);
	DDPut("...");
	
	sprintf(query, "UPDATE vmatik_filelist
					SET file_uldate=NOW()
					WHERE file_id=%s", sql_row[6]);
	mysql_query(db, query);

	DDPut(" touched\n");

	return(MAINT_UPDATE);
}

/*
 * Validates/unvalidates a file. Users with no access can't see
 * unvalidated files, and uploaders are not given credit until
 * validation. 
 *
 * Note: Unvalidating takes given credits away! If file has
 *       failed integrity check, credits will NOT be touched.
 *
 * Bugs: - this function code is somewhat stupid. 
 *
 */
int fl_validatefile(MYSQL *db, MYSQL_ROW sql_row)
{
	char query[QUERY_MAX];
	int byid, fcreds, bcreds,integrity;
	
	DDPut(sql_row[2]);
	DDPut("...");
	
	integrity=atoi(sql_row[7]);

	sprintf(query, "file_id=%s", sql_row[6]);
	byid=mi_sql_getnum(db, "file_byid", "vmatik_filelist", query);
	bcreds=mi_sql_getnum(db, "file_bytes2uler", "vmatik_filelist", query);
	fcreds=mi_sql_getnum(db, "file_files2uler", "vmatik_filelist", query);
	
	sprintf(query, "UPDATE vmatik_filelist SET file_flags=(file_flags | %ld)
			WHERE file_id=%s AND NOT (file_flags & %ld)", 
			FILE_VALIDATED, sql_row[6], FILE_VALIDATED);
	mysql_query(db, query);
	
	if(mysql_affected_rows(db)>0)
	{
		if(integrity!=INTEGRITY_FAILED)
		{
			mi_sql_setuser(db, "user_filecred", byid, '+', fcreds);
			mi_sql_setuser(db, "user_bytecred", byid, '+', bcreds);
		}
		
		DDPut(" validated\n");
		return(MAINT_UPDATE);
	}

	sprintf(query, "UPDATE vmatik_filelist SET file_flags=(file_flags & %ld)
			WHERE file_id=%s", 
			~FILE_VALIDATED, sql_row[6]);
	mysql_query(db, query);

	if(integrity!=INTEGRITY_FAILED)
	{
		mi_sql_setuser(db, "user_filecred", byid, '-', fcreds);
		mi_sql_setuser(db, "user_bytecred", byid, '-', bcreds);
	}	

	DDPut(" unvalidated\n");
	
	return(MAINT_UPDATE);
}

/*
 * Makes description of the most necessary infos of 'sql_row'.
 *
 * 'outbuffer' must have enough space to contain the stuff!
 *
 * Uses: currentyear
 *
 * Returns: 0 if failed,
 *          amount of lines spent otherwise
 *
 */
int fl_makedesc(MYSQL_ROW sql_row, char *outbuffer)
{
	struct tm *file_up_time;
	time_t conv_time_temp;
	char base[PATH_MAX];
	char size_temp[5];
	char time_temp[7];
	char *thisdesc;
	char *ext;
	char tagchar=' ';
	char statchar=' ';
	char file_integrity;
	int i=0,a,c;
	int lines=0;
	int file_flags, file_size;

	conv_time_temp=atol(sql_row[1]);
	if(conv_time_temp!=0)
	{
		file_up_time=gmtime(&conv_time_temp);
	
		if(file_up_time->tm_year<currentyear)
			sprintf(time_temp, "%3.3s'%2d", 
			        &monthlist[(file_up_time->tm_mon)*3],
					file_up_time->tm_year);
		else
			sprintf(time_temp, "%2d-%3.3s",
			        file_up_time->tm_mday,
					&monthlist[(file_up_time->tm_mon)*3]);
	}
	else
		sprintf(time_temp, "??-???");

	strcpy(base, sql_row[2]);
	if((ext=strrchr(base, '.')))			// find last .
	{
		ext[0]=0;							// cut filename here
		ext++;
		mi_strupr(ext);
	}
	else
		ext="";								// No extension at all

	file_flags=atoi(sql_row[4]);

	if(file_flags & FILE_FAVORITE)
		statchar='+';
	
	if(!(file_flags & FILE_VALIDATED))
		statchar='v';

	file_integrity=atoi(sql_row[7]);
	if(file_integrity==INTEGRITY_FAILED)
		statchar='!';

	if(file_flags & FILE_OFFLINE)
		statchar='o';

	if(file_flags & FILE_PRIVATE)
		statchar='p';

	file_size=atoi(sql_row[5]);
	if(file_size>1000000)
	{
		if((file_size/1000000)>10)
			sprintf(size_temp, "%3d%c", file_size/1000000, 'M');
		else
			sprintf(size_temp, "%.1f%c", (float)(file_size*0.000001), 'M');
	}
	else
		sprintf(size_temp, "%3d%c", file_size/1000, 'k');
	
//	a=sprintf(outbuffer, "%4s%c%6.6s%c%-14.14s %3.3s %4.4s ", 
	a=sprintf(outbuffer, sd[filedescstr], 
			sql_row[0],statchar,time_temp,tagchar,
			base, ext, size_temp);
			// Size of this thingy is 36!

	i=0;
	c=a+1;						// There's 37 spaces before desc starts

	thisdesc=sql_row[3];

	while(thisdesc[i])				// construct the description
	{
		if (thisdesc[i]=='\n' || c==81)
		{
			int b;
		
			outbuffer[a]='\n';
			for(b=a+1;b<a+37;b++)
				outbuffer[b]=' ';
			a+=37;
			c=37;
			lines++;
		}
		else
		{
			outbuffer[a]=thisdesc[i];
			a++;c++;
		}
		i++;
	}

	outbuffer[a]='\n';
	outbuffer[a+1]=0;
	
	lines++;
	
	return(lines);
}

/*
 * Scans new files from every conference.
 *
 */
int fl_globalnewscan(void)
{
	struct VMatik_Conference *mc;
	int oldc;
	char gbuf[300];

	oldc=conf->CONF_NUMBER;
	
	DDPut(sd[flglobhstr]);

	mc=(struct VMatik_Conference *)confs->lh_Head;
	while(mc->chead.ln_Succ)
	{
		if (jc_checkconfaccess(mc->CONF_NUMBER,&user) && isconftagged(mc->CONF_NUMBER)) 
		{
			struct SystemFunctions func;
			
			memset(&func, 0, sizeof(struct SystemFunctions));
			
			sprintf(gbuf,sd[flconfstr],mc->CONF_NAME);
			DDPut(gbuf);
			
			jc_joinconf(mc->CONF_NUMBER,JC_SHUTUP|JC_QUICK);		

			func.displayfunction=fl_display_normal;
		
			fl_browselist("new", &func, "GNewscan", MODE_ALL, &vm_database);
		}
		mc=(struct VMatik_Conference *)mc->chead.ln_Succ;
	}
	jc_joinconf(oldc,JC_SHUTUP|JC_QUICK);
	return 1;
}

/* 
 * creates a filearea precalc table
 * Makes a new table, if filearea->area_lasttouch has been touched.
 *
 * Bugs: Doesn't check if user has access to see private files.
 *       unvalidated are handled.
 *
 */
int fl_makeprec(MYSQL *db, int area_id)
{
	char query[QUERY_MAX];
	char limits[QUERY_MAX];
	char order_str[512];
	char used_order;
	int precalced=0;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;

//	DDPut("Prec: Started\n");

	sprintf(query, "SELECT 1 FROM vmatik_precalc, vmatik_fileareas WHERE
			precalc_user=%d AND precalc_area=%d AND area_id=%d AND 
			precalc_date>area_lasttouch",
	user.user_serial_id, area_id, area_id);

	mysql_query(db, query);
	sql_result=mysql_store_result(db);
	if(!sql_result)
	{
		sprintf(query, "Error: %s\n", mysql_error(db));
		DDPut(query);
		return(-1);
	}

	precalced=mysql_num_rows(sql_result);
	mysql_free_result(sql_result);

	if(precalced)						// Precalc is still up-to-date
		return(0);

	sprintf(query, "area_id=%d", area_id);
	used_order=mi_sql_getnum(db, "area_sortorder", "vmatik_fileareas",
							query);
	if(used_order==0 || used_order>4)			// Shouldn't happen!!
		used_order=SORT_ALPHA;

	sprintf(query, "SELECT order_type FROM vmatik_order
					WHERE order_user=%d AND order_area=%d",
					user.user_serial_id, area_id);
	mysql_query(db, query);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		sql_row=mysql_fetch_row(sql_result);
		if(sql_row && sql_row[0])
			used_order=atoi(sql_row[0]);
		mysql_free_result(sql_result);
	}

	switch(used_order)
	{
		case 1:
			sprintf(order_str, "file_name ASC");
			break;
		case 2:
			sprintf(order_str, "file_name DESC");
			break;
		case 3:
			sprintf(order_str, "file_uldate ASC");
			break;
		case 4:
		default:
			sprintf(order_str, "file_uldate DESC");
			break;
	}	

	sprintf(query, "DELETE FROM vmatik_precalc WHERE precalc_user=%d AND
			precalc_area=%d", user.user_serial_id, area_id);
	mysql_query(db, query);

	sprintf(query, "INSERT INTO vmatik_precalc (precalc_user, precalc_area)
			VALUES (%d,%d)", user.user_serial_id, area_id);
	mysql_query(db, query);
	
	sprintf(query, "DROP TABLE vmatik_u%d_a%d", user.user_serial_id,
			area_id);
	mysql_query(db, query);

	sprintf(query, "CREATE TABLE vmatik_u%d_a%d (offset INTEGER NOT NULL
			AUTO_INCREMENT, f_id INTEGER NOT NULL, PRIMARY KEY (offset), INDEX
			index_offset (offset), INDEX index_f_id (f_id))",
			user.user_serial_id, area_id);
	mysql_query(db, query);

	if(access_flags & SECB_COSYSOP)
		limits[0]=0;
	else	
		sprintf(limits, "AND ((file_flags & %ld) OR file_byid=%d)
						AND NOT (file_flags & %ld)", 
							FILE_VALIDATED, user.user_serial_id,
							FILE_OFFLINE);

	sprintf(query, "INSERT INTO vmatik_u%d_a%d SELECT 0, file_id FROM
			vmatik_filelist WHERE file_area=%d %s ORDER BY %s",
			user.user_serial_id, area_id, area_id, limits, order_str);
	mysql_query(db, query);

//	DDPut("Prec: passed!\n");

	return(1);
}

/*
 * Frees all filearea precalcs from user 'user_id'
 *
 */
int fl_free_precalcs(MYSQL *db, int user_id)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char query[QUERY_MAX];

	sprintf(query, "SELECT precalc_area FROM vmatik_precalc WHERE
			precalc_user=%d", user_id);
	mysql_query(db, query);
	
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		while((sql_row=mysql_fetch_row(sql_result)))
		{
			sprintf(query, "DROP TABLE vmatik_u%d_a%s",
					user_id, sql_row[0]);
			mysql_query(db, query);
		}
	}

	mysql_free_result(sql_result);
	
	sprintf(query, "DELETE FROM vmatik_precalc WHERE precalc_user=%d",
			user_id);
	mysql_query(db, query);

	return(1);
}

/*
 * Converts a range into SQL's "blaa AND blaa OR bloo" statements.
 *
 * 'what' is the SQL column that is to be compared with the range.
 *
 * Note: 'sql_string' must have enough space!
 *
 */
int fl_range2sql(struct List *range, char *what, char *sql_string)
{
	struct Range *rangetmp;
	int location=0;

	if(!range || !sql_string)
		return(0);	

	rangetmp=(struct Range *)range->lh_Head;
	while(rangetmp->head.ln_Succ)
	{
		if(location>0)		// Not first unit!
			location+=sprintf(&sql_string[location], " OR ");

		if(rangetmp->range_start == rangetmp->range_stop)
			location+=sprintf(&sql_string[location], "(%s=%ld)",
								what, rangetmp->range_start);
		else
		if(rangetmp->range_stop == INT_MAX)
			location+=sprintf(&sql_string[location], "(%s>=%ld)",
								what, rangetmp->range_start);
		else
			location+=sprintf(&sql_string[location], "(%s>=%ld AND %s<=%ld)",
								what, rangetmp->range_start, 
								what, rangetmp->range_stop);

		rangetmp=(struct Range *)rangetmp->head.ln_Succ;
	}

	return(1);
}

/*
 * Sets the filearea touchdate to current
 *
 */
int fl_touch_filearea(MYSQL *db, int area_id)
{
	char query[QUERY_MAX];

	sprintf(query, "UPDATE vmatik_fileareas SET area_lasttouch=NOW() WHERE
					area_id=%d", area_id);
	mysql_query(db, query);

	return(1);
}
