/*
 * Entering a new message, etc
 *
 */
#include "proto.h"
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/stat.h>


int str2addr(char *s, unsigned short *zone, unsigned short *net,
 			 unsigned short *node, unsigned short *point);

int entermsg(struct VMatik_Message *msg, int reply, char *params)
{
	char ebuf[1024];
	int hola;
	int msgfd;
	char *s;
	struct VMatik_Message header;
	struct userbase ub;
	char *lineedmem;
	int receiver_id;

	if (toupper(base->MSGBASE_FN_FLAGS)=='E' && 
		(access_flags & SECB_FIDOMESSAGE)==0) 
	{
		DDPut(sd[emnofidomsgstr]);
		return 0;
	}

	if (toupper(base->MSGBASE_FN_FLAGS)=='N' && 
		(access_flags & SECB_SENDNETMAIL)==0)
	{
		DDPut(sd[emnonetmsgstr]);
		return 0;
	}

	changenodestatus("Entering a message");
	if (msg) {
		memcpy(&header,msg,sizeof(struct VMatik_Message));
	} else {
		memset(&header, 0, sizeof(struct VMatik_Message));
		s=(char *)&header;
		if (params) 
			strncpy(header.MSG_RECEIVER,params,25);
	}
	
	if (!(base->MSGBASE_FLAGS & MSGB_ALLOW_PUBLIC) && 
		!(base->MSGBASE_FLAGS & MSGB_ALLOW_PRIVATE)) 
	{
		DDPut(sd[emnomsgsstr]);
		return 0;
	}

	DDPut(sd[emhead1str]);
	DDPut(base->MSGBASE_NAME);
	ebuf[0]=0;
	strcat(ebuf,sd[emhead2str]);
	hola=61-strlen(base->MSGBASE_NAME);
	while (hola)
	{
		strcat(ebuf,"-");
		hola--;
	}
	DDPut(ebuf);    
	sprintf(ebuf,sd[emhead3str],highest);
	DDPut(ebuf);
	DDPut(sd[emhead4str]);  

	if (!(base->MSGBASE_FLAGS & MSGB_ALLOW_PUBLIC) || 
		(header.MSG_FLAGS & MSG_FLAGS_PRIVATE)) 
	{
		DDPut(sd[emprvstr]);
		header.MSG_FLAGS |= MSG_FLAGS_PRIVATE;
	} 
	else 
	{
		DDPut(sd[empubstr]);
	}
	header.MSG_CREATION=time(NULL);
	DDPut(sd[emhead5str]);
	DDPut(ctime(&header.MSG_CREATION));     

	DDPut(sd[emhead6str]);
	if (base->MSGBASE_FLAGS & MSGB_USE_HANDLES) {
		strcpy(header.MSG_AUTHOR,user.user_handle);
	} else {
		strcpy(header.MSG_AUTHOR,user.user_realname);   
	}       
	DDPut(header.MSG_AUTHOR);
	while (1)
	{
askrec:
		DDPut(sd[emhead7str]);
		if (!(Prompt(header.MSG_RECEIVER,25,0))) 
			return 0;
		if (header.MSG_RECEIVER[0]==0 || 
			(!strcasecmp(header.MSG_RECEIVER,"all")) || 
			(!strcasecmp(header.MSG_RECEIVER,"all users"))) {
			if (!(base->MSGBASE_FLAGS & MSGB_ALLOW_PUBLIC)) 
			{
				DDPut(sd[emhead8str]);
				HotKey(0);
				header.MSG_RECEIVER[0]=0;
			} else {
				DDPut(sd[emhead9str]);
				header.MSG_RECEIVER[0]=0;
				break;
			}
		} else if (!strcasecmp(header.MSG_RECEIVER,"eall")) {
			if (!(base->MSGBASE_FLAGS & MSGB_ALLOW_PUBLIC)) {
				DDPut(sd[emhead8str]);
				HotKey(0);
				header.MSG_RECEIVER[0]=0;
			} else if (access_flags & SECB_EALLMESSAGE) {
				header.MSG_RECEIVER[0]=-1;
				DDPut(sd[emhead10str]);
				break;
			} else {
				DDPut(sd[emnopoststr]);
				HotKey(0);
				header.MSG_RECEIVER[0]=0;
			}               
		} else {
			if (toupper(base->MSGBASE_FN_FLAGS) == 'L') {
				if (!strcasecmp(header.MSG_RECEIVER,"sysop")) {
					receiver_id=1;
				} else {
					receiver_id=mi_findusername(header.MSG_RECEIVER);
				}
				if (!receiver_id) {
					DDPut(sd[emnouserstr]);
					HotKey(0);
					goto askrec;
				}

				mi_loaduser(receiver_id, &ub);
	
				if (!jc_checkconfaccess(conf->CONF_NUMBER,&ub)) {
					DDPut(sd[emnoaccessstr]);
					HotKey(0);
				}
				
				DDPut("[5;12H                     [5;12H");
				if (base->MSGBASE_FLAGS & MSGB_USE_HANDLES) {
					strcpy(header.MSG_RECEIVER,ub.user_handle);
				} else {
					strcpy(header.MSG_RECEIVER,ub.user_realname);   
				}       
				DDPut(header.MSG_RECEIVER);
				break;                  
			} else break;   
		}
	}
	DDPut(sd[emsubjectstr]);
	if (!(Prompt(header.MSG_SUBJECT,67,0))) return 0;
	if (header.MSG_SUBJECT[0]==0) {
		DDPut(sd[emabortedstr]);
		return 0;
	}
	DDPut("[11;1H                                                                       [11;1H");
	if (header.MSG_RECEIVER[0]==0 || header.MSG_RECEIVER[0]==-1 || 
		(header.MSG_FLAGS & MSG_FLAGS_PRIVATE) || 
		!(base->MSGBASE_FLAGS & MSGB_ALLOW_PRIVATE)) 
	{} 
	else 
	{
		DDPut(sd[emisprivatestr]);
		hola=HotKey(HOT_NOYES);
		if (hola==0) return 0;
		if (hola==1) header.MSG_FLAGS |= MSG_FLAGS_PRIVATE;
	}

	if (!(header.MSG_FLAGS & MSG_FLAGS_PRIVATE) && 
		!(access_flags & SECB_PUBLICMESSAGE)) {
		DDPut(sd[emnopubstr]);
		return 0;
	}

	if (toupper(base->MSGBASE_FN_FLAGS)=='N') {
		if (header.MSG_FN_DEST_NET) {
			sprintf(ebuf,"%d:%d/%d.%d",header.MSG_FN_DEST_ZONE,
				header.MSG_FN_DEST_NET,header.MSG_FN_DEST_NODE,
				header.MSG_FN_DEST_POINT);
		} else {
			*ebuf=0;
		}
		DDPut(sd[emnetaddstr]);
		if (!(Prompt(ebuf,30,0))) return 0;
		if (!str2addr(ebuf,&header.MSG_FN_DEST_ZONE,&header.MSG_FN_DEST_NET,
			      &header.MSG_FN_DEST_NODE,&header.MSG_FN_DEST_POINT)) return 0;
	}
	*header.MSG_ATTACH=0;

	if (base->MSGBASE_FLAGS & MSGB_FILE_ATTACHS) {
		if ( (header.MSG_FLAGS & MSG_FLAGS_PRIVATE) && 
			(access_flags & SECB_PVTATTACH)) {
			*header.MSG_ATTACH=1;
		} else if ( !(header.MSG_FLAGS & MSG_FLAGS_PRIVATE) && 
				(access_flags & SECB_PUBATTACH)) { 
			*header.MSG_ATTACH=1;
		} 
	}
	
	if (reply) {
		if (!em_askqlines()) {
			sprintf(ebuf,"%sVMatik%d.msg",VMTMP,node);
			unlink(ebuf);	
		}
		DDPut("\n\n");
	}
	lineedmem=(char *)malloc(80*500);
	hola=edfile(lineedmem,reply,&header);
	if (hola==0) {
		char fabuf[1024];
		
		DDPut(sd[emaborted2str]);
		free(lineedmem);
		ul_cleandir(currnode->Node_TempDir);
		sprintf(fabuf,"%sattachs.%d",VMTMP,node);
		unlink(fabuf);
		return 0;
	}

	DDPut(sd[emsavingstr]);
	
	getmsgptrs();
	highest++;
	header.MSG_NUMBER=highest;
	if (setmsgptrs()==0) {
		free(lineedmem);
		return 0;
	}       

	if (*header.MSG_ATTACH) {
		char fabuf[1024];
		FILE *fd;
		
		sprintf(fabuf,"%sattachs.%d",VMTMP,node);
		if ( (fd=fopen(fabuf,"r"))) {
			char hoobab[1024];
			
			sprintf(hoobab,"%smessages/base%3.3d/fa%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,header.MSG_NUMBER);
			mkdir(hoobab,0755);
			
			while(fgetsnolf(hoobab,1024,fd))
			{
				char sr[1024];
				char de[1024];
				sprintf(sr,"%s%s",currnode->Node_TempDir,hoobab);
				sprintf(de,"%smessages/base%3.3d/fa%5.5d/%s",conf->CONF_PATH,base->MSGBASE_NUMBER,header.MSG_NUMBER,hoobab);
				newrename(sr,de);
			}
			fclose(fd);             
			sprintf(hoobab,"%smessages/base%3.3d/msf%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,header.MSG_NUMBER);
			newrename(fabuf,hoobab);
		} else {
			*header.MSG_ATTACH=0;
		}
	}
	sprintf(ebuf,"%smessages/base%3.3d/msgbase.dat",conf->CONF_PATH,base->MSGBASE_NUMBER);

	if (toupper(base->MSGBASE_FN_FLAGS)!='L') 
	{
		header.MSG_FN_ORIG_ZONE=base->MSGBASE_FN_ZONE;
		header.MSG_FN_ORIG_NET=base->MSGBASE_FN_NET;
		header.MSG_FN_ORIG_NODE=base->MSGBASE_FN_NODE;
		header.MSG_FN_ORIG_POINT=base->MSGBASE_FN_POINT;
		header.MSG_FLAGS |= MSG_FLAGS_FIDOMSG;
	}

	if ((msgfd=open(ebuf,O_RDWR|O_CREAT,0664)) < 0) {
		DDPut(sd[emwriteerrstr]);
		free(lineedmem);
		return 0;
	}

	lseek(msgfd,0,SEEK_END);
	write(msgfd,&header,sizeof(struct VMatik_Message));
	close(msgfd);
	
	sprintf(ebuf,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,header.MSG_NUMBER);

	if ((msgfd=open(ebuf,O_RDWR|O_CREAT,0664)) < 0) {
		DDPut(sd[emwriteerrstr]);
		free(lineedmem);
		return 0;
	}

	if (toupper(base->MSGBASE_FN_FLAGS)=='E') {
		char ub[128];
		int uq;
		
		strcpy(ub,base->MSGBASE_FN_TAG);
		mi_strupr(ub);
		sprintf(ebuf,"AREA:%s\n",ub);
		write(msgfd,ebuf,strlen(ebuf));
		if ((uq=getfidounique())) {
			sprintf(ebuf,"\001MSGID: %d:%d/%d.%d %8.8x\n",base->MSGBASE_FN_ZONE,base->MSGBASE_FN_NET,base->MSGBASE_FN_NODE,base->MSGBASE_FN_POINT,uq);
			write(msgfd,ebuf,strlen(ebuf));
			if (header.MSG_ORIGINAL) {
				if (em_getreplyid(header.MSG_ORIGINAL,ebuf))
				  write(msgfd,ebuf,strlen(ebuf));
			}
		}
	} else if (toupper(base->MSGBASE_FN_FLAGS)=='N') {
		if (header.MSG_FN_DEST_POINT) {
			sprintf(ebuf,"\001TOPT: %d\n",header.MSG_FN_DEST_POINT);
			write(msgfd,ebuf,strlen(ebuf));
		}
		if (header.MSG_FN_ORIG_POINT) {
			sprintf(ebuf,"\001FMPT: %d\n",header.MSG_FN_ORIG_POINT);
			write(msgfd,ebuf,strlen(ebuf));
		}
		if (header.MSG_FN_DEST_ZONE != base->MSGBASE_FN_ZONE) {
			sprintf(ebuf,"\001INTL: %d:%d/%d %d:%d/%d\n",
				header.MSG_FN_DEST_ZONE,header.MSG_FN_DEST_NET,
				header.MSG_FN_DEST_NODE,header.MSG_FN_ORIG_ZONE,
				header.MSG_FN_ORIG_NET,header.MSG_FN_ORIG_NODE);
			write(msgfd,ebuf,strlen(ebuf));
		}
	}
	s=lineedmem;    
	while(hola)
	{
		sprintf(ebuf,"%s\n",s);
		write(msgfd,ebuf,strlen(ebuf));
		hola--;
		s=&s[80];
	}

	if (toupper(base->MSGBASE_FN_FLAGS)=='E') {
		sprintf(ebuf,"\n--- VMatik/Linux %s\n * Origin: %s (%d:%d/%d)\nSEEN-BY: %d/%d\n",versionstring,base->MSGBASE_FN_ORIGIN,base->MSGBASE_FN_ZONE,base->MSGBASE_FN_NET,base->MSGBASE_FN_NODE,base->MSGBASE_FN_NET,base->MSGBASE_FN_NODE);
		write(msgfd,ebuf,strlen(ebuf));
	} else if (toupper(base->MSGBASE_FN_FLAGS)!='L') {
		sprintf(ebuf,"\n--- VMatik/Linux %s\n",versionstring);
		write(msgfd,ebuf,strlen(ebuf));
	}
	close(msgfd);
	
	DDPut(sd[emdonestr]);
	free(lineedmem);

	if (header.MSG_FLAGS & MSG_FLAGS_PRIVATE) {
		user.user_prvmessages++;
		clog.cl_pvtmessages++;
	} else {
		user.user_pubmessages++;
		clog.cl_pubmessages++;
	}
			
	sprintf(ebuf,"%sVMatik%d.msg",VMTMP,node);
	unlink(ebuf);	

	sprintf(ebuf, "Posted message to %d/%d\n", conf->CONF_NUMBER,
					base->MSGBASE_NUMBER);
	writelog(ebuf);	
	
	return 1;
}

int fsed(char *buffer, int mode, struct VMatik_Message *header)
{
	char buf[200];
	FILE *myf;
	int rc=0;
	char goo[1024];
	int head;
	
	if (!mode) {
		sprintf(buf,"%sVMatik%d.msg",VMTMP,node);
		unlink(buf);
	}

			
	if (header) {
		sprintf(goo,"%smsgheader.%d",VMTMP,node);
		head=open(goo,O_WRONLY|O_TRUNC|O_CREAT,0644);
		if (head > -1) {
			write(head,header,sizeof(struct VMatik_Message));
			close(head);
		}
	}

	dp_rundoor(maincfg.CFG_FSEDCOMMAND,0);
	sprintf(buf,"%sfsed%d.txt",VMTMP,node);

	if ((myf=fopen(buf,"r"))) {
		while(fgetsnolf(buf,79,myf)) {
			strcpy(&buffer[rc*80],buf);
			rc++;
		}       
		fclose(myf);
		sprintf(buf,"%sfsed%d.txt",VMTMP,node);
		unlink(buf);
		return rc;
	}
	return 0;
}

int comment(void)
{
	int oldb;
	char ebuf[PATH_MAX];
	
	if (!conf->CONF_COMMENTAREA) return 0;
	
	oldb=base->MSGBASE_NUMBER;
	
	if (jc_changemsgbase(conf->CONF_COMMENTAREA,MC_QUICK|MC_NOSTAT)) {
		entermsg(0,0,maincfg.CFG_SYSOPNAME);    
		sprintf(ebuf,"%sVMatik%d.msg",VMTMP,node);
		unlink(ebuf);	
		jc_changemsgbase(oldb,MC_QUICK|MC_NOSTAT);
		return 1;
	}
	return 0;
}


void getmsgptrs(void)
{
	int msgfd;
	struct VMatik_MsgPointers ptrs;
	
	char gmpbuf[1024];
	sprintf(gmpbuf,"%smessages/base%3.3d/msgbase.ptr",conf->CONF_PATH,base->MSGBASE_NUMBER);

	if ((msgfd=open(gmpbuf,O_RDONLY)) < 0) {
		highest=0;
		lowest=0;
		return;
	}

	read(msgfd,&ptrs,sizeof(struct VMatik_MsgPointers));
	close(msgfd);
	highest=ptrs.msp_high;
	lowest=ptrs.msp_low;    
}

int setmsgptrs(void)
{
	int msgfd;
	struct VMatik_MsgPointers ptrs;
	
	char gmpbuf[1024];
	sprintf(gmpbuf,"%smessages/base%3.3d/msgbase.ptr",conf->CONF_PATH,base->MSGBASE_NUMBER);

	if ((msgfd=open(gmpbuf,O_RDWR|O_CREAT,0664)) < 0) {
		DDPut(sd[setptrserrstr]);
		return 0;
	}

	ptrs.msp_high=highest;
	ptrs.msp_low=lowest;
	write(msgfd,&ptrs,sizeof(struct VMatik_MsgPointers));
	close(msgfd);
	return 1;
}


int edfile(char *lineedmem, int reply, struct VMatik_Message *header)
{
	int edtype=0;
	int hola;
			
	edtype=0;
	if (user.user_toggles & TOGGLE_ASK_EDITOR) {
		DDPut(sd[emfsedstr]);
		hola=HotKey(HOT_YESNO);
		if (hola==0) return 0;
		if (hola==1) edtype=1;
	} else if (user.user_toggles & TOGGLE_FSED) {
		edtype=1;
	}

	memset(lineedmem,0,40000);
	
	if (edtype) {
		return fsed(lineedmem,reply,header);
	} else {
		return lineed(lineedmem,reply,header);
	}
}

int getfidounique(void)
{
	int fn;
	char buf[1024];
	int i=0;
	
	sprintf(buf,"%s/data/fidocnt.dat",origdir);
	fn=open(buf,O_CREAT|O_RDWR,0644);
	if (fn < 0) return 0;
	read(fn,&i,sizeof(int));
	i++;
	lseek(fn,0,SEEK_SET);
	write(fn,&i,sizeof(int));
	close(fn);
	return i;
}

int str2addr(char *s, unsigned short *zone, unsigned short *net, unsigned short *node, unsigned short *point)
{
	char cb[1024];
	char *t;
	*zone=*net=*node=*point=0;
	
	if (*s=='-'||*s==10||*s==13||*s < '0' || *s > '9') {
		return 0;
	}
	
	t=cb;
	while(*s!=':' && *s) *t++=*s++;
	*t=0;
	*zone=atoi(cb);
	if (!*s) return 0; else s++;
	
	t=cb;
	while(*s!='/' && *s) *t++=*s++;
	*t=0;
	*net=atoi(cb);
	if (!*s) return 0; else s++;

	t=cb;
	while(*s!='.' && *s && *s!=13 && *s!=10) *t++=*s++;
	*t=0;
	*node=atoi(cb);
	if (!*s || *s==13 || *s==10) return 1; else s++;

	t=cb;
	while(*s && *s!=10 && *s!=13) *t++=*s++;
	*t=0;
	*point=atoi(cb);
	return 1;

}

int em_askqlines(void)
{
	char qbuffer[200];
	char input[100];
	int  ql;
	int  lcount;
	int  outp;
	int  startn;
	int  endn;              
	int  line;
	FILE *qfd, *msgfd;
	
	sprintf(qbuffer,"%sVMatik%d.mtm",VMTMP,node);
	qfd=fopen(qbuffer,"r");

	if (!qfd) return 0;

	DDPut("\n");
		
	while (1)
	{
		ql=0;
		lcount=user.user_screenlength;
		outp=1;
		
		while (fgets(input,77,qfd))
		{
			ql++;
			if (outp) {
				sprintf(qbuffer,sd[lel2str],ql,input);
				DDPut(qbuffer);
				lcount--;
			}

			if (lcount==0) {
				int hot;
				
				DDPut(sd[morepromptstr]); 
				hot=HotKey(0);
				DDPut("\r                                                         \r");
				if (hot=='N'||hot=='n') {
					outp=0;
					lcount=-1;
				}
				else if (hot=='C'||hot=='c') {
					lcount=-1;
				} else {
					lcount=user.user_screenlength;
				}
			}
		}
		sprintf(qbuffer,sd[lequotestr],ql);
		DDPut(qbuffer);
		qbuffer[0]=0;
		if (!(Prompt(qbuffer,3,PROMPT_NOCRLF))) {
			fclose(qfd);
			return 0;
		}
		if (!strcasecmp(qbuffer,"l")) {
			DDPut("\n\n");
			fseek(qfd,0,SEEK_SET);          
		} else if ( (!strcasecmp(qbuffer,"*")) || *qbuffer==0) {
			startn=1;
			endn=ql;
			break;
		} else if ((startn=atoi(qbuffer))) {
			DDPut(sd[ledeltostr]);
			qbuffer[0]=0;
			if (!(Prompt(qbuffer,3,PROMPT_NOCRLF))) {
				fclose(qfd);    
				return 0;
			}
			if ((endn=atoi(qbuffer))) {
				break;
			} else {
				fclose(qfd);    
				return 0;
			}
		} else {
			fclose(qfd);    
			return 0;
		}

	}

	fseek(qfd,0,SEEK_SET);
	if (startn < 1 || endn > ql) {
		fclose(qfd);    
		return 0;
	}
	line = 1;

	sprintf(qbuffer,"%sVMatik%d.msg",VMTMP,node);
	msgfd=fopen(qbuffer,"w");

	while (fgets(input,77,qfd))
	{
		if (startn <= line && endn >= line) {
			fputs(input,msgfd);
		}       
		line++;
	}
	fclose(qfd);    
	fclose(msgfd);    
	return 1;
}

int em_getreplyid(int msg, char *de) {
	FILE *msgf;
	char buf[1024];
	
	sprintf(buf,"%smessages/base%3.3d/msg%5.5d",conf->CONF_PATH,base->MSGBASE_NUMBER,msg);
	msgf=fopen(buf,"r");
	if (!msgf) return 0;
	while(fgets(buf,1024,msgf)) {
		if (!strncmp(buf,"\001MSGID:",7)) {
			buf[1]='R';
			buf[2]='E';
			buf[3]='P';
			buf[4]='L';
			buf[5]='Y';
			fclose(msgf);
			strcpy(de,buf);
			return 1;
		}
	}
	fclose(msgf);
	return 0;
}

